/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.game;

import com.hideandseek.HideAndSeekPlugin;
import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaBoundaries;
import com.hideandseek.arena.ArenaManager;
import com.hideandseek.config.CaptureMode;
import com.hideandseek.config.ConfigManager;
import com.hideandseek.config.ShopConfig;
import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.effects.EffectManagerImpl;
import com.hideandseek.game.Game;
import com.hideandseek.game.GamePhase;
import com.hideandseek.game.GameResult;
import com.hideandseek.game.PlayerBackup;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.game.WorldBorderBackup;
import com.hideandseek.libs.kotlin.Deprecated;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.Unit;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.collections.SetsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.Ref;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.random.Random;
import com.hideandseek.points.PointManager;
import com.hideandseek.scoreboard.GameScoreboard;
import com.hideandseek.shop.ShopManager;
import com.hideandseek.spectator.SpectatorManager;
import com.hideandseek.strength.SeekerStrengthManager;
import com.hideandseek.utils.MessageUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u0010\u0010=\u001a\u0004\u0018\u00010\r2\u0006\u0010>\u001a\u00020?J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u000e\u0010C\u001a\u00020A2\u0006\u0010B\u001a\u00020\rJ\u0010\u0010D\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010E\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010F\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010G\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010H\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J4\u0010I\u001a\u00020J2\u0006\u0010>\u001a\u00020?2\u001a\b\u0002\u0010K\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020N0M0L2\b\b\u0002\u0010O\u001a\u00020NJ'\u0010P\u001a\u0004\u0018\u00010N2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020N2\u0006\u0010T\u001a\u00020NH\u0002\u00a2\u0006\u0002\u0010UJ\u0010\u0010V\u001a\u0002092\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u0002092\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Z\u001a\u0002092\u0006\u0010W\u001a\u00020XH\u0003J\u0010\u0010[\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u000e\u0010\\\u001a\u00020A2\u0006\u0010:\u001a\u00020;J\u0016\u0010]\u001a\u00020A2\u0006\u0010^\u001a\u00020;2\u0006\u0010_\u001a\u00020;J\u001e\u0010`\u001a\u00020A2\u0006\u0010a\u001a\u00020;2\u0006\u0010b\u001a\u00020c2\u0006\u0010B\u001a\u00020\rJ\u0018\u0010d\u001a\u00020A2\u0006\u0010:\u001a\u00020;2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010e\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010f\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010g\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u000e\u0010h\u001a\u00020A2\u0006\u0010i\u001a\u00020jJ\u0010\u0010k\u001a\u00020l2\u0006\u0010i\u001a\u00020jH\u0002J\u0010\u0010m\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010n\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010o\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0010\u0010p\u001a\u00020A2\u0006\u0010q\u001a\u00020lH\u0002J\u0018\u0010r\u001a\u00020A2\u0006\u0010B\u001a\u00020\r2\u0006\u0010q\u001a\u00020lH\u0002J\u000e\u0010s\u001a\u00020A2\u0006\u0010q\u001a\u00020lJ\f\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00130uJ\u000e\u0010v\u001a\u0002092\u0006\u0010:\u001a\u00020;J\b\u0010w\u001a\u00020AH\u0002J\u0010\u0010x\u001a\u00020A2\u0006\u0010q\u001a\u00020lH\u0002J\b\u0010y\u001a\u00020AH\u0002J\u0018\u0010z\u001a\u00020A2\u0006\u0010>\u001a\u00020?2\u0006\u0010{\u001a\u00020NH\u0002J\u000e\u0010|\u001a\u00020A2\u0006\u0010B\u001a\u00020\rJ\u000e\u0010}\u001a\u00020A2\u0006\u0010B\u001a\u00020\rJ\u0010\u0010~\u001a\u00020A2\u0006\u0010B\u001a\u00020\rH\u0002J\u0006\u0010\u007f\u001a\u00020NR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u000103X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u0006\u0080\u0001"}, d2={"Lcom/hideandseek/game/GameManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "configManager", "Lcom/hideandseek/config/ConfigManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/config/ConfigManager;)V", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "getConfigManager", "()Lcom/hideandseek/config/ConfigManager;", "value", "Lcom/hideandseek/game/Game;", "activeGame", "getActiveGame", "()Lcom/hideandseek/game/Game;", "waitingPlayers", "", "Ljava/util/UUID;", "shopManager", "Lcom/hideandseek/shop/ShopManager;", "getShopManager", "()Lcom/hideandseek/shop/ShopManager;", "setShopManager", "(Lcom/hideandseek/shop/ShopManager;)V", "disguiseManager", "Lcom/hideandseek/disguise/DisguiseManager;", "getDisguiseManager", "()Lcom/hideandseek/disguise/DisguiseManager;", "setDisguiseManager", "(Lcom/hideandseek/disguise/DisguiseManager;)V", "pointManager", "Lcom/hideandseek/points/PointManager;", "getPointManager", "()Lcom/hideandseek/points/PointManager;", "setPointManager", "(Lcom/hideandseek/points/PointManager;)V", "arenaManager", "Lcom/hideandseek/arena/ArenaManager;", "getArenaManager", "()Lcom/hideandseek/arena/ArenaManager;", "setArenaManager", "(Lcom/hideandseek/arena/ArenaManager;)V", "gameScoreboard", "Lcom/hideandseek/scoreboard/GameScoreboard;", "getGameScoreboard", "()Lcom/hideandseek/scoreboard/GameScoreboard;", "setGameScoreboard", "(Lcom/hideandseek/scoreboard/GameScoreboard;)V", "seekerStrengthManager", "Lcom/hideandseek/strength/SeekerStrengthManager;", "getSeekerStrengthManager", "()Lcom/hideandseek/strength/SeekerStrengthManager;", "setSeekerStrengthManager", "(Lcom/hideandseek/strength/SeekerStrengthManager;)V", "joinGame", "", "player", "Lorg/bukkit/entity/Player;", "leaveGame", "startGame", "arena", "Lcom/hideandseek/arena/Arena;", "applySpectatorModeToSpectators", "", "game", "assignRoles", "setupTeams", "cleanupTeams", "setupWorldTime", "backupPlayers", "teleportPlayers", "getRandomSpawnLocation", "Lorg/bukkit/Location;", "usedLocations", "", "Lcom/hideandseek/libs/kotlin/Pair;", "", "minDistance", "findSafeGroundY", "world", "Lorg/bukkit/World;", "x", "z", "(Lorg/bukkit/World;II)Ljava/lang/Integer;", "isDangerousBlock", "material", "Lorg/bukkit/Material;", "isSafeAir", "isPassableBlock", "giveShopItems", "giveShopItemToPlayer", "handleCapture", "capturer", "captured", "revertSeekerToHider", "seeker", "seekerData", "Lcom/hideandseek/game/PlayerGameData;", "updateTeamForReversion", "applyWorldBorder", "startPreparationPhase", "startSeekPhase", "endGame", "result", "Lcom/hideandseek/game/GameResult;", "getResultMessage", "", "displayStats", "displayRankings", "restorePlayers", "broadcastToWaiting", "message", "broadcastToGame", "broadcastToActiveGame", "getWaitingPlayers", "", "isInGame", "checkAutoStart", "broadcastToServer", "tryStartGame", "startGameCountdown", "seconds", "startAutoRestartTimer", "cancelAutoRestartTimer", "transitionToWaiting", "getActivePlayerCount", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nGameManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameManager.kt\ncom/hideandseek/game/GameManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1453:1\n1869#2,2:1454\n774#2:1456\n865#2,2:1457\n1869#2:1459\n1870#2:1461\n1563#2:1462\n1634#2,3:1463\n1869#2,2:1466\n1869#2,2:1472\n1869#2:1474\n1869#2,2:1475\n1870#2:1477\n1869#2,2:1478\n1869#2,2:1481\n1740#2,3:1486\n1869#2,2:1491\n1869#2,2:1493\n1869#2,2:1495\n1869#2,2:1497\n1869#2,2:1499\n1869#2,2:1501\n774#2:1503\n865#2,2:1504\n1999#2,14:1506\n1869#2,2:1520\n1878#2,3:1522\n1878#2,3:1525\n1869#2,2:1530\n1869#2,2:1532\n1869#2,2:1534\n1617#2,9:1536\n1869#2:1545\n1870#2:1547\n1626#2:1548\n774#2:1549\n865#2,2:1550\n827#2:1552\n855#2,2:1553\n1869#2,2:1555\n1869#2,2:1557\n1869#2,2:1559\n1788#2,4:1561\n1869#2,2:1565\n1#3:1460\n1#3:1546\n216#4,2:1468\n216#4,2:1470\n216#4:1480\n217#4:1483\n216#4,2:1484\n216#4,2:1489\n216#4,2:1528\n*S KotlinDebug\n*F\n+ 1 GameManager.kt\ncom/hideandseek/game/GameManager\n*L\n195#1:1454,2\n204#1:1456\n204#1:1457,2\n219#1:1459\n219#1:1461\n241#1:1462\n241#1:1463,3\n281#1:1466,2\n380#1:1472,2\n403#1:1474\n406#1:1475,2\n403#1:1477\n418#1:1478,2\n468#1:1481,2\n545#1:1486,3\n685#1:1491,2\n718#1:1493,2\n823#1:1495,2\n865#1:1497,2\n921#1:1499,2\n1007#1:1501,2\n1098#1:1503\n1098#1:1504,2\n1099#1:1506,14\n1115#1:1520,2\n1131#1:1522,3\n1164#1:1525,3\n1206#1:1530,2\n1212#1:1532,2\n1264#1:1534,2\n1400#1:1536,9\n1400#1:1545\n1400#1:1547\n1400#1:1548\n1401#1:1549\n1401#1:1550,2\n1402#1:1552\n1402#1:1553,2\n1411#1:1555,2\n1425#1:1557,2\n1436#1:1559,2\n1447#1:1561,4\n943#1:1565,2\n1400#1:1546\n301#1:1468,2\n352#1:1470,2\n455#1:1480\n455#1:1483\n484#1:1484,2\n639#1:1489,2\n1192#1:1528,2\n*E\n"})
public final class GameManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final ConfigManager configManager;
    @Nullable
    private Game activeGame;
    @NotNull
    private final List<UUID> waitingPlayers;
    @Nullable
    private ShopManager shopManager;
    @Nullable
    private DisguiseManager disguiseManager;
    @Nullable
    private PointManager pointManager;
    @Nullable
    private ArenaManager arenaManager;
    @Nullable
    private GameScoreboard gameScoreboard;
    @Nullable
    private SeekerStrengthManager seekerStrengthManager;

    public GameManager(@NotNull Plugin plugin, @NotNull ConfigManager configManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(configManager, "configManager");
        this.plugin = plugin;
        this.configManager = configManager;
        this.waitingPlayers = new ArrayList();
    }

    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Nullable
    public final Game getActiveGame() {
        return this.activeGame;
    }

    @Nullable
    public final ShopManager getShopManager() {
        return this.shopManager;
    }

    public final void setShopManager(@Nullable ShopManager shopManager) {
        this.shopManager = shopManager;
    }

    @Nullable
    public final DisguiseManager getDisguiseManager() {
        return this.disguiseManager;
    }

    public final void setDisguiseManager(@Nullable DisguiseManager disguiseManager) {
        this.disguiseManager = disguiseManager;
    }

    @Nullable
    public final PointManager getPointManager() {
        return this.pointManager;
    }

    public final void setPointManager(@Nullable PointManager pointManager) {
        this.pointManager = pointManager;
    }

    @Nullable
    public final ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public final void setArenaManager(@Nullable ArenaManager arenaManager) {
        this.arenaManager = arenaManager;
    }

    @Nullable
    public final GameScoreboard getGameScoreboard() {
        return this.gameScoreboard;
    }

    public final void setGameScoreboard(@Nullable GameScoreboard gameScoreboard) {
        this.gameScoreboard = gameScoreboard;
    }

    @Nullable
    public final SeekerStrengthManager getSeekerStrengthManager() {
        return this.seekerStrengthManager;
    }

    public final void setSeekerStrengthManager(@Nullable SeekerStrengthManager seekerStrengthManager) {
        this.seekerStrengthManager = seekerStrengthManager;
    }

    public final boolean joinGame(@NotNull Player player) {
        SpectatorManager spectatorManager;
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        Plugin plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SpectatorManager spectatorManager2 = spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
        boolean bl = spectatorManager2 != null ? spectatorManager2.isSpectator(uuid) : false;
        if (bl) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&e\u89b3\u6226\u30e2\u30fc\u30c9\u304c\u6709\u52b9\u3067\u3059\u3002\u30b2\u30fc\u30e0\u306b\u53c2\u52a0\u3059\u308b\u306b\u306f &c/hs spectator off &e\u3092\u5b9f\u884c\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            MessageUtil.INSTANCE.send((CommandSender)player, "&7\u5f85\u6a5f\u30ea\u30b9\u30c8\u306b\u306f\u8868\u793a\u3055\u308c\u307e\u3059\u304c\u3001\u30b2\u30fc\u30e0\u958b\u59cb\u6642\u306b\u81ea\u52d5\u7684\u306b\u89b3\u6226\u8005\u306b\u306a\u308a\u307e\u3059\u3002");
        }
        if (this.waitingPlayers.contains(uuid)) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cAlready in game");
            return false;
        }
        Game game = this.activeGame;
        if (game != null) {
            PlayerGameData playerData;
            if (game.getPlayers().containsKey(uuid)) {
                PlayerGameData playerGameData = game.getPlayers().get(uuid);
                Intrinsics.checkNotNull(playerGameData);
                playerData = playerGameData;
                MessageUtil.INSTANCE.send((CommandSender)player, "&aRejoined game as " + (playerData.getRole() == PlayerRole.SEEKER ? "&c\u9b3c" : "&a\u4eba"));
                Location spawn = GameManager.getRandomSpawnLocation$default(this, game.getArena(), null, 0, 6, null);
                player.teleport(spawn);
                player.getInventory().clear();
                this.giveShopItemToPlayer(player);
                switch (WhenMappings.$EnumSwitchMapping$0[playerData.getRole().ordinal()]) {
                    case 1: {
                        player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&c&l\u9b3c"), (Component)MessageUtil.INSTANCE.colorize("&7\u518d\u53c2\u52a0\u3057\u307e\u3057\u305f"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(2000L), (Duration)Duration.ofMillis(500L))));
                        break;
                    }
                    case 2: {
                        if (playerData.isCaptured()) {
                            player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&7&l\u89b3\u6226\u30e2\u30fc\u30c9"), (Component)MessageUtil.INSTANCE.colorize("&7\u9b3c\u5316\u6e08\u307f"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(2000L), (Duration)Duration.ofMillis(500L))));
                            player.setGameMode(GameMode.SPECTATOR);
                            break;
                        }
                        player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&a&l\u4eba"), (Component)MessageUtil.INSTANCE.colorize("&7\u518d\u53c2\u52a0\u3057\u307e\u3057\u305f"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(2000L), (Duration)Duration.ofMillis(500L))));
                    }
                }
                return true;
            }
            playerData = new PlayerGameData(uuid, PlayerRole.HIDER, false, 0, null, null, 0, 0, 252, null);
            playerData.setBackup(PlayerBackup.Companion.create(player));
            game.getPlayers().put(uuid, playerData);
            player.getInventory().clear();
            player.teleport(GameManager.getRandomSpawnLocation$default(this, game.getArena(), null, 0, 6, null));
            this.giveShopItemToPlayer(player);
            MessageUtil.INSTANCE.send((CommandSender)player, "&aJoined game as &a\u4eba");
            this.broadcastToGame(game, "&e" + player.getName() + " \u304c\u30b2\u30fc\u30e0\u306b\u53c2\u52a0\u3057\u307e\u3057\u305f\uff08\u4eba\uff09");
            player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&a&l\u4eba"), (Component)MessageUtil.INSTANCE.colorize("&7\u9b3c\u304b\u3089\u9003\u3052\u308d\uff01"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(2000L), (Duration)Duration.ofMillis(500L))));
            return true;
        }
        this.waitingPlayers.add(uuid);
        int count = this.waitingPlayers.size();
        MessageUtil.INSTANCE.send((CommandSender)player, "&aJoined game! (" + count + " players)");
        this.broadcastToWaiting("&e" + player.getName() + " joined the game (" + count + " players)");
        this.checkAutoStart();
        return true;
    }

    public final boolean leaveGame(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        if (this.waitingPlayers.remove(uuid)) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&aLeft the game");
            this.broadcastToWaiting("&e" + player.getName() + " left the game (" + this.waitingPlayers.size() + " players)");
            return true;
        }
        Game game = this.activeGame;
        if (game != null && game.getPlayers().containsKey(uuid)) {
            PlayerGameData playerGameData = game.getPlayers().get(uuid);
            Intrinsics.checkNotNull(playerGameData);
            PlayerGameData playerData = playerGameData;
            PlayerBackup playerBackup = playerData.getBackup();
            if (playerBackup != null) {
                playerBackup.restore(player);
            }
            MessageUtil.INSTANCE.send((CommandSender)player, "&aLeft the game");
            MessageUtil.INSTANCE.send((CommandSender)player, "&7You can rejoin to continue playing");
            return true;
        }
        MessageUtil.INSTANCE.send((CommandSender)player, "&cNot in game");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Game startGame(@NotNull Arena arena) {
        Game game;
        void $this$mapTo$iv$iv;
        List list;
        Object uuid;
        Intrinsics.checkNotNullParameter(arena, "arena");
        if (this.activeGame != null) {
            return null;
        }
        Plugin plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SpectatorManager spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
        this.plugin.getLogger().info("[DEBUG] Waiting players: " + this.waitingPlayers.size());
        Iterable $this$forEach$iv = this.waitingPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            uuid = (UUID)element$iv;
            boolean bl = false;
            Object object = Bukkit.getPlayer((UUID)uuid);
            if (object == null || (object = object.getName()) == null) {
                object = "Unknown";
            }
            Object playerName = object;
            SpectatorManager spectatorManager2 = spectatorManager;
            boolean isSpectator = spectatorManager2 != null ? spectatorManager2.isSpectator((UUID)uuid) : false;
            this.plugin.getLogger().info("[DEBUG] - " + (String)playerName + " (isSpectator: " + isSpectator + ")");
        }
        List spectatorPlayers = new ArrayList();
        if (this.configManager.isForceJoinAllPlayers()) {
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.waitingPlayers;
            boolean $i$f$filter = false;
            uuid = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator isSpectator = $this$filterTo$iv$iv.iterator();
            while (isSpectator.hasNext()) {
                boolean isSpectator2;
                Object element$iv$iv = isSpectator.next();
                UUID uuid2 = (UUID)element$iv$iv;
                boolean bl = false;
                SpectatorManager spectatorManager3 = spectatorManager;
                boolean bl2 = isSpectator2 = spectatorManager3 != null ? spectatorManager3.isSpectator(uuid2) : false;
                if (isSpectator2) {
                    spectatorPlayers.add(uuid2);
                }
                if (!(!isSpectator2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.toList((Iterable)this.waitingPlayers);
        }
        List activePlayers = list;
        this.plugin.getLogger().info("[DEBUG] Active players (after filtering spectators): " + activePlayers.size());
        Iterable $this$forEach$iv2 = spectatorPlayers;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            void $this$startGame_u24lambda_u242_u240_u240;
            Location bl;
            Player player;
            UUID uuid3 = (UUID)element$iv;
            boolean bl3 = false;
            if (Bukkit.getPlayer((UUID)uuid3) == null) continue;
            boolean bl4 = false;
            MessageUtil.INSTANCE.send((CommandSender)player, "&e\u89b3\u6226\u30e2\u30fc\u30c9\u306e\u305f\u3081\u3001\u30b2\u30fc\u30e0\u306b\u306f\u53c2\u52a0\u305b\u305a\u89b3\u6226\u3057\u307e\u3059\u3002");
            MessageUtil.INSTANCE.send((CommandSender)player, "&7\u53c2\u52a0\u3059\u308b\u306b\u306f &c/hs spectator off &7\u3092\u5b9f\u884c\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            SpectatorManager spectatorManager4 = spectatorManager;
            if (spectatorManager4 != null) {
                spectatorManager4.applySpectatorMode(player);
            }
            Location isSpectator2 = bl = arena.getBoundaries().getCenter();
            Player player2 = player;
            boolean bl5 = false;
            $this$startGame_u24lambda_u242_u240_u240.setY(arena.getBoundaries().getCenter().getY() + (double)10);
            player2.teleport(bl);
        }
        int minPlayers = this.configManager.getMinPlayers();
        if (activePlayers.size() < minPlayers) {
            if (!((Collection)this.waitingPlayers).isEmpty() && activePlayers.isEmpty()) {
                this.broadcastToWaiting("&c\u53c2\u52a0\u30d7\u30ec\u30a4\u30e4\u30fc\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002\u89b3\u6226\u8005\u306e\u307f\u3067\u306f\u30b2\u30fc\u30e0\u3092\u958b\u59cb\u3067\u304d\u307e\u305b\u3093\u3002");
            }
            return null;
        }
        Iterable $this$map$iv = activePlayers;
        boolean $i$f$map = false;
        Iterable uuid3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void uuid4;
            UUID $this$startGame_u24lambda_u242_u240_u240 = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(uuid4, new PlayerGameData((UUID)uuid4, PlayerRole.HIDER, false, 0, null, null, 0, 0, 252, null)));
        }
        Map players = MapsKt.toMutableMap(MapsKt.toMap((List)destination$iv$iv));
        this.activeGame = game = new Game(null, arena, GamePhase.WAITING, players, System.currentTimeMillis(), System.currentTimeMillis(), null, null, 0L, null, 961, null);
        this.waitingPlayers.clear();
        this.assignRoles(game);
        this.backupPlayers(game);
        this.teleportPlayers(game);
        this.giveShopItems(game);
        this.applyWorldBorder(game);
        this.setupWorldTime(game);
        this.setupTeams(game);
        this.startPreparationPhase(game);
        this.applySpectatorModeToSpectators(game);
        return game;
    }

    private final void applySpectatorModeToSpectators(Game game) {
        Plugin plugin = this.plugin;
        Object object = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        if (object == null || (object = object.getSpectatorManager()) == null) {
            return;
        }
        HideAndSeekPlugin spectatorManager = object;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            if (!((SpectatorManager)((Object)spectatorManager)).isSpectator(uUID) || game.getPlayers().containsKey(player.getUniqueId())) continue;
            Intrinsics.checkNotNull(player);
            ((SpectatorManager)((Object)spectatorManager)).applySpectatorMode(player);
            MessageUtil.INSTANCE.send((CommandSender)player, "&e\u89b3\u6226\u30e2\u30fc\u30c9\u3067\u30b2\u30fc\u30e0\u3092\u89b3\u6226\u3057\u3066\u3044\u307e\u3059");
        }
    }

    public final void assignRoles(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        List playerList = CollectionsKt.toList((Iterable)game.getPlayers().keySet());
        this.plugin.getLogger().info("[DEBUG] Assigning roles for " + playerList.size() + " players");
        UUID seekerUuid = (UUID)CollectionsKt.random(playerList, Random.Default);
        PlayerGameData playerGameData = game.getPlayers().get(seekerUuid);
        if (playerGameData != null) {
            playerGameData.setRole(PlayerRole.SEEKER);
        }
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            PlayerGameData data = entry.getValue();
            Object object = Bukkit.getPlayer((UUID)uuid);
            if (object == null || (object = object.getName()) == null) {
                object = "Unknown";
            }
            Object playerName = object;
            this.plugin.getLogger().info("[DEBUG] Assigned role - Player: " + (String)playerName + ", Role: " + data.getRole());
        }
    }

    private final void setupTeams(Game game) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        Team team = mainScoreboard.getTeam("hs_seekers");
        if (team != null) {
            team.unregister();
        }
        Team team2 = mainScoreboard.getTeam("hs_hiders");
        if (team2 != null) {
            team2.unregister();
        }
        Team team3 = mainScoreboard.getTeam("hs_spectators");
        if (team3 != null) {
            team3.unregister();
        }
        Team team4 = mainScoreboard.registerNewTeam("hs_seekers");
        Intrinsics.checkNotNullExpressionValue(team4, "registerNewTeam(...)");
        Team seekerTeam = team4;
        seekerTeam.setColor(ChatColor.RED);
        seekerTeam.setPrefix("\u00a7c");
        seekerTeam.setSuffix("");
        seekerTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
        Team team5 = mainScoreboard.registerNewTeam("hs_hiders");
        Intrinsics.checkNotNullExpressionValue(team5, "registerNewTeam(...)");
        Team hiderTeam = team5;
        hiderTeam.setColor(ChatColor.GREEN);
        hiderTeam.setPrefix("\u00a7a");
        hiderTeam.setSuffix("");
        hiderTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        Team team6 = mainScoreboard.registerNewTeam("hs_spectators");
        Intrinsics.checkNotNullExpressionValue(team6, "registerNewTeam(...)");
        Team spectatorTeam = team6;
        spectatorTeam.setColor(ChatColor.GRAY);
        spectatorTeam.setPrefix("\u00a77");
        spectatorTeam.setSuffix("");
        spectatorTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
        this.plugin.getLogger().info("[Team Setup] Created teams - \u9b3c: RED, \u4eba: GREEN, \u89b3\u6226\u8005: GRAY");
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Plugin plugin = $this$forEach$iv.entrySet().iterator();
        while (plugin.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = plugin.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            PlayerGameData playerData = entry.getValue();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            if (!Intrinsics.areEqual(player.getScoreboard(), mainScoreboard)) {
                this.plugin.getLogger().info("[Team] Setting " + player.getName() + " to use main scoreboard");
                player.setScoreboard(mainScoreboard);
            }
            Intrinsics.checkNotNullExpressionValue(player.getName(), "getName(...)");
            switch (WhenMappings.$EnumSwitchMapping$0[playerData.getRole().ordinal()]) {
                case 1: {
                    String playerName;
                    seekerTeam.addEntry(playerName);
                    this.plugin.getLogger().info("[Team] Added " + playerName + " to \u9b3c team (RED)");
                    break;
                }
                case 2: {
                    String playerName;
                    hiderTeam.addEntry(playerName);
                    this.plugin.getLogger().info("[Team] Added " + playerName + " to \u4eba team (GREEN)");
                    break;
                }
                case 3: {
                    String playerName;
                    spectatorTeam.addEntry(playerName);
                    this.plugin.getLogger().info("[Team] Added " + playerName + " to SPECTATOR team (GRAY)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SpectatorManager spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv2 = collection;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            boolean bl;
            Player player = (Player)element$iv;
            boolean bl3 = false;
            SpectatorManager spectatorManager2 = spectatorManager;
            if (spectatorManager2 != null) {
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                bl = spectatorManager2.isSpectator(uUID);
            } else {
                bl = false;
            }
            if (!bl || game.getPlayers().containsKey(player.getUniqueId())) continue;
            if (!Intrinsics.areEqual(player.getScoreboard(), mainScoreboard)) {
                player.setScoreboard(mainScoreboard);
            }
            spectatorTeam.addEntry(player.getName());
            ((HideAndSeekPlugin)this.plugin).getLogger().info("[Team] Added " + player.getName() + " (non-game spectator) to SPECTATOR team (GRAY)");
        }
    }

    private final void cleanupTeams(Game game) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        this.plugin.getLogger().info("[Team Cleanup] Cleaning up teams for game");
        String[] stringArray = new String[]{"hs_seekers", "hs_hiders", "hs_spectators"};
        List<String> teamNames = CollectionsKt.listOf(stringArray);
        Iterable $this$forEach$iv = teamNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Team team;
            String teamName = (String)element$iv;
            boolean bl = false;
            if (mainScoreboard.getTeam(teamName) == null) continue;
            boolean bl2 = false;
            Set set = team.getEntries();
            Intrinsics.checkNotNullExpressionValue(set, "getEntries(...)");
            Iterable $this$forEach$iv2 = CollectionsKt.toList(set);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String entry = (String)element$iv2;
                boolean bl3 = false;
                team.removeEntry(entry);
                this.plugin.getLogger().info("[Team Cleanup] Removed " + entry + " from team " + teamName);
            }
            team.unregister();
            this.plugin.getLogger().info("[Team Cleanup] Unregistered team " + teamName);
        }
        $this$forEach$iv = game.getPlayers().keySet();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl4 = false;
            if (Intrinsics.areEqual(player.getScoreboard(), mainScoreboard)) continue;
            player.setScoreboard(mainScoreboard);
        }
        this.plugin.getLogger().info("[Team Cleanup] Team cleanup complete");
    }

    private final void setupWorldTime(Game game) {
        World world = game.getArena().getWorld();
        world.setTime(1000L);
        int taskId = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> GameManager.setupWorldTime$lambda$0(world), 200L, 200L).getTaskId();
        game.setNightSkipTaskId(taskId);
    }

    private final void backupPlayers(Game game) {
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            PlayerGameData playerData = entry.getValue();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            playerData.setBackup(PlayerBackup.Companion.create(player));
            if (player.isDead()) {
                player.spigot().respawn();
            }
            player.getInventory().clear();
            player.setGameMode(GameMode.SURVIVAL);
            Collection collection = player.getActivePotionEffects();
            Intrinsics.checkNotNullExpressionValue(collection, "getActivePotionEffects(...)");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PotionEffect effect = (PotionEffect)element$iv2;
                boolean bl3 = false;
                player.removePotionEffect(effect.getType());
            }
            player.setHealth(player.getMaxHealth());
            player.setFoodLevel(20);
            player.setSaturation(20.0f);
        }
    }

    private final void teleportPlayers(Game game) {
        Set usedLocations = new LinkedHashSet();
        int minDistance = 5;
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            Location spawn = this.getRandomSpawnLocation(game.getArena(), usedLocations, minDistance);
            Location center = game.getArena().getBoundaries().getCenter();
            double distance = spawn.distance(center);
            double radius = game.getArena().getBoundaries().getSize() / 2.0;
            this.plugin.getLogger().info("[Spawn] " + player.getName() + " at (" + spawn.getBlockX() + ", " + spawn.getBlockY() + ", " + spawn.getBlockZ() + "), distance from center: " + (int)distance + "/" + (int)radius);
            player.teleport(spawn);
            usedLocations.add(new Pair<Integer, Integer>(spawn.getBlockX(), spawn.getBlockZ()));
        }
    }

    @NotNull
    public final Location getRandomSpawnLocation(@NotNull Arena arena, @NotNull Set<Pair<Integer, Integer>> usedLocations, int minDistance) {
        Intrinsics.checkNotNullParameter(arena, "arena");
        Intrinsics.checkNotNullParameter(usedLocations, "usedLocations");
        Location center = arena.getBoundaries().getCenter();
        double diameter = arena.getBoundaries().getSize();
        double radius = diameter / 2.0;
        double maxOffset = radius * 0.5;
        World world = arena.getWorld();
        this.plugin.getLogger().info("[Spawn] Arena diameter: " + diameter + ", radius: " + radius + ", spawn range: " + maxOffset);
        int attempts = 0;
        int maxAttempts = 50;
        while (attempts < maxAttempts) {
            Integer safeY;
            boolean isFarEnough;
            double distanceFromCenter;
            int spawnZ;
            int spawnX;
            block6: {
                double offsetX = Math.random() * maxOffset * (double)2 - maxOffset;
                double offsetZ = Math.random() * maxOffset * (double)2 - maxOffset;
                spawnX = (int)((double)center.getBlockX() + offsetX);
                spawnZ = (int)((double)center.getBlockZ() + offsetZ);
                Location testLocation = new Location(world, (double)spawnX + 0.5, center.getY(), (double)spawnZ + 0.5);
                distanceFromCenter = testLocation.distance(center);
                if (distanceFromCenter > maxOffset) {
                    ++attempts;
                    continue;
                }
                Iterable $this$all$iv = usedLocations;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl = false;
                        int usedX = ((Number)pair.component1()).intValue();
                        int usedZ = ((Number)pair.component2()).intValue();
                        double distance = Math.sqrt((spawnX - usedX) * (spawnX - usedX) + (spawnZ - usedZ) * (spawnZ - usedZ));
                        if (distance >= (double)minDistance) continue;
                        v0 = false;
                        break block6;
                    }
                    v0 = isFarEnough = true;
                }
            }
            if (isFarEnough && (safeY = this.findSafeGroundY(world, spawnX, spawnZ)) != null) {
                Location spawnLocation = new Location(world, (double)spawnX + 0.5, (double)safeY.intValue(), (double)spawnZ + 0.5, 0.0f, 0.0f);
                this.plugin.getLogger().info("[Spawn Check] Location at (" + spawnX + ", " + safeY + ", " + spawnZ + "), distance from center: " + (int)distanceFromCenter + "/" + (int)radius + " (" + (int)(distanceFromCenter / radius * (double)100) + "%)");
                return spawnLocation;
            }
            ++attempts;
        }
        this.plugin.getLogger().warning("[Spawn] Could not find safe spawn location after " + maxAttempts + " attempts, using center");
        Integer n = this.findSafeGroundY(world, center.getBlockX(), center.getBlockZ());
        int safeY = n != null ? n : world.getHighestBlockYAt(center.getBlockX(), center.getBlockZ()) + 1;
        return new Location(world, (double)center.getBlockX() + 0.5, (double)safeY, (double)center.getBlockZ() + 0.5, 0.0f, 0.0f);
    }

    public static /* synthetic */ Location getRandomSpawnLocation$default(GameManager gameManager, Arena arena, Set set, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n2 & 4) != 0) {
            n = 5;
        }
        return gameManager.getRandomSpawnLocation(arena, set, n);
    }

    private final Integer findSafeGroundY(World world, int x, int z) {
        int y;
        int maxY = world.getMaxHeight();
        int minY = world.getMinHeight();
        if (minY <= (y = maxY)) {
            while (true) {
                Block groundBlock;
                Intrinsics.checkNotNullExpressionValue(world.getBlockAt(x, y, z), "getBlockAt(...)");
                Intrinsics.checkNotNullExpressionValue(world.getBlockAt(x, y + 1, z), "getBlockAt(...)");
                Intrinsics.checkNotNullExpressionValue(world.getBlockAt(x, y + 2, z), "getBlockAt(...)");
                if (groundBlock.getType().isSolid()) {
                    Material material = groundBlock.getType();
                    Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
                    if (!this.isDangerousBlock(material)) {
                        Block aboveBlock;
                        Material material2 = aboveBlock.getType();
                        Intrinsics.checkNotNullExpressionValue(material2, "getType(...)");
                        if (this.isSafeAir(material2)) {
                            Block aboveBlock2;
                            Material material3 = aboveBlock2.getType();
                            Intrinsics.checkNotNullExpressionValue(material3, "getType(...)");
                            if (this.isSafeAir(material3)) {
                                this.plugin.getLogger().info("[Safe Ground] Found at (" + x + ", " + (y + 1) + ", " + z + "): ground=" + groundBlock.getType() + ", above=" + aboveBlock.getType());
                                return y + 1;
                            }
                        }
                    }
                }
                if (y == minY) break;
                --y;
            }
        }
        this.plugin.getLogger().warning("[Safe Ground] No safe ground found at (" + x + ", " + z + ")");
        return null;
    }

    private final boolean isDangerousBlock(Material material) {
        return switch (WhenMappings.$EnumSwitchMapping$1[material.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7 -> true;
            default -> false;
        };
    }

    private final boolean isSafeAir(Material material) {
        return switch (WhenMappings.$EnumSwitchMapping$1[material.ordinal()]) {
            case 8, 9, 10 -> true;
            default -> false;
        };
    }

    @Deprecated(message="Use isSafeAir for spawn checking")
    private final boolean isPassableBlock(Material material) {
        return material.isAir() || !material.isSolid();
    }

    private final void giveShopItems(Game game) {
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this.giveShopItemToPlayer(player);
        }
    }

    public final void giveShopItemToPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ShopManager shopManager = this.shopManager;
        if (shopManager == null) {
            return;
        }
        ShopManager shopMgr = shopManager;
        ConfigurationSection shopConfig = this.configManager.getShop().getConfigurationSection("shop");
        if (shopConfig == null) {
            return;
        }
        ShopConfig config = new ShopConfig(shopConfig);
        int slot = config.getShopItemSlot();
        ItemStack shopItem = shopMgr.createShopItem();
        player.getInventory().setItem(slot, shopItem);
    }

    public final void handleCapture(@NotNull Player capturer, @NotNull Player captured) {
        Intrinsics.checkNotNullParameter(capturer, "capturer");
        Intrinsics.checkNotNullParameter(captured, "captured");
        Game game = this.activeGame;
        if (game == null) {
            return;
        }
        Game game2 = game;
        PlayerGameData playerGameData = game2.getPlayers().get(captured.getUniqueId());
        if (playerGameData == null) {
            return;
        }
        PlayerGameData capturedData = playerGameData;
        switch (WhenMappings.$EnumSwitchMapping$2[this.configManager.getCaptureMode().ordinal()]) {
            case 1: {
                Team mainHiderTeam;
                capturedData.setRole(PlayerRole.SPECTATOR);
                captured.setGameMode(GameMode.SPECTATOR);
                Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
                Scoreboard mainScoreboard = scoreboard;
                Team mainSpectatorTeam = mainScoreboard.getTeam("hs_spectators");
                Team team = mainHiderTeam = mainScoreboard.getTeam("hs_hiders");
                if (team != null) {
                    team.removeEntry(captured.getName());
                }
                Team team2 = mainSpectatorTeam;
                if (team2 != null) {
                    team2.addEntry(captured.getName());
                }
                this.plugin.getLogger().info("[Team] " + captured.getName() + " \u9b3c\u5316 - moved from \u4eba to \u89b3\u6226\u8005 team (main scoreboard)");
                Iterable $this$forEach$iv = game2.getPlayers().keySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Team hiderTeam;
                    Scoreboard playerScoreboard;
                    Player player;
                    UUID uuid = (UUID)element$iv;
                    boolean bl = false;
                    if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(player.getScoreboard(), "getScoreboard(...)");
                    if (Intrinsics.areEqual(playerScoreboard, mainScoreboard)) continue;
                    Team spectatorTeam = playerScoreboard.getTeam("hs_spectators");
                    Team team3 = hiderTeam = playerScoreboard.getTeam("hs_hiders");
                    if (team3 != null) {
                        team3.removeEntry(captured.getName());
                    }
                    Team team4 = spectatorTeam;
                    if (team4 == null) continue;
                    team4.addEntry(captured.getName());
                }
                this.plugin.getLogger().info("[Team] " + captured.getName() + " team updated in all individual scoreboards");
                MessageUtil.INSTANCE.send((CommandSender)captured, "&cYou were captured by " + capturer.getName() + "! &7\u89b3\u6226\u30e2\u30fc\u30c9\u306b\u306a\u308a\u307e\u3057\u305f");
                break;
            }
            case 2: {
                Team mainHiderTeam;
                capturedData.setRole(PlayerRole.SEEKER);
                capturedData.setCaptured(false);
                Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
                Scoreboard mainScoreboard = scoreboard;
                Team mainSeekerTeam = mainScoreboard.getTeam("hs_seekers");
                Team team = mainHiderTeam = mainScoreboard.getTeam("hs_hiders");
                if (team != null) {
                    team.removeEntry(captured.getName());
                }
                Team team5 = mainSeekerTeam;
                if (team5 != null) {
                    team5.addEntry(captured.getName());
                }
                this.plugin.getLogger().info("[Team] " + captured.getName() + " \u9b3c\u5316 - moved from \u4eba to \u9b3c team (main scoreboard)");
                Iterable $this$forEach$iv = game2.getPlayers().keySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Team hiderTeam;
                    Scoreboard playerScoreboard;
                    Player player;
                    UUID uuid = (UUID)element$iv;
                    boolean bl = false;
                    if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue(player.getScoreboard(), "getScoreboard(...)");
                    if (Intrinsics.areEqual(playerScoreboard, mainScoreboard)) continue;
                    Team seekerTeam = playerScoreboard.getTeam("hs_seekers");
                    Team team6 = hiderTeam = playerScoreboard.getTeam("hs_hiders");
                    if (team6 != null) {
                        team6.removeEntry(captured.getName());
                    }
                    Team team7 = seekerTeam;
                    if (team7 == null) continue;
                    team7.addEntry(captured.getName());
                }
                this.plugin.getLogger().info("[Team] " + captured.getName() + " team updated in all individual scoreboards");
                this.giveShopItemToPlayer(captured);
                MessageUtil.INSTANCE.send((CommandSender)captured, "&cYou were captured by " + capturer.getName() + "! &e\u9b3c\u306b\u306a\u308a\u307e\u3057\u305f\uff01");
                MessageUtil.INSTANCE.send((CommandSender)capturer, "&a" + captured.getName() + " \u3092\u6355\u307e\u3048\u307e\u3057\u305f\uff01 &e" + captured.getName() + "\u304c\u9b3c\u306b\u306a\u308a\u307e\u3057\u305f\uff01");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void revertSeekerToHider(@NotNull Player seeker, @NotNull PlayerGameData seekerData, @NotNull Game game) {
        EffectManagerImpl effectManager;
        int n;
        Intrinsics.checkNotNullParameter(seeker, "seeker");
        Intrinsics.checkNotNullParameter(seekerData, "seekerData");
        Intrinsics.checkNotNullParameter(game, "game");
        this.plugin.getLogger().info("[Reversion] " + seeker.getName() + " reverting to HIDER");
        seekerData.setRole(PlayerRole.HIDER);
        seekerData.setCaptured(false);
        SeekerStrengthManager seekerStrengthManager = this.seekerStrengthManager;
        if (seekerStrengthManager != null) {
            UUID uUID = seeker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            n = seekerStrengthManager.getStrength(uUID);
        } else {
            n = 0;
        }
        int previousStrength = n;
        SeekerStrengthManager seekerStrengthManager2 = this.seekerStrengthManager;
        if (seekerStrengthManager2 != null) {
            UUID uUID = seeker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            seekerStrengthManager2.resetStrength(uUID);
        }
        int hiderPoints = seekerData.getHiderPoints();
        PointManager pointManager = this.pointManager;
        if (pointManager != null) {
            UUID uUID = seeker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            pointManager.setPoints(uUID, hiderPoints);
        }
        this.plugin.getLogger().info("[Reversion] Restored " + seeker.getName() + " points to " + hiderPoints + " (from hiderPoints)");
        Plugin plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        EffectManagerImpl effectManagerImpl = effectManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getEffectManager() : null;
        if (effectManagerImpl != null) {
            UUID uUID = seeker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            effectManagerImpl.removeAllEffects(uUID);
        }
        this.updateTeamForReversion(seeker, game);
        Location spawnLocation = GameManager.getRandomSpawnLocation$default(this, game.getArena(), null, 0, 6, null);
        seeker.teleport(spawnLocation);
        seeker.getInventory().clear();
        this.giveShopItemToPlayer(seeker);
        MessageUtil.INSTANCE.send((CommandSender)seeker, "&a\u3042\u306a\u305f\u306f\u4eba\u9593\u306b\u623b\u308a\u307e\u3057\u305f\uff01");
        this.broadcastToActiveGame("&e" + seeker.getName() + " \u304c\u4eba\u9593\u306b\u623b\u308a\u307e\u3057\u305f\uff01");
        seeker.playSound(seeker.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        seeker.getWorld().spawnParticle(Particle.ENCHANT, seeker.getLocation(), 50, 0.5, 1.0, 0.5);
        this.plugin.getLogger().info("[Reversion] " + seeker.getName() + " successfully reverted to HIDER (previous strength: " + previousStrength + ", restored points: " + hiderPoints + ")");
    }

    private final void updateTeamForReversion(Player player, Game game) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        Team seekerTeam = mainScoreboard.getTeam("hs_seekers");
        Team hiderTeam = mainScoreboard.getTeam("hs_hiders");
        Team team = seekerTeam;
        if (team != null) {
            team.removeEntry(player.getName());
        }
        Team team2 = hiderTeam;
        if (team2 != null) {
            team2.addEntry(player.getName());
        }
        this.plugin.getLogger().info("[Team] " + player.getName() + " moved from SEEKER to HIDER team (reversion)");
        Iterable $this$forEach$iv = game.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scoreboard playerScoreboard;
            Player otherPlayer;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(otherPlayer.getScoreboard(), "getScoreboard(...)");
            if (Intrinsics.areEqual(playerScoreboard, mainScoreboard)) continue;
            Team otherSeekerTeam = playerScoreboard.getTeam("hs_seekers");
            Team otherHiderTeam = playerScoreboard.getTeam("hs_hiders");
            Team team3 = otherSeekerTeam;
            if (team3 != null) {
                team3.removeEntry(player.getName());
            }
            Team team4 = otherHiderTeam;
            if (team4 == null) continue;
            team4.addEntry(player.getName());
        }
        this.plugin.getLogger().info("[Team] " + player.getName() + " team updated in all individual scoreboards");
    }

    private final void applyWorldBorder(Game game) {
        World world = game.getArena().getWorld();
        game.setWorldBorderBackup(WorldBorderBackup.Companion.capture(world));
        WorldBorder worldBorder = world.getWorldBorder();
        Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
        WorldBorder worldBorder2 = worldBorder;
        ArenaBoundaries boundaries = game.getArena().getBoundaries();
        Location center = boundaries.getCenter();
        double diameter = boundaries.getSize();
        worldBorder2.setCenter(center);
        worldBorder2.setSize(diameter);
        worldBorder2.setWarningDistance(5);
        worldBorder2.setDamageAmount(0.2);
        worldBorder2.setDamageBuffer(0.0);
        this.plugin.getLogger().info("[WorldBorder] Set border at (" + center.getBlockX() + ", " + center.getBlockZ() + ") with diameter " + diameter);
    }

    private final void startPreparationPhase(Game game) {
        Player player;
        UUID uuid;
        game.setPhase(GamePhase.PREPARATION);
        game.setPhaseStartTime(System.currentTimeMillis());
        GameScoreboard gameScoreboard = this.gameScoreboard;
        if (gameScoreboard != null) {
            gameScoreboard.startUpdating(game);
        }
        Iterable $this$forEach$iv = game.getSeekers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 300, 1, false, false));
            player.setSendViewDistance(0);
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 300, 255, false, false));
            player.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 300, 255, false, false));
            MessageUtil.INSTANCE.send((CommandSender)player, "&c\u3042\u306a\u305f\u306f\u9b3c\u3067\u3059\uff01");
            MessageUtil.INSTANCE.send((CommandSender)player, "&7You cannot move or see for 15 seconds...");
            player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&c&l\u9b3c"), (Component)MessageUtil.INSTANCE.colorize("&715\u79d2\u5f8c\u306b\u30b2\u30fc\u30e0\u958b\u59cb\uff01"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(500L))));
        }
        $this$forEach$iv = game.getHiders();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl3 = false;
            player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&a&l\u4eba"), (Component)MessageUtil.INSTANCE.colorize("&7\u9b3c\u304b\u3089\u9003\u3052\u308d\uff01"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(500L))));
        }
        this.broadcastToGame(game, "&e===[ Game Started! ]===");
        this.broadcastToGame(game, "&7Preparation phase: " + this.configManager.getPreparationTime() + " seconds");
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> GameManager.startPreparationPhase$lambda$2(this, game), 300L);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> GameManager.startPreparationPhase$lambda$3(this, game), (long)(this.configManager.getPreparationTime() * 20));
    }

    private final void startSeekPhase(Game game) {
        game.setPhase(GamePhase.SEEKING);
        game.setPhaseStartTime(System.currentTimeMillis());
        this.broadcastToGame(game, "&e===[ Seeking Phase Started! ]===");
        double pointsPerSecond = this.configManager.getConfig().getDouble("points.points-per-second", 1.0);
        int accumulationInterval = this.configManager.getConfig().getInt("points.accumulation-interval", 15);
        PointManager pointManager = this.pointManager;
        if (pointManager != null) {
            pointManager.startPointAccumulation(game, pointsPerSecond, accumulationInterval * 20);
        }
        int seekTime = this.configManager.getSeekTime();
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> GameManager.startSeekPhase$lambda$0(this, game, seekTime), (long)(seekTime * 20));
    }

    public final void endGame(@NotNull GameResult result) {
        Intrinsics.checkNotNullParameter((Object)result, "result");
        Game game = this.activeGame;
        if (game == null) {
            return;
        }
        Game game2 = game;
        game2.setPhase(GamePhase.ENDED);
        GameScoreboard gameScoreboard = this.gameScoreboard;
        if (gameScoreboard != null) {
            gameScoreboard.stopUpdating();
        }
        PointManager pointManager = this.pointManager;
        if (pointManager != null) {
            pointManager.stopPointAccumulation();
        }
        Integer n = game2.getNightSkipTaskId();
        if (n != null) {
            int taskId = ((Number)n).intValue();
            boolean bl = false;
            Bukkit.getScheduler().cancelTask(taskId);
            game2.setNightSkipTaskId(null);
        }
        DisguiseManager disguiseManager = this.disguiseManager;
        if (disguiseManager != null) {
            disguiseManager.clearAllDisguises();
        }
        List<Object> winners = switch (WhenMappings.$EnumSwitchMapping$3[result.ordinal()]) {
            case 1 -> game2.getHiders();
            case 2 -> game2.getSeekers();
            case 3 -> CollectionsKt.emptyList();
            default -> throw new NoWhenBranchMatchedException();
        };
        Iterable $this$forEach$iv = game2.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            Unit resultTitle = switch (WhenMappings.$EnumSwitchMapping$3[result.ordinal()]) {
                case 3 -> {
                    Player player;
                    player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&7&l\u30b2\u30fc\u30e0\u4e2d\u6b62"), (Component)MessageUtil.INSTANCE.colorize("&7Game Cancelled"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(1000L))));
                    yield Unit.INSTANCE;
                }
                case 2 -> {
                    Player player;
                    player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&e&l\u30b2\u30fc\u30e0\u7d42\u4e86"), (Component)MessageUtil.INSTANCE.colorize("&c\u5168\u54e1\u9b3c\u5316\uff01"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(1000L))));
                    player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    yield Unit.INSTANCE;
                }
                case 1 -> {
                    Player player;
                    player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&e&l\u30b2\u30fc\u30e0\u7d42\u4e86"), (Component)MessageUtil.INSTANCE.colorize("&a\u6642\u9593\u5207\u308c\uff01"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(1000L))));
                    player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                    yield Unit.INSTANCE;
                }
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        this.broadcastToGame(game2, "&e===[ Game Over! ]===");
        this.broadcastToGame(game2, "&aResult: " + this.getResultMessage(result));
        this.broadcastToGame(game2, "");
        this.displayStats(game2);
        this.displayRankings(game2);
        this.restorePlayers(game2);
        WorldBorderBackup worldBorderBackup = game2.getWorldBorderBackup();
        if (worldBorderBackup != null) {
            worldBorderBackup.restore(game2.getArena().getWorld());
        }
        this.cleanupTeams(game2);
        if (this.configManager.isAutoRestartEnabled() && result != GameResult.CANCELLED) {
            game2.setPhase(GamePhase.POST_GAME);
            game2.setPhaseStartTime(System.currentTimeMillis());
            this.activeGame = game2;
            this.startAutoRestartTimer(game2);
        } else {
            this.activeGame = null;
        }
        this.broadcastToGame(game2, "&7Thank you for playing!");
    }

    private final String getResultMessage(GameResult result) {
        return switch (WhenMappings.$EnumSwitchMapping$3[result.ordinal()]) {
            case 1 -> "\u4eba\u9593\u306e\u52dd\u5229\uff01";
            case 2 -> "\u9b3c\u306e\u52dd\u5229\uff01";
            case 3 -> "\u30b2\u30fc\u30e0\u4e2d\u6b62";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void displayStats(Game game) {
        Object v0;
        void $this$maxByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        this.broadcastToGame(game, "&e--- Game Statistics ---");
        long duration = (System.currentTimeMillis() - game.getStartTime()) / (long)1000;
        this.broadcastToGame(game, "&7Duration: " + duration + "s");
        this.broadcastToGame(game, "&7Total Captures: " + game.getCaptured().size() + "/" + game.getHiders().size());
        Iterable iterable = game.getPlayers().values();
        boolean $i$f$filter = false;
        void var7_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerGameData it = (PlayerGameData)element$iv$iv;
            boolean bl = false;
            if (!(it.getRole() == PlayerRole.SEEKER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                PlayerGameData it = (PlayerGameData)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getCaptureCount();
                do {
                    Object e$iv = iterator$iv.next();
                    PlayerGameData it2 = (PlayerGameData)e$iv;
                    $i$a$-maxByOrNull-GameManager$displayStats$topSeeker$2 = false;
                    int v$iv = it2.getCaptureCount();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        PlayerGameData topSeeker = v0;
        if (topSeeker != null && topSeeker.getCaptureCount() > 0) {
            Player player = Bukkit.getPlayer((UUID)topSeeker.getUuid());
            if (player != null) {
                Player player2 = player;
                boolean bl = false;
                this.broadcastToGame(game, "&7\u6700\u591a\u9b3c\u5316: " + player2.getName() + " (" + topSeeker.getCaptureCount() + "\u4eba\u9b3c\u5316)");
            }
        }
        this.broadcastToGame(game, "");
    }

    private final void displayRankings(Game game) {
        PointManager pointManager = this.pointManager;
        if (pointManager == null) {
            return;
        }
        PointManager pointMgr = pointManager;
        this.plugin.getLogger().info("[Rankings] === Player Points Debug ===");
        Iterable $this$forEach$iv = game.getPlayers().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerGameData playerData = (PlayerGameData)element$iv;
            boolean bl = false;
            Player player = Bukkit.getPlayer((UUID)playerData.getUuid());
            Logger logger = this.plugin.getLogger();
            Object object = player;
            if (object == null || (object = object.getName()) == null) {
                object = playerData.getUuid();
            }
            logger.info("[Rankings] " + object + ": \u4eba=" + playerData.getHiderPoints() + ", \u9b3c=" + playerData.getSeekerPoints() + ", Total=" + pointMgr.getPoints(playerData.getUuid()));
        }
        this.broadcastToGame(game, "&e--- Individual Rankings ---");
        this.broadcastToGame(game, "&7(Players can appear in both rankings)");
        this.broadcastToGame(game, "");
        this.broadcastToGame(game, "&a&l\u4eba\u9593\u30e9\u30f3\u30ad\u30f3\u30b0:");
        List<Pair<UUID, Integer>> hiderRankings = pointMgr.getRankedPlayersByRolePoints(game, PlayerRole.HIDER);
        if (hiderRankings.isEmpty()) {
            this.broadcastToGame(game, "&7  \u4eba\u9593\u306a\u3057");
        } else {
            Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)hiderRankings, 5);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String medal;
                int player;
                if ((player = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = player;
                boolean bl = false;
                UUID uuid = (UUID)pair.component1();
                int points = ((Number)pair.component2()).intValue();
                Player player2 = Bukkit.getPlayer((UUID)uuid);
                if (player2 != null) {
                    medal = switch (index) {
                        case 0 -> "&6\ud83e\udd47";
                        case 1 -> "&7\ud83e\udd48";
                        case 2 -> "&c\ud83e\udd49";
                        default -> "&7" + (index + 1) + ".";
                    };
                    this.broadcastToGame(game, "  " + medal + " &f" + player2.getName() + ": &e" + points + " points");
                    continue;
                }
                medal = switch (index) {
                    case 0 -> "&6\ud83e\udd47";
                    case 1 -> "&7\ud83e\udd48";
                    case 2 -> "&c\ud83e\udd49";
                    default -> "&7" + (index + 1) + ".";
                };
                this.broadcastToGame(game, "  " + medal + " &7[Offline]: &e" + points + " points");
            }
        }
        this.broadcastToGame(game, "");
        this.broadcastToGame(game, "&c&l\u9b3c\u30e9\u30f3\u30ad\u30f3\u30b0:");
        List<Pair<UUID, Integer>> seekerRankings = pointMgr.getRankedPlayersByRolePoints(game, PlayerRole.SEEKER);
        if (seekerRankings.isEmpty()) {
            this.broadcastToGame(game, "&7  \u9b3c\u306a\u3057");
        } else {
            Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)seekerRankings, 5);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String medal;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl = false;
                UUID uuid = (UUID)pair.component1();
                int points = ((Number)pair.component2()).intValue();
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player != null) {
                    medal = switch (index) {
                        case 0 -> "&6\ud83e\udd47";
                        case 1 -> "&7\ud83e\udd48";
                        case 2 -> "&c\ud83e\udd49";
                        default -> "&7" + (index + 1) + ".";
                    };
                    this.broadcastToGame(game, "  " + medal + " &f" + player.getName() + ": &e" + points + " points");
                    continue;
                }
                medal = switch (index) {
                    case 0 -> "&6\ud83e\udd47";
                    case 1 -> "&7\ud83e\udd48";
                    case 2 -> "&c\ud83e\udd49";
                    default -> "&7" + (index + 1) + ".";
                };
                this.broadcastToGame(game, "  " + medal + " &7[Offline]: &e" + points + " points");
            }
        }
        this.broadcastToGame(game, "");
    }

    private final void restorePlayers(Game game) {
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            PlayerGameData playerData = entry.getValue();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            PlayerBackup playerBackup = playerData.getBackup();
            if (playerBackup != null) {
                playerBackup.restore(player);
            }
            GameScoreboard gameScoreboard = this.gameScoreboard;
            if (gameScoreboard == null) continue;
            gameScoreboard.removePlayer(player);
        }
        this.cleanupTeams(game);
    }

    private final void broadcastToWaiting(String message) {
        Iterable $this$forEach$iv = this.waitingPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            MessageUtil.INSTANCE.send((CommandSender)it, message);
        }
    }

    private final void broadcastToGame(Game game, String message) {
        Iterable $this$forEach$iv = game.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            MessageUtil.INSTANCE.send((CommandSender)it, message);
        }
    }

    public final void broadcastToActiveGame(@NotNull String message) {
        block0: {
            Intrinsics.checkNotNullParameter(message, "message");
            Game game = this.activeGame;
            if (game == null) break block0;
            Game game2 = game;
            boolean bl = false;
            this.broadcastToGame(game2, message);
        }
    }

    @NotNull
    public final List<UUID> getWaitingPlayers() {
        return CollectionsKt.toList((Iterable)this.waitingPlayers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isInGame(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.waitingPlayers.contains(player.getUniqueId())) return true;
        Game game = this.activeGame;
        Object object = game;
        if (game == null) return false;
        Map<UUID, PlayerGameData> map = ((Game)object).getPlayers();
        object = map;
        if (map == null) return false;
        if (!object.containsKey(player.getUniqueId())) return false;
        return true;
    }

    private final void checkAutoStart() {
        if (this.activeGame != null) {
            return;
        }
        int minPlayers = this.configManager.getMinPlayers();
        if (this.waitingPlayers.size() >= minPlayers) {
            Arena arena;
            ArenaManager arenaManager = this.arenaManager;
            Arena arena2 = arena = arenaManager != null ? arenaManager.getRandomArena() : null;
            if (arena == null) {
                this.broadcastToWaiting("&cNo arenas available. Cannot start game.");
                return;
            }
            this.broadcastToWaiting("&aStarting game on arena: &e" + arena.getDisplayName());
            this.startGameCountdown(arena, 3);
        }
    }

    private final void broadcastToServer(String message) {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(player);
            MessageUtil.INSTANCE.send((CommandSender)player, message);
        }
    }

    private final void tryStartGame() {
        Arena arena;
        this.plugin.getLogger().info("[AutoRestart] tryStartGame() called with " + this.waitingPlayers.size() + " waiting players");
        ArenaManager arenaManager = this.arenaManager;
        Arena arena2 = arena = arenaManager != null ? arenaManager.getRandomArena() : null;
        if (arena != null) {
            this.plugin.getLogger().info("[AutoRestart] Arena selected: " + arena.getDisplayName() + ", starting countdown");
            this.startGameCountdown(arena, 3);
        } else {
            this.plugin.getLogger().warning("[AutoRestart] No arenas available!");
            this.broadcastToWaiting("&cNo arenas available. Cannot start game.");
        }
    }

    private final void startGameCountdown(Arena arena, int seconds) {
        this.plugin.getLogger().info("[AutoRestart] Starting countdown from " + seconds + " seconds");
        Ref.IntRef remaining = new Ref.IntRef();
        remaining.element = seconds;
        Runnable countdownTask2 = new Runnable(remaining, this, arena){
            final /* synthetic */ Ref.IntRef $remaining;
            final /* synthetic */ GameManager this$0;
            final /* synthetic */ Arena $arena;
            {
                this.$remaining = $remaining;
                this.this$0 = $receiver;
                this.$arena = $arena;
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                void $this$forEach$iv;
                if (this.$remaining.element <= 0) {
                    this.this$0.getPlugin().getLogger().info("[AutoRestart] Countdown finished, calling startGame()");
                    this.this$0.startGame(this.$arena);
                    return;
                }
                Iterable iterable = GameManager.access$getWaitingPlayers$p(this.this$0);
                Ref.IntRef intRef = this.$remaining;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Player player;
                    UUID uuid = (UUID)element$iv;
                    boolean bl = false;
                    if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                    boolean bl2 = false;
                    String color = switch (intRef.element) {
                        case 1 -> "&c";
                        case 2 -> "&e";
                        default -> "&a";
                    };
                    player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize(color + "&l" + intRef.element), (Component)MessageUtil.INSTANCE.colorize("&7\u30b2\u30fc\u30e0\u958b\u59cb\u307e\u3067..."), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis(250L))));
                }
                int n = this.$remaining.element;
                this.$remaining.element = n + -1;
                Bukkit.getScheduler().runTaskLater(this.this$0.getPlugin(), (Runnable)this, 20L);
            }
        };
        Bukkit.getScheduler().runTask(this.plugin, countdownTask2);
    }

    public final void startAutoRestartTimer(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        if (!this.configManager.isAutoRestartEnabled()) {
            return;
        }
        int countdownSeconds = this.configManager.getPostGameCountdown();
        int broadcastInterval = this.configManager.getBroadcastInterval();
        game.setAutoRestartStartTime(System.currentTimeMillis());
        int countdownTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> GameManager.startAutoRestartTimer$lambda$0(game, countdownSeconds, this, broadcastInterval), 0L, 20L);
        game.setAutoRestartTaskId(countdownTaskId);
        this.plugin.getLogger().info("Auto-restart timer started: " + countdownSeconds + "s countdown");
    }

    public final void cancelAutoRestartTimer(@NotNull Game game) {
        block0: {
            Intrinsics.checkNotNullParameter(game, "game");
            Integer n = game.getAutoRestartTaskId();
            if (n == null) break block0;
            int taskId = ((Number)n).intValue();
            boolean bl = false;
            Bukkit.getScheduler().cancelTask(taskId);
            game.setAutoRestartTaskId(null);
            this.plugin.getLogger().info("Auto-restart timer cancelled");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transitionToWaiting(Game game) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        this.plugin.getLogger().info("[AutoRestart] Transitioning to WAITING phase");
        List previousPlayers = CollectionsKt.toList((Iterable)game.getPlayers().keySet());
        this.broadcastToGame(game, "&a\u30b2\u30fc\u30e0\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u65b0\u3057\u3044\u30b2\u30fc\u30e0\u306e\u6e96\u5099\u4e2d...");
        Iterable $this$mapNotNull$iv = previousPlayers;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (Bukkit.getPlayer((UUID)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!it.isOnline()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            SpectatorManager spectatorManager;
            Player player = (Player)element$iv$iv;
            boolean bl4 = false;
            Plugin plugin = this.plugin;
            HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
            SpectatorManager spectatorManager2 = spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
            if (spectatorManager2 != null) {
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                bl = spectatorManager2.isSpectator(uUID);
            } else {
                bl = false;
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List activePlayers = (List)destination$iv$iv;
        int minPlayers = this.configManager.getMinPlayers();
        this.plugin.getLogger().info("[AutoRestart] Active players: " + activePlayers.size() + ", Min required: " + minPlayers);
        Iterable $this$forEach$iv = activePlayers;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            this.plugin.getLogger().info("[AutoRestart]   - " + player.getName());
        }
        this.activeGame = null;
        this.plugin.getLogger().info("[AutoRestart] Cleared activeGame, will create new Game object");
        if (activePlayers.size() >= minPlayers) {
            this.broadcastToServer("&a\u898f\u5b9a\u4eba\u6570\u306b\u9054\u3057\u307e\u3057\u305f\uff01\u30b2\u30fc\u30e0\u3092\u958b\u59cb\u3057\u307e\u3059...");
            this.plugin.getLogger().info("[AutoRestart] Starting new game with " + activePlayers.size() + " players");
            this.waitingPlayers.clear();
            $this$forEach$iv = activePlayers;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Player)element$iv;
                boolean bl = false;
                UUID uUID = it.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                this.waitingPlayers.add(uUID);
            }
            this.tryStartGame();
        } else {
            this.broadcastToServer("&e\u53c2\u52a0\u30d7\u30ec\u30a4\u30e4\u30fc\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\uff08" + activePlayers.size() + "/" + minPlayers + "\u4eba\uff09");
            this.broadcastToServer("&e\u898f\u5b9a\u4eba\u6570\u306b\u9054\u3059\u308b\u307e\u3067\u5f85\u6a5f\u3057\u307e\u3059...");
            this.plugin.getLogger().info("[AutoRestart] Insufficient players, waiting for more");
            this.waitingPlayers.clear();
            $this$forEach$iv = activePlayers;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Player)element$iv;
                boolean bl = false;
                UUID uUID = it.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                this.waitingPlayers.add(uUID);
            }
        }
    }

    public final int getActivePlayerCount() {
        int n;
        Plugin plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SpectatorManager spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
        Iterable $this$count$iv = this.waitingPlayers;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                UUID uuid = (UUID)element$iv;
                boolean bl = false;
                SpectatorManager spectatorManager2 = spectatorManager;
                boolean isSpectator = spectatorManager2 != null ? spectatorManager2.isSpectator(uuid) : false;
                if (!(!isSpectator) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    private static final void setupWorldTime$lambda$0(World $world) {
        if ($world.getTime() >= 12542L || $world.getTime() <= 23459L) {
            boolean isNight;
            long l = $world.getTime();
            boolean bl = 12542L <= l ? l < 24000L : (isNight = false);
            if (isNight) {
                $world.setTime(1000L);
            }
        }
    }

    private static final void startPreparationPhase$lambda$2(GameManager this$0, Game $game) {
        if (Intrinsics.areEqual(this$0.activeGame, $game)) {
            Iterable $this$forEach$iv = $game.getSeekers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UUID uuid = (UUID)element$iv;
                boolean bl = false;
                if (Bukkit.getPlayer((UUID)uuid) != null) {
                    Player player;
                    boolean bl2 = false;
                    player.setSendViewDistance(10);
                    MessageUtil.INSTANCE.send((CommandSender)player, "&aYou can now see and move!");
                }
            }
        }
    }

    private static final void startPreparationPhase$lambda$3(GameManager this$0, Game $game) {
        if (Intrinsics.areEqual(this$0.activeGame, $game)) {
            this$0.startSeekPhase($game);
        }
    }

    private static final void startSeekPhase$lambda$0(GameManager this$0, Game $game, int $seekTime) {
        GameResult result;
        if (Intrinsics.areEqual(this$0.activeGame, $game) && $game.getPhase() == GamePhase.SEEKING && (result = $game.checkWinCondition((long)$seekTime * (long)1000)) != null) {
            this$0.endGame(result);
        }
    }

    private static final void startAutoRestartTimer$lambda$0(Game $game, int $countdownSeconds, GameManager this$0, int $broadcastInterval) {
        long elapsed = (System.currentTimeMillis() - $game.getAutoRestartStartTime()) / (long)1000;
        int remaining = $countdownSeconds - (int)elapsed;
        if (remaining <= 0) {
            Integer n = $game.getAutoRestartTaskId();
            if (n == null) {
                return;
            }
            Bukkit.getScheduler().cancelTask(n.intValue());
            $game.setAutoRestartTaskId(null);
            this$0.transitionToWaiting($game);
        } else if (remaining % $broadcastInterval == 0 || remaining <= 5) {
            this$0.broadcastToGame($game, "&e\u6b21\u306e\u30b2\u30fc\u30e0\u307e\u3067 &b" + remaining + " &e\u79d2...");
        }
    }

    public static final /* synthetic */ List access$getWaitingPlayers$p(GameManager $this) {
        return $this.waitingPlayers;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[PlayerRole.values().length];
            try {
                nArray[PlayerRole.SEEKER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.HIDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.SPECTATOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Material.values().length];
            try {
                nArray[Material.LAVA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.MAGMA_BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.FIRE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CAMPFIRE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.SOUL_CAMPFIRE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CACTUS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.SWEET_BERRY_BUSH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.AIR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CAVE_AIR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.VOID_AIR.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[CaptureMode.values().length];
            try {
                nArray[CaptureMode.SPECTATOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaptureMode.INFECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[GameResult.values().length];
            try {
                nArray[GameResult.HIDER_WIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameResult.SEEKER_WIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameResult.CANCELLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

