/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.items;

import com.hideandseek.game.Game;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.items.ItemConfig;
import com.hideandseek.items.ItemEffectHandler;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Result;
import com.hideandseek.libs.kotlin.ResultKt;
import com.hideandseek.libs.kotlin.Unit;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.functions.Function1;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.random.Random;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J-\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/hideandseek/items/DecoyBlockHandler;", "Lcom/hideandseek/items/ItemEffectHandler;", "<init>", "()V", "canApply", "", "player", "Lorg/bukkit/entity/Player;", "game", "Lcom/hideandseek/game/Game;", "apply", "Lcom/hideandseek/libs/kotlin/Result;", "", "config", "Lcom/hideandseek/items/ItemConfig;", "apply-0E7RQCE", "(Lorg/bukkit/entity/Player;Lcom/hideandseek/game/Game;Lcom/hideandseek/items/ItemConfig;)Ljava/lang/Object;", "onExpire", "getDisplayLore", "", "", "Companion", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nDecoyBlockHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecoyBlockHandler.kt\ncom/hideandseek/items/DecoyBlockHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ItemConfig.kt\ncom/hideandseek/items/ItemConfig\n*L\n1#1,164:1\n1788#2,4:165\n67#3:169\n*S KotlinDebug\n*F\n+ 1 DecoyBlockHandler.kt\ncom/hideandseek/items/DecoyBlockHandler\n*L\n71#1:165,4\n94#1:169\n*E\n"})
public final class DecoyBlockHandler
implements ItemEffectHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<UUID, ArmorStand> activeDecoys = new ConcurrentHashMap();

    @Override
    public boolean canApply(@NotNull Player player, @NotNull Game game) {
        int existingDecoys;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        PlayerGameData playerGameData = game.getPlayers().get(player.getUniqueId());
        if (playerGameData == null) {
            return false;
        }
        PlayerGameData playerData = playerGameData;
        if (!Intrinsics.areEqual(playerData.getRole().name(), "HIDER")) {
            return false;
        }
        if (playerData.isCaptured()) {
            return false;
        }
        Collection<ArmorStand> collection = activeDecoys.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            v2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                List metadata;
                ArmorStand armorStand = (ArmorStand)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(armorStand.getMetadata("ownerId"), "getMetadata(...)");
                if (!(!((Collection)metadata).isEmpty() && Intrinsics.areEqual(((MetadataValue)metadata.get(0)).asString(), player.getUniqueId().toString())) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v2 = existingDecoys = count$iv;
        }
        if (existingDecoys >= 2) {
            player.sendMessage("\u00a7c\u30c7\u30b3\u30a4\u306e\u6700\u5927\u6570\u306b\u9054\u3057\u3066\u3044\u307e\u3059\uff08\u6700\u59272\u500b\uff09");
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Object apply-0E7RQCE(@NotNull Player player, @NotNull Game game, @NotNull ItemConfig config) {
        Object object;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(config, "config");
        try {
            Material material;
            Material[] this_$iv;
            Vector vector = player.getLocation().getDirection().normalize().multiply(5);
            Intrinsics.checkNotNullExpressionValue(vector, "multiply(...)");
            Vector direction = vector;
            Location location = player.getLocation().clone().add(direction);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            Location targetLocation = location;
            targetLocation.setY((double)targetLocation.getWorld().getHighestBlockYAt(targetLocation.getBlockX(), targetLocation.getBlockZ()));
            ItemConfig itemConfig = config;
            String key$iv = "blockType";
            boolean $i$f$getMetadata = false;
            Object object2 = this_$iv.getMetadata().get(key$iv);
            if (!(object2 instanceof Material)) {
                object2 = null;
            }
            if ((material = (Material)object2) == null) {
                this_$iv = new Material[]{Material.STONE, Material.DIRT, Material.COBBLESTONE};
                material = (Material)CollectionsKt.random((Collection)CollectionsKt.listOf(this_$iv), Random.Default);
            }
            Material blockType = material;
            Entity entity = targetLocation.getWorld().spawn(targetLocation, ArmorStand.class, arg_0 -> DecoyBlockHandler.apply_0E7RQCE$lambda$1(arg_0 -> DecoyBlockHandler.apply_0E7RQCE$lambda$0(player, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue(entity, "spawn(...)");
            ArmorStand armorStand = (ArmorStand)entity;
            targetLocation.getBlock().setType(blockType);
            UUID decoyId = UUID.randomUUID();
            ((Map)activeDecoys).put(decoyId, armorStand);
            BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
            Plugin plugin = player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
            Intrinsics.checkNotNull(plugin);
            bukkitScheduler.runTaskLater(plugin, () -> DecoyBlockHandler.apply_0E7RQCE$lambda$2(decoyId, targetLocation), (long)(config.getDuration() * 20));
            player.sendMessage("\u00a7a\u2726 \u30c7\u30b3\u30a4\u30d6\u30ed\u30c3\u30af\u3092\u8a2d\u7f6e\u3057\u307e\u3057\u305f");
            player.sendMessage("\u00a77\u5834\u6240: X:" + targetLocation.getBlockX() + ", Y:" + targetLocation.getBlockY() + ", Z:" + targetLocation.getBlockZ());
            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 0.8f);
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Exception e) {
            object = Result.constructor-impl(ResultKt.createFailure(e));
        }
        return object;
    }

    @Override
    public void onExpire(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        player.sendMessage("\u00a77\u30c7\u30b3\u30a4\u30d6\u30ed\u30c3\u30af\u304c\u6d88\u6ec5\u3057\u307e\u3057\u305f");
    }

    @Override
    @NotNull
    public List<String> getDisplayLore(@NotNull ItemConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        String[] stringArray = new String[]{"\u00a77\u507d\u306e\u507d\u88c5\u30d6\u30ed\u30c3\u30af\u3092\u8a2d\u7f6e", "\u00a77\u30b7\u30fc\u30ab\u30fc\u3092\u6b3a\u304f\u305f\u3081\u306e\u30c0\u30df\u30fc", "", "\u00a7b\u52b9\u679c: \u00a7f\u507d\u88c5\u30d6\u30ed\u30c3\u30af\u30925\u30d6\u30ed\u30c3\u30af\u5148\u306b\u8a2d\u7f6e", "\u00a7b\u6301\u7d9a\u6642\u9593: \u00a7f" + config.getDuration() / 60 + "\u5206\u9593", "\u00a7b\u5236\u9650: \u00a7f\u6700\u59272\u500b\u307e\u3067", "", "\u00a77\u30b7\u30fc\u30ab\u30fc\u304c\u653b\u6483\u3057\u3066\u3082\u6355\u7372\u3055\u308c\u307e\u305b\u3093"};
        return CollectionsKt.listOf(stringArray);
    }

    private static final Unit apply_0E7RQCE$lambda$0(Player $player, ArmorStand stand) {
        stand.setVisible(false);
        stand.setSmall(true);
        stand.setGravity(false);
        stand.setMarker(true);
        stand.setInvulnerable(true);
        stand.setAI(false);
        stand.setCustomName("\u00a77\u507d\u88c5\u30d6\u30ed\u30c3\u30af");
        stand.setCustomNameVisible(false);
        Plugin plugin = $player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
        Intrinsics.checkNotNull(plugin);
        stand.setMetadata("ownerId", (MetadataValue)new FixedMetadataValue(plugin, (Object)$player.getUniqueId().toString()));
        Plugin plugin2 = $player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
        Intrinsics.checkNotNull(plugin2);
        stand.setMetadata("isDecoy", (MetadataValue)new FixedMetadataValue(plugin2, (Object)true));
        return Unit.INSTANCE;
    }

    private static final void apply_0E7RQCE$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void apply_0E7RQCE$lambda$2(UUID $decoyId, Location $targetLocation) {
        Intrinsics.checkNotNull($decoyId);
        Companion.removeDecoy($decoyId);
        $targetLocation.getBlock().setType(Material.AIR);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hideandseek/items/DecoyBlockHandler$Companion;", "", "<init>", "()V", "activeDecoys", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lorg/bukkit/entity/ArmorStand;", "removeDecoy", "", "decoyId", "removePlayerDecoys", "playerId", "removeAllDecoys", "EasyHideAndSeek"})
    @SourceDebugExtension(value={"SMAP\nDecoyBlockHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecoyBlockHandler.kt\ncom/hideandseek/items/DecoyBlockHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1869#2,2:165\n*S KotlinDebug\n*F\n+ 1 DecoyBlockHandler.kt\ncom/hideandseek/items/DecoyBlockHandler$Companion\n*L\n52#1:165,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void removeDecoy(@NotNull UUID decoyId) {
            block0: {
                Intrinsics.checkNotNullParameter(decoyId, "decoyId");
                ArmorStand armorStand = (ArmorStand)activeDecoys.remove(decoyId);
                if (armorStand == null) break block0;
                ArmorStand armorStand2 = armorStand;
                boolean bl = false;
                armorStand2.remove();
            }
        }

        public final void removePlayerDecoys(@NotNull UUID playerId) {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            activeDecoys.entrySet().removeIf(arg_0 -> Companion.removePlayerDecoys$lambda$1(arg_0 -> Companion.removePlayerDecoys$lambda$0(playerId, arg_0), arg_0));
        }

        public final void removeAllDecoys() {
            Collection collection = activeDecoys.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ArmorStand it = (ArmorStand)element$iv;
                boolean bl = false;
                it.remove();
            }
            activeDecoys.clear();
        }

        private static final boolean removePlayerDecoys$lambda$0(UUID $playerId, Map.Entry entry) {
            boolean bl;
            Intrinsics.checkNotNullParameter(entry, "<destruct>");
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, "component1(...)");
            UUID decoyId = (UUID)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "component2(...)");
            ArmorStand armorStand = (ArmorStand)v;
            List list = armorStand.getMetadata("ownerId");
            Intrinsics.checkNotNullExpressionValue(list, "getMetadata(...)");
            List metadata = list;
            if (!((Collection)metadata).isEmpty() && Intrinsics.areEqual(((MetadataValue)metadata.get(0)).asString(), $playerId.toString())) {
                armorStand.remove();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        private static final boolean removePlayerDecoys$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

