/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.items;

import com.hideandseek.game.Game;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.items.ItemConfig;
import com.hideandseek.items.ItemEffectHandler;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Result;
import com.hideandseek.libs.kotlin.ResultKt;
import com.hideandseek.libs.kotlin.Triple;
import com.hideandseek.libs.kotlin.Unit;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.comparisons.ComparisonsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.Ref;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J-\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/hideandseek/items/TrackerInsightHandler;", "Lcom/hideandseek/items/ItemEffectHandler;", "<init>", "()V", "canApply", "", "player", "Lorg/bukkit/entity/Player;", "game", "Lcom/hideandseek/game/Game;", "apply", "Lcom/hideandseek/libs/kotlin/Result;", "", "config", "Lcom/hideandseek/items/ItemConfig;", "apply-0E7RQCE", "(Lorg/bukkit/entity/Player;Lcom/hideandseek/game/Game;Lcom/hideandseek/items/ItemConfig;)Ljava/lang/Object;", "onExpire", "getDisplayLore", "", "", "formatTime", "seconds", "", "Companion", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nTrackerInsightHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackerInsightHandler.kt\ncom/hideandseek/items/TrackerInsightHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1021#2,2:150\n*S KotlinDebug\n*F\n+ 1 TrackerInsightHandler.kt\ncom/hideandseek/items/TrackerInsightHandler\n*L\n75#1:150,2\n*E\n"})
public final class TrackerInsightHandler
implements ItemEffectHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<UUID, Long> lastMovementTimes = new LinkedHashMap();

    @Override
    public boolean canApply(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        PlayerGameData playerGameData = game.getPlayers().get(player.getUniqueId());
        if (playerGameData == null) {
            return false;
        }
        PlayerGameData playerData = playerGameData;
        return Intrinsics.areEqual(playerData.getRole().name(), "SEEKER");
    }

    @Override
    @NotNull
    public Object apply-0E7RQCE(@NotNull Player player, @NotNull Game game, @NotNull ItemConfig config) {
        Object object;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(config, "config");
        try {
            List hiderInsights = new ArrayList();
            for (Map.Entry<UUID, PlayerGameData> entry : game.getPlayers().entrySet()) {
                Player hider;
                UUID playerId = entry.getKey();
                PlayerGameData playerData = entry.getValue();
                if (!Intrinsics.areEqual(playerData.getRole().name(), "HIDER") || playerData.isCaptured() || Bukkit.getPlayer((UUID)playerId) == null) continue;
                long secondsSinceMovement = Companion.getSecondsSinceMovement(playerId);
                String status = secondsSinceMovement < 5L ? "\u00a7a\u79fb\u52d5\u4e2d" : (secondsSinceMovement < 15L ? "\u00a7e\u9759\u6b62" : "\u00a7c\u9577\u6642\u9593\u9759\u6b62");
                hiderInsights.add(new Triple<String, Long, String>(hider.getName(), secondsSinceMovement, status));
            }
            List $this$sortByDescending$iv = hiderInsights;
            boolean $i$f$sortByDescending2 = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith($this$sortByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        Triple it = (Triple)b;
                        boolean bl = false;
                        Comparable comparable = (Long)it.getSecond();
                        it = (Triple)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, (Comparable)((Long)it.getSecond()));
                    }
                });
            }
            player.sendMessage("\u00a76\u2726 \u8ffd\u8de1\u306e\u6d1e\u5bdf");
            player.sendMessage("\u00a77\u30cf\u30a4\u30c0\u30fc\u306e\u79fb\u52d5\u72b6\u6cc1:");
            player.sendMessage("");
            if (hiderInsights.isEmpty()) {
                player.sendMessage("  \u00a77\u30cf\u30a4\u30c0\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
            } else {
                for (Triple $i$f$sortByDescending2 : hiderInsights) {
                    String name = (String)$i$f$sortByDescending2.component1();
                    long seconds = ((Number)$i$f$sortByDescending2.component2()).longValue();
                    String status = (String)$i$f$sortByDescending2.component3();
                    String timeStr = this.formatTime(seconds);
                    player.sendMessage("  \u00a77" + name + ": " + status + " \u00a77(" + timeStr + ")");
                }
                player.sendMessage("");
                player.sendMessage("\u00a77\u00a7o\u9577\u6642\u9593\u9759\u6b62\u3057\u3066\u3044\u308b\u30cf\u30a4\u30c0\u30fc\u306f\u507d\u88c5\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u9ad8\u3044");
            }
            player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.2f);
            Plugin plugin = player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
            Intrinsics.checkNotNull(plugin);
            Plugin plugin2 = plugin;
            Ref.IntRef secondsLeft = new Ref.IntRef();
            secondsLeft.element = config.getDuration();
            BukkitRunnable task2 = new BukkitRunnable(secondsLeft, player, hiderInsights){
                final /* synthetic */ Ref.IntRef $secondsLeft;
                final /* synthetic */ Player $player;
                final /* synthetic */ List<Triple<String, Long, String>> $hiderInsights;
                {
                    this.$secondsLeft = $secondsLeft;
                    this.$player = $player;
                    this.$hiderInsights = $hiderInsights;
                }

                public void run() {
                    int n;
                    if (this.$secondsLeft.element <= 0 || !this.$player.isOnline()) {
                        this.cancel();
                        return;
                    }
                    Iterable $this$count$iv = this.$hiderInsights;
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (T element$iv : $this$count$iv) {
                            Triple it = (Triple)element$iv;
                            boolean bl = false;
                            if (!(((Number)it.getSecond()).longValue() >= 15L) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int stationaryCount = n;
                    this.$player.sendActionBar("\u00a76\u6d1e\u5bdf: \u00a7e" + stationaryCount + "\u4eba\u00a77\u304c\u9577\u6642\u9593\u9759\u6b62 \u00a77(" + this.$secondsLeft.element + "\u79d2)");
                    int n2 = this.$secondsLeft.element;
                    this.$secondsLeft.element = n2 + -1;
                }
            };
            task2.runTaskTimer(plugin2, 0L, 20L);
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Exception e) {
            object = Result.constructor-impl(ResultKt.createFailure(e));
        }
        return object;
    }

    @Override
    public void onExpire(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
    }

    @Override
    @NotNull
    public List<String> getDisplayLore(@NotNull ItemConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        String[] stringArray = new String[]{"\u00a77\u5404\u30cf\u30a4\u30c0\u30fc\u306e\u9759\u6b62\u6642\u9593\u3092\u8868\u793a", "\u00a77\u507d\u88c5\u4e2d\u306e\u30cf\u30a4\u30c0\u30fc\u3092\u63a8\u6e2c\u3067\u304d\u308b", "", "\u00a7b\u52b9\u679c: \u00a7f\u30cf\u30a4\u30c0\u30fc\u306e\u79fb\u52d5\u72b6\u6cc1\u3092\u8868\u793a", "\u00a7b\u8868\u793a\u6642\u9593: \u00a7f" + config.getDuration() + "\u79d2", "", "\u00a77\u9577\u6642\u9593\u9759\u6b62 = \u507d\u88c5\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u5927", "\u00a77\u79fb\u52d5\u4e2d = \u507d\u88c5\u3057\u3066\u3044\u306a\u3044\u53ef\u80fd\u6027\u5927"};
        return CollectionsKt.listOf(stringArray);
    }

    private final String formatTime(long seconds) {
        return seconds < 60L ? seconds + "\u79d2\u524d" : (seconds < 3600L ? seconds / (long)60 + "\u5206" + seconds % (long)60 + "\u79d2\u524d" : seconds / (long)3600 + "\u6642\u9593\u4ee5\u4e0a\u524d");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/hideandseek/items/TrackerInsightHandler$Companion;", "", "<init>", "()V", "lastMovementTimes", "", "Ljava/util/UUID;", "", "updateMovementTime", "", "playerId", "getSecondsSinceMovement", "clearAll", "EasyHideAndSeek"})
    public static final class Companion {
        private Companion() {
        }

        public final void updateMovementTime(@NotNull UUID playerId) {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            lastMovementTimes.put(playerId, System.currentTimeMillis());
        }

        public final long getSecondsSinceMovement(@NotNull UUID playerId) {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Long l = (Long)lastMovementTimes.get(playerId);
            if (l == null) {
                return 0L;
            }
            long lastTime = l;
            return (System.currentTimeMillis() - lastTime) / (long)1000;
        }

        public final void clearAll() {
            lastMovementTimes.clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

