/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaBoundaries;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.GamePhase;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.utils.MessageUtil;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/hideandseek/listeners/BoundaryListener;", "Lorg/bukkit/event/Listener;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lcom/hideandseek/game/GameManager;)V", "onPlayerMove", "", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "EasyHideAndSeek"})
public final class BoundaryListener
implements Listener {
    @NotNull
    private final GameManager gameManager;

    public BoundaryListener(@NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.gameManager = gameManager;
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        double maxDistance;
        Arena arena;
        ArenaBoundaries boundaries;
        Location center;
        double distance;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Location location = event.getTo();
        if (location == null) {
            return;
        }
        Location to = location;
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        if (game2.getPhase() != GamePhase.SEEKING && game2.getPhase() != GamePhase.PREPARATION) {
            return;
        }
        if (!game2.getPlayers().containsKey(player2.getUniqueId())) {
            return;
        }
        if (game2.getPhase() == GamePhase.PREPARATION) {
            PlayerGameData playerData;
            PlayerGameData playerGameData = playerData = game2.getPlayers().get(player2.getUniqueId());
            if ((playerGameData != null ? playerGameData.getRole() : null) == PlayerRole.SEEKER) {
                return;
            }
        }
        if ((distance = to.distance(center = (boundaries = (arena = game2.getArena()).getBoundaries()).getCenter())) > (maxDistance = boundaries.getSize() / 2.0)) {
            event.setCancelled(true);
            Vector vector = center.toVector().subtract(to.toVector()).normalize();
            Intrinsics.checkNotNullExpressionValue(vector, "normalize(...)");
            Vector direction = vector;
            Location location2 = center.clone().add(direction.multiply(-maxDistance * 0.9));
            Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
            Location safeLocation = location2;
            safeLocation.setY(to.getY());
            player2.teleport(safeLocation);
            this.gameManager.getPlugin().getLogger().info("[Boundary] " + player2.getName() + " tried to leave arena: distance " + (int)distance + " > max " + (int)maxDistance);
            MessageUtil.INSTANCE.send((CommandSender)player2, "&cYou cannot leave the game area!");
        } else if (distance > maxDistance * 0.85) {
            MessageUtil.INSTANCE.send((CommandSender)player2, "&eWarning: Approaching boundary!");
        }
    }
}

