/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.shop.ShopManager;
import com.hideandseek.utils.MessageUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hideandseek/listeners/InventoryListener;", "Lorg/bukkit/event/Listener;", "shopManager", "Lcom/hideandseek/shop/ShopManager;", "<init>", "(Lcom/hideandseek/shop/ShopManager;)V", "onPlayerInventoryClick", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onPlayerDropItem", "Lorg/bukkit/event/player/PlayerDropItemEvent;", "onPlayerSwapHandItems", "Lorg/bukkit/event/player/PlayerSwapHandItemsEvent;", "EasyHideAndSeek"})
public final class InventoryListener
implements Listener {
    @NotNull
    private final ShopManager shopManager;

    public InventoryListener(@NotNull ShopManager shopManager) {
        Intrinsics.checkNotNullParameter(shopManager, "shopManager");
        this.shopManager = shopManager;
    }

    @EventHandler
    public final void onPlayerInventoryClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack clickedItem = itemStack;
        if (this.shopManager.isShopItem(clickedItem) && Intrinsics.areEqual(event.getClickedInventory(), event.getWhoClicked().getInventory())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPlayerDropItem(@NotNull PlayerDropItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ItemStack itemStack = event.getItemDrop().getItemStack();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemStack(...)");
        ItemStack item = itemStack;
        if (this.shopManager.isShopItem(item)) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            MessageUtil.INSTANCE.send((CommandSender)player, "&cYou cannot drop this item");
        }
    }

    @EventHandler
    public final void onPlayerSwapHandItems(@NotNull PlayerSwapHandItemsEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ItemStack itemStack = event.getMainHandItem();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getMainHandItem(...)");
        ItemStack mainHandItem = itemStack;
        ItemStack itemStack2 = event.getOffHandItem();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "getOffHandItem(...)");
        ItemStack offHandItem = itemStack2;
        if (this.shopManager.isShopItem(mainHandItem) || this.shopManager.isShopItem(offHandItem)) {
            event.setCancelled(true);
        }
    }
}

