/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.HideAndSeekPlugin;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.respawn.RespawnFailureReason;
import com.hideandseek.respawn.RespawnManager;
import com.hideandseek.respawn.RespawnResult;
import com.hideandseek.spectator.SpectatorManager;
import com.hideandseek.strength.SeekerStrengthManager;
import com.hideandseek.utils.MessageUtil;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J8\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/hideandseek/listeners/PlayerDeathListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "gameManager", "Lcom/hideandseek/game/GameManager;", "respawnManager", "Lcom/hideandseek/respawn/RespawnManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/game/GameManager;Lcom/hideandseek/respawn/RespawnManager;)V", "onPlayerDeath", "", "event", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "handleRespawn", "handleSeekerVsSeekerPK", "killer", "Lorg/bukkit/entity/Player;", "victim", "killerData", "Lcom/hideandseek/game/PlayerGameData;", "victimData", "game", "Lcom/hideandseek/game/Game;", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nPlayerDeathListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerDeathListener.kt\ncom/hideandseek/listeners/PlayerDeathListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n1869#2,2:237\n1869#2,2:239\n*S KotlinDebug\n*F\n+ 1 PlayerDeathListener.kt\ncom/hideandseek/listeners/PlayerDeathListener\n*L\n174#1:237,2\n208#1:239,2\n*E\n"})
public final class PlayerDeathListener
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final GameManager gameManager;
    @NotNull
    private final RespawnManager respawnManager;

    public PlayerDeathListener(@NotNull Plugin plugin, @NotNull GameManager gameManager, @NotNull RespawnManager respawnManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        Intrinsics.checkNotNullParameter(respawnManager, "respawnManager");
        this.plugin = plugin;
        this.gameManager = gameManager;
        this.respawnManager = respawnManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(player, "getEntity(...)");
        Player victim = player;
        Player killer = victim.getKiller();
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        if (!game2.getPlayers().containsKey(victim.getUniqueId())) {
            return;
        }
        if (killer != null && game2.getPlayers().containsKey(killer.getUniqueId())) {
            PlayerGameData victimData = game2.getPlayers().get(victim.getUniqueId());
            PlayerGameData killerData = game2.getPlayers().get(killer.getUniqueId());
            if (victimData != null && killerData != null && victimData.getRole() == PlayerRole.SEEKER && killerData.getRole() == PlayerRole.SEEKER) {
                this.handleSeekerVsSeekerPK(killer, victim, killerData, victimData, game2, event);
                return;
            }
        }
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> PlayerDeathListener.onPlayerDeath$lambda$0(this, event), 1L);
    }

    private final void handleRespawn(PlayerDeathEvent event) {
        block9: {
            block10: {
                RespawnResult result;
                Player player;
                block8: {
                    Player player2 = event.getEntity();
                    Intrinsics.checkNotNullExpressionValue(player2, "getEntity(...)");
                    player = player2;
                    result = this.respawnManager.respawnPlayer(player);
                    if (!(result instanceof RespawnResult.Success)) break block8;
                    MessageUtil.INSTANCE.send((CommandSender)player, "&aRespawned at safe location");
                    if (this.plugin.getLogger().isLoggable(Level.FINE)) {
                        this.plugin.getLogger().fine("Respawned " + player.getName() + " at " + ((RespawnResult.Success)result).getLocation().getBlockX() + ", " + ((RespawnResult.Success)result).getLocation().getBlockY() + ", " + ((RespawnResult.Success)result).getLocation().getBlockZ());
                    }
                    break block9;
                }
                if (!(result instanceof RespawnResult.Failure)) break block10;
                switch (WhenMappings.$EnumSwitchMapping$0[((RespawnResult.Failure)result).getReason().ordinal()]) {
                    case 1: {
                        Game game = this.gameManager.getActiveGame();
                        if (game != null) {
                            Location fallbackLocation = GameManager.getRandomSpawnLocation$default(this.gameManager, game.getArena(), null, 0, 6, null);
                            player.teleport(fallbackLocation);
                            MessageUtil.INSTANCE.send((CommandSender)player, "&eNo safe location found, respawned at random location");
                            this.plugin.getLogger().warning("No safe spawn location found for " + player.getName() + ", using random spawn");
                        }
                        break block9;
                    }
                    case 2: {
                        this.plugin.getLogger().fine(player.getName() + " died but is not in active game");
                        break block9;
                    }
                    case 3: {
                        this.plugin.getLogger().fine(player.getName() + " died but game is not active");
                        break block9;
                    }
                    case 4: {
                        MessageUtil.INSTANCE.send((CommandSender)player, "&cRespawn failed, please contact an administrator");
                        this.plugin.getLogger().severe("Teleport failed for " + player.getName() + " during respawn");
                        break block9;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void handleSeekerVsSeekerPK(Player killer, Player victim, PlayerGameData killerData, PlayerGameData victimData, Game game, PlayerDeathEvent event) {
        SeekerStrengthManager strengthManager;
        Plugin plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SeekerStrengthManager seekerStrengthManager = strengthManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSeekerStrengthManager() : null;
        if (strengthManager == null) {
            this.plugin.getLogger().warning("[SeekerPK] SeekerStrengthManager not available");
            return;
        }
        UUID uUID = killer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        int killerStrength = strengthManager.getStrength(uUID);
        UUID uUID2 = victim.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        int victimStrength = strengthManager.getStrength(uUID2);
        UUID uUID3 = killer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
        UUID uUID4 = victim.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
        int comparison = strengthManager.compareStrength(uUID3, uUID4);
        ((HideAndSeekPlugin)this.plugin).getLogger().info("[SeekerPK] " + killer.getName() + " (strength: " + killerStrength + ") killed " + victim.getName() + " (strength: " + victimStrength + ")");
        event.getDrops().clear();
        event.setDroppedExp(0);
        event.setDeathMessage(null);
        if (comparison < 0) {
            ((HideAndSeekPlugin)this.plugin).getLogger().info("[SeekerPK] " + killer.getName() + " is weaker - reverting to HIDER as punishment");
            Bukkit.getScheduler().runTask(this.plugin, () -> PlayerDeathListener.handleSeekerVsSeekerPK$lambda$0(victim));
            MessageUtil.INSTANCE.send((CommandSender)killer, "&a\u81ea\u5206\u3088\u308a\u5f37\u3044\u9b3c\u3092\u5012\u3057\u3001\u4eba\u9593\u306b\u623b\u3063\u305f\uff01");
            MessageUtil.INSTANCE.send((CommandSender)victim, "&c" + killer.getName() + " \u304c\u3042\u306a\u305f\u3092\u5012\u3057\u307e\u3057\u305f\u304c\u3001\u3042\u306a\u305f\u306e\u65b9\u304c\u5f37\u304b\u3063\u305f\u305f\u3081 " + killer.getName() + " \u304c\u4eba\u9593\u306b\u623b\u308a\u307e\u3057\u305f\uff01");
            Iterable $this$forEach$iv = game.getPlayers().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player;
                PlayerGameData playerData = (PlayerGameData)element$iv;
                boolean bl = false;
                if (Bukkit.getPlayer((UUID)playerData.getUuid()) == null) continue;
                boolean bl2 = false;
                if (Intrinsics.areEqual(player.getUniqueId(), killer.getUniqueId()) || Intrinsics.areEqual(player.getUniqueId(), victim.getUniqueId())) continue;
                MessageUtil.INSTANCE.send((CommandSender)player, "&e" + killer.getName() + " &7\u304c\u5f37\u3044\u9b3c &e" + victim.getName() + " &7\u3092\u5012\u3057\u3001\u4eba\u9593\u306b\u623b\u3063\u305f\uff01");
            }
            killer.playSound(killer.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            victim.playSound(victim.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
            v6 = Bukkit.getScheduler().runTask(this.plugin, () -> PlayerDeathListener.handleSeekerVsSeekerPK$lambda$2(this, killer, killerData, game));
        } else {
            ((HideAndSeekPlugin)this.plugin).getLogger().info("[SeekerPK] " + killer.getName() + " is stronger/equal - " + victim.getName() + " is defeated");
            v6 = Bukkit.getScheduler().runTask(this.plugin, () -> PlayerDeathListener.handleSeekerVsSeekerPK$lambda$3(victim, killer, game, victimData, strengthManager, this));
        }
    }

    private static final void onPlayerDeath$lambda$0(PlayerDeathListener this$0, PlayerDeathEvent $event) {
        this$0.handleRespawn($event);
    }

    private static final void handleSeekerVsSeekerPK$lambda$0(Player $victim) {
        $victim.spigot().respawn();
        $victim.setHealth($victim.getMaxHealth());
        $victim.setFireTicks(0);
        $victim.setFallDistance(0.0f);
        $victim.setFoodLevel(20);
    }

    private static final void handleSeekerVsSeekerPK$lambda$2(PlayerDeathListener this$0, Player $killer, PlayerGameData $killerData, Game $game) {
        this$0.gameManager.revertSeekerToHider($killer, $killerData, $game);
    }

    private static final void handleSeekerVsSeekerPK$lambda$3(Player $victim, Player $killer, Game $game, PlayerGameData $victimData, SeekerStrengthManager $strengthManager, PlayerDeathListener this$0) {
        SpectatorManager spectatorManager;
        $victim.spigot().respawn();
        $victim.setHealth($victim.getMaxHealth());
        $victim.setFireTicks(0);
        $victim.setFallDistance(0.0f);
        $victim.setFoodLevel(20);
        MessageUtil.INSTANCE.send((CommandSender)$killer, "&a" + $victim.getName() + " \u3092\u5012\u3057\u307e\u3057\u305f\uff01 &7(\u3042\u306a\u305f\u306e\u65b9\u304c\u5f37\u3044)");
        MessageUtil.INSTANCE.send((CommandSender)$victim, "&c" + $killer.getName() + " \u306b\u5012\u3055\u308c\u307e\u3057\u305f... &7(\u76f8\u624b\u306e\u65b9\u304c\u5f37\u304b\u3063\u305f)");
        Iterable $this$forEach$iv = $game.getPlayers().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            PlayerGameData playerData = (PlayerGameData)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)playerData.getUuid()) == null) continue;
            boolean bl2 = false;
            if (Intrinsics.areEqual(player.getUniqueId(), $killer.getUniqueId()) || Intrinsics.areEqual(player.getUniqueId(), $victim.getUniqueId())) continue;
            MessageUtil.INSTANCE.send((CommandSender)player, "&c" + $killer.getName() + " &7\u304c &c" + $victim.getName() + " &7\u3092\u5012\u3057\u305f\uff01 &7(\u9b3c\u540c\u58eb\u306e\u6226\u3044)");
        }
        $killer.playSound($killer.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        $victim.playSound($victim.getLocation(), Sound.ENTITY_VILLAGER_HURT, 1.0f, 0.8f);
        $victimData.setRole(PlayerRole.SPECTATOR);
        $victimData.setCaptured(true);
        UUID uUID = $victim.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        $strengthManager.resetStrength(uUID);
        Plugin plugin = this$0.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SpectatorManager spectatorManager2 = spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
        if (spectatorManager2 != null) {
            spectatorManager2.applySpectatorMode($victim);
        }
        ((HideAndSeekPlugin)this$0.plugin).getLogger().info("[SeekerPK] " + $victim.getName() + " converted to SPECTATOR after being defeated by " + $killer.getName());
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RespawnFailureReason.values().length];
            try {
                nArray[RespawnFailureReason.NO_SAFE_LOCATION_FOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RespawnFailureReason.PLAYER_NOT_IN_GAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RespawnFailureReason.GAME_NOT_ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RespawnFailureReason.TELEPORT_FAILED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

