/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.points.PointManager;
import com.hideandseek.utils.MessageUtil;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/hideandseek/listeners/TauntListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "gameManager", "Lcom/hideandseek/game/GameManager;", "pointManager", "Lcom/hideandseek/points/PointManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/game/GameManager;Lcom/hideandseek/points/PointManager;)V", "onProjectileLaunch", "", "event", "Lorg/bukkit/event/entity/ProjectileLaunchEvent;", "onPlayerInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "spawnTauntFirework", "player", "Lorg/bukkit/entity/Player;", "EasyHideAndSeek"})
public final class TauntListener
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final GameManager gameManager;
    @NotNull
    private final PointManager pointManager;

    public TauntListener(@NotNull Plugin plugin, @NotNull GameManager gameManager, @NotNull PointManager pointManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        Intrinsics.checkNotNullParameter(pointManager, "pointManager");
        this.plugin = plugin;
        this.gameManager = gameManager;
        this.pointManager = pointManager;
    }

    @EventHandler
    public final void onProjectileLaunch(@NotNull ProjectileLaunchEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ProjectileSource projectileSource = event.getEntity().getShooter();
        Player player = projectileSource instanceof Player ? (Player)projectileSource : null;
        if (player == null) {
            return;
        }
        Player shooter = player;
        if (event.getEntityType() != EntityType.SNOWBALL) {
            return;
        }
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        PlayerGameData playerGameData = game2.getPlayers().get(shooter.getUniqueId());
        if (playerGameData == null) {
            return;
        }
        PlayerGameData playerData = playerGameData;
        if (playerData.getRole() != PlayerRole.HIDER) {
            return;
        }
        if (playerData.isCaptured()) {
            return;
        }
        int bonusPoints = this.plugin.getConfig().getInt("points.taunt-bonuses.snowball", 50);
        UUID uUID = shooter.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.pointManager.awardTauntBonus(uUID, bonusPoints);
        MessageUtil.INSTANCE.send((CommandSender)shooter, "&e+" + bonusPoints + " \u30dd\u30a4\u30f3\u30c8 &7(\u96ea\u7389\u6311\u767a)");
        shooter.sendMessage("\u00a7c\u8b66\u544a: \u30b7\u30fc\u30ab\u30fc\u306b\u4f4d\u7f6e\u304c\u30d0\u30ec\u3084\u3059\u304f\u306a\u308a\u307e\u3057\u305f\uff01");
    }

    @EventHandler
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        if (item.getType() != Material.FIREWORK_ROCKET) {
            return;
        }
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        PlayerGameData playerGameData = game2.getPlayers().get(player2.getUniqueId());
        if (playerGameData == null) {
            return;
        }
        PlayerGameData playerData = playerGameData;
        if (playerData.getRole() != PlayerRole.HIDER) {
            return;
        }
        if (playerData.isCaptured()) {
            return;
        }
        int bonusPoints = this.plugin.getConfig().getInt("points.taunt-bonuses.firework", 100);
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.pointManager.awardTauntBonus(uUID, bonusPoints);
        MessageUtil.INSTANCE.send((CommandSender)player2, "&e+" + bonusPoints + " \u30dd\u30a4\u30f3\u30c8 &7(\u82b1\u706b\u6311\u767a)");
        player2.sendMessage("\u00a7c\u8b66\u544a: \u30b7\u30fc\u30ab\u30fc\u306b\u4f4d\u7f6e\u304c\u975e\u5e38\u306b\u30d0\u30ec\u3084\u3059\u304f\u306a\u308a\u307e\u3057\u305f\uff01");
        this.spawnTauntFirework(player2);
    }

    private final void spawnTauntFirework(Player player) {
        Location location = player.getLocation().clone().add(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location location2 = location;
        Entity entity = player.getWorld().spawnEntity(location2, EntityType.FIREWORK_ROCKET);
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Firework");
        Firework firework = (Firework)entity;
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        Intrinsics.checkNotNullExpressionValue(fireworkMeta, "getFireworkMeta(...)");
        FireworkMeta meta = fireworkMeta;
        Color[] colorArray = new Color[]{Color.RED, Color.YELLOW, Color.LIME, Color.AQUA, Color.FUCHSIA};
        FireworkEffect fireworkEffect = FireworkEffect.builder().withColor(colorArray).with(FireworkEffect.Type.BALL_LARGE).withTrail().withFlicker().build();
        Intrinsics.checkNotNullExpressionValue(fireworkEffect, "build(...)");
        FireworkEffect effect = fireworkEffect;
        meta.addEffect(effect);
        meta.setPower(1);
        firework.setFireworkMeta(meta);
    }
}

