/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.scoreboard;

import com.hideandseek.HideAndSeekPlugin;
import com.hideandseek.game.Game;
import com.hideandseek.game.GamePhase;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.points.PointManager;
import com.hideandseek.utils.MessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\rJ\u001c\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\rJ\u0006\u0010\u0018\u001a\u00020\rJ\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010\u001f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010 \u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/hideandseek/scoreboard/ScoreboardManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "gameUpdateTask", "Lorg/bukkit/scheduler/BukkitTask;", "lobbyUpdateTask", "legacySerializer", "Lnet/kyori/adventure/text/serializer/legacy/LegacyComponentSerializer;", "Lorg/jetbrains/annotations/NotNull;", "startUpdating", "", "game", "Lcom/hideandseek/game/Game;", "stopGameUpdating", "startLobbyUpdating", "waitingPlayers", "", "Ljava/util/UUID;", "minPlayers", "", "stopLobbyUpdating", "stopAllUpdating", "updateScoreboards", "updatePlayerScoreboard", "player", "Lorg/bukkit/entity/Player;", "role", "Lcom/hideandseek/game/PlayerRole;", "updateLobbyScoreboards", "updateLobbyScoreboard", "playerCount", "clearScoreboard", "clearAllScoreboards", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nScoreboardManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreboardManager.kt\ncom/hideandseek/scoreboard/ScoreboardManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n216#2,2:214\n1878#3,3:216\n1869#3,2:219\n1878#3,3:221\n1869#3,2:224\n*S KotlinDebug\n*F\n+ 1 ScoreboardManager.kt\ncom/hideandseek/scoreboard/ScoreboardManager\n*L\n53#1:214,2\n145#1:216,3\n155#1:219,2\n192#1:221,3\n206#1:224,2\n*E\n"})
public final class ScoreboardManager {
    @NotNull
    private final Plugin plugin;
    @Nullable
    private BukkitTask gameUpdateTask;
    @Nullable
    private BukkitTask lobbyUpdateTask;
    @NotNull
    private final LegacyComponentSerializer legacySerializer;

    public ScoreboardManager(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacySection();
        Intrinsics.checkNotNullExpressionValue(legacyComponentSerializer, "legacySection(...)");
        this.legacySerializer = legacyComponentSerializer;
    }

    public final void startUpdating(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        this.stopGameUpdating();
        this.gameUpdateTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> ScoreboardManager.startUpdating$lambda$0(this, game), 0L, 20L);
    }

    public final void stopGameUpdating() {
        BukkitTask bukkitTask = this.gameUpdateTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.gameUpdateTask = null;
    }

    public final void startLobbyUpdating(@NotNull List<UUID> waitingPlayers, int minPlayers) {
        Intrinsics.checkNotNullParameter(waitingPlayers, "waitingPlayers");
        this.stopLobbyUpdating();
        this.lobbyUpdateTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> ScoreboardManager.startLobbyUpdating$lambda$0(this, waitingPlayers, minPlayers), 0L, 20L);
    }

    public final void stopLobbyUpdating() {
        BukkitTask bukkitTask = this.lobbyUpdateTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.lobbyUpdateTask = null;
    }

    public final void stopAllUpdating() {
        this.stopGameUpdating();
        this.stopLobbyUpdating();
    }

    private final void updateScoreboards(Game game) {
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            PlayerGameData playerData = entry.getValue();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this.updatePlayerScoreboard(player, game, playerData.getRole());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePlayerScoreboard(Player player, Game game, PlayerRole role) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getNewScoreboard(...)");
        Scoreboard scoreboard2 = scoreboard;
        Objective objective = scoreboard2.registerNewObjective("hideandseek", "dummy", MessageUtil.INSTANCE.colorize("&e&l[ Hide and Seek ]"));
        Intrinsics.checkNotNullExpressionValue(objective, "registerNewObjective(...)");
        Objective objective2 = objective;
        objective2.setDisplaySlot(DisplaySlot.SIDEBAR);
        List lines = new ArrayList();
        switch (WhenMappings.$EnumSwitchMapping$0[game.getPhase().ordinal()]) {
            case 1: {
                lines.add("&7Status: &eWaiting");
                boolean bl = lines.add("&7Players: &a" + game.getPlayers().size());
                break;
            }
            case 2: {
                long elapsed = (System.currentTimeMillis() - game.getPhaseStartTime()) / (long)1000;
                long remaining = (long)30 - elapsed;
                lines.add("&7Phase: &ePreparation");
                boolean bl = lines.add("&7Time: &a" + remaining + "s");
                break;
            }
            case 3: {
                long elapsed = (System.currentTimeMillis() - game.getPhaseStartTime()) / (long)1000;
                long remaining = (long)600 - elapsed;
                long minutes = remaining / (long)60;
                long seconds = remaining % (long)60;
                lines.add("&7Phase: &cSeeking");
                String string = "%02d";
                Object[] objectArray = new Object[]{seconds};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
                boolean bl = lines.add("&7Time: &a" + minutes + ":" + string2);
                break;
            }
            case 4: {
                boolean bl = lines.add("&7Phase: &cEnded");
                break;
            }
            case 5: {
                lines.add("&7Phase: &eRestarting");
                boolean bl = lines.add("&7Next game soon...");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        lines.add("&7");
        switch (WhenMappings.$EnumSwitchMapping$1[role.ordinal()]) {
            case 1: {
                int n;
                PointManager pointMgr;
                lines.add("&7Role: &cSeeker");
                int captured = game.getCaptured().size();
                int total = game.getHiders().size();
                lines.add("&7Captured: &a" + captured + "/" + total);
                PlayerGameData playerGameData = game.getPlayers().get(player.getUniqueId());
                int captureCount = playerGameData != null ? playerGameData.getCaptureCount() : 0;
                lines.add("&7Your captures: &e" + captureCount);
                Plugin plugin = this.plugin;
                HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
                PointManager pointManager = pointMgr = hideAndSeekPlugin != null ? hideAndSeekPlugin.getPointManager() : null;
                if (pointManager != null) {
                    UUID uUID = player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    n = pointManager.getPoints(uUID);
                } else {
                    n = 0;
                }
                int points = n;
                boolean bl2 = lines.add("&7Points: &6" + points);
                break;
            }
            case 2: {
                int n;
                PointManager pointMgr;
                lines.add("&7Role: &aHider");
                int remaining = game.getHiders().size() - game.getCaptured().size();
                lines.add("&7Remaining: &a" + remaining);
                PlayerGameData playerGameData = game.getPlayers().get(player.getUniqueId());
                boolean isCaptured = playerGameData != null ? playerGameData.isCaptured() : false;
                boolean bl = isCaptured ? lines.add("&7Status: &cCaptured") : lines.add("&7Status: &aHiding");
                Plugin points = this.plugin;
                HideAndSeekPlugin hideAndSeekPlugin = points instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)points : null;
                PointManager pointManager = pointMgr = hideAndSeekPlugin != null ? hideAndSeekPlugin.getPointManager() : null;
                if (pointManager != null) {
                    UUID uUID = player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    n = pointManager.getPoints(uUID);
                } else {
                    n = 0;
                }
                int points2 = n;
                boolean bl2 = lines.add("&7Points: &6" + points2);
                break;
            }
            case 3: {
                lines.add("&7Role: &7Spectator");
                int captured = game.getCaptured().size();
                int total = game.getHiders().size();
                boolean bl2 = lines.add("&7Captured: &a" + captured + "/" + total);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        lines.add("&8");
        lines.add("&7Arena: &f" + game.getArena().getDisplayName());
        Iterable $this$forEachIndexed$iv = CollectionsKt.asReversedMutable(lines);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String legacyString;
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String points = (String)item$iv;
            int index = n;
            boolean bl = false;
            Component component = MessageUtil.INSTANCE.colorize((String)line);
            Intrinsics.checkNotNullExpressionValue(this.legacySerializer.serialize(component), "serialize(...)");
            objective2.getScore(legacyString).setScore(index);
        }
        player.setScoreboard(scoreboard2);
    }

    private final void updateLobbyScoreboards(List<UUID> waitingPlayers, int minPlayers) {
        Iterable $this$forEach$iv = waitingPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this.updateLobbyScoreboard(player, waitingPlayers.size(), minPlayers);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLobbyScoreboard(Player player, int playerCount, int minPlayers) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getNewScoreboard(...)");
        Scoreboard scoreboard2 = scoreboard;
        Objective objective = scoreboard2.registerNewObjective("hideandseek", "dummy", MessageUtil.INSTANCE.colorize("&e&l[ Hide and Seek ]"));
        Intrinsics.checkNotNullExpressionValue(objective, "registerNewObjective(...)");
        Objective objective2 = objective;
        objective2.setDisplaySlot(DisplaySlot.SIDEBAR);
        List lines = new ArrayList();
        lines.add("&7Status: &eWaiting for players");
        lines.add("&7");
        lines.add("&7Players: &a" + playerCount);
        lines.add("&7Minimum: &e" + minPlayers);
        lines.add("&7");
        if (playerCount >= minPlayers) {
            lines.add("&aReady to start!");
            lines.add("&7Waiting for admin to");
            v2 = lines.add("&7use: &e/hs admin start");
        } else {
            int needed;
            v2 = lines.add("&cNeed " + needed + " more player" + ((needed = minPlayers - playerCount) > 1 ? "s" : ""));
        }
        lines.add("&8");
        lines.add("&7Use &e/hs leave &7to exit");
        Iterable $this$forEachIndexed$iv = CollectionsKt.asReversedMutable(lines);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String legacyString;
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            Component component = MessageUtil.INSTANCE.colorize((String)line);
            Intrinsics.checkNotNullExpressionValue(this.legacySerializer.serialize(component), "serialize(...)");
            objective2.getScore(legacyString).setScore(index);
        }
        player.setScoreboard(scoreboard2);
    }

    public final void clearScoreboard(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
    }

    public final void clearAllScoreboards(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        Iterable $this$forEach$iv = game.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this.clearScoreboard(player);
        }
    }

    private static final void startUpdating$lambda$0(ScoreboardManager this$0, Game $game) {
        this$0.updateScoreboards($game);
    }

    private static final void startLobbyUpdating$lambda$0(ScoreboardManager this$0, List $waitingPlayers, int $minPlayers) {
        this$0.updateLobbyScoreboards($waitingPlayers, $minPlayers);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GamePhase.values().length];
            try {
                nArray[GamePhase.WAITING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.PREPARATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.SEEKING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.ENDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.POST_GAME.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PlayerRole.values().length];
            try {
                nArray[PlayerRole.SEEKER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.HIDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.SPECTATOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

