/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.arena;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaSetupSession;
import com.hideandseek.config.ArenaConfig;
import com.hideandseek.config.ConfigManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.random.Random;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\rJ\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016J\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u0018J\u0016\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010 \u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010!\u001a\u00020\rJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\rJ\u000e\u0010$\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\rJ\b\u0010%\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/hideandseek/arena/ArenaManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "configManager", "Lcom/hideandseek/config/ConfigManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/config/ConfigManager;)V", "setupSessions", "", "Ljava/util/UUID;", "Lcom/hideandseek/arena/ArenaSetupSession;", "arenas", "", "Lcom/hideandseek/arena/Arena;", "arenaConfig", "Lcom/hideandseek/config/ArenaConfig;", "loadArenas", "", "getArena", "name", "getArenaNames", "", "getAllArenas", "", "setPos1", "admin", "Lorg/bukkit/entity/Player;", "location", "Lorg/bukkit/Location;", "setPos2", "getSetupSession", "createArena", "displayName", "deleteArena", "", "arenaExists", "getRandomArena", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nArenaManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArenaManager.kt\ncom/hideandseek/arena/ArenaManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,173:1\n382#2,7:174\n382#2,7:181\n*S KotlinDebug\n*F\n+ 1 ArenaManager.kt\ncom/hideandseek/arena/ArenaManager\n*L\n68#1:174,7\n81#1:181,7\n*E\n"})
public final class ArenaManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final ConfigManager configManager;
    @NotNull
    private final Map<UUID, ArenaSetupSession> setupSessions;
    @NotNull
    private final Map<String, Arena> arenas;
    private ArenaConfig arenaConfig;

    public ArenaManager(@NotNull Plugin plugin, @NotNull ConfigManager configManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(configManager, "configManager");
        this.plugin = plugin;
        this.configManager = configManager;
        this.setupSessions = new LinkedHashMap();
        this.arenas = new LinkedHashMap();
    }

    public final void loadArenas() {
        this.arenaConfig = new ArenaConfig(this.configManager.getArenas());
        this.arenas.clear();
        ArenaConfig arenaConfig = this.arenaConfig;
        if (arenaConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException("arenaConfig");
            arenaConfig = null;
        }
        this.arenas.putAll(arenaConfig.loadArenas());
        this.plugin.getLogger().info("Loaded " + this.arenas.size() + " arena(s)");
    }

    @Nullable
    public final Arena getArena(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.arenas.get(name);
    }

    @NotNull
    public final List<String> getArenaNames() {
        return CollectionsKt.toList((Iterable)this.arenas.keySet());
    }

    @NotNull
    public final Map<String, Arena> getAllArenas() {
        return MapsKt.toMap(this.arenas);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPos1(@NotNull Player admin, @NotNull Location location) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(admin, "admin");
        Intrinsics.checkNotNullParameter(location, "location");
        Map<UUID, ArenaSetupSession> map = this.setupSessions;
        UUID key$iv = admin.getUniqueId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            UUID uUID = admin.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            ArenaSetupSession answer$iv = new ArenaSetupSession(uUID, null, null, 6, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ArenaSetupSession session = (ArenaSetupSession)object;
        session.setPos1(location);
    }

    /*
     * WARNING - void declaration
     */
    public final void setPos2(@NotNull Player admin, @NotNull Location location) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(admin, "admin");
        Intrinsics.checkNotNullParameter(location, "location");
        Map<UUID, ArenaSetupSession> map = this.setupSessions;
        UUID key$iv = admin.getUniqueId();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            UUID uUID = admin.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            ArenaSetupSession answer$iv = new ArenaSetupSession(uUID, null, null, 6, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ArenaSetupSession session = (ArenaSetupSession)object;
        session.setPos2(location);
    }

    @Nullable
    public final ArenaSetupSession getSetupSession(@NotNull Player admin) {
        Intrinsics.checkNotNullParameter(admin, "admin");
        return this.setupSessions.get(admin.getUniqueId());
    }

    @NotNull
    public final Arena createArena(@NotNull Player admin, @NotNull String name, @NotNull String displayName) {
        Intrinsics.checkNotNullParameter(admin, "admin");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        ArenaSetupSession arenaSetupSession = this.setupSessions.get(admin.getUniqueId());
        if (arenaSetupSession == null) {
            throw new IllegalStateException("No setup session found. Use /hs admin setpos1 first.");
        }
        ArenaSetupSession session = arenaSetupSession;
        if (this.arenas.containsKey(name)) {
            throw new IllegalStateException("Arena '" + name + "' already exists. Delete it first or use a different name.");
        }
        Arena arena = session.toArena(name, displayName);
        this.arenas.put(name, arena);
        ArenaConfig arenaConfig = this.arenaConfig;
        if (arenaConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException("arenaConfig");
            arenaConfig = null;
        }
        arenaConfig.saveArena(arena);
        this.configManager.save(this.configManager.getArenas(), "arenas.yml");
        this.setupSessions.remove(admin.getUniqueId());
        this.plugin.getLogger().info("Created arena: " + name);
        return arena;
    }

    public static /* synthetic */ Arena createArena$default(ArenaManager arenaManager, Player player, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = string;
        }
        return arenaManager.createArena(player, string, string2);
    }

    public final boolean deleteArena(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Arena arena = this.arenas.get(name);
        if (arena == null) {
            return false;
        }
        Arena arena2 = arena;
        this.arenas.remove(name);
        ArenaConfig arenaConfig = this.arenaConfig;
        if (arenaConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException("arenaConfig");
            arenaConfig = null;
        }
        arenaConfig.deleteArena(name);
        this.configManager.save(this.configManager.getArenas(), "arenas.yml");
        this.plugin.getLogger().info("Deleted arena: " + name);
        return true;
    }

    public final boolean arenaExists(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.arenas.containsKey(name);
    }

    @Nullable
    public final Arena getRandomArena() {
        if (this.arenas.isEmpty()) {
            return null;
        }
        return CollectionsKt.random(this.arenas.values(), Random.Default);
    }
}

