/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.commands;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaManager;
import com.hideandseek.arena.ArenaSetupSession;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.text.Regex;
import com.hideandseek.libs.kotlin.text.StringsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J%\u0010\u0019\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0014H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J%\u0010\u001c\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0014H\u0002\u00a2\u0006\u0002\u0010\u001aJ%\u0010\u001d\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0014H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J=\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/hideandseek/commands/AdminCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "arenaManager", "Lcom/hideandseek/arena/ArenaManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "<init>", "(Lcom/hideandseek/arena/ArenaManager;Lcom/hideandseek/game/GameManager;Lcom/hideandseek/i18n/MessageManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "handleSetPos1", "", "handleSetPos2", "handleCreateGame", "(Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)V", "handleList", "handleDelete", "handleStart", "handleReload", "sendHelp", "onTabComplete", "", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nAdminCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdminCommand.kt\ncom/hideandseek/commands/AdminCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n1869#2,2:245\n774#2:247\n865#2,2:248\n774#2:250\n865#2,2:251\n*S KotlinDebug\n*F\n+ 1 AdminCommand.kt\ncom/hideandseek/commands/AdminCommand\n*L\n131#1:245,2\n235#1:247\n235#1:248,2\n237#1:250\n237#1:251,2\n*E\n"})
public final class AdminCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final ArenaManager arenaManager;
    @NotNull
    private final GameManager gameManager;
    @NotNull
    private final MessageManager messageManager;

    public AdminCommand(@NotNull ArenaManager arenaManager, @NotNull GameManager gameManager, @NotNull MessageManager messageManager) {
        Intrinsics.checkNotNullParameter(arenaManager, "arenaManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        Intrinsics.checkNotNullParameter(messageManager, "messageManager");
        this.arenaManager = arenaManager;
        this.gameManager = gameManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("hideandseek.admin")) {
            this.messageManager.send(sender, "error.no_permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "setpos1": {
                this.handleSetPos1(sender);
                break;
            }
            case "setpos2": {
                this.handleSetPos2(sender);
                break;
            }
            case "creategame": {
                this.handleCreateGame(sender, args);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "delete": {
                this.handleDelete(sender, args);
                break;
            }
            case "start": {
                this.handleStart(sender, args);
                break;
            }
            case "reload": {
                this.handleReload(sender);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private final void handleSetPos1(CommandSender sender) {
        if (!(sender instanceof Player)) {
            this.messageManager.send(sender, "error.player_only", new Object[0]);
            return;
        }
        Player player = (Player)sender;
        Location location = ((Player)sender).getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.arenaManager.setPos1(player, location);
        Object[] objectArray = new Object[]{((Player)sender).getLocation().getBlockX(), ((Player)sender).getLocation().getBlockY(), ((Player)sender).getLocation().getBlockZ()};
        this.messageManager.send((Player)sender, "admin.setpos1.success", objectArray);
    }

    private final void handleSetPos2(CommandSender sender) {
        block1: {
            if (!(sender instanceof Player)) {
                this.messageManager.send(sender, "error.player_only", new Object[0]);
                return;
            }
            ArenaSetupSession session = this.arenaManager.getSetupSession((Player)sender);
            Player player = (Player)sender;
            Location location = ((Player)sender).getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            this.arenaManager.setPos2(player, location);
            Object[] objectArray = new Object[]{((Player)sender).getLocation().getBlockX(), ((Player)sender).getLocation().getBlockY(), ((Player)sender).getLocation().getBlockZ()};
            this.messageManager.send((Player)sender, "admin.setpos2.success", objectArray);
            ArenaSetupSession arenaSetupSession = session;
            if (arenaSetupSession == null || (arenaSetupSession = arenaSetupSession.getPos1()) == null) break block1;
            ArenaSetupSession pos1 = arenaSetupSession;
            boolean bl = false;
            double distance = pos1.distance(((Player)sender).getLocation());
            Player player2 = (Player)sender;
            Object[] objectArray2 = new Object[1];
            String string = "%.1f";
            Object[] objectArray3 = new Object[]{distance};
            Intrinsics.checkNotNullExpressionValue(String.format(string, Arrays.copyOf(objectArray3, objectArray3.length)), "format(...)");
            this.messageManager.send(player2, "admin.setpos2.distance", objectArray2);
        }
    }

    private final void handleCreateGame(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.messageManager.send(sender, "error.player_only", new Object[0]);
            return;
        }
        if (args.length < 2) {
            this.messageManager.send((Player)sender, "admin.creategame.usage", new Object[0]);
            return;
        }
        String name = args[1];
        CharSequence charSequence = name;
        if (!new Regex("[a-zA-Z0-9_-]+").matches(charSequence)) {
            this.messageManager.send((Player)sender, "admin.creategame.invalid_name", new Object[0]);
            return;
        }
        try {
            Arena arena = ArenaManager.createArena$default(this.arenaManager, (Player)sender, name, null, 4, null);
            Object[] objectArray = new Object[]{name};
            this.messageManager.send((Player)sender, "admin.creategame.success", objectArray);
            Player player = (Player)sender;
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(arena.getWorld().getName(), "getName(...)");
            this.messageManager.send(player, "admin.creategame.success.world", objectArray);
            Player player2 = (Player)sender;
            objectArray = new Object[1];
            String string = "%.1f";
            Object[] objectArray2 = new Object[]{arena.getBoundaries().getSize()};
            Intrinsics.checkNotNullExpressionValue(String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), "format(...)");
            this.messageManager.send(player2, "admin.creategame.success.size", objectArray);
            objectArray = new Object[]{arena.getBoundaries().getCenter().getBlockX(), arena.getBoundaries().getCenter().getBlockY(), arena.getBoundaries().getCenter().getBlockZ()};
            this.messageManager.send((Player)sender, "admin.creategame.success.center", objectArray);
        }
        catch (Exception e) {
            Player player = (Player)sender;
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            objectArray[0] = string;
            this.messageManager.send(player, "admin.creategame.error", objectArray);
        }
    }

    private final void handleList(CommandSender sender) {
        Map<String, Arena> arenas = this.arenaManager.getAllArenas();
        if (arenas.isEmpty()) {
            this.messageManager.send(sender, "admin.list.empty", new Object[0]);
            return;
        }
        this.messageManager.send(sender, "admin.list.title", new Object[0]);
        Iterable $this$forEach$iv = arenas.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Arena arena = (Arena)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[2];
            objectArray[0] = arena.getName();
            Intrinsics.checkNotNullExpressionValue(arena.getWorld().getName(), "getName(...)");
            this.messageManager.send(sender, "admin.list.item", objectArray);
        }
        Object[] objectArray = new Object[]{arenas.size()};
        this.messageManager.send(sender, "admin.list.total", objectArray);
    }

    private final void handleDelete(CommandSender sender, String[] args) {
        if (args.length < 2) {
            this.messageManager.send(sender, "admin.delete.usage", new Object[0]);
            return;
        }
        String name = args[1];
        try {
            if (this.arenaManager.deleteArena(name)) {
                Object[] objectArray = new Object[]{name};
                this.messageManager.send(sender, "admin.delete.success", objectArray);
            } else {
                Object[] objectArray = new Object[]{name};
                this.messageManager.send(sender, "admin.delete.not_found", objectArray);
            }
        }
        catch (Exception e) {
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            objectArray[0] = string;
            this.messageManager.send(sender, "admin.delete.error", objectArray);
        }
    }

    private final void handleStart(CommandSender sender, String[] args) {
        Object object;
        if (this.gameManager.getActiveGame() != null) {
            this.messageManager.send(sender, "admin.start.already_in_progress", new Object[0]);
            return;
        }
        if (args.length >= 2) {
            String arenaName = args[1];
            specifiedArena = this.arenaManager.getArena(arenaName);
            if (specifiedArena == null) {
                Object[] objectArray = new Object[]{arenaName};
                this.messageManager.send(sender, "admin.start.arena_not_found", objectArray);
                return;
            }
            object = specifiedArena;
        } else {
            Arena randomArena = this.arenaManager.getRandomArena();
            if (randomArena == null) {
                this.messageManager.send(sender, "admin.start.no_arenas", new Object[0]);
                return;
            }
            specifiedArena = new Object[]{randomArena.getDisplayName()};
            this.messageManager.send(sender, "admin.start.random_arena", specifiedArena);
            object = randomArena;
        }
        Object[] arena = object;
        int waitingCount = this.gameManager.getWaitingPlayers().size();
        int minPlayers = this.gameManager.getConfigManager().getMinPlayers();
        if (waitingCount < minPlayers) {
            Object[] objectArray = new Object[]{waitingCount, minPlayers};
            this.messageManager.send(sender, "admin.start.min_players", objectArray);
            return;
        }
        Game game = this.gameManager.startGame((Arena)arena);
        if (game != null) {
            Object[] objectArray = new Object[]{arena.getDisplayName()};
            this.messageManager.send(sender, "admin.start.success", objectArray);
            objectArray = new Object[]{waitingCount};
            this.messageManager.send(sender, "admin.start.success.players", objectArray);
            objectArray = new Object[]{game.getSeekers().size(), game.getHiders().size()};
            this.messageManager.send(sender, "admin.start.success.teams", objectArray);
        } else {
            this.messageManager.send(sender, "admin.start.failed", new Object[0]);
        }
    }

    private final void handleReload(CommandSender sender) {
        try {
            this.messageManager.reload();
            String languages = CollectionsKt.joinToString$default(this.messageManager.getAvailableLanguages(), ", ", null, null, 0, null, null, 62, null);
            this.messageManager.send(sender, "admin.reload.success", new Object[0]);
            Object[] objectArray = new Object[]{languages};
            this.messageManager.send(sender, "admin.reload.i18n_reloaded", objectArray);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            objectArray[0] = string;
            this.messageManager.send(sender, "admin.reload.error", objectArray);
        }
    }

    private final void sendHelp(CommandSender sender) {
        this.messageManager.send(sender, "admin.help.title", new Object[0]);
        this.messageManager.send(sender, "admin.help.setpos1", new Object[0]);
        this.messageManager.send(sender, "admin.help.setpos2", new Object[0]);
        this.messageManager.send(sender, "admin.help.creategame", new Object[0]);
        this.messageManager.send(sender, "admin.help.list", new Object[0]);
        this.messageManager.send(sender, "admin.help.delete", new Object[0]);
        this.messageManager.send(sender, "admin.help.start", new Object[0]);
        this.messageManager.send(sender, "admin.help.reload", new Object[0]);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("hideandseek.admin")) {
            return CollectionsKt.emptyList();
        }
        return switch (args.length) {
            case 1 -> {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Object var5_5 = new String[]{"setpos1", "setpos2", "creategame", "list", "delete", "start", "reload"};
                var5_5 = CollectionsKt.listOf(var5_5);
                boolean $i$f$filter = false;
                void var7_9 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean $i$a$-filter-AdminCommand$onTabComplete$1 = false;
                    String v0 = args[0].toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(v0, "toLowerCase(...)");
                    if (!StringsKt.startsWith$default(it, v0, false, 2, null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 2 -> {
                String v2 = args[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(v2, "toLowerCase(...)");
                String var5_6 = v2;
                if (Intrinsics.areEqual(var5_6, "delete") || Intrinsics.areEqual(var5_6, "start")) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.arenaManager.getArenaNames();
                    boolean $i$f$filter = false;
                    Iterable destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean $i$a$-filter-AdminCommand$onTabComplete$2 = false;
                        String v3 = args[1].toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(v3, "toLowerCase(...)");
                        if (!StringsKt.startsWith$default(it, v3, false, 2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    yield (List)destination$iv$iv;
                }
                yield null;
            }
            default -> null;
        };
    }
}

