/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.commands;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaManager;
import com.hideandseek.arena.ArenaSetupSession;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.text.Regex;
import com.hideandseek.libs.kotlin.text.StringsKt;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J5\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/hideandseek/commands/CreategameCommand;", "Lorg/bukkit/command/CommandExecutor;", "arenaManager", "Lcom/hideandseek/arena/ArenaManager;", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "<init>", "(Lcom/hideandseek/arena/ArenaManager;Lcom/hideandseek/i18n/MessageManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "EasyHideAndSeek"})
public final class CreategameCommand
implements CommandExecutor {
    @NotNull
    private final ArenaManager arenaManager;
    @NotNull
    private final MessageManager messageManager;

    public CreategameCommand(@NotNull ArenaManager arenaManager, @NotNull MessageManager messageManager) {
        Intrinsics.checkNotNullParameter(arenaManager, "arenaManager");
        Intrinsics.checkNotNullParameter(messageManager, "messageManager");
        this.arenaManager = arenaManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(sender instanceof Player)) {
            this.messageManager.send(sender, "error.player_only", new Object[0]);
            return true;
        }
        if (!sender.hasPermission("hideandseek.admin")) {
            this.messageManager.send((Player)sender, "error.no_permission", new Object[0]);
            return true;
        }
        if (!(args.length == 0) && StringsKt.equals(args[0], "setpos1", true)) {
            Player player = (Player)sender;
            Location location = ((Player)sender).getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            this.arenaManager.setPos1(player, location);
            Object[] objectArray = new Object[]{((Player)sender).getLocation().getBlockX(), ((Player)sender).getLocation().getBlockY(), ((Player)sender).getLocation().getBlockZ()};
            this.messageManager.send((Player)sender, "admin.setpos1.success", objectArray);
            return true;
        }
        if (!(args.length == 0) && StringsKt.equals(args[0], "setpos2", true)) {
            ArenaSetupSession session = this.arenaManager.getSetupSession((Player)sender);
            Player player = (Player)sender;
            Location location = ((Player)sender).getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            this.arenaManager.setPos2(player, location);
            Object[] objectArray = new Object[]{((Player)sender).getLocation().getBlockX(), ((Player)sender).getLocation().getBlockY(), ((Player)sender).getLocation().getBlockZ()};
            this.messageManager.send((Player)sender, "admin.setpos2.success", objectArray);
            ArenaSetupSession arenaSetupSession = session;
            if (arenaSetupSession != null && (arenaSetupSession = arenaSetupSession.getPos1()) != null) {
                ArenaSetupSession pos1 = arenaSetupSession;
                boolean bl = false;
                double distance = pos1.distance(((Player)sender).getLocation());
                Player player2 = (Player)sender;
                Object[] objectArray2 = new Object[1];
                String string = "%.1f";
                Object[] objectArray3 = new Object[]{distance};
                Intrinsics.checkNotNullExpressionValue(String.format(string, Arrays.copyOf(objectArray3, objectArray3.length)), "format(...)");
                this.messageManager.send(player2, "admin.setpos2.distance", objectArray2);
            }
            return true;
        }
        if (args.length == 0) {
            this.messageManager.send((Player)sender, "admin.creategame.usage", new Object[0]);
            return true;
        }
        String name = args[0];
        CharSequence charSequence = name;
        if (!new Regex("[a-zA-Z0-9_-]+").matches(charSequence)) {
            this.messageManager.send((Player)sender, "admin.creategame.invalid_name", new Object[0]);
            return true;
        }
        try {
            Arena arena = ArenaManager.createArena$default(this.arenaManager, (Player)sender, name, null, 4, null);
            Object[] objectArray = new Object[]{name};
            this.messageManager.send((Player)sender, "admin.creategame.success", objectArray);
            Player player = (Player)sender;
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(arena.getWorld().getName(), "getName(...)");
            this.messageManager.send(player, "admin.creategame.success.world", objectArray);
            Player player3 = (Player)sender;
            objectArray = new Object[1];
            String string = "%.1f";
            Object[] objectArray4 = new Object[]{arena.getBoundaries().getSize()};
            Intrinsics.checkNotNullExpressionValue(String.format(string, Arrays.copyOf(objectArray4, objectArray4.length)), "format(...)");
            this.messageManager.send(player3, "admin.creategame.success.size", objectArray);
            objectArray = new Object[]{arena.getBoundaries().getCenter().getBlockX(), arena.getBoundaries().getCenter().getBlockY(), arena.getBoundaries().getCenter().getBlockZ()};
            this.messageManager.send((Player)sender, "admin.creategame.success.center", objectArray);
        }
        catch (Exception e) {
            Player player = (Player)sender;
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            objectArray[0] = string;
            this.messageManager.send(player, "admin.creategame.error", objectArray);
        }
        return true;
    }
}

