/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.commands;

import com.hideandseek.i18n.LanguagePreferenceManager;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.text.CharsKt;
import com.hideandseek.libs.kotlin.text.StringsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ5\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0010H\u0002J=\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0012H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/hideandseek/commands/LangCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "languagePreferenceManager", "Lcom/hideandseek/i18n/LanguagePreferenceManager;", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "<init>", "(Lcom/hideandseek/i18n/LanguagePreferenceManager;Lcom/hideandseek/i18n/MessageManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "showCurrentLanguage", "", "player", "Lorg/bukkit/entity/Player;", "showAvailableLanguages", "setLanguage", "languageCode", "onTabComplete", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "parseLocale", "Ljava/util/Locale;", "localeString", "getLanguageDisplayName", "locale", "Companion", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nLangCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangCommand.kt\ncom/hideandseek/commands/LangCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1563#2:182\n1634#2,3:183\n774#2:186\n865#2,2:187\n*S KotlinDebug\n*F\n+ 1 LangCommand.kt\ncom/hideandseek/commands/LangCommand\n*L\n141#1:182\n141#1:183,3\n143#1:186\n143#1:187,2\n*E\n"})
public final class LangCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LanguagePreferenceManager languagePreferenceManager;
    @NotNull
    private final MessageManager messageManager;
    @NotNull
    private static final String PERMISSION = "hideandseek.lang";

    public LangCommand(@NotNull LanguagePreferenceManager languagePreferenceManager, @NotNull MessageManager messageManager) {
        Intrinsics.checkNotNullParameter(languagePreferenceManager, "languagePreferenceManager");
        Intrinsics.checkNotNullParameter(messageManager, "messageManager");
        this.languagePreferenceManager = languagePreferenceManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(sender instanceof Player)) {
            Player player = sender instanceof Player ? (Player)sender : null;
            if (player == null) {
                return true;
            }
            this.messageManager.send(player, "error.player_only", new Object[0]);
            return true;
        }
        if (!sender.hasPermission(PERMISSION)) {
            this.messageManager.send((Player)sender, "error.no_permission", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.showCurrentLanguage((Player)sender);
        } else if (StringsKt.equals(args[0], "list", true)) {
            this.showAvailableLanguages((Player)sender);
        } else {
            this.setLanguage((Player)sender, args[0]);
        }
        return true;
    }

    private final void showCurrentLanguage(Player player) {
        Locale currentLocale = this.languagePreferenceManager.getLocale(player);
        String displayName = this.getLanguageDisplayName(currentLocale);
        Object[] objectArray = new Object[]{displayName};
        this.messageManager.send(player, "command.lang.current", objectArray);
    }

    private final void showAvailableLanguages(Player player) {
        List<Locale> availableLanguages = this.languagePreferenceManager.getAvailableLanguages();
        String languageNames = CollectionsKt.joinToString$default(availableLanguages, ", ", null, null, 0, null, arg_0 -> LangCommand.showAvailableLanguages$lambda$0(this, arg_0), 30, null);
        Object[] objectArray = new Object[]{languageNames};
        this.messageManager.send(player, "command.lang.list", objectArray);
    }

    private final void setLanguage(Player player, String languageCode) {
        List<Locale> availableLanguages = this.languagePreferenceManager.getAvailableLanguages();
        Locale targetLocale = this.parseLocale(languageCode);
        if (targetLocale == null) {
            Object[] objectArray = new Object[]{languageCode};
            this.messageManager.send(player, "command.lang.invalid", objectArray);
            this.showAvailableLanguages(player);
            return;
        }
        if (!availableLanguages.contains(targetLocale)) {
            Object[] objectArray = new Object[]{languageCode};
            this.messageManager.send(player, "command.lang.invalid", objectArray);
            this.showAvailableLanguages(player);
            return;
        }
        try {
            this.languagePreferenceManager.setLocale(player, targetLocale, true);
            String displayName = this.getLanguageDisplayName(targetLocale);
            Object[] objectArray = new Object[]{displayName};
            this.messageManager.send(player, "command.lang.set", objectArray);
        }
        catch (IllegalArgumentException e) {
            Object[] objectArray = new Object[]{languageCode};
            this.messageManager.send(player, "command.lang.invalid", objectArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        List list;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!(sender instanceof Player) || !sender.hasPermission(PERMISSION)) {
            return CollectionsKt.emptyList();
        }
        if (args.length == 1) {
            void $this$filterTo$iv$iv;
            String it;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = new String[]{"list"};
            List<String> suggestions = CollectionsKt.mutableListOf(object);
            object = this.languagePreferenceManager.getAvailableLanguages();
            List<String> list2 = suggestions;
            boolean $i$f$map = false;
            void var8_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Locale locale = (Locale)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = ((Locale)((Object)it)).toLanguageTag();
                Intrinsics.checkNotNullExpressionValue(string, "toLanguageTag(...)");
                collection.add(StringsKt.replace$default(string, "-", "_", false, 4, null));
            }
            list2.addAll((List)destination$iv$iv);
            Iterable $this$filter$iv = suggestions;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith(it, args[0], true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final Locale parseLocale(String localeString) {
        Locale locale;
        try {
            String normalized = StringsKt.replace$default(localeString, "_", "-", false, 4, null);
            Locale locale2 = Locale.forLanguageTag(normalized);
            String string = locale2.getLanguage();
            Intrinsics.checkNotNullExpressionValue(string, "getLanguage(...)");
            locale = ((CharSequence)string).length() == 0 ? null : locale2;
        }
        catch (Exception e) {
            locale = null;
        }
        return locale;
    }

    /*
     * WARNING - void declaration
     */
    private final String getLanguageDisplayName(Locale locale) {
        String string;
        String string2 = locale.getDisplayLanguage(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "getDisplayLanguage(...)");
        String string3 = string2;
        if (((CharSequence)string3).length() > 0) {
            void it;
            char c = string3.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((Object)(Character.isLowerCase((char)it) ? CharsKt.titlecase((char)it, locale) : String.valueOf((char)it)));
            String string4 = string3;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string3;
        }
        String nativeName = string;
        String string6 = locale.toLanguageTag();
        Intrinsics.checkNotNullExpressionValue(string6, "toLanguageTag(...)");
        String tag = StringsKt.replace$default(string6, "-", "_", false, 4, null);
        return nativeName + " (" + tag + ")";
    }

    private static final CharSequence showAvailableLanguages$lambda$0(LangCommand this$0, Locale locale) {
        Intrinsics.checkNotNullParameter(locale, "locale");
        return this$0.getLanguageDisplayName(locale);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/hideandseek/commands/LangCommand$Companion;", "", "<init>", "()V", "PERMISSION", "", "EasyHideAndSeek"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

