/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.commands;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaManager;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J5\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/hideandseek/commands/ListCommand;", "Lorg/bukkit/command/CommandExecutor;", "arenaManager", "Lcom/hideandseek/arena/ArenaManager;", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "<init>", "(Lcom/hideandseek/arena/ArenaManager;Lcom/hideandseek/i18n/MessageManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nListCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListCommand.kt\ncom/hideandseek/commands/ListCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1869#2,2:42\n*S KotlinDebug\n*F\n+ 1 ListCommand.kt\ncom/hideandseek/commands/ListCommand\n*L\n33#1:42,2\n*E\n"})
public final class ListCommand
implements CommandExecutor {
    @NotNull
    private final ArenaManager arenaManager;
    @NotNull
    private final MessageManager messageManager;

    public ListCommand(@NotNull ArenaManager arenaManager, @NotNull MessageManager messageManager) {
        Intrinsics.checkNotNullParameter(arenaManager, "arenaManager");
        Intrinsics.checkNotNullParameter(messageManager, "messageManager");
        this.arenaManager = arenaManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("hideandseek.admin")) {
            this.messageManager.send(sender, "error.no_permission", new Object[0]);
            return true;
        }
        Map<String, Arena> arenas = this.arenaManager.getAllArenas();
        if (arenas.isEmpty()) {
            this.messageManager.send(sender, "admin.list.empty", new Object[0]);
            return true;
        }
        this.messageManager.send(sender, "admin.list.title", new Object[0]);
        Iterable $this$forEach$iv = arenas.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Arena arena = (Arena)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[2];
            objectArray[0] = arena.getName();
            Intrinsics.checkNotNullExpressionValue(arena.getWorld().getName(), "getName(...)");
            this.messageManager.send(sender, "admin.list.item", objectArray);
        }
        Object[] objectArray = new Object[]{arenas.size()};
        this.messageManager.send(sender, "admin.list.total", objectArray);
        return true;
    }
}

