/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.commands;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaManager;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.text.StringsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J=\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/hideandseek/commands/StartCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "arenaManager", "Lcom/hideandseek/arena/ArenaManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "<init>", "(Lcom/hideandseek/arena/ArenaManager;Lcom/hideandseek/game/GameManager;Lcom/hideandseek/i18n/MessageManager;)V", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nStartCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartCommand.kt\ncom/hideandseek/commands/StartCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n774#2:91\n865#2,2:92\n*S KotlinDebug\n*F\n+ 1 StartCommand.kt\ncom/hideandseek/commands/StartCommand\n*L\n85#1:91\n85#1:92,2\n*E\n"})
public final class StartCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final ArenaManager arenaManager;
    @NotNull
    private final GameManager gameManager;
    @NotNull
    private final MessageManager messageManager;

    public StartCommand(@NotNull ArenaManager arenaManager, @NotNull GameManager gameManager, @NotNull MessageManager messageManager) {
        Intrinsics.checkNotNullParameter(arenaManager, "arenaManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        Intrinsics.checkNotNullParameter(messageManager, "messageManager");
        this.arenaManager = arenaManager;
        this.gameManager = gameManager;
        this.messageManager = messageManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Object object;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("hideandseek.admin")) {
            this.messageManager.send(sender, "error.no_permission", new Object[0]);
            return true;
        }
        if (this.gameManager.getActiveGame() != null) {
            this.messageManager.send(sender, "admin.start.already_in_progress", new Object[0]);
            return true;
        }
        if (!(args.length == 0)) {
            String arenaName = args[0];
            specifiedArena = this.arenaManager.getArena(arenaName);
            if (specifiedArena == null) {
                Object[] objectArray = new Object[]{arenaName};
                this.messageManager.send(sender, "admin.start.arena_not_found", objectArray);
                return true;
            }
            object = specifiedArena;
        } else {
            Arena randomArena = this.arenaManager.getRandomArena();
            if (randomArena == null) {
                this.messageManager.send(sender, "admin.start.no_arenas", new Object[0]);
                return true;
            }
            specifiedArena = new Object[]{randomArena.getDisplayName()};
            this.messageManager.send(sender, "admin.start.random_arena", specifiedArena);
            object = randomArena;
        }
        Object[] arena = object;
        int waitingCount = this.gameManager.getWaitingPlayers().size();
        int minPlayers = this.gameManager.getConfigManager().getMinPlayers();
        if (waitingCount < minPlayers) {
            Object[] objectArray = new Object[]{waitingCount, minPlayers};
            this.messageManager.send(sender, "admin.start.min_players", objectArray);
            return true;
        }
        Game game = this.gameManager.startGame((Arena)arena);
        if (game != null) {
            Object[] objectArray = new Object[]{arena.getDisplayName()};
            this.messageManager.send(sender, "admin.start.success", objectArray);
            objectArray = new Object[]{waitingCount};
            this.messageManager.send(sender, "admin.start.success.players", objectArray);
            objectArray = new Object[]{game.getSeekers().size(), game.getHiders().size()};
            this.messageManager.send(sender, "admin.start.success.teams", objectArray);
        } else {
            this.messageManager.send(sender, "admin.start.failed", new Object[0]);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        List list;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("hideandseek.admin")) {
            return CollectionsKt.emptyList();
        }
        if (args.length == 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.arenaManager.getArenaNames();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                String string = args[0].toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                if (!StringsKt.startsWith$default(it, string, false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }
}

