/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.config;

import com.hideandseek.config.CaptureMode;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.ranges.RangesKt;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0010J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\u001cJ\u0006\u0010\"\u001a\u00020\u001cJ\u0006\u0010#\u001a\u00020\u001eJ\u0006\u0010$\u001a\u00020\u0017J\u0006\u0010%\u001a\u00020\u001eJ\u0006\u0010&\u001a\u00020\u0017J\u0006\u0010'\u001a\u00020\u001eJ\u0006\u0010(\u001a\u00020\u001eJ\u0006\u0010)\u001a\u00020\u001eJ\u0006\u0010*\u001a\u00020\u001cJ\u0006\u0010+\u001a\u00020\u001eJ\u0006\u0010,\u001a\u00020\u001eJ\u0006\u0010-\u001a\u00020\u0017J\u0006\u0010.\u001a\u00020\u001eJ\u0006\u0010/\u001a\u00020\u0017J\u0006\u00100\u001a\u000201R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u00062"}, d2={"Lcom/hideandseek/config/ConfigManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "value", "Lorg/bukkit/configuration/file/FileConfiguration;", "config", "getConfig", "()Lorg/bukkit/configuration/file/FileConfiguration;", "arenas", "getArenas", "shop", "getShop", "load", "", "loadOrCreate", "fileName", "", "save", "reload", "getPreparationTime", "", "getSeekTime", "getMinPlayers", "getMaxPlayers", "getSeekerRatio", "", "isEconomyEnabled", "", "getHiderWinReward", "getSeekerWinReward", "getPerCaptureReward", "getParticipationReward", "isAutoRestartEnabled", "getPostGameCountdown", "isForceJoinAllPlayers", "getBroadcastInterval", "isSpectatorEnabled", "isAllowJoinDuringGame", "isPersistSpectatorState", "getSpectatorFlightSpeed", "isShowSeekerCount", "isShowHiderCount", "getShowTopPlayers", "isShowTeamLists", "getScoreboardUpdateInterval", "getCaptureMode", "Lcom/hideandseek/config/CaptureMode;", "EasyHideAndSeek"})
public final class ConfigManager {
    @NotNull
    private final Plugin plugin;
    private FileConfiguration config;
    private FileConfiguration arenas;
    private FileConfiguration shop;

    public ConfigManager(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @NotNull
    public final FileConfiguration getConfig() {
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration != null) {
            return fileConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException("config");
        return null;
    }

    @NotNull
    public final FileConfiguration getArenas() {
        FileConfiguration fileConfiguration = this.arenas;
        if (fileConfiguration != null) {
            return fileConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException("arenas");
        return null;
    }

    @NotNull
    public final FileConfiguration getShop() {
        FileConfiguration fileConfiguration = this.shop;
        if (fileConfiguration != null) {
            return fileConfiguration;
        }
        Intrinsics.throwUninitializedPropertyAccessException("shop");
        return null;
    }

    public final void load() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.config = fileConfiguration;
        this.arenas = this.loadOrCreate("arenas.yml");
        this.shop = this.loadOrCreate("shop.yml");
        this.plugin.getLogger().info("Configuration files loaded successfully");
    }

    private final FileConfiguration loadOrCreate(String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            try {
                this.plugin.saveResource(fileName, false);
                this.plugin.getLogger().info("Created default " + fileName);
            }
            catch (IllegalArgumentException e) {
                try {
                    File file2 = file.getParentFile();
                    if (file2 != null) {
                        file2.mkdirs();
                    }
                    file.createNewFile();
                    this.plugin.getLogger().warning(fileName + " not found in resources, created empty file");
                }
                catch (IOException ioException) {
                    this.plugin.getLogger().severe("Failed to create " + fileName + ": " + ioException.getMessage());
                }
            }
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        return (FileConfiguration)yamlConfiguration;
    }

    public final void save(@NotNull FileConfiguration config, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        File file = new File(this.plugin.getDataFolder(), fileName);
        try {
            config.save(file);
            this.plugin.getLogger().info("Saved " + fileName);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save " + fileName + ": " + e.getMessage());
        }
    }

    public final void reload() {
        this.load();
        this.plugin.getLogger().info("Configuration reloaded");
    }

    public final int getPreparationTime() {
        return this.getConfig().getInt("game.preparation-time", 30);
    }

    public final int getSeekTime() {
        return this.getConfig().getInt("game.seek-time", 600);
    }

    public final int getMinPlayers() {
        return this.getConfig().getInt("general.min-players", 2);
    }

    public final int getMaxPlayers() {
        return this.getConfig().getInt("general.max-players", 30);
    }

    public final double getSeekerRatio() {
        return this.getConfig().getDouble("game.seeker-ratio", 0.23);
    }

    public final boolean isEconomyEnabled() {
        return this.getConfig().getBoolean("economy.enabled", true);
    }

    public final double getHiderWinReward() {
        return this.getConfig().getDouble("economy.rewards.hider-win", 1000.0);
    }

    public final double getSeekerWinReward() {
        return this.getConfig().getDouble("economy.rewards.seeker-win", 1000.0);
    }

    public final double getPerCaptureReward() {
        return this.getConfig().getDouble("economy.rewards.per-capture", 200.0);
    }

    public final double getParticipationReward() {
        return this.getConfig().getDouble("economy.rewards.participation", 100.0);
    }

    public final boolean isAutoRestartEnabled() {
        return this.getConfig().getBoolean("auto-restart.enabled", true);
    }

    public final int getPostGameCountdown() {
        return RangesKt.coerceIn(this.getConfig().getInt("auto-restart.post-game-countdown", 20), 5, 300);
    }

    public final boolean isForceJoinAllPlayers() {
        return this.getConfig().getBoolean("auto-restart.force-join-all-players", true);
    }

    public final int getBroadcastInterval() {
        return this.getConfig().getInt("auto-restart.broadcast-interval", 5);
    }

    public final boolean isSpectatorEnabled() {
        return this.getConfig().getBoolean("spectator.enabled", true);
    }

    public final boolean isAllowJoinDuringGame() {
        return this.getConfig().getBoolean("spectator.allow-join-during-game", true);
    }

    public final boolean isPersistSpectatorState() {
        return this.getConfig().getBoolean("spectator.persist-state", true);
    }

    public final double getSpectatorFlightSpeed() {
        return this.getConfig().getDouble("spectator.flight-speed", 1.5);
    }

    public final boolean isShowSeekerCount() {
        return this.getConfig().getBoolean("spectator.scoreboard.show-seeker-count", true);
    }

    public final boolean isShowHiderCount() {
        return this.getConfig().getBoolean("spectator.scoreboard.show-hider-count", true);
    }

    public final int getShowTopPlayers() {
        return RangesKt.coerceIn(this.getConfig().getInt("spectator.scoreboard.show-top-players", 3), 0, 10);
    }

    public final boolean isShowTeamLists() {
        return this.getConfig().getBoolean("spectator.scoreboard.show-team-lists", true);
    }

    public final int getScoreboardUpdateInterval() {
        return RangesKt.coerceAtLeast(this.getConfig().getInt("spectator.scoreboard.update-interval", 2), 1);
    }

    @NotNull
    public final CaptureMode getCaptureMode() {
        CaptureMode captureMode;
        String string;
        block5: {
            block4: {
                string = this.getConfig().getString("capture.mode", "INFECTION");
                if (string == null) break block4;
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
                string = string2;
                if (string2 != null) break block5;
            }
            string = "INFECTION";
        }
        String modeString = string;
        try {
            captureMode = CaptureMode.valueOf(modeString);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid capture mode '" + modeString + "', using INFECTION");
            captureMode = CaptureMode.INFECTION;
        }
        return captureMode;
    }
}

