/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.config;

import com.hideandseek.effects.EffectType;
import com.hideandseek.libs.kotlin.Lazy;
import com.hideandseek.libs.kotlin.LazyKt;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.text.StringsKt;
import com.hideandseek.shop.CamouflageTier;
import com.hideandseek.shop.ShopAction;
import com.hideandseek.shop.ShopCategory;
import com.hideandseek.shop.ShopItem;
import com.hideandseek.shop.UsageRestriction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007H\u0002J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tJ \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0014\u001a\u00020\bJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\tJ\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0018\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0006\u0010\u001f\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\u001cJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\tJ\u0006\u0010\"\u001a\u00020\u0016J\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lcom/hideandseek/config/ShopConfig;", "", "config", "Lorg/bukkit/configuration/ConfigurationSection;", "<init>", "(Lorg/bukkit/configuration/ConfigurationSection;)V", "disguiseBlocksMap", "", "Lcom/hideandseek/shop/CamouflageTier;", "", "Lorg/bukkit/Material;", "getDisguiseBlocksMap", "()Ljava/util/Map;", "disguiseBlocksMap$delegate", "Lcom/hideandseek/libs/kotlin/Lazy;", "loadDisguiseBlocks", "getDisguiseBlockItems", "Lcom/hideandseek/shop/ShopItem;", "createDisguiseBlockItem", "material", "tier", "slot", "", "getDisguiseBlocksByTier", "loadCategories", "Lcom/hideandseek/shop/ShopCategory;", "deserializeCategory", "id", "", "section", "deserializeItem", "getShopItemMaterial", "getShopItemDisplayName", "getShopItemLore", "getShopItemSlot", "getShopItemGlow", "", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nShopConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShopConfig.kt\ncom/hideandseek/config/ShopConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1617#2,9:299\n1869#2:308\n1870#2:310\n1626#2:311\n1617#2,9:312\n1869#2:321\n1870#2:323\n1626#2:324\n1617#2,9:325\n1869#2:334\n1870#2:336\n1626#2:337\n1#3:309\n1#3:322\n1#3:335\n1#3:338\n*S KotlinDebug\n*F\n+ 1 ShopConfig.kt\ncom/hideandseek/config/ShopConfig\n*L\n25#1:299,9\n25#1:308\n25#1:310\n25#1:311\n38#1:312,9\n38#1:321\n38#1:323\n38#1:324\n51#1:325,9\n51#1:334\n51#1:336\n51#1:337\n25#1:309\n38#1:322\n51#1:335\n*E\n"})
public final class ShopConfig {
    @NotNull
    private final ConfigurationSection config;
    @NotNull
    private final Lazy disguiseBlocksMap$delegate;

    public ShopConfig(@NotNull ConfigurationSection config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this.config = config;
        this.disguiseBlocksMap$delegate = LazyKt.lazy(() -> ShopConfig.disguiseBlocksMap_delegate$lambda$0(this));
    }

    private final Map<CamouflageTier, List<Material>> getDisguiseBlocksMap() {
        Lazy lazy = this.disguiseBlocksMap$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<CamouflageTier, List<Material>> loadDisguiseBlocks() {
        Map result;
        block15: {
            List blocks;
            Material it$iv$iv;
            boolean bl;
            Material material;
            String blockName;
            boolean bl2;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            Iterator iterator2;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            boolean $i$f$mapNotNullTo;
            Collection destination$iv$iv;
            boolean $i$f$mapNotNull;
            Iterable $this$mapNotNull$iv;
            ConfigurationSection section;
            result = new LinkedHashMap();
            ConfigurationSection configurationSection = this.config.getConfigurationSection("disguise-blocks");
            if (configurationSection == null) {
                return MapsKt.emptyMap();
            }
            ConfigurationSection disguiseSection = configurationSection;
            ConfigurationSection configurationSection2 = disguiseSection.getConfigurationSection("high-visibility");
            if (configurationSection2 != null) {
                section = configurationSection2;
                boolean bl3 = false;
                List list = section.getStringList("blocks");
                Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
                $this$mapNotNull$iv = list;
                $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator2.next();
                    bl2 = false;
                    blockName = (String)element$iv$iv;
                    boolean bl4 = false;
                    try {
                        Intrinsics.checkNotNull(blockName);
                        String string = blockName.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                        material = Material.valueOf((String)string);
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println((Object)("Invalid material '" + blockName + "' in high-visibility tier"));
                        material = null;
                    }
                    if (material == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                blocks = (List)destination$iv$iv;
                result.put(CamouflageTier.HIGH_VISIBILITY, blocks);
            }
            ConfigurationSection configurationSection3 = disguiseSection.getConfigurationSection("medium-visibility");
            if (configurationSection3 != null) {
                section = configurationSection3;
                boolean bl5 = false;
                List list = section.getStringList("blocks");
                Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
                $this$mapNotNull$iv = list;
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator2.next();
                    bl2 = false;
                    blockName = (String)element$iv$iv;
                    boolean bl6 = false;
                    try {
                        Intrinsics.checkNotNull(blockName);
                        String string = blockName.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                        material = Material.valueOf((String)string);
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println((Object)("Invalid material '" + blockName + "' in medium-visibility tier"));
                        material = null;
                    }
                    if (material == null) continue;
                    bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                blocks = (List)destination$iv$iv;
                result.put(CamouflageTier.MEDIUM_VISIBILITY, blocks);
            }
            ConfigurationSection configurationSection4 = disguiseSection.getConfigurationSection("low-visibility");
            if (configurationSection4 == null) break block15;
            section = configurationSection4;
            boolean bl7 = false;
            List list = section.getStringList("blocks");
            Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
            $this$mapNotNull$iv = list;
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                bl2 = false;
                blockName = (String)element$iv$iv;
                boolean bl8 = false;
                try {
                    Intrinsics.checkNotNull(blockName);
                    String string = blockName.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                    material = Material.valueOf((String)string);
                }
                catch (IllegalArgumentException e) {
                    System.out.println((Object)("Invalid material '" + blockName + "' in low-visibility tier"));
                    material = null;
                }
                if (material == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            blocks = (List)destination$iv$iv;
            result.put(CamouflageTier.LOW_VISIBILITY, blocks);
        }
        return result;
    }

    @NotNull
    public final List<ShopItem> getDisguiseBlockItems() {
        List items = new ArrayList();
        int slotCounter = 0;
        for (Map.Entry<CamouflageTier, List<Material>> entry : this.getDisguiseBlocksMap().entrySet()) {
            CamouflageTier tier = entry.getKey();
            List<Material> materials = entry.getValue();
            for (Material material : materials) {
                items.add(this.createDisguiseBlockItem(material, tier, slotCounter++));
            }
        }
        return items;
    }

    private final ShopItem createDisguiseBlockItem(Material material, CamouflageTier tier, int slot) {
        String string = material.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        Object object = new char[]{' '};
        String materialName = CollectionsKt.joinToString$default(StringsKt.split$default((CharSequence)StringsKt.replace$default(string, '_', ' ', false, 4, null), object, false, 0, 6, null), " ", null, null, 0, null, ShopConfig::createDisguiseBlockItem$lambda$0, 30, null);
        String string2 = material.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        object = "disguise-" + string2;
        String string3 = "\u00a7e" + materialName;
        String[] stringArray = new String[]{"\u00a77Click to disguise as this block", "", "\u00a77Tier: " + tier.getDisplayName(), tier.getFormattedDescription(), "", tier.getBasePrice() == 0 ? "\u00a7aFree!" : "\u00a7eCost: \u00a76" + tier.getBasePrice() + " coins", "", "\u00a7cRequires: Active game"};
        List<String> list = CollectionsKt.listOf(stringArray);
        int n = tier.getBasePrice();
        ShopAction.Disguise disguise = new ShopAction.Disguise(material);
        UsageRestriction usageRestriction = UsageRestriction.IN_GAME_ONLY;
        return new ShopItem((String)object, material, string3, list, slot, n, disguise, null, null, null, null, null, "HIDER", null, null, usageRestriction, tier, null, null, null, null, 1994624, null);
    }

    @NotNull
    public final List<Material> getDisguiseBlocksByTier(@NotNull CamouflageTier tier) {
        Intrinsics.checkNotNullParameter((Object)tier, "tier");
        List<Object> list = this.getDisguiseBlocksMap().get((Object)tier);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<ShopCategory> loadCategories() {
        List categories = new ArrayList();
        ConfigurationSection configurationSection = this.config.getConfigurationSection("categories");
        if (configurationSection == null) {
            return categories;
        }
        ConfigurationSection categoriesSection = configurationSection;
        for (String categoryKey : categoriesSection.getKeys(false)) {
            if (categoriesSection.getConfigurationSection(categoryKey) == null) continue;
            try {
                ConfigurationSection categorySection;
                Intrinsics.checkNotNull(categoryKey);
                ShopCategory category = this.deserializeCategory(categoryKey, categorySection);
                categories.add(category);
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to load shop category '" + categoryKey + "': " + e.getMessage()));
            }
        }
        return categories;
    }

    private final ShopCategory deserializeCategory(String id, ConfigurationSection section) {
        Material material;
        String string;
        String displayName;
        String string2 = section.getString("display-name");
        if (string2 == null) {
            string2 = displayName = id;
        }
        if ((string = section.getString("icon")) == null) {
            string = "GRASS_BLOCK";
        }
        String iconName = string;
        try {
            String string3 = iconName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toUpperCase(...)");
            material = Material.valueOf((String)string3);
        }
        catch (IllegalArgumentException e) {
            material = Material.GRASS_BLOCK;
        }
        Material icon = material;
        int slot = section.getInt("slot", 10);
        String roleFilter = section.getString("role-filter");
        List items = new ArrayList();
        ConfigurationSection itemsSection = section.getConfigurationSection("items");
        if (itemsSection != null) {
            for (String itemKey : itemsSection.getKeys(false)) {
                if (itemsSection.getConfigurationSection(itemKey) == null) continue;
                try {
                    ConfigurationSection itemSection;
                    Intrinsics.checkNotNull(itemKey);
                    ShopItem item = this.deserializeItem(itemKey, itemSection);
                    items.add(item);
                }
                catch (Exception e) {
                    System.out.println((Object)("Failed to load shop item '" + itemKey + "': " + e.getMessage()));
                }
            }
        }
        return new ShopCategory(id, displayName, icon, slot, items, roleFilter);
    }

    private final ShopItem deserializeItem(String id, ConfigurationSection section) {
        ShopAction shopAction;
        UsageRestriction usageRestriction2;
        EffectType effectType;
        Object it;
        String effectTypeStr;
        Material material;
        String string = section.getString("material");
        if (string == null) {
            string = "STONE";
        }
        String materialName = string;
        try {
            String string2 = materialName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            material = Material.valueOf((String)string2);
        }
        catch (IllegalArgumentException e) {
            material = Material.STONE;
        }
        Material material2 = material;
        String string3 = section.getString("display-name");
        if (string3 == null) {
            string3 = id;
        }
        String displayName = string3;
        List list = section.getStringList("lore");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List lore = list;
        int slot = section.getInt("slot", 0);
        int price = section.getInt("price", 0);
        String string4 = effectTypeStr = section.getString("effect-type");
        if (string4 != null) {
            EffectType effectType2;
            it = string4;
            boolean bl = false;
            try {
                String string5 = ((String)it).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string5, "toUpperCase(...)");
                effectType2 = EffectType.valueOf(string5);
            }
            catch (IllegalArgumentException e) {
                System.out.println((Object)("Invalid effect type '" + (String)it + "' for item '" + id + "', ignoring"));
                effectType2 = null;
            }
            effectType = effectType2;
        } else {
            effectType = null;
        }
        EffectType effectType3 = effectType;
        it = section.getInt("effect-duration", 0);
        int it22 = ((Number)it).intValue();
        boolean bl = false;
        Object effectDuration = it22 > 0 ? it : null;
        Double it22 = section.getDouble("effect-intensity", 0.0);
        double it3 = ((Number)it22).doubleValue();
        boolean bl2 = false;
        Double effectIntensity = it3 > 0.0 ? it22 : null;
        String tauntType = section.getString("taunt-type");
        Integer e = section.getInt("taunt-bonus", 0);
        int it4 = ((Number)e).intValue();
        boolean bl3 = false;
        Integer tauntBonus = it4 > 0 ? e : null;
        String itemType = section.getString("item-type");
        String itemMaterial = section.getString("item-material");
        int itemAmount = section.getInt("item-amount", 1);
        System.out.println((Object)("[ShopConfig] Loading item '" + id + "': itemType=" + itemType + ", itemMaterial=" + itemMaterial + ", itemAmount=" + itemAmount));
        String roleFilter = section.getString("role-filter");
        Integer n = section.getInt("cooldown", 0);
        int it322 = ((Number)n).intValue();
        boolean bl4 = false;
        Integer cooldown = it322 > 0 ? n : null;
        Integer it322 = section.getInt("max-purchases", 0);
        int it5 = ((Number)it322).intValue();
        boolean usageRestriction2 = false;
        Integer maxPurchases = it5 > 0 ? it322 : null;
        String string6 = section.getString("usage-restriction");
        if (string6 == null) {
            string6 = "ALWAYS";
        }
        String usageRestrictionStr = string6;
        try {
            String string7 = usageRestrictionStr.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string7, "toUpperCase(...)");
            usageRestriction2 = UsageRestriction.valueOf(string7);
        }
        catch (IllegalArgumentException e2) {
            System.out.println((Object)("Invalid usage restriction '" + usageRestrictionStr + "' for item '" + id + "', using ALWAYS"));
            usageRestriction2 = UsageRestriction.ALWAYS;
        }
        UsageRestriction usageRestriction3 = usageRestriction2;
        if ((Intrinsics.areEqual(itemType, "TAUNT_ITEM") || Intrinsics.areEqual(itemType, "EQUIPMENT")) && itemMaterial != null) {
            Material material3;
            try {
                String string8 = itemMaterial.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string8, "toUpperCase(...)");
                material3 = Material.valueOf((String)string8);
            }
            catch (IllegalArgumentException e3) {
                material3 = material2;
            }
            Material giveMaterial = material3;
            System.out.println((Object)("[ShopConfig] Item '" + id + "' -> GiveItem(" + giveMaterial + ", " + itemAmount + ") [itemType=" + itemType + ", itemMaterial=" + itemMaterial + "]"));
            shopAction = new ShopAction.GiveItem(giveMaterial, itemAmount);
        } else if (effectType3 != null && effectDuration != null && effectIntensity != null) {
            System.out.println((Object)("[ShopConfig] Item '" + id + "' -> UseEffectItem"));
            shopAction = new ShopAction.UseEffectItem(effectType3, (Integer)effectDuration, effectIntensity);
        } else if (tauntType != null && tauntBonus != null) {
            System.out.println((Object)("[ShopConfig] Item '" + id + "' -> UseTauntItem (legacy - DEPRECATED)"));
            shopAction = new ShopAction.UseTauntItem(tauntType, tauntBonus, material2);
        } else {
            System.out.println((Object)("[ShopConfig] Item '" + id + "' -> Disguise (default)"));
            shopAction = new ShopAction.Disguise(material2);
        }
        ShopAction action = shopAction;
        ShopItem item = new ShopItem(id, material2, displayName, lore, slot, price, action, effectType3, (Integer)effectDuration, effectIntensity, tauntType, tauntBonus, roleFilter, cooldown, maxPurchases, usageRestriction3, null, null, null, null, null, 0x1F0000, null);
        item.validate();
        return item;
    }

    @NotNull
    public final Material getShopItemMaterial() {
        Material material;
        String string = this.config.getString("shop-item.material", "EMERALD");
        if (string == null) {
            string = "EMERALD";
        }
        String materialName = string;
        try {
            String string2 = materialName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            material = Material.valueOf((String)string2);
        }
        catch (IllegalArgumentException e) {
            material = Material.EMERALD;
        }
        return material;
    }

    @NotNull
    public final String getShopItemDisplayName() {
        String string = this.config.getString("shop-item.display-name", "&a&lShop");
        if (string == null) {
            string = "&a&lShop";
        }
        return string;
    }

    @NotNull
    public final List<String> getShopItemLore() {
        List list = this.config.getStringList("shop-item.lore");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        return list;
    }

    public final int getShopItemSlot() {
        return this.config.getInt("shop-item.slot", 8);
    }

    public final boolean getShopItemGlow() {
        return this.config.getBoolean("shop-item.glow", true);
    }

    private static final Map disguiseBlocksMap_delegate$lambda$0(ShopConfig this$0) {
        return this$0.loadDisguiseBlocks();
    }

    private static final CharSequence createDisguiseBlockItem$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return StringsKt.capitalize(it);
    }
}

