/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.effects;

import com.hideandseek.effects.ActiveEffect;
import com.hideandseek.effects.EffectType;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.functions.Function1;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007J\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\r\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017J\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00010\u0010R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/hideandseek/effects/EffectStorage;", "", "<init>", "()V", "effects", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcom/hideandseek/effects/EffectType;", "Lcom/hideandseek/effects/ActiveEffect;", "putEffect", "", "effect", "getEffect", "playerId", "effectType", "getAllEffects", "", "removeEffect", "removeAllEffects", "", "hasEffect", "", "getAllPlayers", "", "clearAll", "cleanupExpired", "", "estimateMemoryUsage", "", "getStats", "", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nEffectStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EffectStorage.kt\ncom/hideandseek/effects/EffectStorage\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n216#2,2:178\n216#2:180\n216#2,2:181\n217#2:183\n1#3:184\n1788#4,4:185\n*S KotlinDebug\n*F\n+ 1 EffectStorage.kt\ncom/hideandseek/effects/EffectStorage\n*L\n114#1:178,2\n141#1:180\n145#1:181,2\n141#1:183\n165#1:185,4\n*E\n"})
public final class EffectStorage {
    @NotNull
    private final ConcurrentHashMap<UUID, ConcurrentHashMap<EffectType, ActiveEffect>> effects = new ConcurrentHashMap();

    public final void putEffect(@NotNull ActiveEffect effect) {
        Intrinsics.checkNotNullParameter(effect, "effect");
        this.effects.computeIfAbsent(effect.getPlayerId(), arg_0 -> EffectStorage.putEffect$lambda$1(EffectStorage::putEffect$lambda$0, arg_0)).put(effect.getEffectType(), effect);
    }

    @Nullable
    public final ActiveEffect getEffect(@NotNull UUID playerId, @NotNull EffectType effectType) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        ConcurrentHashMap<EffectType, ActiveEffect> concurrentHashMap = this.effects.get(playerId);
        return concurrentHashMap != null ? concurrentHashMap.get((Object)effectType) : null;
    }

    @NotNull
    public final Map<EffectType, ActiveEffect> getAllEffects(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Map<EffectType, ActiveEffect> map = this.effects.get(playerId);
        if (map == null || (map = MapsKt.toMap((Map)map)) == null) {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Nullable
    public final ActiveEffect removeEffect(@NotNull UUID playerId, @NotNull EffectType effectType) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        ConcurrentHashMap<EffectType, ActiveEffect> concurrentHashMap = this.effects.get(playerId);
        if (concurrentHashMap == null) {
            return null;
        }
        ConcurrentHashMap<EffectType, ActiveEffect> playerEffects = concurrentHashMap;
        ActiveEffect removed = playerEffects.remove((Object)effectType);
        if (playerEffects.isEmpty()) {
            this.effects.remove(playerId);
        }
        return removed;
    }

    @NotNull
    public final List<ActiveEffect> removeAllEffects(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Object object = this.effects.remove(playerId);
        if (object == null || (object = ((ConcurrentHashMap)object).values()) == null || (object = CollectionsKt.toList((Iterable)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        List<ActiveEffect> removed = object;
        return removed;
    }

    public final boolean hasEffect(@NotNull UUID playerId, @NotNull EffectType effectType) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        ActiveEffect activeEffect = this.getEffect(playerId, effectType);
        if (activeEffect == null) {
            return false;
        }
        ActiveEffect effect = activeEffect;
        return !effect.isExpired();
    }

    @NotNull
    public final Set<UUID> getAllPlayers() {
        Set set = this.effects.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        return CollectionsKt.toSet(set);
    }

    public final void clearAll() {
        this.effects.clear();
    }

    public final int cleanupExpired() {
        int removed = 0;
        Map $this$forEach$iv = this.effects;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID playerId = (UUID)entry.getKey();
            ConcurrentHashMap playerEffects = (ConcurrentHashMap)entry.getValue();
            Iterator iterator3 = playerEffects.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry2;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                if (!((ActiveEffect)entry2.getValue()).isExpired()) continue;
                iterator3.remove();
                ++removed;
            }
            if (!playerEffects.isEmpty()) continue;
            this.effects.remove(playerId);
        }
        return removed;
    }

    public final long estimateMemoryUsage() {
        long total = 0L;
        Map $this$forEach$iv = this.effects;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            ConcurrentHashMap playerEffects = (ConcurrentHashMap)entry.getValue();
            total += (long)64;
            Map $this$forEach$iv2 = playerEffects;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry entry2 = element$iv2 = iterator3.next();
                boolean bl2 = false;
                ActiveEffect effect = (ActiveEffect)entry2.getValue();
                total += (long)200;
                total += (long)effect.getMetadata().size() * 40L;
                total += (long)64;
            }
        }
        return total;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> getStats() {
        int n;
        int n2;
        ConcurrentHashMap concurrentHashMap;
        Object object2;
        Collection<ConcurrentHashMap<EffectType, ActiveEffect>> collection = this.effects.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        int n3 = 0;
        for (Object object2 : iterable) {
            void it;
            concurrentHashMap = (ConcurrentHashMap)object2;
            n2 = n3;
            boolean bl = false;
            n = it.size();
            n3 = n2 + n;
        }
        int totalEffects = n3;
        Collection<ConcurrentHashMap<EffectType, ActiveEffect>> collection2 = this.effects.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Pair[] pairArray = (Pair[])collection2;
        int n4 = 0;
        object2 = pairArray.iterator();
        while (object2.hasNext()) {
            int n5;
            void playerEffects;
            ConcurrentHashMap bl = concurrentHashMap = object2.next();
            n2 = n4;
            boolean bl2 = false;
            Collection collection3 = playerEffects.values();
            Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
            Iterable $this$count$iv = collection3;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n5 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ActiveEffect it = (ActiveEffect)element$iv;
                    boolean bl3 = false;
                    if (!(!it.isExpired()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n5 = count$iv;
            }
            n = n5;
            n4 = n2 + n;
        }
        int activeEffects = n4;
        pairArray = new Pair[]{TuplesKt.to("total_players", this.effects.size()), TuplesKt.to("total_effects", totalEffects), TuplesKt.to("active_effects", activeEffects), TuplesKt.to("expired_effects", totalEffects - activeEffects), TuplesKt.to("estimated_memory_kb", this.estimateMemoryUsage() / (long)1024)};
        return MapsKt.mapOf(pairArray);
    }

    private static final ConcurrentHashMap putEffect$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ConcurrentHashMap();
    }

    private static final ConcurrentHashMap putEffect$lambda$1(Function1 $tmp0, Object p0) {
        return (ConcurrentHashMap)$tmp0.invoke(p0);
    }
}

