/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.effects;

import com.hideandseek.effects.ActiveEffect;
import com.hideandseek.effects.EffectHandler;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.items.ItemConfig;
import com.hideandseek.items.ItemEffectHandler;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Result;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/hideandseek/effects/ItemEffectHandlerAdapter;", "Lcom/hideandseek/effects/EffectHandler;", "itemHandler", "Lcom/hideandseek/items/ItemEffectHandler;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lcom/hideandseek/items/ItemEffectHandler;Lcom/hideandseek/game/GameManager;)V", "apply", "", "player", "Lorg/bukkit/entity/Player;", "effect", "Lcom/hideandseek/effects/ActiveEffect;", "remove", "EasyHideAndSeek"})
public final class ItemEffectHandlerAdapter
implements EffectHandler {
    @NotNull
    private final ItemEffectHandler itemHandler;
    @NotNull
    private final GameManager gameManager;

    public ItemEffectHandlerAdapter(@NotNull ItemEffectHandler itemHandler, @NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(itemHandler, "itemHandler");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.itemHandler = itemHandler;
        this.gameManager = gameManager;
    }

    @Override
    public void apply(@NotNull Player player, @NotNull ActiveEffect effect) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(effect, "effect");
        player.sendMessage("\u00a7d[DEBUG] ItemEffectHandlerAdapter.apply() called for " + effect.getEffectType());
        player.sendMessage("\u00a7d[DEBUG] Handler class: " + this.itemHandler.getClass().getSimpleName());
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            player.sendMessage("\u00a7c[DEBUG] No active game found!");
            return;
        }
        player.sendMessage("\u00a7d[DEBUG] Active game found: " + game.getArena().getName());
        if (!this.itemHandler.canApply(player, game)) {
            player.sendMessage("\u00a7c[DEBUG] Handler.canApply() returned false!");
            return;
        }
        player.sendMessage("\u00a7a[DEBUG] Handler.canApply() returned true");
        ItemConfig config = new ItemConfig((int)(effect.getEndTime().getEpochSecond() - effect.getStartTime().getEpochSecond()), effect.getIntensity(), effect.getMetadata());
        player.sendMessage("\u00a7d[DEBUG] ItemConfig created: duration=" + config.getDuration() + ", intensity=" + config.getIntensity());
        player.sendMessage("\u00a7d[DEBUG] Calling itemHandler.apply()...");
        Object result = this.itemHandler.apply-0E7RQCE(player, game, config);
        player.sendMessage("\u00a7d[DEBUG] itemHandler.apply() result: success=" + Result.isSuccess-impl(result) + ", failure=" + Result.isFailure-impl(result));
        if (Result.isFailure-impl(result)) {
            Throwable throwable = Result.exceptionOrNull-impl(result);
            player.sendMessage("\u00a7c[DEBUG] Error: " + (throwable != null ? throwable.getMessage() : null));
        }
    }

    @Override
    public void remove(@NotNull Player player, @NotNull ActiveEffect effect) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(effect, "effect");
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        this.itemHandler.onExpire(player, game2);
    }
}

