/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.game;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 42\u00020\u0001:\u00014BW\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010(\u001a\u00020\u0010H\u0016J\u0016\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\t\u0010+\u001a\u00020\u0007H\u00c6\u0003J\t\u0010,\u001a\u00020\tH\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\t\u0010/\u001a\u00020\u0010H\u00c6\u0003Jl\u00100\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u00c6\u0001\u00a2\u0006\u0002\u00101J\t\u00102\u001a\u000203H\u00d6\u0001R\u001b\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00065"}, d2={"Lcom/hideandseek/game/PlayerBackup;", "", "inventory", "", "Lorg/bukkit/inventory/ItemStack;", "armor", "location", "Lorg/bukkit/Location;", "gameMode", "Lorg/bukkit/GameMode;", "scoreboard", "Lorg/bukkit/scoreboard/Scoreboard;", "potionEffects", "", "Lorg/bukkit/potion/PotionEffect;", "viewDistance", "", "<init>", "([Lorg/bukkit/inventory/ItemStack;[Lorg/bukkit/inventory/ItemStack;Lorg/bukkit/Location;Lorg/bukkit/GameMode;Lorg/bukkit/scoreboard/Scoreboard;Ljava/util/Collection;I)V", "getInventory", "()[Lorg/bukkit/inventory/ItemStack;", "[Lorg/bukkit/inventory/ItemStack;", "getArmor", "getLocation", "()Lorg/bukkit/Location;", "getGameMode", "()Lorg/bukkit/GameMode;", "getScoreboard", "()Lorg/bukkit/scoreboard/Scoreboard;", "getPotionEffects", "()Ljava/util/Collection;", "getViewDistance", "()I", "restore", "", "player", "Lorg/bukkit/entity/Player;", "equals", "", "other", "hashCode", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "([Lorg/bukkit/inventory/ItemStack;[Lorg/bukkit/inventory/ItemStack;Lorg/bukkit/Location;Lorg/bukkit/GameMode;Lorg/bukkit/scoreboard/Scoreboard;Ljava/util/Collection;I)Lcom/hideandseek/game/PlayerBackup;", "toString", "", "Companion", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nPlayerBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerBackup.kt\ncom/hideandseek/game/PlayerBackup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1869#2,2:90\n1869#2,2:92\n*S KotlinDebug\n*F\n+ 1 PlayerBackup.kt\ncom/hideandseek/game/PlayerBackup\n*L\n21#1:90,2\n26#1:92,2\n*E\n"})
public final class PlayerBackup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStack[] inventory;
    @NotNull
    private final ItemStack[] armor;
    @NotNull
    private final Location location;
    @NotNull
    private final GameMode gameMode;
    @Nullable
    private final Scoreboard scoreboard;
    @NotNull
    private final Collection<PotionEffect> potionEffects;
    private final int viewDistance;

    public PlayerBackup(@NotNull ItemStack[] inventory, @NotNull ItemStack[] armor, @NotNull Location location, @NotNull GameMode gameMode, @Nullable Scoreboard scoreboard, @NotNull Collection<? extends PotionEffect> potionEffects, int viewDistance) {
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        Intrinsics.checkNotNullParameter(armor, "armor");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        Intrinsics.checkNotNullParameter(potionEffects, "potionEffects");
        this.inventory = inventory;
        this.armor = armor;
        this.location = location;
        this.gameMode = gameMode;
        this.scoreboard = scoreboard;
        this.potionEffects = potionEffects;
        this.viewDistance = viewDistance;
    }

    @NotNull
    public final ItemStack[] getInventory() {
        return this.inventory;
    }

    @NotNull
    public final ItemStack[] getArmor() {
        return this.armor;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final GameMode getGameMode() {
        return this.gameMode;
    }

    @Nullable
    public final Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    @NotNull
    public final Collection<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public final int getViewDistance() {
        return this.viewDistance;
    }

    public final void restore(@NotNull Player player) {
        PotionEffect effect;
        Intrinsics.checkNotNullParameter(player, "player");
        Collection collection = player.getActivePotionEffects();
        Intrinsics.checkNotNullExpressionValue(collection, "getActivePotionEffects(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            effect = (PotionEffect)element$iv;
            boolean bl = false;
            player.removePotionEffect(effect.getType());
        }
        $this$forEach$iv = this.potionEffects;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            effect = (PotionEffect)element$iv;
            boolean bl = false;
            player.addPotionEffect(effect);
        }
        player.getInventory().setContents((ItemStack[])this.inventory.clone());
        player.getInventory().setArmorContents((ItemStack[])this.armor.clone());
        player.setGameMode(this.gameMode);
        player.setSendViewDistance(this.viewDistance);
        if (this.location.getWorld() != null && this.location.isChunkLoaded()) {
            v1 = player.teleport(this.location);
        } else {
            World world = this.location.getWorld();
            if (world == null || (world = world.getSpawnLocation()) == null) {
                Location location = player.getWorld().getSpawnLocation();
                world = location;
                Intrinsics.checkNotNullExpressionValue(location, "getSpawnLocation(...)");
            }
            World fallback = world;
            v1 = player.teleport((Location)fallback);
        }
        if (this.scoreboard != null) {
            player.setScoreboard(this.scoreboard);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type com.hideandseek.game.PlayerBackup");
        PlayerBackup cfr_ignored_0 = (PlayerBackup)object2;
        if (!Arrays.equals(this.inventory, ((PlayerBackup)other).inventory)) {
            return false;
        }
        if (!Arrays.equals(this.armor, ((PlayerBackup)other).armor)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.location, ((PlayerBackup)other).location)) {
            return false;
        }
        if (this.gameMode != ((PlayerBackup)other).gameMode) {
            return false;
        }
        return Intrinsics.areEqual(this.scoreboard, ((PlayerBackup)other).scoreboard);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.inventory);
        result = 31 * result + Arrays.hashCode(this.armor);
        result = 31 * result + this.location.hashCode();
        result = 31 * result + this.gameMode.hashCode();
        Scoreboard scoreboard = this.scoreboard;
        result = 31 * result + (scoreboard != null ? scoreboard.hashCode() : 0);
        return result;
    }

    @NotNull
    public final ItemStack[] component1() {
        return this.inventory;
    }

    @NotNull
    public final ItemStack[] component2() {
        return this.armor;
    }

    @NotNull
    public final Location component3() {
        return this.location;
    }

    @NotNull
    public final GameMode component4() {
        return this.gameMode;
    }

    @Nullable
    public final Scoreboard component5() {
        return this.scoreboard;
    }

    @NotNull
    public final Collection<PotionEffect> component6() {
        return this.potionEffects;
    }

    public final int component7() {
        return this.viewDistance;
    }

    @NotNull
    public final PlayerBackup copy(@NotNull ItemStack[] inventory, @NotNull ItemStack[] armor, @NotNull Location location, @NotNull GameMode gameMode, @Nullable Scoreboard scoreboard, @NotNull Collection<? extends PotionEffect> potionEffects, int viewDistance) {
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        Intrinsics.checkNotNullParameter(armor, "armor");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(gameMode, "gameMode");
        Intrinsics.checkNotNullParameter(potionEffects, "potionEffects");
        return new PlayerBackup(inventory, armor, location, gameMode, scoreboard, potionEffects, viewDistance);
    }

    public static /* synthetic */ PlayerBackup copy$default(PlayerBackup playerBackup, ItemStack[] itemStackArray, ItemStack[] itemStackArray2, Location location, GameMode gameMode, Scoreboard scoreboard, Collection collection, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            itemStackArray = playerBackup.inventory;
        }
        if ((n2 & 2) != 0) {
            itemStackArray2 = playerBackup.armor;
        }
        if ((n2 & 4) != 0) {
            location = playerBackup.location;
        }
        if ((n2 & 8) != 0) {
            gameMode = playerBackup.gameMode;
        }
        if ((n2 & 0x10) != 0) {
            scoreboard = playerBackup.scoreboard;
        }
        if ((n2 & 0x20) != 0) {
            collection = playerBackup.potionEffects;
        }
        if ((n2 & 0x40) != 0) {
            n = playerBackup.viewDistance;
        }
        return playerBackup.copy(itemStackArray, itemStackArray2, location, gameMode, scoreboard, collection, n);
    }

    @NotNull
    public String toString() {
        return "PlayerBackup(inventory=" + Arrays.toString(this.inventory) + ", armor=" + Arrays.toString(this.armor) + ", location=" + this.location + ", gameMode=" + this.gameMode + ", scoreboard=" + this.scoreboard + ", potionEffects=" + this.potionEffects + ", viewDistance=" + this.viewDistance + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/hideandseek/game/PlayerBackup$Companion;", "", "<init>", "()V", "create", "Lcom/hideandseek/game/PlayerBackup;", "player", "Lorg/bukkit/entity/Player;", "EasyHideAndSeek"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlayerBackup create(@NotNull Player player) {
            Intrinsics.checkNotNullParameter(player, "player");
            ItemStack[] itemStackArray = (ItemStack[])player.getInventory().getContents().clone();
            ItemStack[] itemStackArray2 = (ItemStack[])player.getInventory().getArmorContents().clone();
            Location location = player.getLocation().clone();
            Intrinsics.checkNotNullExpressionValue(location, "clone(...)");
            GameMode gameMode = player.getGameMode();
            Intrinsics.checkNotNullExpressionValue(gameMode, "getGameMode(...)");
            Scoreboard scoreboard = player.getScoreboard();
            Collection collection = player.getActivePotionEffects();
            Intrinsics.checkNotNullExpressionValue(collection, "getActivePotionEffects(...)");
            return new PlayerBackup(itemStackArray, itemStackArray2, location, gameMode, scoreboard, CollectionsKt.toList(collection), player.getClientViewDistance());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

