/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.game;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\tH\u00c6\u0003JE\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\tH\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006("}, d2={"Lcom/hideandseek/game/WorldBorderBackup;", "", "center", "Lorg/bukkit/Location;", "size", "", "damageAmount", "damageBuffer", "warningDistance", "", "warningTime", "<init>", "(Lorg/bukkit/Location;DDDII)V", "getCenter", "()Lorg/bukkit/Location;", "getSize", "()D", "getDamageAmount", "getDamageBuffer", "getWarningDistance", "()I", "getWarningTime", "restore", "", "world", "Lorg/bukkit/World;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "EasyHideAndSeek"})
public final class WorldBorderBackup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Location center;
    private final double size;
    private final double damageAmount;
    private final double damageBuffer;
    private final int warningDistance;
    private final int warningTime;

    public WorldBorderBackup(@NotNull Location center, double size, double damageAmount, double damageBuffer, int warningDistance, int warningTime) {
        Intrinsics.checkNotNullParameter(center, "center");
        this.center = center;
        this.size = size;
        this.damageAmount = damageAmount;
        this.damageBuffer = damageBuffer;
        this.warningDistance = warningDistance;
        this.warningTime = warningTime;
    }

    @NotNull
    public final Location getCenter() {
        return this.center;
    }

    public final double getSize() {
        return this.size;
    }

    public final double getDamageAmount() {
        return this.damageAmount;
    }

    public final double getDamageBuffer() {
        return this.damageBuffer;
    }

    public final int getWarningDistance() {
        return this.warningDistance;
    }

    public final int getWarningTime() {
        return this.warningTime;
    }

    public final void restore(@NotNull World world) {
        Intrinsics.checkNotNullParameter(world, "world");
        WorldBorder worldBorder = world.getWorldBorder();
        Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
        WorldBorder border = worldBorder;
        border.setCenter(this.center);
        border.setSize(this.size);
        border.setDamageAmount(this.damageAmount);
        border.setDamageBuffer(this.damageBuffer);
        border.setWarningDistance(this.warningDistance);
        border.setWarningTime(this.warningTime);
    }

    @NotNull
    public final Location component1() {
        return this.center;
    }

    public final double component2() {
        return this.size;
    }

    public final double component3() {
        return this.damageAmount;
    }

    public final double component4() {
        return this.damageBuffer;
    }

    public final int component5() {
        return this.warningDistance;
    }

    public final int component6() {
        return this.warningTime;
    }

    @NotNull
    public final WorldBorderBackup copy(@NotNull Location center, double size, double damageAmount, double damageBuffer, int warningDistance, int warningTime) {
        Intrinsics.checkNotNullParameter(center, "center");
        return new WorldBorderBackup(center, size, damageAmount, damageBuffer, warningDistance, warningTime);
    }

    public static /* synthetic */ WorldBorderBackup copy$default(WorldBorderBackup worldBorderBackup, Location location, double d, double d2, double d3, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            location = worldBorderBackup.center;
        }
        if ((n3 & 2) != 0) {
            d = worldBorderBackup.size;
        }
        if ((n3 & 4) != 0) {
            d2 = worldBorderBackup.damageAmount;
        }
        if ((n3 & 8) != 0) {
            d3 = worldBorderBackup.damageBuffer;
        }
        if ((n3 & 0x10) != 0) {
            n = worldBorderBackup.warningDistance;
        }
        if ((n3 & 0x20) != 0) {
            n2 = worldBorderBackup.warningTime;
        }
        return worldBorderBackup.copy(location, d, d2, d3, n, n2);
    }

    @NotNull
    public String toString() {
        return "WorldBorderBackup(center=" + this.center + ", size=" + this.size + ", damageAmount=" + this.damageAmount + ", damageBuffer=" + this.damageBuffer + ", warningDistance=" + this.warningDistance + ", warningTime=" + this.warningTime + ")";
    }

    public int hashCode() {
        int result = this.center.hashCode();
        result = result * 31 + Double.hashCode(this.size);
        result = result * 31 + Double.hashCode(this.damageAmount);
        result = result * 31 + Double.hashCode(this.damageBuffer);
        result = result * 31 + Integer.hashCode(this.warningDistance);
        result = result * 31 + Integer.hashCode(this.warningTime);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WorldBorderBackup)) {
            return false;
        }
        WorldBorderBackup worldBorderBackup = (WorldBorderBackup)other;
        if (!Intrinsics.areEqual(this.center, worldBorderBackup.center)) {
            return false;
        }
        if (Double.compare(this.size, worldBorderBackup.size) != 0) {
            return false;
        }
        if (Double.compare(this.damageAmount, worldBorderBackup.damageAmount) != 0) {
            return false;
        }
        if (Double.compare(this.damageBuffer, worldBorderBackup.damageBuffer) != 0) {
            return false;
        }
        if (this.warningDistance != worldBorderBackup.warningDistance) {
            return false;
        }
        return this.warningTime == worldBorderBackup.warningTime;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/hideandseek/game/WorldBorderBackup$Companion;", "", "<init>", "()V", "capture", "Lcom/hideandseek/game/WorldBorderBackup;", "world", "Lorg/bukkit/World;", "defaultBackup", "EasyHideAndSeek"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WorldBorderBackup capture(@NotNull World world) {
            Intrinsics.checkNotNullParameter(world, "world");
            WorldBorder worldBorder = world.getWorldBorder();
            Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
            WorldBorder border = worldBorder;
            Location location = border.getCenter();
            Intrinsics.checkNotNullExpressionValue(location, "getCenter(...)");
            return new WorldBorderBackup(location, border.getSize(), border.getDamageAmount(), border.getDamageBuffer(), border.getWarningDistance(), border.getWarningTime());
        }

        @NotNull
        public final WorldBorderBackup defaultBackup(@NotNull World world) {
            Intrinsics.checkNotNullParameter(world, "world");
            Location location = world.getSpawnLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getSpawnLocation(...)");
            return new WorldBorderBackup(location, 2.9999984E7, 0.2, 5.0, 5, 15);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

