/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.items;

import com.hideandseek.game.Game;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.items.ItemConfig;
import com.hideandseek.items.ItemEffectHandler;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.Result;
import com.hideandseek.libs.kotlin.ResultKt;
import com.hideandseek.libs.kotlin.Unit;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.Ref;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J-\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/hideandseek/items/AreaScanHandler;", "Lcom/hideandseek/items/ItemEffectHandler;", "<init>", "()V", "canApply", "", "player", "Lorg/bukkit/entity/Player;", "game", "Lcom/hideandseek/game/Game;", "apply", "Lcom/hideandseek/libs/kotlin/Result;", "", "config", "Lcom/hideandseek/items/ItemConfig;", "apply-0E7RQCE", "(Lorg/bukkit/entity/Player;Lcom/hideandseek/game/Game;Lcom/hideandseek/items/ItemConfig;)Ljava/lang/Object;", "onExpire", "getDisplayLore", "", "", "getDirection", "from", "Lorg/bukkit/Location;", "to", "createScanParticles", "radius", "", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nAreaScanHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AreaScanHandler.kt\ncom/hideandseek/items/AreaScanHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,173:1\n1491#2:174\n1516#2,3:175\n1519#2,3:185\n382#3,7:178\n*S KotlinDebug\n*F\n+ 1 AreaScanHandler.kt\ncom/hideandseek/items/AreaScanHandler\n*L\n61#1:174\n61#1:175,3\n61#1:185,3\n61#1:178,7\n*E\n"})
public final class AreaScanHandler
implements ItemEffectHandler {
    @Override
    public boolean canApply(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        PlayerGameData playerGameData = game.getPlayers().get(player.getUniqueId());
        if (playerGameData == null) {
            return false;
        }
        PlayerGameData playerData = playerGameData;
        return Intrinsics.areEqual(playerData.getRole().name(), "SEEKER");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Object apply-0E7RQCE(@NotNull Player player, @NotNull Game game, @NotNull ItemConfig config) {
        Object object;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(config, "config");
        try {
            Object playerData;
            double scanRadius = config.getIntensity();
            List nearbyHiders = new ArrayList();
            for (Map.Entry<UUID, PlayerGameData> entry : game.getPlayers().entrySet()) {
                Player hider;
                double distance;
                UUID uUID = entry.getKey();
                playerData = entry.getValue();
                if (!Intrinsics.areEqual(((PlayerGameData)playerData).getRole().name(), "HIDER") || ((PlayerGameData)playerData).isCaptured() || Bukkit.getPlayer((UUID)uUID) == null || !((distance = player.getLocation().distance(hider.getLocation())) <= scanRadius)) continue;
                Location location = player.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                Location location2 = hider.getLocation();
                Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
                String direction = this.getDirection(location, location2);
                nearbyHiders.add(new Pair<Player, String>(hider, direction));
            }
            this.createScanParticles(player, scanRadius);
            if (nearbyHiders.isEmpty()) {
                player.sendMessage("\u00a7c\u2726 \u30a8\u30ea\u30a2\u30b9\u30ad\u30e3\u30f3");
                player.sendMessage("\u00a77\u7bc4\u56f2" + (int)scanRadius + "\u30d6\u30ed\u30c3\u30af\u5185\u306b\u30cf\u30a4\u30c0\u30fc\u306f\u3044\u307e\u305b\u3093");
            } else {
                void $this$groupByTo$iv$iv;
                player.sendMessage("\u00a7a\u2726 \u30a8\u30ea\u30a2\u30b9\u30ad\u30e3\u30f3");
                player.sendMessage("\u00a7e" + nearbyHiders.size() + "\u4eba\u00a77\u306e\u30cf\u30a4\u30c0\u30fc\u3092\u691c\u51fa \u00a77(\u534a\u5f84" + (int)scanRadius + "\u30d6\u30ed\u30c3\u30af)");
                player.sendMessage("");
                Iterable $this$groupBy$iv = nearbyHiders;
                boolean bl = false;
                playerData = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    void $this$getOrPut$iv$iv$iv;
                    Pair it = (Pair)element$iv$iv;
                    boolean bl2 = false;
                    String key$iv$iv = (String)it.getSecond();
                    Map map = destination$iv$iv;
                    String key$iv$iv$iv = key$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl22 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map byDirection = destination$iv$iv;
                for (Map.Entry entry : byDirection.entrySet()) {
                    String direction = (String)entry.getKey();
                    List hiders = (List)entry.getValue();
                    player.sendMessage("  \u00a77" + direction + ": \u00a7e" + hiders.size() + "\u4eba");
                }
            }
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_AMBIENT, 1.0f, 1.5f);
            Plugin plugin = player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
            Intrinsics.checkNotNull(plugin);
            Plugin plugin2 = plugin;
            String message = nearbyHiders.isEmpty() ? "\u00a7c\u30b9\u30ad\u30e3\u30f3\u7d50\u679c: 0\u4eba" : "\u00a7a\u30b9\u30ad\u30e3\u30f3\u7d50\u679c: \u00a7e" + nearbyHiders.size() + "\u4eba\u00a77\u306e\u30cf\u30a4\u30c0\u30fc\u691c\u51fa";
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = config.getDuration();
            BukkitRunnable task2 = new BukkitRunnable(intRef, player, message){
                final /* synthetic */ Ref.IntRef $secondsLeft;
                final /* synthetic */ Player $player;
                final /* synthetic */ String $message;
                {
                    this.$secondsLeft = $secondsLeft;
                    this.$player = $player;
                    this.$message = $message;
                }

                public void run() {
                    if (this.$secondsLeft.element <= 0 || !this.$player.isOnline()) {
                        this.cancel();
                        return;
                    }
                    this.$player.sendActionBar(this.$message + " \u00a77(" + this.$secondsLeft.element + "\u79d2)");
                    int n = this.$secondsLeft.element;
                    this.$secondsLeft.element = n + -1;
                }
            };
            task2.runTaskTimer(plugin2, 0L, 20L);
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Exception e) {
            object = Result.constructor-impl(ResultKt.createFailure(e));
        }
        return object;
    }

    @Override
    public void onExpire(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
    }

    @Override
    @NotNull
    public List<String> getDisplayLore(@NotNull ItemConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        String[] stringArray = new String[]{"\u00a77\u5468\u56f2\u306e\u30cf\u30a4\u30c0\u30fc\u6570\u3068\u65b9\u5411\u3092\u8868\u793a", "\u00a77\u58c1\u8d8a\u3057\u3067\u3082\u691c\u51fa\u53ef\u80fd", "", "\u00a7b\u52b9\u679c: \u00a7f\u7bc4\u56f2\u5185\u306e\u30cf\u30a4\u30c0\u30fc\u6570\u3068\u65b9\u5411", "\u00a7b\u7bc4\u56f2: \u00a7f" + (int)config.getIntensity() + "\u30d6\u30ed\u30c3\u30af", "\u00a7b\u8868\u793a\u6642\u9593: \u00a7f" + config.getDuration() + "\u79d2", "", "\u00a77\u65b9\u5411\u306f8\u65b9\u4f4d\u3067\u8868\u793a\u3055\u308c\u307e\u3059"};
        return CollectionsKt.listOf(stringArray);
    }

    private final String getDirection(Location from, Location to) {
        double dx = to.getX() - from.getX();
        double dz = to.getZ() - from.getZ();
        double angle = Math.toDegrees(Math.atan2(dz, dx));
        double normalizedAngle = (angle + (double)360) % (double)360;
        return normalizedAngle < 22.5 || normalizedAngle >= 337.5 ? "\u6771" : (normalizedAngle < 67.5 ? "\u5357\u6771" : (normalizedAngle < 112.5 ? "\u5357" : (normalizedAngle < 157.5 ? "\u5357\u897f" : (normalizedAngle < 202.5 ? "\u897f" : (normalizedAngle < 247.5 ? "\u5317\u897f" : (normalizedAngle < 292.5 ? "\u5317" : "\u5317\u6771"))))));
    }

    private final void createScanParticles(Player player, double radius) {
        Location location = player.getLocation().clone().add(0.0, 0.5, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location center = location;
        for (int i = 0; i < 4; ++i) {
            long delay = i * 5;
            double currentRadius = radius * (double)(i + 1) / 4.0;
            BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
            Plugin plugin = player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
            Intrinsics.checkNotNull(plugin);
            bukkitScheduler.runTaskLater(plugin, () -> AreaScanHandler.createScanParticles$lambda$0(currentRadius, center, player), delay);
        }
    }

    private static final void createScanParticles$lambda$0(double $currentRadius, Location $center, Player $player) {
        int points = 32;
        for (int j = 0; j < points; ++j) {
            Location particleLocation;
            double angle = Math.PI * 2 * (double)j / (double)points;
            double x = $currentRadius * Math.cos(angle);
            double z = $currentRadius * Math.sin(angle);
            Intrinsics.checkNotNullExpressionValue($center.clone().add(x, 0.0, z), "add(...)");
            $player.getWorld().spawnParticle(Particle.ELECTRIC_SPARK, particleLocation, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

