/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.items;

import com.hideandseek.disguise.DisguiseData;
import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.effects.ActiveEffect;
import com.hideandseek.effects.EffectHandler;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/hideandseek/items/GlowDetectorHandler;", "Lcom/hideandseek/effects/EffectHandler;", "plugin", "Lorg/bukkit/plugin/Plugin;", "disguiseManager", "Lcom/hideandseek/disguise/DisguiseManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/disguise/DisguiseManager;)V", "glowTasks", "", "Ljava/util/UUID;", "", "apply", "", "player", "Lorg/bukkit/entity/Player;", "effect", "Lcom/hideandseek/effects/ActiveEffect;", "remove", "spawnGlowParticles", "maxDistance", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nGlowDetectorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlowDetectorHandler.kt\ncom/hideandseek/items/GlowDetectorHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1869#2,2:92\n*S KotlinDebug\n*F\n+ 1 GlowDetectorHandler.kt\ncom/hideandseek/items/GlowDetectorHandler\n*L\n70#1:92,2\n*E\n"})
public final class GlowDetectorHandler
implements EffectHandler {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final DisguiseManager disguiseManager;
    @NotNull
    private final Map<UUID, Integer> glowTasks;

    public GlowDetectorHandler(@NotNull Plugin plugin, @NotNull DisguiseManager disguiseManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(disguiseManager, "disguiseManager");
        this.plugin = plugin;
        this.disguiseManager = disguiseManager;
        this.glowTasks = new LinkedHashMap();
    }

    @Override
    public void apply(@NotNull Player player, @NotNull ActiveEffect effect) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(effect, "effect");
        int glowUpdateInterval = this.plugin.getConfig().getInt("effects.performance.glow-update-interval", 10);
        int glowMaxDistance = this.plugin.getConfig().getInt("effects.performance.glow-max-distance", 50);
        int glowTaskId = this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, () -> GlowDetectorHandler.apply$lambda$0(this, player, glowMaxDistance), 0L, (long)glowUpdateInterval).getTaskId();
        this.glowTasks.put(player.getUniqueId(), glowTaskId);
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.2f);
        player.spawnParticle(Particle.GLOW, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.5, 0.5, 0.5, 0.05);
        player.sendMessage("\u00a7e\u2728 \u507d\u88c5\u30d6\u30ed\u30c3\u30af\u691c\u51fa\u304c\u6709\u52b9\u306b\u306a\u308a\u307e\u3057\u305f\uff08" + effect.getTotalDuration() + "\u79d2\u9593\uff09");
    }

    @Override
    public void remove(@NotNull Player player, @NotNull ActiveEffect effect) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(effect, "effect");
        Integer glowTaskId = this.glowTasks.remove(player.getUniqueId());
        if (glowTaskId != null) {
            this.plugin.getServer().getScheduler().cancelTask(glowTaskId.intValue());
        }
        player.sendMessage("\u00a77\u507d\u88c5\u30d6\u30ed\u30c3\u30af\u691c\u51fa\u306e\u52b9\u679c\u304c\u5207\u308c\u307e\u3057\u305f");
    }

    private final void spawnGlowParticles(Player player, int maxDistance) {
        if (!player.isOnline()) {
            return;
        }
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location playerLoc = location;
        Map<UUID, DisguiseData> disguises = this.disguiseManager.getActiveDisguises();
        Iterable $this$forEach$iv = disguises.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Location centerLoc;
            DisguiseData disguiseData = (DisguiseData)element$iv;
            boolean bl = false;
            Location location2 = disguiseData.getBlockLocation();
            if (!Intrinsics.areEqual(location2.getWorld(), playerLoc.getWorld()) || !(location2.distance(playerLoc) <= (double)maxDistance)) continue;
            Intrinsics.checkNotNullExpressionValue(location2.clone().add(0.5, 0.5, 0.5), "add(...)");
            player.spawnParticle(Particle.END_ROD, centerLoc, 5, 0.3, 0.3, 0.3, 0.02);
        }
    }

    private static final void apply$lambda$0(GlowDetectorHandler this$0, Player $player, int $glowMaxDistance) {
        this$0.spawnGlowParticles($player, $glowMaxDistance);
    }
}

