/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.items;

import com.hideandseek.game.Game;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.items.ItemConfig;
import com.hideandseek.items.ItemEffectHandler;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Result;
import com.hideandseek.libs.kotlin.ResultKt;
import com.hideandseek.libs.kotlin.Unit;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J-\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/hideandseek/items/TrackerCompassHandler;", "Lcom/hideandseek/items/ItemEffectHandler;", "<init>", "()V", "canApply", "", "player", "Lorg/bukkit/entity/Player;", "game", "Lcom/hideandseek/game/Game;", "apply", "Lcom/hideandseek/libs/kotlin/Result;", "", "config", "Lcom/hideandseek/items/ItemConfig;", "apply-0E7RQCE", "(Lorg/bukkit/entity/Player;Lcom/hideandseek/game/Game;Lcom/hideandseek/items/ItemConfig;)Ljava/lang/Object;", "onExpire", "getDisplayLore", "", "", "findNearestHider", "seeker", "Companion", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nTrackerCompassHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackerCompassHandler.kt\ncom/hideandseek/items/TrackerCompassHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1788#2,4:178\n*S KotlinDebug\n*F\n+ 1 TrackerCompassHandler.kt\ncom/hideandseek/items/TrackerCompassHandler\n*L\n54#1:178,4\n*E\n"})
public final class TrackerCompassHandler
implements ItemEffectHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<UUID, Integer> activeCompasses = new ConcurrentHashMap();

    @Override
    public boolean canApply(@NotNull Player player, @NotNull Game game) {
        int hidersRemaining;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        PlayerGameData playerGameData = game.getPlayers().get(player.getUniqueId());
        if (playerGameData == null) {
            return false;
        }
        PlayerGameData playerData = playerGameData;
        if (!Intrinsics.areEqual(playerData.getRole().name(), "SEEKER")) {
            return false;
        }
        Iterable $this$count$iv = game.getPlayers().values();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            v1 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PlayerGameData it = (PlayerGameData)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getRole().name(), "HIDER") && !it.isCaptured()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = hidersRemaining = count$iv;
        }
        if (hidersRemaining == 0) {
            player.sendMessage("\u00a7c\u96a0\u308c\u3066\u3044\u308b\u30cf\u30a4\u30c0\u30fc\u304c\u3044\u307e\u305b\u3093");
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Object apply-0E7RQCE(@NotNull Player player, @NotNull Game game, @NotNull ItemConfig config) {
        Object object;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(config, "config");
        try {
            Plugin plugin = player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
            Intrinsics.checkNotNull(plugin);
            Plugin plugin2 = plugin;
            ItemStack compass = new ItemStack(Material.COMPASS);
            ItemMeta itemMeta = compass.getItemMeta();
            Intrinsics.checkNotNull(itemMeta);
            ItemMeta meta = itemMeta;
            meta.setDisplayName("\u00a76\u8ffd\u8de1\u30b3\u30f3\u30d1\u30b9");
            String[] stringArray = new String[]{"\u00a77\u6700\u3082\u8fd1\u3044\u30cf\u30a4\u30c0\u30fc\u3092\u6307\u3057\u307e\u3059", "\u00a77\u6b8b\u308a: \u00a7e" + config.getDuration() + "\u79d2"};
            meta.setLore(CollectionsKt.listOf(stringArray));
            compass.setItemMeta(meta);
            ItemStack[] itemStackArray = new ItemStack[]{compass};
            HashMap hashMap = player.getInventory().addItem(itemStackArray);
            Intrinsics.checkNotNullExpressionValue(hashMap, "addItem(...)");
            HashMap remaining = hashMap;
            if (!((Map)remaining).isEmpty()) {
                player.getWorld().dropItem(player.getLocation(), compass);
            }
            BukkitRunnable task2 = new BukkitRunnable(config, player, plugin2, this, game){
                private int secondsLeft;
                final /* synthetic */ Player $player;
                final /* synthetic */ Plugin $plugin;
                final /* synthetic */ TrackerCompassHandler this$0;
                final /* synthetic */ Game $game;
                {
                    this.$player = $player;
                    this.$plugin = $plugin;
                    this.this$0 = $receiver;
                    this.$game = $game;
                    this.secondsLeft = $config.getDuration();
                }

                public final int getSecondsLeft() {
                    return this.secondsLeft;
                }

                public final void setSecondsLeft(int n) {
                    this.secondsLeft = n;
                }

                public void run() {
                    if (this.secondsLeft <= 0 || !this.$player.isOnline()) {
                        UUID uUID = this.$player.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                        TrackerCompassHandler.Companion.stopTracking(uUID, this.$plugin);
                        this.cancel();
                        return;
                    }
                    Player nearestHider = TrackerCompassHandler.access$findNearestHider(this.this$0, this.$player, this.$game);
                    if (nearestHider != null) {
                        this.$player.setCompassTarget(nearestHider.getLocation());
                        double distance = this.$player.getLocation().distance(nearestHider.getLocation());
                        this.$player.sendActionBar("\u00a76\u30b3\u30f3\u30d1\u30b9: \u00a7f\u6700\u3082\u8fd1\u3044\u30cf\u30a4\u30c0\u30fc \u00a77(" + (int)distance + "m) \u00a7e\u6b8b\u308a" + this.secondsLeft + "\u79d2");
                    } else {
                        this.$player.sendActionBar("\u00a7c\u30cf\u30a4\u30c0\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093 \u00a7e\u6b8b\u308a" + this.secondsLeft + "\u79d2");
                    }
                    this.secondsLeft -= 2;
                }
            };
            int taskId = task2.runTaskTimer(plugin2, 0L, 40L).getTaskId();
            Map map = activeCompasses;
            UUID uUID = player.getUniqueId();
            Integer n = taskId;
            map.put(uUID, n);
            player.sendMessage("\u00a7a\u2726 \u8ffd\u8de1\u30b3\u30f3\u30d1\u30b9\u3092\u53d6\u5f97\u3057\u307e\u3057\u305f");
            player.sendMessage("\u00a77\u30b3\u30f3\u30d1\u30b9\u304c\u6700\u3082\u8fd1\u3044\u30cf\u30a4\u30c0\u30fc\u3092\u6307\u3057\u307e\u3059");
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_POWER_SELECT, 1.0f, 1.5f);
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Exception e) {
            object = Result.constructor-impl(ResultKt.createFailure(e));
        }
        return object;
    }

    @Override
    public void onExpire(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        Plugin plugin = player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
        Intrinsics.checkNotNull(plugin);
        Plugin plugin2 = plugin;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Companion.stopTracking(uUID, plugin2);
        player.setCompassTarget(player.getWorld().getSpawnLocation());
        player.sendMessage("\u00a77\u8ffd\u8de1\u30b3\u30f3\u30d1\u30b9\u306e\u52b9\u679c\u304c\u5207\u308c\u307e\u3057\u305f");
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.3f, 0.8f);
    }

    @Override
    @NotNull
    public List<String> getDisplayLore(@NotNull ItemConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        String[] stringArray = new String[]{"\u00a77\u6700\u3082\u8fd1\u3044\u30cf\u30a4\u30c0\u30fc\u306e\u65b9\u5411\u3092\u6307\u3059\u30b3\u30f3\u30d1\u30b9", "\u00a772\u79d2\u3054\u3068\u306b\u81ea\u52d5\u66f4\u65b0", "", "\u00a7b\u52b9\u679c: \u00a7f\u30b3\u30f3\u30d1\u30b9\u304c\u6700\u5bc4\u308a\u306e\u30cf\u30a4\u30c0\u30fc\u3092\u6307\u3059", "\u00a7b\u6301\u7d9a\u6642\u9593: \u00a7f" + config.getDuration() + "\u79d2", "\u00a7b\u66f4\u65b0\u9593\u9694: \u00a7f2\u79d2", "", "\u00a77\u30a2\u30af\u30b7\u30e7\u30f3\u30d0\u30fc\u306b\u8ddd\u96e2\u304c\u8868\u793a\u3055\u308c\u307e\u3059"};
        return CollectionsKt.listOf(stringArray);
    }

    private final Player findNearestHider(Player seeker, Game game) {
        Player nearestHider = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Map.Entry<UUID, PlayerGameData> entry : game.getPlayers().entrySet()) {
            Player hider;
            double distance;
            UUID playerId = entry.getKey();
            PlayerGameData playerData = entry.getValue();
            if (!Intrinsics.areEqual(playerData.getRole().name(), "HIDER") || playerData.isCaptured() || Bukkit.getPlayer((UUID)playerId) == null || !((distance = seeker.getLocation().distance(hider.getLocation())) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestHider = hider;
        }
        return nearestHider;
    }

    public static final /* synthetic */ Player access$findNearestHider(TrackerCompassHandler $this, Player seeker, Game game) {
        return $this.findNearestHider(seeker, game);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hideandseek/items/TrackerCompassHandler$Companion;", "", "<init>", "()V", "activeCompasses", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "", "stopTracking", "", "playerId", "plugin", "Lorg/bukkit/plugin/Plugin;", "stopAllTracking", "EasyHideAndSeek"})
    @SourceDebugExtension(value={"SMAP\nTrackerCompassHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackerCompassHandler.kt\ncom/hideandseek/items/TrackerCompassHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n1869#2,2:178\n*S KotlinDebug\n*F\n+ 1 TrackerCompassHandler.kt\ncom/hideandseek/items/TrackerCompassHandler$Companion\n*L\n38#1:178,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void stopTracking(@NotNull UUID playerId, @NotNull Plugin plugin) {
            block0: {
                Intrinsics.checkNotNullParameter(playerId, "playerId");
                Intrinsics.checkNotNullParameter(plugin, "plugin");
                Integer n = (Integer)activeCompasses.remove(playerId);
                if (n == null) break block0;
                int taskId = ((Number)n).intValue();
                boolean bl = false;
                Bukkit.getScheduler().cancelTask(taskId);
            }
        }

        public final void stopAllTracking(@NotNull Plugin plugin) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Collection collection = activeCompasses.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Integer taskId = (Integer)element$iv;
                boolean bl = false;
                BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
                Intrinsics.checkNotNull(taskId);
                bukkitScheduler.cancelTask(taskId.intValue());
            }
            activeCompasses.clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

