/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.effects.EffectManager;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.GamePhase;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hideandseek/listeners/EffectCleanupListener;", "Lorg/bukkit/event/Listener;", "effectManager", "Lcom/hideandseek/effects/EffectManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "logger", "Ljava/util/logging/Logger;", "<init>", "(Lcom/hideandseek/effects/EffectManager;Lcom/hideandseek/game/GameManager;Ljava/util/logging/Logger;)V", "onPlayerQuit", "", "event", "Lorg/bukkit/event/player/PlayerQuitEvent;", "EasyHideAndSeek"})
public final class EffectCleanupListener
implements Listener {
    @NotNull
    private final EffectManager effectManager;
    @NotNull
    private final GameManager gameManager;
    @NotNull
    private final Logger logger;

    public EffectCleanupListener(@NotNull EffectManager effectManager, @NotNull GameManager gameManager, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(effectManager, "effectManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.effectManager = effectManager;
        this.gameManager = gameManager;
        this.logger = logger;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        int minPlayers;
        int activePlayerCount;
        Game game;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        int removedCount = this.effectManager.removeAllEffects(uUID);
        if (removedCount > 0) {
            this.logger.fine("Removed " + removedCount + " effects from " + player2.getName() + " on quit");
        }
        if ((game = this.gameManager.getActiveGame()) != null && game.getPhase() == GamePhase.POST_GAME && (activePlayerCount = this.gameManager.getActivePlayerCount()) < (minPlayers = this.gameManager.getConfigManager().getMinPlayers())) {
            this.logger.info("Player count dropped below minimum during POST_GAME phase - timer will continue but game won't start");
        }
    }
}

