/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.shop.ShopManager;
import com.hideandseek.utils.MessageUtil;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/hideandseek/listeners/PlayerInteractListener;", "Lorg/bukkit/event/Listener;", "shopManager", "Lcom/hideandseek/shop/ShopManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lcom/hideandseek/shop/ShopManager;Lcom/hideandseek/game/GameManager;)V", "onPlayerInteract", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "EasyHideAndSeek"})
public final class PlayerInteractListener
implements Listener {
    @NotNull
    private final ShopManager shopManager;
    @NotNull
    private final GameManager gameManager;

    public PlayerInteractListener(@NotNull ShopManager shopManager, @NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(shopManager, "shopManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.shopManager = shopManager;
        this.gameManager = gameManager;
    }

    @EventHandler
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        if ((event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) && this.shopManager.isShopItem(item)) {
            event.setCancelled(true);
            Game game = this.gameManager.getActiveGame();
            if (game == null) {
                MessageUtil.INSTANCE.send((CommandSender)player2, "&cYou must be in a game to use the shop");
                return;
            }
            if (!game.getPlayers().containsKey(player2.getUniqueId())) {
                MessageUtil.INSTANCE.send((CommandSender)player2, "&cYou are not in this game");
                return;
            }
            PlayerGameData playerData = game.getPlayers().get(player2.getUniqueId());
            Object object = playerData;
            String playerRole = object != null && (object = ((PlayerGameData)object).getRole()) != null ? ((Enum)object).name() : null;
            this.shopManager.openMainMenu(player2, playerRole);
        }
    }
}

