/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.effects.EffectManager;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.WorldBorderBackup;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.spectator.SpectatorManager;
import com.hideandseek.utils.MessageUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/hideandseek/listeners/PlayerJoinListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "disguiseManager", "Lcom/hideandseek/disguise/DisguiseManager;", "effectManager", "Lcom/hideandseek/effects/EffectManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "spectatorManager", "Lcom/hideandseek/spectator/SpectatorManager;", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/disguise/DisguiseManager;Lcom/hideandseek/effects/EffectManager;Lcom/hideandseek/game/GameManager;Lcom/hideandseek/spectator/SpectatorManager;Lcom/hideandseek/i18n/MessageManager;)V", "cleanedWorlds", "", "", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "autoJoinGame", "player", "Lorg/bukkit/entity/Player;", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nPlayerJoinListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerJoinListener.kt\ncom/hideandseek/listeners/PlayerJoinListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1869#2,2:99\n*S KotlinDebug\n*F\n+ 1 PlayerJoinListener.kt\ncom/hideandseek/listeners/PlayerJoinListener\n*L\n51#1:99,2\n*E\n"})
public final class PlayerJoinListener
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final DisguiseManager disguiseManager;
    @NotNull
    private final EffectManager effectManager;
    @NotNull
    private final GameManager gameManager;
    @Nullable
    private final SpectatorManager spectatorManager;
    @Nullable
    private final MessageManager messageManager;
    @NotNull
    private final Set<String> cleanedWorlds;

    public PlayerJoinListener(@NotNull Plugin plugin, @NotNull DisguiseManager disguiseManager, @NotNull EffectManager effectManager, @NotNull GameManager gameManager, @Nullable SpectatorManager spectatorManager, @Nullable MessageManager messageManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(disguiseManager, "disguiseManager");
        Intrinsics.checkNotNullParameter(effectManager, "effectManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.plugin = plugin;
        this.disguiseManager = disguiseManager;
        this.effectManager = effectManager;
        this.gameManager = gameManager;
        this.spectatorManager = spectatorManager;
        this.messageManager = messageManager;
        this.cleanedWorlds = new LinkedHashSet();
    }

    public /* synthetic */ PlayerJoinListener(Plugin plugin, DisguiseManager disguiseManager, EffectManager effectManager, GameManager gameManager, SpectatorManager spectatorManager, MessageManager messageManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            spectatorManager = null;
        }
        if ((n & 0x20) != 0) {
            messageManager = null;
        }
        this(plugin, disguiseManager, effectManager, gameManager, spectatorManager, messageManager);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        String string = player2.getWorld().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String worldName = string;
        if (!this.cleanedWorlds.contains(worldName)) {
            World world = player2.getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            WorldBorderBackup defaultBorder = WorldBorderBackup.Companion.defaultBackup(world);
            World world2 = player2.getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
            defaultBorder.restore(world2);
            this.cleanedWorlds.add(worldName);
        }
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        if (this.disguiseManager.isDisguised(uUID)) {
            this.disguiseManager.undisguise(player2, "server_restart_cleanup");
        }
        UUID uUID2 = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        this.effectManager.removeAllEffects(uUID2);
        Collection collection = player2.getActivePotionEffects();
        Intrinsics.checkNotNullExpressionValue(collection, "getActivePotionEffects(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PotionEffect effect = (PotionEffect)element$iv;
            boolean bl = false;
            player2.removePotionEffect(effect.getType());
        }
        player2.setSendViewDistance(10);
        if (player2.getGameMode() != GameMode.SURVIVAL && !player2.hasPermission("hideandseek.admin")) {
            player2.setGameMode(GameMode.SURVIVAL);
        }
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> PlayerJoinListener.onPlayerJoin$lambda$1(this, player2), 20L);
    }

    private final void autoJoinGame(Player player) {
        if (this.gameManager.isInGame(player)) {
            return;
        }
        if (this.messageManager != null) {
            this.messageManager.send(player, "player.welcome", new Object[0]);
        } else {
            player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&e&lHide and Seek"), (Component)MessageUtil.INSTANCE.colorize("&7\u3088\u3046\u3053\u305d\uff01"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(2000L), (Duration)Duration.ofMillis(500L))));
        }
        this.gameManager.joinGame(player);
    }

    private static final void onPlayerJoin$lambda$1(PlayerJoinListener this$0, Player $player) {
        this$0.autoJoinGame($player);
    }
}

