/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.points.PointManager;
import com.hideandseek.utils.MessageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/hideandseek/listeners/TauntListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "gameManager", "Lcom/hideandseek/game/GameManager;", "pointManager", "Lcom/hideandseek/points/PointManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/game/GameManager;Lcom/hideandseek/points/PointManager;)V", "onProjectileLaunch", "", "event", "Lorg/bukkit/event/entity/ProjectileLaunchEvent;", "onProjectileHit", "Lorg/bukkit/event/entity/ProjectileHitEvent;", "onPlayerInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "calculateFireworkBonus", "", "player", "Lorg/bukkit/entity/Player;", "game", "Lcom/hideandseek/game/Game;", "spawnTauntFirework", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nTauntListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TauntListener.kt\ncom/hideandseek/listeners/TauntListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1617#2,9:265\n1869#2:274\n1870#2:276\n1626#2:277\n1#3:275\n*S KotlinDebug\n*F\n+ 1 TauntListener.kt\ncom/hideandseek/listeners/TauntListener\n*L\n197#1:265,9\n197#1:274\n197#1:276\n197#1:277\n197#1:275\n*E\n"})
public final class TauntListener
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final GameManager gameManager;
    @NotNull
    private final PointManager pointManager;

    public TauntListener(@NotNull Plugin plugin, @NotNull GameManager gameManager, @NotNull PointManager pointManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        Intrinsics.checkNotNullParameter(pointManager, "pointManager");
        this.plugin = plugin;
        this.gameManager = gameManager;
        this.pointManager = pointManager;
    }

    @EventHandler
    public final void onProjectileLaunch(@NotNull ProjectileLaunchEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ProjectileSource projectileSource = event.getEntity().getShooter();
        Player player = projectileSource instanceof Player ? (Player)projectileSource : null;
        if (player == null) {
            return;
        }
        Player shooter = player;
        if (event.getEntityType() != EntityType.SNOWBALL) {
            return;
        }
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        PlayerGameData playerGameData = game2.getPlayers().get(shooter.getUniqueId());
        if (playerGameData == null) {
            return;
        }
        PlayerGameData playerData = playerGameData;
        if (playerData.getRole() != PlayerRole.HIDER) {
            return;
        }
        if (playerData.isCaptured()) {
            return;
        }
        int bonusPoints = this.plugin.getConfig().getInt("points.taunt-bonuses.snowball", 50);
        UUID uUID = shooter.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.pointManager.awardTauntBonus(uUID, bonusPoints);
        MessageUtil.INSTANCE.send((CommandSender)shooter, "&e+" + bonusPoints + " \u30dd\u30a4\u30f3\u30c8 &7(\u96ea\u7389\u6311\u767a)");
        shooter.sendMessage("\u00a7c\u8b66\u544a: \u30b7\u30fc\u30ab\u30fc\u306b\u4f4d\u7f6e\u304c\u30d0\u30ec\u3084\u3059\u304f\u306a\u308a\u307e\u3057\u305f\uff01");
    }

    @EventHandler
    public final void onProjectileHit(@NotNull ProjectileHitEvent event) {
        Player shooter;
        Player hitPlayer;
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntityType() != EntityType.SNOWBALL) {
            return;
        }
        this.plugin.getLogger().info("[Taunt] Snowball hit detected");
        Entity entity = event.getHitEntity();
        Player player = hitPlayer = entity instanceof Player ? (Player)entity : null;
        if (hitPlayer == null) {
            Entity entity2 = event.getHitEntity();
            this.plugin.getLogger().info("[Taunt] Hit entity is not a player: " + (EntityType)(entity2 != null ? entity2.getType() : null));
            return;
        }
        ProjectileSource projectileSource = event.getEntity().getShooter();
        Player player2 = shooter = projectileSource instanceof Player ? (Player)projectileSource : null;
        if (shooter == null) {
            this.plugin.getLogger().info("[Taunt] Shooter is not a player");
            return;
        }
        this.plugin.getLogger().info("[Taunt] " + shooter.getName() + " hit " + hitPlayer.getName() + " with snowball");
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            this.plugin.getLogger().info("[Taunt] No active game");
            return;
        }
        PlayerGameData shooterData = game.getPlayers().get(shooter.getUniqueId());
        if (shooterData == null) {
            this.plugin.getLogger().info("[Taunt] Shooter " + shooter.getName() + " not in game");
            return;
        }
        PlayerGameData hitData = game.getPlayers().get(hitPlayer.getUniqueId());
        if (hitData == null) {
            this.plugin.getLogger().info("[Taunt] Hit player " + hitPlayer.getName() + " not in game");
            return;
        }
        this.plugin.getLogger().info("[Taunt] Shooter role: " + shooterData.getRole() + ", isCaptured: " + shooterData.isCaptured());
        this.plugin.getLogger().info("[Taunt] Hit player role: " + hitData.getRole());
        if (shooterData.getRole() != PlayerRole.HIDER || shooterData.isCaptured()) {
            this.plugin.getLogger().info("[Taunt] Shooter is not an active hider");
            return;
        }
        if (hitData.getRole() != PlayerRole.SEEKER) {
            this.plugin.getLogger().info("[Taunt] Hit player is not a seeker");
            return;
        }
        int bonusPoints = this.plugin.getConfig().getInt("points.taunt-bonuses.snowball", 50);
        UUID uUID = shooter.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.pointManager.awardTauntBonus(uUID, bonusPoints);
        MessageUtil.INSTANCE.send((CommandSender)shooter, "&a&l\u96ea\u7389\u304c\u9b3c\u306b\u547d\u4e2d\uff01 &e+" + bonusPoints + " \u30dc\u30fc\u30ca\u30b9\u30dd\u30a4\u30f3\u30c8\uff01");
        MessageUtil.INSTANCE.send((CommandSender)hitPlayer, "&c" + shooter.getName() + " &7\u306e\u96ea\u7389\u304c\u547d\u4e2d\u3057\u307e\u3057\u305f\uff01");
        hitPlayer.playSound(hitPlayer.getLocation(), Sound.ENTITY_PLAYER_HURT, 1.0f, 1.0f);
        shooter.playSound(shooter.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.5f);
        hitPlayer.getWorld().spawnParticle(Particle.CLOUD, hitPlayer.getLocation().add(0.0, 1.0, 0.0), 20, 0.5, 0.5, 0.5, 0.1);
        this.plugin.getLogger().info("[Taunt] " + shooter.getName() + " hit seeker " + hitPlayer.getName() + " with snowball, awarded " + bonusPoints + " bonus points");
    }

    @EventHandler
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        if (item.getType() != Material.FIREWORK_ROCKET) {
            return;
        }
        this.plugin.getLogger().info("[Taunt] Firework usage detected by " + player2.getName());
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            this.plugin.getLogger().info("[Taunt] No active game");
            return;
        }
        PlayerGameData playerData = game.getPlayers().get(player2.getUniqueId());
        if (playerData == null) {
            this.plugin.getLogger().info("[Taunt] Player " + player2.getName() + " not in game");
            return;
        }
        this.plugin.getLogger().info("[Taunt] Player role: " + playerData.getRole() + ", isCaptured: " + playerData.isCaptured());
        if (playerData.getRole() != PlayerRole.HIDER) {
            this.plugin.getLogger().info("[Taunt] Player is not a hider");
            return;
        }
        if (playerData.isCaptured()) {
            this.plugin.getLogger().info("[Taunt] Player is captured");
            return;
        }
        int bonusPoints = this.calculateFireworkBonus(player2, game);
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.pointManager.awardTauntBonus(uUID, bonusPoints);
        MessageUtil.INSTANCE.send((CommandSender)player2, "&e+" + bonusPoints + " \u30dd\u30a4\u30f3\u30c8 &7(\u82b1\u706b\u6311\u767a)");
        player2.sendMessage("\u00a7c\u8b66\u544a: \u30b7\u30fc\u30ab\u30fc\u306b\u4f4d\u7f6e\u304c\u975e\u5e38\u306b\u30d0\u30ec\u3084\u3059\u304f\u306a\u308a\u307e\u3057\u305f\uff01");
        player2.playSound(player2.getLocation(), Sound.ENTITY_FIREWORK_ROCKET_LAUNCH, 1.0f, 1.0f);
        this.spawnTauntFirework(player2);
        this.plugin.getLogger().info("[Taunt] " + player2.getName() + " used firework, awarded " + bonusPoints + " points");
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateFireworkBonus(Player player, Game game) {
        void $this$mapNotNullTo$iv$iv;
        int basePoints;
        int totalBonus = basePoints = this.plugin.getConfig().getInt("points.taunt-bonuses.firework", 100);
        Iterable $this$mapNotNull$iv = game.getSeekers();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (Bukkit.getPlayer((UUID)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List seekers = (List)destination$iv$iv;
        this.plugin.getLogger().info("[Taunt] Calculating firework bonus - " + seekers.size() + " seekers in game");
        int closeCount = 0;
        int mediumCount = 0;
        int farCount = 0;
        for (Player seeker : seekers) {
            if (!Intrinsics.areEqual(seeker.getWorld(), player.getWorld())) {
                this.plugin.getLogger().info("[Taunt] Seeker " + seeker.getName() + " in different world");
                continue;
            }
            double distance = seeker.getLocation().distance(player.getLocation());
            this.plugin.getLogger().info("[Taunt] Seeker " + seeker.getName() + " distance: " + (int)distance + "m");
            if (distance <= 10.0) {
                totalBonus += 100;
                ++closeCount;
                continue;
            }
            if (distance <= 20.0) {
                totalBonus += 50;
                ++mediumCount;
                continue;
            }
            if (!(distance <= 30.0)) continue;
            totalBonus += 25;
            ++farCount;
        }
        this.plugin.getLogger().info("[Taunt] Firework bonus: base=" + basePoints + ", close=" + closeCount + ", medium=" + mediumCount + ", far=" + farCount + ", total=" + totalBonus);
        if (closeCount > 0 || mediumCount > 0 || farCount > 0) {
            List breakdown = new ArrayList();
            if (closeCount > 0) {
                breakdown.add("&c\u6975\u8fd1 x" + closeCount + " (+" + closeCount * 100 + ")");
            }
            if (mediumCount > 0) {
                breakdown.add("&e\u8fd1 x" + mediumCount + " (+" + mediumCount * 50 + ")");
            }
            if (farCount > 0) {
                breakdown.add("&7\u4e2d x" + farCount + " (+" + farCount * 25 + ")");
            }
            MessageUtil.INSTANCE.send((CommandSender)player, "&7\u8ddd\u96e2\u30dc\u30fc\u30ca\u30b9: " + CollectionsKt.joinToString$default(breakdown, " ", null, null, 0, null, null, 62, null));
        } else {
            MessageUtil.INSTANCE.send((CommandSender)player, "&7\u4ed8\u8fd1\u306b\u9b3c\u306a\u3057\uff08\u57fa\u672c\u30dd\u30a4\u30f3\u30c8\u306e\u307f\uff09");
        }
        return totalBonus;
    }

    private final void spawnTauntFirework(Player player) {
        Location location = player.getLocation().clone().add(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location location2 = location;
        Entity entity = player.getWorld().spawnEntity(location2, EntityType.FIREWORK_ROCKET);
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Firework");
        Firework firework = (Firework)entity;
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        Intrinsics.checkNotNullExpressionValue(fireworkMeta, "getFireworkMeta(...)");
        FireworkMeta meta = fireworkMeta;
        Color[] colorArray = new Color[]{Color.RED, Color.YELLOW, Color.LIME, Color.AQUA, Color.FUCHSIA};
        FireworkEffect fireworkEffect = FireworkEffect.builder().withColor(colorArray).with(FireworkEffect.Type.BALL_LARGE).withTrail().withFlicker().build();
        Intrinsics.checkNotNullExpressionValue(fireworkEffect, "build(...)");
        FireworkEffect effect = fireworkEffect;
        meta.addEffect(effect);
        meta.setPower(1);
        firework.setFireworkMeta(meta);
    }
}

