/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.points;

import com.hideandseek.game.Game;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.comparisons.ComparisonsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\tJ\u0016\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\u000fJ \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u000fJ\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\tJ.\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u0017J\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0$0#J(\u0010%\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0$0#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'J(\u0010(\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0$0#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/hideandseek/points/PointManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "playerPoints", "", "Ljava/util/UUID;", "", "pointAccumulationTaskId", "Ljava/lang/Integer;", "getPoints", "playerId", "addPoints", "", "points", "setPoints", "resetAll", "startPointAccumulation", "game", "Lcom/hideandseek/game/Game;", "pointsPerSecond", "", "updateInterval", "", "stopPointAccumulation", "awardTauntBonus", "bonusPoints", "handleCapture", "seekerId", "hiderId", "basePoints", "stealPercentage", "getRankedPlayers", "", "Lcom/hideandseek/libs/kotlin/Pair;", "getRankedPlayersByRole", "role", "Lcom/hideandseek/game/PlayerRole;", "getRankedPlayersByRolePoints", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nPointManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PointManager.kt\ncom/hideandseek/points/PointManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,173:1\n1068#2:174\n1563#2:175\n1634#2,3:176\n774#2:179\n865#2,2:180\n1068#2:182\n1563#2:183\n1634#2,3:184\n1617#2,9:187\n1869#2:196\n1870#2:198\n1626#2:199\n1068#2:200\n774#2:201\n865#2,2:202\n1869#2,2:204\n1#3:197\n*S KotlinDebug\n*F\n+ 1 PointManager.kt\ncom/hideandseek/points/PointManager\n*L\n132#1:174\n133#1:175\n133#1:176,3\n141#1:179\n141#1:180,2\n142#1:182\n143#1:183\n143#1:184,3\n153#1:187,9\n153#1:196\n153#1:198\n153#1:199\n170#1:200\n65#1:201\n65#1:202,2\n69#1:204,2\n153#1:197\n*E\n"})
public final class PointManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Map<UUID, Integer> playerPoints;
    @Nullable
    private Integer pointAccumulationTaskId;

    public PointManager(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.playerPoints = new LinkedHashMap();
    }

    public final int getPoints(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Integer n = this.playerPoints.get(playerId);
        return n != null ? n : 0;
    }

    public final void addPoints(@NotNull UUID playerId, int points) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Integer n = this.playerPoints.get(playerId);
        int current = n != null ? n : 0;
        this.playerPoints.put(playerId, current + points);
    }

    public final void setPoints(@NotNull UUID playerId, int points) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        this.playerPoints.put(playerId, points);
    }

    public final void resetAll() {
        this.playerPoints.clear();
    }

    public final void startPointAccumulation(@NotNull Game game, double pointsPerSecond, long updateInterval) {
        Intrinsics.checkNotNullParameter(game, "game");
        this.stopPointAccumulation();
        this.pointAccumulationTaskId = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> PointManager.startPointAccumulation$lambda$0(updateInterval, pointsPerSecond, game, this), updateInterval, updateInterval).getTaskId();
    }

    public static /* synthetic */ void startPointAccumulation$default(PointManager pointManager, Game game, double d, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = 300L;
        }
        pointManager.startPointAccumulation(game, d, l);
    }

    public final void stopPointAccumulation() {
        block0: {
            Integer n = this.pointAccumulationTaskId;
            if (n == null) break block0;
            int taskId = ((Number)n).intValue();
            boolean bl = false;
            Bukkit.getScheduler().cancelTask(taskId);
            this.pointAccumulationTaskId = null;
        }
    }

    public final void awardTauntBonus(@NotNull UUID playerId, int bonusPoints) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        this.addPoints(playerId, bonusPoints);
    }

    public final int handleCapture(@NotNull Game game, @NotNull UUID seekerId, @NotNull UUID hiderId, int basePoints, double stealPercentage) {
        int totalPoints;
        block1: {
            Intrinsics.checkNotNullParameter(game, "game");
            Intrinsics.checkNotNullParameter(seekerId, "seekerId");
            Intrinsics.checkNotNullParameter(hiderId, "hiderId");
            int hiderPoints = this.getPoints(hiderId);
            int pointsStolen = (int)((double)hiderPoints * stealPercentage);
            totalPoints = basePoints + pointsStolen;
            this.addPoints(seekerId, totalPoints);
            this.setPoints(hiderId, hiderPoints - pointsStolen);
            PlayerGameData playerGameData = game.getPlayers().get(seekerId);
            if (playerGameData == null) break block1;
            PlayerGameData seekerData = playerGameData;
            boolean bl = false;
            seekerData.setSeekerPoints(seekerData.getSeekerPoints() + totalPoints);
            Player seekerPlayer = Bukkit.getPlayer((UUID)seekerId);
            Logger logger = this.plugin.getLogger();
            Object object = seekerPlayer;
            if (object == null || (object = object.getName()) == null) {
                object = seekerId;
            }
            logger.info("[PointCapture] " + object + " captured: +" + totalPoints + " (base: " + basePoints + ", stolen: " + pointsStolen + ", seekerPoints: " + seekerData.getSeekerPoints() + ")");
        }
        return totalPoints;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<UUID, Integer>> getRankedPlayers() {
        void $this$mapTo$iv$iv;
        Iterable $this$sortedByDescending$iv = this.playerPoints.entrySet();
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<UUID, Integer>> getRankedPlayersByRole(@NotNull Game game, @NotNull PlayerRole role) {
        void $this$mapTo$iv$iv;
        Map.Entry entry;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter((Object)role, "role");
        Iterable $this$filter$iv = this.playerPoints.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            UUID uuid = (UUID)entry.getKey();
            PlayerGameData playerGameData = game.getPlayers().get(uuid);
            if (!((playerGameData != null ? playerGameData.getRole() : null) == role)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
            }
        });
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getKey(), it.getValue()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<UUID, Integer>> getRankedPlayersByRolePoints(@NotNull Game game, @NotNull PlayerRole role) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter((Object)role, "role");
        Iterable $this$mapNotNull$iv = game.getPlayers().values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<UUID, Integer> pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            PlayerGameData playerData = (PlayerGameData)element$iv$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[role.ordinal()]) {
                case 1: {
                    if (playerData.getOriginalRole() == PlayerRole.HIDER || playerData.getHiderPoints() > 0) {
                        pair = TuplesKt.to(playerData.getUuid(), playerData.getHiderPoints());
                        break;
                    }
                    pair = null;
                    break;
                }
                case 2: {
                    if (playerData.getOriginalRole() == PlayerRole.SEEKER || playerData.getSeekerPoints() > 0) {
                        pair = TuplesKt.to(playerData.getUuid(), playerData.getSeekerPoints());
                        break;
                    }
                    pair = null;
                    break;
                }
                default: {
                    pair = null;
                }
            }
            if (pair == null) continue;
            Pair<UUID, Integer> it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getSecond()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void startPointAccumulation$lambda$0(long $updateInterval, double $pointsPerSecond, Game $game, PointManager this$0) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        double secondsElapsed = (double)$updateInterval / 20.0;
        int pointsToAdd = (int)($pointsPerSecond * secondsElapsed);
        Iterable iterable = $game.getPlayers().values();
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PlayerGameData it = (PlayerGameData)element$iv$iv;
            boolean bl = false;
            if (!(it.getRole() == PlayerRole.HIDER && !it.isCaptured())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List alivehiders = (List)destination$iv$iv;
        this$0.plugin.getLogger().info("[PointAccumulation] Awarding " + pointsToAdd + " points to " + alivehiders.size() + " alive hiders");
        Iterable $this$forEach$iv = alivehiders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayerGameData playerData = (PlayerGameData)element$iv;
            boolean bl = false;
            Player player = Bukkit.getPlayer((UUID)playerData.getUuid());
            if (player == null || !player.isOnline()) continue;
            this$0.addPoints(playerData.getUuid(), pointsToAdd);
            playerData.setHiderPoints(playerData.getHiderPoints() + pointsToAdd);
            this$0.plugin.getLogger().info("[PointAccumulation] " + player.getName() + ": +" + pointsToAdd + " (total: " + this$0.getPoints(playerData.getUuid()) + ", hiderPoints: " + playerData.getHiderPoints() + ")");
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlayerRole.values().length];
            try {
                nArray[PlayerRole.HIDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.SEEKER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

