/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.respawn;

import com.hideandseek.arena.ArenaBoundaries;
import com.hideandseek.config.BlockRestorationConfig;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.SetsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.random.Random;
import com.hideandseek.libs.kotlin.text.StringsKt;
import com.hideandseek.respawn.RespawnFailureReason;
import com.hideandseek.respawn.RespawnResult;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ>\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u00142\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fJ\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/hideandseek/respawn/RespawnManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "config", "Lcom/hideandseek/config/BlockRestorationConfig;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/config/BlockRestorationConfig;Lcom/hideandseek/game/GameManager;)V", "respawnPlayer", "Lcom/hideandseek/respawn/RespawnResult;", "player", "Lorg/bukkit/entity/Player;", "findSafeRandomLocation", "Lorg/bukkit/Location;", "world", "Lorg/bukkit/World;", "center", "radius", "", "excludeLocations", "", "boundaries", "Lcom/hideandseek/arena/ArenaBoundaries;", "isSafeLocation", "", "location", "isUnstableBlock", "material", "Lorg/bukkit/Material;", "isDangerousBlock", "isPassableBlock", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nRespawnManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RespawnManager.kt\ncom/hideandseek/respawn/RespawnManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n1761#2,3:232\n*S KotlinDebug\n*F\n+ 1 RespawnManager.kt\ncom/hideandseek/respawn/RespawnManager\n*L\n122#1:232,3\n*E\n"})
public final class RespawnManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final BlockRestorationConfig config;
    @NotNull
    private final GameManager gameManager;

    public RespawnManager(@NotNull Plugin plugin, @NotNull BlockRestorationConfig config, @NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.plugin = plugin;
        this.config = config;
        this.gameManager = gameManager;
    }

    @NotNull
    public final RespawnResult respawnPlayer(@NotNull Player player) {
        int n;
        Intrinsics.checkNotNullParameter(player, "player");
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return new RespawnResult.Failure(RespawnFailureReason.PLAYER_NOT_IN_GAME);
        }
        Game game2 = game;
        PlayerGameData playerGameData = game2.getPlayers().get(player.getUniqueId());
        if (playerGameData == null) {
            return new RespawnResult.Failure(RespawnFailureReason.PLAYER_NOT_IN_GAME);
        }
        PlayerGameData playerData = playerGameData;
        ArenaBoundaries boundaries = game2.getArena().getBoundaries();
        Location centerLocation = new Location(game2.getArena().getWorld(), boundaries.getCenter().getX(), 64.0, boundaries.getCenter().getZ());
        World world = game2.getArena().getWorld();
        if (this.config.getUseGameBoundaries()) {
            int radiusX = (int)(boundaries.getWidth() / (double)2);
            int radiusZ = (int)(boundaries.getDepth() / (double)2);
            n = Math.min(radiusX, radiusZ);
        } else {
            n = this.config.getRespawnSearchRadius();
        }
        Location location = RespawnManager.findSafeRandomLocation$default(this, world, centerLocation, n, null, this.config.getUseGameBoundaries() ? boundaries : null, 8, null);
        if (location == null) {
            return new RespawnResult.Failure(RespawnFailureReason.NO_SAFE_LOCATION_FOUND);
        }
        Location location2 = location;
        boolean success = player.teleport(location2);
        if (!success) {
            return new RespawnResult.Failure(RespawnFailureReason.TELEPORT_FAILED);
        }
        if (this.config.getDebugLogging()) {
            this.plugin.getLogger().info("Respawned " + player.getName() + " at " + location2.getBlockX() + ", " + location2.getBlockY() + ", " + location2.getBlockZ());
        }
        return new RespawnResult.Success(location2);
    }

    @Nullable
    public final Location findSafeRandomLocation(@NotNull World world, @NotNull Location center, int radius, @NotNull Set<? extends Location> excludeLocations, @Nullable ArenaBoundaries boundaries) {
        Intrinsics.checkNotNullParameter(world, "world");
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(excludeLocations, "excludeLocations");
        int maxAttempts = this.config.getMaxRespawnAttempts();
        int attempts = 0;
        while (attempts < maxAttempts) {
            boolean bl;
            Location location;
            int y;
            int z;
            int x;
            block6: {
                ++attempts;
                int offsetX = Random.Default.nextInt(-radius, radius + 1);
                int offsetZ = Random.Default.nextInt(-radius, radius + 1);
                x = center.getBlockX() + offsetX;
                z = center.getBlockZ() + offsetZ;
                y = world.getHighestBlockYAt(x, z);
                location = new Location(world, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5);
                if (boundaries != null && !boundaries.contains(location)) {
                    if (!this.config.getDebugLogging()) continue;
                    this.plugin.getLogger().fine("Skipping location (" + x + ", " + z + ") - outside arena boundaries");
                    continue;
                }
                Iterable $this$any$iv = excludeLocations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Location it = (Location)element$iv;
                        boolean bl2 = false;
                        if (!(it.distanceSquared(location) < 4.0)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl || !this.isSafeLocation(location)) continue;
            if (this.config.getDebugLogging()) {
                this.plugin.getLogger().info("[Respawn] Found safe location at (" + x + ", " + y + ", " + z + ") within boundaries");
            }
            return location;
        }
        this.plugin.getLogger().warning("[Respawn] Failed to find safe location after " + maxAttempts + " attempts");
        return null;
    }

    public static /* synthetic */ Location findSafeRandomLocation$default(RespawnManager respawnManager, World world, Location location, int n, Set set, ArenaBoundaries arenaBoundaries, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 50;
        }
        if ((n2 & 8) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n2 & 0x10) != 0) {
            arenaBoundaries = null;
        }
        return respawnManager.findSafeRandomLocation(world, location, n, set, arenaBoundaries);
    }

    public final boolean isSafeLocation(@NotNull Location location) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(location, "location");
                World world = location.getWorld();
                if (world == null) {
                    return false;
                }
                World world2 = world;
                if (location.getBlockY() < world2.getMinHeight() + 1) {
                    return false;
                }
                Block block = world2.getBlockAt(location.getBlockX(), location.getBlockY() - 1, location.getBlockZ());
                Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
                Block groundBlock = block;
                Block block2 = world2.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
                Intrinsics.checkNotNullExpressionValue(block2, "getBlockAt(...)");
                Block feetBlock = block2;
                Block block3 = world2.getBlockAt(location.getBlockX(), location.getBlockY() + 1, location.getBlockZ());
                Intrinsics.checkNotNullExpressionValue(block3, "getBlockAt(...)");
                Block headBlock = block3;
                if (!groundBlock.getType().isSolid()) {
                    return false;
                }
                Material material = groundBlock.getType();
                Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
                if (this.isDangerousBlock(material)) {
                    return false;
                }
                Material material2 = groundBlock.getType();
                Intrinsics.checkNotNullExpressionValue(material2, "getType(...)");
                if (this.isUnstableBlock(material2)) {
                    return false;
                }
                Material material3 = feetBlock.getType();
                Intrinsics.checkNotNullExpressionValue(material3, "getType(...)");
                if (!this.isPassableBlock(material3)) break block8;
                Material material4 = headBlock.getType();
                Intrinsics.checkNotNullExpressionValue(material4, "getType(...)");
                if (this.isPassableBlock(material4)) break block9;
            }
            return false;
        }
        return true;
    }

    private final boolean isUnstableBlock(Material material) {
        return StringsKt.contains$default((CharSequence)material.name(), "LEAVES", false, 2, null) ? true : (StringsKt.contains$default((CharSequence)material.name(), "GLASS_PANE", false, 2, null) ? true : (StringsKt.contains$default((CharSequence)material.name(), "IRON_BARS", false, 2, null) ? true : (material == Material.SCAFFOLDING ? true : (material == Material.SNOW ? true : material == Material.POWDER_SNOW))));
    }

    private final boolean isDangerousBlock(Material material) {
        return switch (WhenMappings.$EnumSwitchMapping$0[material.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7 -> true;
            default -> false;
        };
    }

    private final boolean isPassableBlock(Material material) {
        return switch (WhenMappings.$EnumSwitchMapping$0[material.ordinal()]) {
            case 8, 9, 10 -> true;
            default -> false;
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Material.values().length];
            try {
                nArray[Material.LAVA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.MAGMA_BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.FIRE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CAMPFIRE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.SOUL_CAMPFIRE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CACTUS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.SWEET_BERRY_BUSH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.AIR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CAVE_AIR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.VOID_AIR.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

