/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.shop;

import com.hideandseek.config.ConfigManager;
import com.hideandseek.config.ShopConfig;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.comparisons.ComparisonsKt;
import com.hideandseek.libs.kotlin.jvm.functions.Function1;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.shop.CamouflageTier;
import com.hideandseek.shop.ShopCategory;
import com.hideandseek.shop.ShopItem;
import com.hideandseek.shop.UsageRestriction;
import com.hideandseek.utils.ItemBuilder;
import com.hideandseek.utils.MessageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018J\u001a\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 J\"\u0010!\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020 2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 J&\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\"\u001a\u00020 H\u0002J\u0010\u0010)\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020 J\u0018\u0010*\u001a\u0004\u0018\u00010(2\u0006\u0010\"\u001a\u00020 2\u0006\u0010+\u001a\u00020 J\u0010\u0010,\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\u0018J\u0010\u0010-\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\u0018J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020 0'2\u0006\u0010\u001b\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Lcom/hideandseek/shop/ShopManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "configManager", "Lcom/hideandseek/config/ConfigManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/config/ConfigManager;)V", "categories", "", "Lcom/hideandseek/shop/ShopCategory;", "shopItemKey", "Lorg/bukkit/NamespacedKey;", "categoryKey", "itemIdKey", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "getMessageManager", "()Lcom/hideandseek/i18n/MessageManager;", "setMessageManager", "(Lcom/hideandseek/i18n/MessageManager;)V", "loadCategories", "", "createShopItem", "Lorg/bukkit/inventory/ItemStack;", "isShopItem", "", "item", "openMainMenu", "player", "Lorg/bukkit/entity/Player;", "playerRole", "", "openCategory", "categoryId", "buildDisguiseBlocksGUI", "inventory", "Lorg/bukkit/inventory/Inventory;", "items", "", "Lcom/hideandseek/shop/ShopItem;", "getCategory", "getShopItem", "itemId", "getCategoryFromItem", "getItemIdFromItem", "buildRestrictionLore", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nShopManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShopManager.kt\ncom/hideandseek/shop/ShopManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,363:1\n1#2:364\n1869#3,2:365\n774#3:367\n865#3,2:368\n1869#3,2:370\n1056#3:372\n1491#3:373\n1516#3,3:374\n1519#3,3:384\n382#4,7:377\n*S KotlinDebug\n*F\n+ 1 ShopManager.kt\ncom/hideandseek/shop/ShopManager\n*L\n90#1:365,2\n105#1:367\n105#1:368,2\n111#1:370,2\n171#1:372\n234#1:373\n234#1:374,3\n234#1:384,3\n234#1:377,7\n*E\n"})
public final class ShopManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final ConfigManager configManager;
    @NotNull
    private final List<ShopCategory> categories;
    @NotNull
    private final NamespacedKey shopItemKey;
    @NotNull
    private final NamespacedKey categoryKey;
    @NotNull
    private final NamespacedKey itemIdKey;
    @Nullable
    private MessageManager messageManager;

    public ShopManager(@NotNull Plugin plugin, @NotNull ConfigManager configManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(configManager, "configManager");
        this.plugin = plugin;
        this.configManager = configManager;
        this.categories = new ArrayList();
        this.shopItemKey = new NamespacedKey(this.plugin, "shop_item");
        this.categoryKey = new NamespacedKey(this.plugin, "shop_category");
        this.itemIdKey = new NamespacedKey(this.plugin, "shop_item_id");
    }

    @Nullable
    public final MessageManager getMessageManager() {
        return this.messageManager;
    }

    public final void setMessageManager(@Nullable MessageManager messageManager) {
        this.messageManager = messageManager;
    }

    public final void loadCategories() {
        this.categories.clear();
        ConfigurationSection shopConfig = this.configManager.getShop().getConfigurationSection("shop");
        if (shopConfig != null) {
            Object v0;
            ShopConfig config;
            block4: {
                config = new ShopConfig(shopConfig);
                List<ShopCategory> loadedCategories = config.loadCategories();
                this.categories.addAll((Collection<ShopCategory>)loadedCategories);
                Iterable iterable = this.categories;
                for (Object t : iterable) {
                    ShopCategory it = (ShopCategory)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getId(), "disguise-blocks")) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            ShopCategory disguiseCategory = v0;
            if (disguiseCategory != null) {
                List<ShopItem> dynamicDisguiseItems = config.getDisguiseBlockItems();
                ShopCategory updatedCategory = ShopCategory.copy$default(disguiseCategory, null, null, null, 0, dynamicDisguiseItems, null, 47, null);
                this.categories.removeIf(arg_0 -> ShopManager.loadCategories$lambda$2(ShopManager::loadCategories$lambda$1, arg_0));
                this.categories.add(updatedCategory);
                this.plugin.getLogger().info("Loaded " + dynamicDisguiseItems.size() + " disguise block items from tier configuration");
            }
            this.plugin.getLogger().info("Loaded " + this.categories.size() + " shop categories");
        } else {
            this.plugin.getLogger().warning("No shop configuration found");
        }
    }

    @NotNull
    public final ItemStack createShopItem() {
        ConfigurationSection shopConfig = this.configManager.getShop().getConfigurationSection("shop");
        if (shopConfig == null) {
            return new ItemStack(Material.EMERALD);
        }
        ShopConfig config = new ShopConfig(shopConfig);
        Material material = config.getShopItemMaterial();
        String displayName = config.getShopItemDisplayName();
        List<String> lore = config.getShopItemLore();
        boolean glow = config.getShopItemGlow();
        ItemBuilder itemBuilder = new ItemBuilder(material).displayName(displayName).lore(lore);
        PersistentDataType persistentDataType = PersistentDataType.BYTE;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "BYTE");
        ItemBuilder item = itemBuilder.persistentData(this.shopItemKey, persistentDataType, (byte)1);
        if (glow) {
            item.glow(true);
        }
        return item.build();
    }

    public final boolean isShopItem(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        ItemMeta meta = itemMeta;
        return meta.getPersistentDataContainer().has(this.shopItemKey, PersistentDataType.BYTE);
    }

    public final void openMainMenu(@NotNull Player player, @Nullable String playerRole) {
        List list;
        Iterator $this$filterTo$iv$iv2;
        String titleKey;
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.categories.isEmpty()) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cShop is not available");
            return;
        }
        player.sendMessage("\u00a7e[DEBUG] openMainMenu called");
        player.sendMessage("\u00a7e[DEBUG] Player role: " + playerRole);
        player.sendMessage("\u00a7e[DEBUG] Total categories: " + this.categories.size());
        Iterable $this$forEach$iv = this.categories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShopCategory cat = (ShopCategory)element$iv;
            boolean bl = false;
            player.sendMessage("\u00a7e[DEBUG] Category: " + cat.getId() + ", roleFilter: " + cat.getRoleFilter() + ", slot: " + cat.getSlot());
        }
        String string = playerRole;
        if (string != null) {
            String string2 = string.toUpperCase(Locale.ROOT);
            v2 = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        } else {
            v2 = $i$f$forEach = null;
        }
        String string3 = titleKey = Intrinsics.areEqual($i$f$forEach, "SEEKER") ? "shop.title.seeker" : (Intrinsics.areEqual($i$f$forEach, "HIDER") ? "shop.title.hider" : "shop.title.hider");
        Object object = this.messageManager;
        if (object == null || (object = object.getRawMessage(player, titleKey, new Object[0])) == null) {
            object = "&a&lShop Menu";
        }
        Object title = object;
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.INSTANCE.colorize((String)title));
        Intrinsics.checkNotNullExpressionValue(inventory, "createInventory(...)");
        Inventory inventory2 = inventory;
        if (playerRole != null) {
            Iterable $this$filter$iv = this.categories;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                ShopCategory it = (ShopCategory)element$iv$iv;
                boolean bl = false;
                if (!it.isVisibleTo(playerRole)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = this.categories;
        }
        List visibleCategories = list;
        player.sendMessage("\u00a7e[DEBUG] Visible categories: " + visibleCategories.size());
        Iterable $this$forEach$iv2 = visibleCategories;
        boolean $i$f$forEach2 = false;
        $this$filterTo$iv$iv2 = $this$forEach$iv2.iterator();
        while ($this$filterTo$iv$iv2.hasNext()) {
            Object element$iv = $this$filterTo$iv$iv2.next();
            ShopCategory cat = (ShopCategory)element$iv;
            boolean bl = false;
            player.sendMessage("\u00a7e[DEBUG] Visible: " + cat.getId());
        }
        for (ShopCategory category : visibleCategories) {
            int $this$filterTo$iv$iv2 = category.getSlot();
            boolean bl = 0 <= $this$filterTo$iv$iv2 ? $this$filterTo$iv$iv2 < 54 : false;
            if (!bl) continue;
            int itemCount = playerRole != null ? category.getItemsForRole(playerRole).size() : category.getItems().size();
            String[] stringArray = new String[]{"&7Click to view items", "&7" + itemCount + " items available"};
            ItemBuilder itemBuilder = new ItemBuilder(category.getIcon()).displayName(category.getDisplayName()).lore(CollectionsKt.listOf(stringArray));
            PersistentDataType persistentDataType = PersistentDataType.STRING;
            Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
            ItemStack item = itemBuilder.persistentData(this.categoryKey, persistentDataType, category.getId()).build();
            inventory2.setItem(category.getSlot(), item);
        }
        Object object2 = this.messageManager;
        if (object2 == null || (object2 = object2.getRawMessage(player, "ui.button.close", new Object[0])) == null) {
            object2 = "&c&lClose";
        }
        Object closeButtonName = object2;
        ItemBuilder itemBuilder = new ItemBuilder(Material.BARRIER).displayName((String)closeButtonName).lore(CollectionsKt.listOf("&7Click to close"));
        PersistentDataType persistentDataType = PersistentDataType.STRING;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
        ItemStack closeButton = itemBuilder.persistentData(this.itemIdKey, persistentDataType, "close").build();
        inventory2.setItem(49, closeButton);
        player.openInventory(inventory2);
    }

    public static /* synthetic */ void openMainMenu$default(ShopManager shopManager, Player player, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        shopManager.openMainMenu(player, string);
    }

    public final void openCategory(@NotNull Player player, @NotNull String categoryId, @Nullable String playerRole) {
        Object object;
        Object v0;
        Iterable iterable;
        block7: {
            Intrinsics.checkNotNullParameter(player, "player");
            Intrinsics.checkNotNullParameter(categoryId, "categoryId");
            iterable = this.categories;
            for (Object t : iterable) {
                ShopCategory it = (ShopCategory)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), categoryId)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        ShopCategory category = v0;
        if (category == null) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cCategory not found");
            return;
        }
        iterable = Bukkit.createInventory(null, (int)54, (Component)MessageUtil.INSTANCE.colorize(category.getDisplayName()));
        Intrinsics.checkNotNullExpressionValue(iterable, "createInventory(...)");
        Iterable inventory = iterable;
        List<ShopItem> visibleItems = playerRole != null ? category.getItemsForRole(playerRole) : category.getItems();
        Iterable $this$sortedBy$iv = visibleItems;
        boolean $i$f$sortedBy = false;
        visibleItems = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                ShopItem it = (ShopItem)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getEffectivePrice());
                it = (ShopItem)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getEffectivePrice());
            }
        });
        if (Intrinsics.areEqual(categoryId, "disguise-blocks")) {
            this.buildDisguiseBlocksGUI((Inventory)inventory, visibleItems, category.getId());
        } else {
            for (ShopItem shopItem : visibleItems) {
                int it = shopItem.getSlot();
                boolean bl = 0 <= it ? it < 54 : false;
                if (!bl) continue;
                List<String> restrictionLore = this.buildRestrictionLore(shopItem);
                int effectivePrice = shopItem.getEffectivePrice();
                String[] stringArray = new String[]{"", effectivePrice == 0 ? "&aFree!" : "&7Price: &e" + effectivePrice + " coins", "&aClick to purchase"};
                ItemBuilder itemBuilder = new ItemBuilder(shopItem.getMaterial()).displayName(shopItem.getDisplayName()).lore(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)shopItem.getLore(), (Iterable)restrictionLore), (Iterable)CollectionsKt.listOf(stringArray)));
                PersistentDataType persistentDataType = PersistentDataType.STRING;
                Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
                ItemBuilder itemBuilder2 = itemBuilder.persistentData(this.itemIdKey, persistentDataType, shopItem.getId());
                PersistentDataType persistentDataType2 = PersistentDataType.STRING;
                Intrinsics.checkNotNullExpressionValue(persistentDataType2, "STRING");
                ItemStack item = itemBuilder2.persistentData(this.categoryKey, persistentDataType2, category.getId()).build();
                inventory.setItem(shopItem.getSlot(), item);
            }
        }
        if ((object = this.messageManager) == null || (object = object.getRawMessage(player, "ui.button.back", new Object[0])) == null) {
            object = "&e&lBack";
        }
        Object backButtonName = object;
        ItemBuilder itemBuilder = new ItemBuilder(Material.ARROW).displayName((String)backButtonName).lore(CollectionsKt.listOf("&7Return to main menu"));
        PersistentDataType persistentDataType = PersistentDataType.STRING;
        Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
        ItemStack backButton = itemBuilder.persistentData(this.itemIdKey, persistentDataType, "back").build();
        inventory.setItem(45, backButton);
        Object object2 = this.messageManager;
        if (object2 == null || (object2 = object2.getRawMessage(player, "ui.button.close", new Object[0])) == null) {
            object2 = "&c&lClose";
        }
        Object closeButtonName = object2;
        ItemBuilder itemBuilder3 = new ItemBuilder(Material.BARRIER).displayName((String)closeButtonName).lore(CollectionsKt.listOf("&7Click to close"));
        PersistentDataType persistentDataType3 = PersistentDataType.STRING;
        Intrinsics.checkNotNullExpressionValue(persistentDataType3, "STRING");
        ItemStack closeButton = itemBuilder3.persistentData(this.itemIdKey, persistentDataType3, "close").build();
        inventory.setItem(49, closeButton);
        player.openInventory((Inventory)inventory);
    }

    public static /* synthetic */ void openCategory$default(ShopManager shopManager, Player player, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        shopManager.openCategory(player, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildDisguiseBlocksGUI(Inventory inventory, List<ShopItem> items, String categoryId) {
        void $this$groupByTo$iv$iv;
        CamouflageTier[] $this$groupBy$iv = (CamouflageTier[])items;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            ShopItem it = (ShopItem)element$iv$iv;
            boolean bl = false;
            CamouflageTier key$iv$iv = it.getCamouflageTier();
            Map map = destination$iv$iv;
            CamouflageTier key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map itemsByTier = destination$iv$iv;
        int currentSlot = 0;
        object = new CamouflageTier[]{CamouflageTier.HIGH_VISIBILITY, CamouflageTier.MEDIUM_VISIBILITY, CamouflageTier.LOW_VISIBILITY};
        List<CamouflageTier> tiers = CollectionsKt.listOf(object);
        block6: for (CamouflageTier tier : tiers) {
            List tierItems;
            if ((List)itemsByTier.get((Object)tier) == null) continue;
            if (currentSlot > 0) {
                currentSlot = (currentSlot / 9 + 1) * 9;
            }
            Material separatorColor = switch (WhenMappings.$EnumSwitchMapping$0[tier.ordinal()]) {
                case 1 -> Material.LIME_STAINED_GLASS_PANE;
                case 2 -> Material.YELLOW_STAINED_GLASS_PANE;
                case 3 -> Material.ORANGE_STAINED_GLASS_PANE;
                default -> throw new NoWhenBranchMatchedException();
            };
            String[] stringArray = new String[]{tier.getFormattedDescription(), "", tier.getBasePrice() == 0 ? "&aFree!" : "&ePrice: &6" + tier.getBasePrice() + " coins"};
            ItemStack separator = new ItemBuilder(separatorColor).displayName(tier.getDisplayName()).lore(CollectionsKt.listOf(stringArray)).build();
            inventory.setItem(currentSlot, separator);
            ++currentSlot;
            for (ShopItem shopItem : tierItems) {
                if (currentSlot >= 45) continue block6;
                int effectivePrice = shopItem.getEffectivePrice();
                String[] stringArray2 = new String[]{"", "&7Tier: " + tier.getDisplayName(), effectivePrice == 0 ? "&aFree!" : "&7Price: &e" + effectivePrice + " coins", "&aClick to purchase"};
                ItemBuilder itemBuilder = new ItemBuilder(shopItem.getMaterial()).displayName(shopItem.getDisplayName()).lore(CollectionsKt.plus((Collection)shopItem.getLore(), (Iterable)CollectionsKt.listOf(stringArray2)));
                PersistentDataType persistentDataType = PersistentDataType.STRING;
                Intrinsics.checkNotNullExpressionValue(persistentDataType, "STRING");
                ItemBuilder itemBuilder2 = itemBuilder.persistentData(this.itemIdKey, persistentDataType, shopItem.getId());
                PersistentDataType persistentDataType2 = PersistentDataType.STRING;
                Intrinsics.checkNotNullExpressionValue(persistentDataType2, "STRING");
                ItemStack item = itemBuilder2.persistentData(this.categoryKey, persistentDataType2, categoryId).build();
                inventory.setItem(currentSlot, item);
                ++currentSlot;
            }
        }
    }

    @Nullable
    public final ShopCategory getCategory(@NotNull String categoryId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(categoryId, "categoryId");
            Iterable iterable = this.categories;
            for (Object t : iterable) {
                ShopCategory it = (ShopCategory)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), categoryId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final ShopItem getShopItem(@NotNull String categoryId, @NotNull String itemId) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter(categoryId, "categoryId");
            Intrinsics.checkNotNullParameter(itemId, "itemId");
            ShopCategory shopCategory = this.getCategory(categoryId);
            if (shopCategory == null) {
                return null;
            }
            ShopCategory category = shopCategory;
            Iterable iterable = category.getItems();
            for (Object t : iterable) {
                ShopItem it = (ShopItem)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getId(), itemId)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final String getCategoryFromItem(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta meta = itemMeta;
        return (String)meta.getPersistentDataContainer().get(this.categoryKey, PersistentDataType.STRING);
    }

    @Nullable
    public final String getItemIdFromItem(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta meta = itemMeta;
        return (String)meta.getPersistentDataContainer().get(this.itemIdKey, PersistentDataType.STRING);
    }

    private final List<String> buildRestrictionLore(ShopItem item) {
        List lore = new ArrayList();
        int effectivePrice = item.getEffectivePrice();
        if (effectivePrice >= 800) {
            lore.add("");
            lore.add("&6\u26a1 \u30d1\u30ef\u30fc\u30a2\u30a4\u30c6\u30e0 &6\u26a1");
        }
        switch (WhenMappings.$EnumSwitchMapping$1[item.getUsageRestriction().ordinal()]) {
            case 1: {
                lore.add("");
                lore.add("&cRequires: Seek phase");
                break;
            }
            case 2: {
                lore.add("");
                lore.add("&cRequires: Active game");
                break;
            }
            case 3: {
                lore.add("");
                lore.add("&cCannot use while captured");
                break;
            }
            case 4: {
                lore.add("");
                lore.add("&cOne use per game");
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (item.getMaxPurchases() != null) {
            lore.add("&7Limit: &e" + item.getMaxPurchases() + " per game");
        }
        if (item.getCooldown() != null) {
            lore.add("&7Cooldown: &e" + item.getCooldown() + "s");
        }
        return lore;
    }

    private static final boolean loadCategories$lambda$1(ShopCategory it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getId(), "disguise-blocks");
    }

    private static final boolean loadCategories$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CamouflageTier.values().length];
            try {
                nArray[CamouflageTier.HIGH_VISIBILITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CamouflageTier.MEDIUM_VISIBILITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CamouflageTier.LOW_VISIBILITY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[UsageRestriction.values().length];
            try {
                nArray[UsageRestriction.SEEK_PHASE_ONLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsageRestriction.IN_GAME_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsageRestriction.NOT_WHILE_CAPTURED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsageRestriction.ONCE_PER_GAME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsageRestriction.ALWAYS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

