/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.spectator;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.SetsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/hideandseek/spectator/SpectatorConfig;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "file", "Ljava/io/File;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "load", "", "save", "isSpectator", "", "uuid", "Ljava/util/UUID;", "setSpectator", "enabled", "getLastUpdated", "", "removeSpectator", "getAllSpectators", "", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nSpectatorConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpectatorConfig.kt\ncom/hideandseek/spectator/SpectatorConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1617#2,9:97\n1869#2:106\n1870#2:108\n1626#2:109\n774#2:110\n865#2,2:111\n1#3:107\n*S KotlinDebug\n*F\n+ 1 SpectatorConfig.kt\ncom/hideandseek/spectator/SpectatorConfig\n*L\n85#1:97,9\n85#1:106\n85#1:108\n85#1:109\n92#1:110\n92#1:111,2\n85#1:107\n*E\n"})
public final class SpectatorConfig {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final File file;
    private FileConfiguration config;

    public SpectatorConfig(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.file = new File(this.plugin.getDataFolder(), "spectators.yml");
    }

    public final void load() {
        if (!this.file.exists()) {
            File file = this.file.getParentFile();
            if (file != null) {
                file.mkdirs();
            }
            this.file.createNewFile();
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        this.config = (FileConfiguration)yamlConfiguration;
    }

    public final void save() {
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        fileConfiguration.save(this.file);
    }

    public final boolean isSpectator(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        return fileConfiguration.getBoolean("spectators." + uuid + ".enabled", false);
    }

    public final void setSpectator(@NotNull UUID uuid, boolean enabled) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        fileConfiguration.set("spectators." + uuid + ".enabled", (Object)enabled);
        FileConfiguration fileConfiguration2 = this.config;
        if (fileConfiguration2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration2 = null;
        }
        fileConfiguration2.set("spectators." + uuid + ".last-updated", (Object)System.currentTimeMillis());
        this.save();
    }

    public final long getLastUpdated(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        return fileConfiguration.getLong("spectators." + uuid + ".last-updated", 0L);
    }

    public final void removeSpectator(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        fileConfiguration.set("spectators." + uuid, null);
        this.save();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<UUID> getAllSpectators() {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        FileConfiguration fileConfiguration = this.config;
        if (fileConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            fileConfiguration = null;
        }
        ConfigurationSection configurationSection = fileConfiguration.getConfigurationSection("spectators");
        if (configurationSection == null) {
            return SetsKt.emptySet();
        }
        ConfigurationSection spectators = configurationSection;
        Set set = spectators.getKeys(false);
        Intrinsics.checkNotNullExpressionValue(set, "getKeys(...)");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            UUID it$iv$iv;
            UUID uUID;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                uUID = UUID.fromString(it);
            }
            catch (IllegalArgumentException e) {
                uUID = null;
            }
            if (uUID == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UUID it = (UUID)element$iv$iv;
            boolean bl = false;
            if (!this.isSpectator(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }
}

