/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.spectator;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.ranges.RangesKt;
import com.hideandseek.spectator.SpectatorConfig;
import com.hideandseek.spectator.SpectatorTeam;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0018\u001a\u00020\tJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aJ\u0006\u0010\u001b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/hideandseek/spectator/SpectatorManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "spectatorConfig", "Lcom/hideandseek/spectator/SpectatorConfig;", "spectatorTeam", "Lcom/hideandseek/spectator/SpectatorTeam;", "initialize", "", "shutdown", "isSpectator", "", "uuid", "Ljava/util/UUID;", "toggleSpectator", "player", "Lorg/bukkit/entity/Player;", "enabled", "applySpectatorMode", "removeSpectatorMode", "restoreSpectatorState", "getSpectatorTeam", "getAllSpectators", "", "getConfig", "EasyHideAndSeek"})
public final class SpectatorManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final SpectatorConfig spectatorConfig;
    private SpectatorTeam spectatorTeam;

    public SpectatorManager(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.spectatorConfig = new SpectatorConfig(this.plugin);
    }

    public final void initialize() {
        this.spectatorConfig.load();
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        this.spectatorTeam = new SpectatorTeam(mainScoreboard);
        this.plugin.getLogger().info("SpectatorManager initialized");
    }

    public final void shutdown() {
        SpectatorTeam spectatorTeam = this.spectatorTeam;
        if (spectatorTeam == null) {
            Intrinsics.throwUninitializedPropertyAccessException("spectatorTeam");
            spectatorTeam = null;
        }
        spectatorTeam.unregister();
        this.plugin.getLogger().info("SpectatorManager shutdown");
    }

    public final boolean isSpectator(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return this.spectatorConfig.isSpectator(uuid);
    }

    public final void toggleSpectator(@NotNull Player player, boolean enabled) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this.spectatorConfig.setSpectator(uUID, enabled);
        if (enabled) {
            SpectatorTeam spectatorTeam = this.spectatorTeam;
            if (spectatorTeam == null) {
                Intrinsics.throwUninitializedPropertyAccessException("spectatorTeam");
                spectatorTeam = null;
            }
            spectatorTeam.addPlayer(player);
        } else {
            SpectatorTeam spectatorTeam = this.spectatorTeam;
            if (spectatorTeam == null) {
                Intrinsics.throwUninitializedPropertyAccessException("spectatorTeam");
                spectatorTeam = null;
            }
            spectatorTeam.removePlayer(player);
        }
    }

    public final void applySpectatorMode(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.setGameMode(GameMode.ADVENTURE);
        player.setAllowFlight(true);
        player.setFlying(true);
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false));
        player.setCollidable(false);
        double flightSpeed = this.plugin.getConfig().getDouble("spectator.flight-speed", 1.5);
        player.setFlySpeed(RangesKt.coerceIn((float)(flightSpeed / 10.0), 0.0f, 1.0f));
    }

    public final void removeSpectatorMode(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        player.setAllowFlight(false);
        player.setFlying(false);
        player.removePotionEffect(PotionEffectType.INVISIBILITY);
        player.setCollidable(true);
        player.setFlySpeed(0.1f);
    }

    public final void restoreSpectatorState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        if (this.isSpectator(uUID)) {
            SpectatorTeam spectatorTeam = this.spectatorTeam;
            if (spectatorTeam == null) {
                Intrinsics.throwUninitializedPropertyAccessException("spectatorTeam");
                spectatorTeam = null;
            }
            spectatorTeam.addPlayer(player);
        }
    }

    @NotNull
    public final SpectatorTeam getSpectatorTeam() {
        SpectatorTeam spectatorTeam = this.spectatorTeam;
        if (spectatorTeam == null) {
            Intrinsics.throwUninitializedPropertyAccessException("spectatorTeam");
            spectatorTeam = null;
        }
        return spectatorTeam;
    }

    @NotNull
    public final Set<UUID> getAllSpectators() {
        return this.spectatorConfig.getAllSpectators();
    }

    @NotNull
    public final SpectatorConfig getConfig() {
        return this.spectatorConfig;
    }
}

