/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.strength;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.strength.SeekerStrengthData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/hideandseek/strength/SeekerStrengthManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "strengthData", "", "Ljava/util/UUID;", "Lcom/hideandseek/strength/SeekerStrengthData;", "getStrength", "", "playerId", "addStrength", "", "points", "resetStrength", "compareStrength", "attackerId", "victimId", "clearAll", "getCaptureCount", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nSeekerStrengthManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeekerStrengthManager.kt\ncom/hideandseek/strength/SeekerStrengthManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,99:1\n382#2,7:100\n*S KotlinDebug\n*F\n+ 1 SeekerStrengthManager.kt\ncom/hideandseek/strength/SeekerStrengthManager\n*L\n46#1:100,7\n*E\n"})
public final class SeekerStrengthManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Map<UUID, SeekerStrengthData> strengthData;

    public SeekerStrengthManager(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.strengthData = new LinkedHashMap();
    }

    public final int getStrength(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        SeekerStrengthData seekerStrengthData = this.strengthData.get(playerId);
        return seekerStrengthData != null ? seekerStrengthData.getStrengthPoints() : 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void addStrength(@NotNull UUID playerId, int points) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Map<UUID, SeekerStrengthData> map = this.strengthData;
        UUID key$iv = playerId;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            SeekerStrengthData answer$iv = new SeekerStrengthData(playerId, 0, 0, 6, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        SeekerStrengthData data = (SeekerStrengthData)object;
        data.addCapture(points);
        this.plugin.getLogger().info("[SeekerStrength] " + playerId + " captured hider: +" + points + " strength (total: " + data.getStrengthPoints() + ", captures: " + data.getCaptureCount() + ")");
    }

    public final void resetStrength(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        SeekerStrengthData seekerStrengthData = this.strengthData.get(playerId);
        if (seekerStrengthData != null) {
            seekerStrengthData.reset();
        }
        this.plugin.getLogger().info("[SeekerStrength] " + playerId + " strength reset to 0");
    }

    public final int compareStrength(@NotNull UUID attackerId, @NotNull UUID victimId) {
        Intrinsics.checkNotNullParameter(attackerId, "attackerId");
        Intrinsics.checkNotNullParameter(victimId, "victimId");
        int attackerStrength = this.getStrength(attackerId);
        int victimStrength = this.getStrength(victimId);
        this.plugin.getLogger().info("[SeekerStrength] Comparing strength: attacker=" + attackerStrength + " vs victim=" + victimStrength);
        return attackerStrength - victimStrength;
    }

    public final void clearAll() {
        int count = this.strengthData.size();
        this.strengthData.clear();
        this.plugin.getLogger().info("[SeekerStrength] Cleared all strength data (" + count + " entries)");
    }

    public final int getCaptureCount(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        SeekerStrengthData seekerStrengthData = this.strengthData.get(playerId);
        return seekerStrengthData != null ? seekerStrengthData.getCaptureCount() : 0;
    }
}

