/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.arena;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaBoundaries;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J+\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/hideandseek/arena/ArenaSetupSession;", "", "adminUuid", "Ljava/util/UUID;", "pos1", "Lorg/bukkit/Location;", "pos2", "<init>", "(Ljava/util/UUID;Lorg/bukkit/Location;Lorg/bukkit/Location;)V", "getAdminUuid", "()Ljava/util/UUID;", "getPos1", "()Lorg/bukkit/Location;", "setPos1", "(Lorg/bukkit/Location;)V", "getPos2", "setPos2", "isComplete", "", "validate", "", "", "toArena", "Lcom/hideandseek/arena/Arena;", "name", "displayName", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "EasyHideAndSeek"})
public final class ArenaSetupSession {
    @NotNull
    private final UUID adminUuid;
    @Nullable
    private Location pos1;
    @Nullable
    private Location pos2;

    public ArenaSetupSession(@NotNull UUID adminUuid, @Nullable Location pos1, @Nullable Location pos2) {
        Intrinsics.checkNotNullParameter(adminUuid, "adminUuid");
        this.adminUuid = adminUuid;
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    public /* synthetic */ ArenaSetupSession(UUID uUID, Location location, Location location2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            location = null;
        }
        if ((n & 4) != 0) {
            location2 = null;
        }
        this(uUID, location, location2);
    }

    @NotNull
    public final UUID getAdminUuid() {
        return this.adminUuid;
    }

    @Nullable
    public final Location getPos1() {
        return this.pos1;
    }

    public final void setPos1(@Nullable Location location) {
        this.pos1 = location;
    }

    @Nullable
    public final Location getPos2() {
        return this.pos2;
    }

    public final void setPos2(@Nullable Location location) {
        this.pos2 = location;
    }

    public final boolean isComplete() {
        return this.pos1 != null && this.pos2 != null;
    }

    @NotNull
    public final List<String> validate() {
        List errors = new ArrayList();
        if (this.pos1 == null) {
            errors.add("pos1 is not set. Use /hs admin setpos1");
        }
        if (this.pos2 == null) {
            errors.add("pos2 is not set. Use /hs admin setpos2");
        }
        World[] worldArray = new World[2];
        Location location = this.pos1;
        worldArray[0] = location != null ? location.getWorld() : null;
        Location location2 = this.pos2;
        worldArray[1] = location2 != null ? location2.getWorld() : null;
        List worlds = CollectionsKt.distinct((Iterable)CollectionsKt.listOfNotNull(worldArray));
        if (worlds.size() > 1) {
            errors.add("All positions must be in the same world (found: " + CollectionsKt.joinToString$default(worlds, null, null, null, 0, null, ArenaSetupSession::validate$lambda$0, 31, null) + ")");
        }
        return errors;
    }

    @NotNull
    public final Arena toArena(@NotNull String name, @NotNull String displayName) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        List<String> validationErrors = this.validate();
        if (!validationErrors.isEmpty()) {
            boolean bl = false;
            String string = "Cannot create arena. Missing:\n" + CollectionsKt.joinToString$default(validationErrors, "\n- ", "- ", null, 0, null, null, 60, null);
            throw new IllegalArgumentException(string.toString());
        }
        Location location = this.pos1;
        Intrinsics.checkNotNull(location);
        World world = location.getWorld();
        Intrinsics.checkNotNull(world);
        Location location2 = this.pos1;
        Intrinsics.checkNotNull(location2);
        Location location3 = this.pos2;
        Intrinsics.checkNotNull(location3);
        return new Arena(name, displayName, world, new ArenaBoundaries(location2, location3));
    }

    @NotNull
    public final UUID component1() {
        return this.adminUuid;
    }

    @Nullable
    public final Location component2() {
        return this.pos1;
    }

    @Nullable
    public final Location component3() {
        return this.pos2;
    }

    @NotNull
    public final ArenaSetupSession copy(@NotNull UUID adminUuid, @Nullable Location pos1, @Nullable Location pos2) {
        Intrinsics.checkNotNullParameter(adminUuid, "adminUuid");
        return new ArenaSetupSession(adminUuid, pos1, pos2);
    }

    public static /* synthetic */ ArenaSetupSession copy$default(ArenaSetupSession arenaSetupSession, UUID uUID, Location location, Location location2, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = arenaSetupSession.adminUuid;
        }
        if ((n & 2) != 0) {
            location = arenaSetupSession.pos1;
        }
        if ((n & 4) != 0) {
            location2 = arenaSetupSession.pos2;
        }
        return arenaSetupSession.copy(uUID, location, location2);
    }

    @NotNull
    public String toString() {
        return "ArenaSetupSession(adminUuid=" + this.adminUuid + ", pos1=" + this.pos1 + ", pos2=" + this.pos2 + ")";
    }

    public int hashCode() {
        int result = this.adminUuid.hashCode();
        result = result * 31 + (this.pos1 == null ? 0 : this.pos1.hashCode());
        result = result * 31 + (this.pos2 == null ? 0 : this.pos2.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArenaSetupSession)) {
            return false;
        }
        ArenaSetupSession arenaSetupSession = (ArenaSetupSession)other;
        if (!Intrinsics.areEqual(this.adminUuid, arenaSetupSession.adminUuid)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.pos1, arenaSetupSession.pos1)) {
            return false;
        }
        return Intrinsics.areEqual(this.pos2, arenaSetupSession.pos2);
    }

    private static final CharSequence validate$lambda$0(World it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        return string;
    }
}

