/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.config;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0014\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u0011\u0010\u0018\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\tR\u0011\u0010\u001a\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\tR\u0011\u0010\u001c\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\rR\u0011\u0010\u001e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\rR\u0011\u0010 \u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\t\u00a8\u0006$"}, d2={"Lcom/hideandseek/config/BlockRestorationConfig;", "", "section", "Lorg/bukkit/configuration/ConfigurationSection;", "<init>", "(Lorg/bukkit/configuration/ConfigurationSection;)V", "enabled", "", "getEnabled", "()Z", "restorationDelaySeconds", "", "getRestorationDelaySeconds", "()I", "maxRestorationsPerTick", "getMaxRestorationsPerTick", "onlyDuringActiveGame", "getOnlyDuringActiveGame", "applyDuringPreparation", "getApplyDuringPreparation", "enableTileEntityRestoration", "getEnableTileEntityRestoration", "debugLogging", "getDebugLogging", "logRestorationStats", "getLogRestorationStats", "randomRespawnEnabled", "getRandomRespawnEnabled", "respawnSearchRadius", "getRespawnSearchRadius", "maxRespawnAttempts", "getMaxRespawnAttempts", "useGameBoundaries", "getUseGameBoundaries", "getRestorationDelayMs", "", "EasyHideAndSeek"})
public final class BlockRestorationConfig {
    @NotNull
    private final ConfigurationSection section;

    public BlockRestorationConfig(@NotNull ConfigurationSection section) {
        Intrinsics.checkNotNullParameter(section, "section");
        this.section = section;
    }

    public final boolean getEnabled() {
        return this.section.getBoolean("block-restoration.enabled", true);
    }

    public final int getRestorationDelaySeconds() {
        return this.section.getInt("block-restoration.restoration-delay-seconds", 5);
    }

    public final int getMaxRestorationsPerTick() {
        return this.section.getInt("block-restoration.max-restorations-per-tick", 10);
    }

    public final boolean getOnlyDuringActiveGame() {
        return this.section.getBoolean("block-restoration.only-during-active-game", true);
    }

    public final boolean getApplyDuringPreparation() {
        return this.section.getBoolean("block-restoration.apply-during-preparation", true);
    }

    public final boolean getEnableTileEntityRestoration() {
        return this.section.getBoolean("block-restoration.enable-tile-entity-restoration", true);
    }

    public final boolean getDebugLogging() {
        return this.section.getBoolean("block-restoration.debug-logging", false);
    }

    public final boolean getLogRestorationStats() {
        return this.section.getBoolean("block-restoration.log-restoration-stats", false);
    }

    public final boolean getRandomRespawnEnabled() {
        return this.section.getBoolean("random-respawn.enabled", true);
    }

    public final int getRespawnSearchRadius() {
        return this.section.getInt("random-respawn.search-radius", 50);
    }

    public final int getMaxRespawnAttempts() {
        return this.section.getInt("random-respawn.max-attempts", 50);
    }

    public final boolean getUseGameBoundaries() {
        return this.section.getBoolean("random-respawn.use-game-boundaries", true);
    }

    public final long getRestorationDelayMs() {
        return (long)this.getRestorationDelaySeconds() * 1000L;
    }
}

