/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.effects;

import com.hideandseek.effects.EffectType;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000bJ\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\nJ\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/hideandseek/effects/EffectValidator;", "", "<init>", "()V", "MIN_DURATION", "", "MAX_DURATION", "INTENSITY_RANGES", "", "Lcom/hideandseek/effects/EffectType;", "Lcom/hideandseek/libs/kotlin/Pair;", "", "validateDuration", "", "durationSeconds", "validateIntensity", "effectType", "intensity", "validatePlayer", "player", "Lorg/bukkit/entity/Player;", "validateEffectApplication", "getDurationRange", "getIntensityRange", "EasyHideAndSeek"})
public final class EffectValidator {
    @NotNull
    public static final EffectValidator INSTANCE = new EffectValidator();
    private static final int MIN_DURATION = 5;
    private static final int MAX_DURATION = 120;
    @NotNull
    private static final Map<EffectType, Pair<Double, Double>> INTENSITY_RANGES;

    private EffectValidator() {
    }

    public final boolean validateDuration(int durationSeconds) {
        if (!(5 <= durationSeconds ? durationSeconds < 121 : false)) {
            boolean bl = false;
            String string = "Effect duration must be between 5 and 120 seconds, got: " + durationSeconds;
            throw new IllegalArgumentException(string.toString());
        }
        return true;
    }

    public final boolean validateIntensity(@NotNull EffectType effectType, double intensity) {
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        Pair<Double, Double> pair = INTENSITY_RANGES.get((Object)effectType);
        if (pair == null) {
            throw new IllegalStateException("No intensity range defined for effect type: " + effectType);
        }
        Pair<Double, Double> range = pair;
        if (!(intensity >= ((Number)range.getFirst()).doubleValue() && intensity <= ((Number)range.getSecond()).doubleValue())) {
            boolean bl = false;
            String string = "Intensity for " + effectType + " must be between " + range.getFirst() + " and " + range.getSecond() + ", got: " + intensity;
            throw new IllegalArgumentException(string.toString());
        }
        return true;
    }

    public final boolean validatePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (!player.isOnline()) {
            boolean bl = false;
            String string = "Cannot apply effect to offline player: " + player.getName();
            throw new IllegalArgumentException(string.toString());
        }
        return true;
    }

    public final boolean validateEffectApplication(@NotNull Player player, @NotNull EffectType effectType, int durationSeconds, double intensity) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        this.validatePlayer(player);
        this.validateDuration(durationSeconds);
        this.validateIntensity(effectType, intensity);
        return true;
    }

    @NotNull
    public final Pair<Integer, Integer> getDurationRange() {
        return TuplesKt.to(5, 120);
    }

    @NotNull
    public final Pair<Double, Double> getIntensityRange(@NotNull EffectType effectType) {
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        Pair<Double, Double> pair = INTENSITY_RANGES.get((Object)effectType);
        if (pair == null) {
            throw new IllegalStateException("No intensity range defined for effect type: " + effectType);
        }
        return pair;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(EffectType.VISION, TuplesKt.to(0.5, 2.0)), TuplesKt.to(EffectType.GLOW, TuplesKt.to(0.5, 2.0)), TuplesKt.to(EffectType.SPEED, TuplesKt.to(0.5, 2.0)), TuplesKt.to(EffectType.REACH, TuplesKt.to(1.0, 2.0)), TuplesKt.to(EffectType.SHADOW_SPRINT, TuplesKt.to(0.5, 2.0)), TuplesKt.to(EffectType.DECOY_BLOCK, TuplesKt.to(1.0, 1.0)), TuplesKt.to(EffectType.SECOND_CHANCE, TuplesKt.to(1.0, 1.0)), TuplesKt.to(EffectType.TRACKER_COMPASS, TuplesKt.to(1.0, 1.0)), TuplesKt.to(EffectType.AREA_SCAN, TuplesKt.to(5.0, 30.0)), TuplesKt.to(EffectType.EAGLE_EYE, TuplesKt.to(5.0, 30.0)), TuplesKt.to(EffectType.TRACKER_INSIGHT, TuplesKt.to(1.0, 1.0)), TuplesKt.to(EffectType.CAPTURE_NET, TuplesKt.to(1.5, 3.0))};
        INTENSITY_RANGES = MapsKt.mapOf(pairArray);
    }
}

