/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.game;

import com.hideandseek.HideAndSeekPlugin;
import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaBoundaries;
import com.hideandseek.arena.ArenaManager;
import com.hideandseek.config.CaptureMode;
import com.hideandseek.config.ConfigManager;
import com.hideandseek.config.ShopConfig;
import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.effects.EffectManagerImpl;
import com.hideandseek.game.Game;
import com.hideandseek.game.GamePhase;
import com.hideandseek.game.GameResult;
import com.hideandseek.game.PlayerBackup;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.game.WorldBorderBackup;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Deprecated;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.collections.SetsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.Ref;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.random.Random;
import com.hideandseek.libs.kotlin.text.StringsKt;
import com.hideandseek.points.PointManager;
import com.hideandseek.scoreboard.GameScoreboard;
import com.hideandseek.scoreboard.LocalizedScoreboardManager;
import com.hideandseek.shop.ShopManager;
import com.hideandseek.spectator.SpectatorManager;
import com.hideandseek.strength.SeekerStrengthManager;
import com.hideandseek.utils.MessageUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\u000e\u0010H\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\u0010\u0010I\u001a\u0004\u0018\u00010\r2\u0006\u0010J\u001a\u00020KJ\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u000e\u0010O\u001a\u00020M2\u0006\u0010N\u001a\u00020\rJ\u0010\u0010P\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010Q\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010R\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010S\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010T\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J4\u0010U\u001a\u00020V2\u0006\u0010J\u001a\u00020K2\u001a\b\u0002\u0010W\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020Z0Y0X2\b\b\u0002\u0010[\u001a\u00020ZJ'\u0010\\\u001a\u0004\u0018\u00010Z2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020Z2\u0006\u0010`\u001a\u00020ZH\u0002\u00a2\u0006\u0002\u0010aJ\u0010\u0010b\u001a\u00020E2\u0006\u0010c\u001a\u00020dH\u0002J\u0010\u0010e\u001a\u00020E2\u0006\u0010c\u001a\u00020dH\u0002J\u0010\u0010f\u001a\u00020E2\u0006\u0010c\u001a\u00020dH\u0002J\u0010\u0010g\u001a\u00020E2\u0006\u0010c\u001a\u00020dH\u0003J\u0010\u0010h\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010i\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u000e\u0010j\u001a\u00020M2\u0006\u0010F\u001a\u00020GJ\u0016\u0010k\u001a\u00020M2\u0006\u0010l\u001a\u00020G2\u0006\u0010m\u001a\u00020GJ\u001e\u0010n\u001a\u00020M2\u0006\u0010o\u001a\u00020G2\u0006\u0010p\u001a\u00020q2\u0006\u0010N\u001a\u00020\rJ\u0018\u0010r\u001a\u00020M2\u0006\u0010F\u001a\u00020G2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010s\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010t\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010u\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u000e\u0010v\u001a\u00020M2\u0006\u0010w\u001a\u00020xJ\u0010\u0010y\u001a\u00020z2\u0006\u0010w\u001a\u00020xH\u0002J\u0010\u0010{\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010|\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010}\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0010\u0010~\u001a\u00020M2\u0006\u0010\u007f\u001a\u00020zH\u0002J\u0019\u0010\u0080\u0001\u001a\u00020M2\u0006\u0010N\u001a\u00020\r2\u0006\u0010\u007f\u001a\u00020zH\u0002J\u000f\u0010\u0081\u0001\u001a\u00020M2\u0006\u0010\u007f\u001a\u00020zJ\u000e\u0010\u0082\u0001\u001a\t\u0012\u0004\u0012\u00020\u00130\u0083\u0001J\u000f\u0010\u0084\u0001\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\t\u0010\u0085\u0001\u001a\u00020MH\u0002J\u0011\u0010\u0086\u0001\u001a\u00020M2\u0006\u0010\u007f\u001a\u00020zH\u0002J\t\u0010\u0087\u0001\u001a\u00020MH\u0002J\u001a\u0010\u0088\u0001\u001a\u00020M2\u0006\u0010J\u001a\u00020K2\u0007\u0010\u0089\u0001\u001a\u00020ZH\u0002J\u000f\u0010\u008a\u0001\u001a\u00020M2\u0006\u0010N\u001a\u00020\rJ\u000f\u0010\u008b\u0001\u001a\u00020M2\u0006\u0010N\u001a\u00020\rJ\u0011\u0010\u008c\u0001\u001a\u00020M2\u0006\u0010N\u001a\u00020\rH\u0002J\u0007\u0010\u008d\u0001\u001a\u00020ZR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u000103X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u001c\u00108\u001a\u0004\u0018\u000109X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010C\u00a8\u0006\u008e\u0001"}, d2={"Lcom/hideandseek/game/GameManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "configManager", "Lcom/hideandseek/config/ConfigManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/config/ConfigManager;)V", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "getConfigManager", "()Lcom/hideandseek/config/ConfigManager;", "value", "Lcom/hideandseek/game/Game;", "activeGame", "getActiveGame", "()Lcom/hideandseek/game/Game;", "waitingPlayers", "", "Ljava/util/UUID;", "shopManager", "Lcom/hideandseek/shop/ShopManager;", "getShopManager", "()Lcom/hideandseek/shop/ShopManager;", "setShopManager", "(Lcom/hideandseek/shop/ShopManager;)V", "disguiseManager", "Lcom/hideandseek/disguise/DisguiseManager;", "getDisguiseManager", "()Lcom/hideandseek/disguise/DisguiseManager;", "setDisguiseManager", "(Lcom/hideandseek/disguise/DisguiseManager;)V", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "getMessageManager", "()Lcom/hideandseek/i18n/MessageManager;", "setMessageManager", "(Lcom/hideandseek/i18n/MessageManager;)V", "pointManager", "Lcom/hideandseek/points/PointManager;", "getPointManager", "()Lcom/hideandseek/points/PointManager;", "setPointManager", "(Lcom/hideandseek/points/PointManager;)V", "arenaManager", "Lcom/hideandseek/arena/ArenaManager;", "getArenaManager", "()Lcom/hideandseek/arena/ArenaManager;", "setArenaManager", "(Lcom/hideandseek/arena/ArenaManager;)V", "gameScoreboard", "Lcom/hideandseek/scoreboard/GameScoreboard;", "getGameScoreboard", "()Lcom/hideandseek/scoreboard/GameScoreboard;", "setGameScoreboard", "(Lcom/hideandseek/scoreboard/GameScoreboard;)V", "localizedScoreboard", "Lcom/hideandseek/scoreboard/LocalizedScoreboardManager;", "getLocalizedScoreboard", "()Lcom/hideandseek/scoreboard/LocalizedScoreboardManager;", "setLocalizedScoreboard", "(Lcom/hideandseek/scoreboard/LocalizedScoreboardManager;)V", "seekerStrengthManager", "Lcom/hideandseek/strength/SeekerStrengthManager;", "getSeekerStrengthManager", "()Lcom/hideandseek/strength/SeekerStrengthManager;", "setSeekerStrengthManager", "(Lcom/hideandseek/strength/SeekerStrengthManager;)V", "joinGame", "", "player", "Lorg/bukkit/entity/Player;", "leaveGame", "startGame", "arena", "Lcom/hideandseek/arena/Arena;", "applySpectatorModeToSpectators", "", "game", "assignRoles", "setupTeams", "cleanupTeams", "setupWorldTime", "backupPlayers", "teleportPlayers", "getRandomSpawnLocation", "Lorg/bukkit/Location;", "usedLocations", "", "Lcom/hideandseek/libs/kotlin/Pair;", "", "minDistance", "findSafeGroundY", "world", "Lorg/bukkit/World;", "x", "z", "(Lorg/bukkit/World;II)Ljava/lang/Integer;", "isUnstableBlock", "material", "Lorg/bukkit/Material;", "isDangerousBlock", "isSafeAir", "isPassableBlock", "clearPlayerInventories", "giveShopItems", "giveShopItemToPlayer", "handleCapture", "capturer", "captured", "revertSeekerToHider", "seeker", "seekerData", "Lcom/hideandseek/game/PlayerGameData;", "updateTeamForReversion", "applyWorldBorder", "startPreparationPhase", "startSeekPhase", "endGame", "result", "Lcom/hideandseek/game/GameResult;", "getResultMessage", "", "displayStats", "displayRankings", "restorePlayers", "broadcastToWaiting", "message", "broadcastToGame", "broadcastToActiveGame", "getWaitingPlayers", "", "isInGame", "checkAutoStart", "broadcastToServer", "tryStartGame", "startGameCountdown", "seconds", "startAutoRestartTimer", "cancelAutoRestartTimer", "transitionToWaiting", "getActivePlayerCount", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nGameManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameManager.kt\ncom/hideandseek/game/GameManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1556:1\n1617#2,9:1557\n1869#2:1566\n1870#2:1568\n1626#2:1569\n1617#2,9:1570\n1869#2:1579\n1870#2:1581\n1626#2:1582\n774#2:1583\n865#2,2:1584\n1617#2,9:1586\n1869#2:1595\n1870#2:1597\n1626#2:1598\n774#2:1599\n865#2,2:1600\n1869#2:1602\n1870#2:1604\n1617#2,9:1605\n1869#2:1614\n1870#2:1616\n1626#2:1617\n1563#2:1618\n1634#2,3:1619\n1869#2,2:1622\n1869#2,2:1626\n1869#2:1628\n1869#2,2:1629\n1870#2:1631\n1869#2,2:1632\n1869#2,2:1635\n1740#2,3:1640\n1869#2,2:1647\n1869#2,2:1649\n1617#2,9:1651\n1869#2:1660\n1870#2:1662\n1626#2:1663\n774#2:1664\n865#2,2:1665\n1869#2,2:1667\n1617#2,9:1669\n1869#2:1678\n1870#2:1680\n1626#2:1681\n1869#2,2:1682\n1869#2,2:1684\n1617#2,9:1686\n1869#2:1695\n1870#2:1697\n1626#2:1698\n1869#2,2:1699\n1617#2,9:1701\n1869#2:1710\n1870#2:1712\n1626#2:1713\n1869#2,2:1714\n1869#2,2:1716\n1869#2,2:1718\n1617#2,9:1720\n1869#2:1729\n1870#2:1731\n1626#2:1732\n774#2:1733\n865#2,2:1734\n1999#2,14:1736\n1617#2,9:1750\n1869#2:1759\n1870#2:1761\n1626#2:1762\n1869#2,2:1763\n1878#2,3:1765\n1869#2,2:1768\n1878#2,3:1770\n1869#2:1775\n1870#2:1777\n1869#2,2:1778\n1869#2,2:1780\n1617#2,9:1782\n1869#2:1791\n1870#2:1793\n1626#2:1794\n1617#2,9:1795\n1869#2:1804\n1870#2:1806\n1626#2:1807\n774#2:1808\n865#2,2:1809\n827#2:1811\n855#2,2:1812\n1869#2,2:1814\n1869#2,2:1816\n1788#2,4:1818\n1869#2,2:1822\n1617#2,9:1824\n1869#2:1833\n1870#2:1835\n1626#2:1836\n1869#2,2:1837\n1869#2,2:1839\n1869#2,2:1841\n1617#2,9:1843\n1869#2:1852\n1870#2:1854\n1626#2:1855\n1#3:1567\n1#3:1580\n1#3:1596\n1#3:1603\n1#3:1615\n1#3:1661\n1#3:1679\n1#3:1696\n1#3:1711\n1#3:1730\n1#3:1760\n1#3:1776\n1#3:1792\n1#3:1805\n1#3:1834\n1#3:1853\n216#4,2:1624\n216#4:1634\n217#4:1637\n216#4,2:1638\n216#4,2:1643\n216#4,2:1645\n216#4,2:1773\n*S KotlinDebug\n*F\n+ 1 GameManager.kt\ncom/hideandseek/game/GameManager\n*L\n122#1:1557,9\n122#1:1566\n122#1:1568\n122#1:1569\n137#1:1570,9\n137#1:1579\n137#1:1581\n137#1:1582\n137#1:1583\n137#1:1584,2\n155#1:1586,9\n155#1:1595\n155#1:1597\n155#1:1598\n192#1:1599\n192#1:1600,2\n205#1:1602\n205#1:1604\n223#1:1605,9\n223#1:1614\n223#1:1616\n223#1:1617\n230#1:1618\n230#1:1619,3\n271#1:1622,2\n350#1:1626,2\n370#1:1628\n373#1:1629,2\n370#1:1631\n383#1:1632,2\n431#1:1635,2\n499#1:1640,3\n673#1:1647,2\n702#1:1649,2\n770#1:1651,9\n770#1:1660\n770#1:1662\n770#1:1663\n770#1:1664\n770#1:1665,2\n803#1:1667,2\n847#1:1669,9\n847#1:1678\n847#1:1680\n847#1:1681\n849#1:1682,2\n902#1:1684,2\n944#1:1686,9\n944#1:1695\n944#1:1697\n944#1:1698\n949#1:1699,2\n1079#1:1701,9\n1079#1:1710\n1079#1:1712\n1079#1:1713\n1083#1:1714,2\n1132#1:1716,2\n1186#1:1718,2\n1225#1:1720,9\n1225#1:1729\n1225#1:1731\n1225#1:1732\n1234#1:1733\n1234#1:1734,2\n1235#1:1736,14\n1248#1:1750,9\n1248#1:1759\n1248#1:1761\n1248#1:1762\n1258#1:1763,2\n1262#1:1765,3\n1285#1:1768,2\n1289#1:1770,3\n1323#1:1775\n1323#1:1777\n1329#1:1778,2\n1381#1:1780,2\n1507#1:1782,9\n1507#1:1791\n1507#1:1793\n1507#1:1794\n1511#1:1795,9\n1511#1:1804\n1511#1:1806\n1511#1:1807\n1512#1:1808\n1512#1:1809,2\n1513#1:1811\n1513#1:1812,2\n1529#1:1814,2\n1539#1:1816,2\n1550#1:1818,4\n923#1:1822,2\n981#1:1824,9\n981#1:1833\n981#1:1835\n981#1:1836\n987#1:1837,2\n1000#1:1839,2\n1013#1:1841,2\n1475#1:1843,9\n1475#1:1852\n1475#1:1854\n1475#1:1855\n122#1:1567\n137#1:1580\n155#1:1596\n223#1:1615\n770#1:1661\n847#1:1679\n944#1:1696\n1079#1:1711\n1225#1:1730\n1248#1:1760\n1507#1:1792\n1511#1:1805\n981#1:1834\n1475#1:1853\n332#1:1624,2\n418#1:1634\n418#1:1637\n447#1:1638,2\n619#1:1643,2\n629#1:1645,2\n1309#1:1773,2\n*E\n"})
public final class GameManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final ConfigManager configManager;
    @Nullable
    private Game activeGame;
    @NotNull
    private final List<UUID> waitingPlayers;
    @Nullable
    private ShopManager shopManager;
    @Nullable
    private DisguiseManager disguiseManager;
    @Nullable
    private MessageManager messageManager;
    @Nullable
    private PointManager pointManager;
    @Nullable
    private ArenaManager arenaManager;
    @Nullable
    private GameScoreboard gameScoreboard;
    @Nullable
    private LocalizedScoreboardManager localizedScoreboard;
    @Nullable
    private SeekerStrengthManager seekerStrengthManager;

    public GameManager(@NotNull Plugin plugin, @NotNull ConfigManager configManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(configManager, "configManager");
        this.plugin = plugin;
        this.configManager = configManager;
        this.waitingPlayers = new ArrayList();
    }

    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Nullable
    public final Game getActiveGame() {
        return this.activeGame;
    }

    @Nullable
    public final ShopManager getShopManager() {
        return this.shopManager;
    }

    public final void setShopManager(@Nullable ShopManager shopManager) {
        this.shopManager = shopManager;
    }

    @Nullable
    public final DisguiseManager getDisguiseManager() {
        return this.disguiseManager;
    }

    public final void setDisguiseManager(@Nullable DisguiseManager disguiseManager) {
        this.disguiseManager = disguiseManager;
    }

    @Nullable
    public final MessageManager getMessageManager() {
        return this.messageManager;
    }

    public final void setMessageManager(@Nullable MessageManager messageManager) {
        this.messageManager = messageManager;
    }

    @Nullable
    public final PointManager getPointManager() {
        return this.pointManager;
    }

    public final void setPointManager(@Nullable PointManager pointManager) {
        this.pointManager = pointManager;
    }

    @Nullable
    public final ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public final void setArenaManager(@Nullable ArenaManager arenaManager) {
        this.arenaManager = arenaManager;
    }

    @Nullable
    public final GameScoreboard getGameScoreboard() {
        return this.gameScoreboard;
    }

    public final void setGameScoreboard(@Nullable GameScoreboard gameScoreboard) {
        this.gameScoreboard = gameScoreboard;
    }

    @Nullable
    public final LocalizedScoreboardManager getLocalizedScoreboard() {
        return this.localizedScoreboard;
    }

    public final void setLocalizedScoreboard(@Nullable LocalizedScoreboardManager localizedScoreboardManager) {
        this.localizedScoreboard = localizedScoreboardManager;
    }

    @Nullable
    public final SeekerStrengthManager getSeekerStrengthManager() {
        return this.seekerStrengthManager;
    }

    public final void setSeekerStrengthManager(@Nullable SeekerStrengthManager seekerStrengthManager) {
        this.seekerStrengthManager = seekerStrengthManager;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean joinGame(@NotNull Player player) {
        Object $this$mapNotNull$iv2;
        SpectatorManager spectatorManager;
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        Plugin plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SpectatorManager spectatorManager2 = spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
        boolean bl = spectatorManager2 != null ? spectatorManager2.isSpectator(uuid) : false;
        if (bl) {
            MessageManager messageManager = this.messageManager;
            if (messageManager != null) {
                messageManager.send(player, "game.spectator.enabled_warning", new Object[0]);
            }
            MessageManager messageManager2 = this.messageManager;
            if (messageManager2 != null) {
                messageManager2.send(player, "game.spectator.wait_list_notice", new Object[0]);
            }
        }
        if (this.waitingPlayers.contains(uuid)) {
            MessageManager messageManager = this.messageManager;
            if (messageManager != null) {
                messageManager.send(player, "player.already_in_game", new Object[0]);
            }
            return false;
        }
        Game game = this.activeGame;
        if (game != null) {
            PlayerGameData playerData;
            if (game.getPlayers().containsKey(uuid)) {
                Object object;
                PlayerGameData playerGameData = game.getPlayers().get(uuid);
                Intrinsics.checkNotNull(playerGameData);
                playerData = playerGameData;
                if (playerData.getRole() == PlayerRole.SEEKER) {
                    object = this.messageManager;
                    if (object == null || (object = object.getMessage(player, "ui.scoreboard.role.seeker", new Object[0])) == null) {
                        object = "&cSeeker";
                    }
                } else {
                    object = this.messageManager;
                    if (object == null || (object = object.getMessage(player, "ui.scoreboard.role.hider", new Object[0])) == null) {
                        object = "&aHider";
                    }
                }
                Object roleName = object;
                MessageManager messageManager = this.messageManager;
                if (messageManager != null) {
                    Object[] objectArray = new Object[]{roleName};
                    messageManager.send(player, "player.join.rejoin", objectArray);
                }
                Location spawn = GameManager.getRandomSpawnLocation$default(this, game.getArena(), null, 0, 6, null);
                player.teleport(spawn);
                LocalizedScoreboardManager localizedScoreboardManager = this.localizedScoreboard;
                if (localizedScoreboardManager != null) {
                    localizedScoreboardManager.addPlayer(player, game);
                }
                player.getInventory().clear();
                this.giveShopItemToPlayer(player);
                switch (WhenMappings.$EnumSwitchMapping$0[playerData.getRole().ordinal()]) {
                    case 1: {
                        MessageManager messageManager3 = this.messageManager;
                        if (messageManager3 != null) {
                            MessageManager.sendTitle$default(messageManager3, player, "game.role.title.seeker", "game.role.subtitle.rejoined", null, null, null, new Object[0], 56, null);
                        }
                        break;
                    }
                    case 2: {
                        if (playerData.isCaptured()) {
                            MessageManager messageManager4 = this.messageManager;
                            if (messageManager4 != null) {
                                MessageManager.sendTitle$default(messageManager4, player, "game.role.title.spectator", "game.role.subtitle.spectator", null, null, null, new Object[0], 56, null);
                            }
                            player.setGameMode(GameMode.SPECTATOR);
                            break;
                        }
                        MessageManager messageManager5 = this.messageManager;
                        if (messageManager5 == null) break;
                        MessageManager.sendTitle$default(messageManager5, player, "game.role.title.hider", "game.role.subtitle.rejoined", null, null, null, new Object[0], 56, null);
                        break;
                    }
                }
                return true;
            }
            playerData = new PlayerGameData(uuid, PlayerRole.HIDER, false, 0, null, null, 0, 0, 252, null);
            playerData.setBackup(PlayerBackup.Companion.create(player));
            game.getPlayers().put(uuid, playerData);
            player.getInventory().clear();
            player.teleport(GameManager.getRandomSpawnLocation$default(this, game.getArena(), null, 0, 6, null));
            this.giveShopItemToPlayer(player);
            LocalizedScoreboardManager localizedScoreboardManager = this.localizedScoreboard;
            if (localizedScoreboardManager != null) {
                localizedScoreboardManager.addPlayer(player, game);
            }
            MessageManager messageManager = this.messageManager;
            if (messageManager != null) {
                messageManager.send(player, "player.join.mid_game", new Object[0]);
            }
            MessageManager messageManager6 = this.messageManager;
            if (messageManager6 != null) {
                void $this$mapNotNullTo$iv$iv;
                Object[] $this$mapNotNull$iv2;
                Iterable spawn = game.getPlayers().keySet();
                MessageManager messageManager7 = messageManager6;
                boolean $i$f$mapNotNull = false;
                void var9_16 = $this$mapNotNull$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Player it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    UUID it = (UUID)element$iv$iv;
                    boolean bl3 = false;
                    if (Bukkit.getPlayer((UUID)it) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Collection collection = (List)destination$iv$iv;
                $this$mapNotNull$iv2 = new Object[1];
                Intrinsics.checkNotNullExpressionValue(player.getName(), "getName(...)");
                messageManager7.broadcast(collection, "player.join.mid_game_broadcast", $this$mapNotNull$iv2);
            }
            MessageManager messageManager8 = this.messageManager;
            if (messageManager8 != null) {
                MessageManager.sendTitle$default(messageManager8, player, "game.role.title.hider", "game.role.subtitle.hider_midjoin", null, null, null, new Object[0], 56, null);
            }
            return true;
        }
        this.waitingPlayers.add(uuid);
        int count = this.waitingPlayers.size();
        MessageManager messageManager = this.messageManager;
        if (messageManager != null) {
            $this$mapNotNull$iv2 = new Object[]{String.valueOf(count)};
            messageManager.send(player, "player.join.waiting", $this$mapNotNull$iv2);
        }
        MessageManager messageManager9 = this.messageManager;
        if (messageManager9 != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            $this$mapNotNull$iv2 = this.waitingPlayers;
            MessageManager messageManager10 = messageManager9;
            boolean $i$f$mapNotNull = false;
            Object[] $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Object[] $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Player it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl5 = false;
                UUID it = (UUID)element$iv$iv;
                boolean bl6 = false;
                if (Bukkit.getPlayer((UUID)it) == null) continue;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv2 = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Player it = (Player)element$iv$iv;
                boolean bl8 = false;
                if (!(!Intrinsics.areEqual(it.getUniqueId(), uuid))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue(player.getName(), "getName(...)");
            objectArray[1] = String.valueOf(count);
            messageManager10.broadcast(collection, "player.join.waiting_broadcast", objectArray);
        }
        this.checkAutoStart();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean leaveGame(@NotNull Player player) {
        block8: {
            Intrinsics.checkNotNullParameter(player, "player");
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            UUID uuid = uUID;
            if (this.waitingPlayers.remove(uuid)) {
                MessageManager messageManager = this.messageManager;
                if (messageManager != null) {
                    messageManager.send(player, "player.leave", new Object[0]);
                }
                MessageManager messageManager2 = this.messageManager;
                if (messageManager2 != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Object[] $this$mapNotNull$iv;
                    Iterable iterable = this.waitingPlayers;
                    MessageManager messageManager3 = messageManager2;
                    boolean $i$f$mapNotNull = false;
                    void var6_7 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Player it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        UUID it = (UUID)element$iv$iv;
                        boolean bl2 = false;
                        if (Bukkit.getPlayer((UUID)it) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Collection collection = (List)destination$iv$iv;
                    $this$mapNotNull$iv = new Object[2];
                    Intrinsics.checkNotNullExpressionValue(player.getName(), "getName(...)");
                    $this$mapNotNull$iv[1] = String.valueOf(this.waitingPlayers.size());
                    messageManager3.broadcast(collection, "player.leave.broadcast", $this$mapNotNull$iv);
                }
                return true;
            }
            Game game = this.activeGame;
            if (game != null && game.getPlayers().containsKey(uuid)) {
                PlayerGameData playerGameData = game.getPlayers().get(uuid);
                Intrinsics.checkNotNull(playerGameData);
                PlayerGameData playerData = playerGameData;
                PlayerBackup playerBackup = playerData.getBackup();
                if (playerBackup != null) {
                    playerBackup.restore(player);
                }
                MessageManager messageManager = this.messageManager;
                if (messageManager != null) {
                    messageManager.send(player, "player.leave", new Object[0]);
                }
                MessageManager messageManager4 = this.messageManager;
                if (messageManager4 != null) {
                    messageManager4.send(player, "player.leave.can_rejoin", new Object[0]);
                }
                return true;
            }
            MessageManager messageManager = this.messageManager;
            if (messageManager == null) break block8;
            messageManager.send(player, "error.not_in_game", new Object[0]);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Game startGame(@NotNull Arena arena) {
        Game game;
        void $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        List list;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(arena, "arena");
        if (this.activeGame != null) {
            return null;
        }
        Plugin plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SpectatorManager spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
        List spectatorPlayers = new ArrayList();
        if (this.configManager.isForceJoinAllPlayers()) {
            Iterable $this$filter$iv = this.waitingPlayers;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                boolean isSpectator;
                Object element$iv$iv = iterator2.next();
                UUID uuid = (UUID)element$iv$iv;
                boolean bl = false;
                SpectatorManager spectatorManager2 = spectatorManager;
                boolean bl2 = isSpectator = spectatorManager2 != null ? spectatorManager2.isSpectator(uuid) : false;
                if (isSpectator) {
                    spectatorPlayers.add(uuid);
                }
                if (!(!isSpectator)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.toList((Iterable)this.waitingPlayers);
        }
        List activePlayers = list;
        Iterable $this$forEach$iv = spectatorPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$startGame_u24lambda_u241_u240_u240;
            Location bl;
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl3 = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl4 = false;
            MessageManager messageManager = this.messageManager;
            if (messageManager != null) {
                messageManager.send(player, "game.spectator.start_notice", new Object[0]);
            }
            MessageManager messageManager2 = this.messageManager;
            if (messageManager2 != null) {
                messageManager2.send(player, "game.spectator.start_how_to_join", new Object[0]);
            }
            SpectatorManager spectatorManager3 = spectatorManager;
            if (spectatorManager3 != null) {
                spectatorManager3.applySpectatorMode(player);
            }
            Location isSpectator = bl = arena.getBoundaries().getCenter();
            Player player2 = player;
            boolean bl5 = false;
            $this$startGame_u24lambda_u241_u240_u240.setY(arena.getBoundaries().getCenter().getY() + (double)10);
            player2.teleport(bl);
        }
        int minPlayers = this.configManager.getMinPlayers();
        if (activePlayers.size() < minPlayers) {
            if (!((Collection)this.waitingPlayers).isEmpty() && activePlayers.isEmpty()) {
                MessageManager messageManager = this.messageManager;
                if (messageManager != null) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    $this$filterTo$iv$iv = this.waitingPlayers;
                    MessageManager messageManager3 = messageManager;
                    boolean $i$f$mapNotNull = false;
                    void uuid = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    Iterator $this$startGame_u24lambda_u241_u240_u240 = $this$forEach$iv$iv$iv.iterator();
                    while ($this$startGame_u24lambda_u241_u240_u240.hasNext()) {
                        Player it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = $this$startGame_u24lambda_u241_u240_u240.next();
                        boolean bl = false;
                        UUID it = (UUID)element$iv$iv;
                        boolean bl6 = false;
                        if (Bukkit.getPlayer((UUID)it) == null) continue;
                        boolean bl7 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    messageManager3.broadcast((List)destination$iv$iv, "error.min_players_spectators_only", new Object[0]);
                }
            }
            return null;
        }
        Iterable $this$map$iv = activePlayers;
        boolean $i$f$map = false;
        Iterable $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void uuid;
            UUID $this$startGame_u24lambda_u241_u240_u240 = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(uuid, new PlayerGameData((UUID)uuid, PlayerRole.HIDER, false, 0, null, null, 0, 0, 252, null)));
        }
        Map players = MapsKt.toMutableMap(MapsKt.toMap((List)destination$iv$iv));
        this.activeGame = game = new Game(null, arena, GamePhase.WAITING, players, System.currentTimeMillis(), System.currentTimeMillis(), null, null, 0L, null, null, 1985, null);
        this.waitingPlayers.clear();
        this.assignRoles(game);
        this.backupPlayers(game);
        this.teleportPlayers(game);
        this.clearPlayerInventories(game);
        this.giveShopItems(game);
        this.applyWorldBorder(game);
        this.setupWorldTime(game);
        this.setupTeams(game);
        this.startPreparationPhase(game);
        this.applySpectatorModeToSpectators(game);
        return game;
    }

    private final void applySpectatorModeToSpectators(Game game) {
        Plugin plugin = this.plugin;
        Object object = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        if (object == null || (object = object.getSpectatorManager()) == null) {
            return;
        }
        HideAndSeekPlugin spectatorManager = object;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            if (!((SpectatorManager)((Object)spectatorManager)).isSpectator(uUID) || game.getPlayers().containsKey(player.getUniqueId())) continue;
            Intrinsics.checkNotNull(player);
            ((SpectatorManager)((Object)spectatorManager)).applySpectatorMode(player);
            MessageUtil.INSTANCE.send((CommandSender)player, "&e\u89b3\u6226\u30e2\u30fc\u30c9\u3067\u30b2\u30fc\u30e0\u3092\u89b3\u6226\u3057\u3066\u3044\u307e\u3059");
        }
    }

    public final void assignRoles(@NotNull Game game) {
        block0: {
            Intrinsics.checkNotNullParameter(game, "game");
            List playerList = CollectionsKt.toList((Iterable)game.getPlayers().keySet());
            UUID seekerUuid = (UUID)CollectionsKt.random(playerList, Random.Default);
            PlayerGameData playerGameData = game.getPlayers().get(seekerUuid);
            if (playerGameData == null) break block0;
            playerGameData.setRole(PlayerRole.SEEKER);
        }
    }

    private final void setupTeams(Game game) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        Team team = mainScoreboard.getTeam("hs_seekers");
        if (team != null) {
            team.unregister();
        }
        Team team2 = mainScoreboard.getTeam("hs_hiders");
        if (team2 != null) {
            team2.unregister();
        }
        Team team3 = mainScoreboard.getTeam("hs_spectators");
        if (team3 != null) {
            team3.unregister();
        }
        Team team4 = mainScoreboard.registerNewTeam("hs_seekers");
        Intrinsics.checkNotNullExpressionValue(team4, "registerNewTeam(...)");
        Team seekerTeam = team4;
        seekerTeam.setColor(ChatColor.RED);
        seekerTeam.setPrefix("\u00a7c");
        seekerTeam.setSuffix("");
        seekerTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
        Team team5 = mainScoreboard.registerNewTeam("hs_hiders");
        Intrinsics.checkNotNullExpressionValue(team5, "registerNewTeam(...)");
        Team hiderTeam = team5;
        hiderTeam.setColor(ChatColor.GREEN);
        hiderTeam.setPrefix("\u00a7a");
        hiderTeam.setSuffix("");
        hiderTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        Team team6 = mainScoreboard.registerNewTeam("hs_spectators");
        Intrinsics.checkNotNullExpressionValue(team6, "registerNewTeam(...)");
        Team spectatorTeam = team6;
        spectatorTeam.setColor(ChatColor.GRAY);
        spectatorTeam.setPrefix("\u00a77");
        spectatorTeam.setSuffix("");
        spectatorTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Plugin plugin = $this$forEach$iv.entrySet().iterator();
        while (plugin.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = plugin.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            PlayerGameData playerData = entry.getValue();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            if (!Intrinsics.areEqual(player.getScoreboard(), mainScoreboard)) {
                player.setScoreboard(mainScoreboard);
            }
            Intrinsics.checkNotNullExpressionValue(player.getName(), "getName(...)");
            switch (WhenMappings.$EnumSwitchMapping$0[playerData.getRole().ordinal()]) {
                case 1: {
                    String playerName;
                    seekerTeam.addEntry(playerName);
                    break;
                }
                case 2: {
                    String playerName;
                    hiderTeam.addEntry(playerName);
                    break;
                }
                case 3: {
                    String playerName;
                    spectatorTeam.addEntry(playerName);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SpectatorManager spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv2 = collection;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            boolean bl;
            Player player = (Player)element$iv;
            boolean bl3 = false;
            SpectatorManager spectatorManager2 = spectatorManager;
            if (spectatorManager2 != null) {
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                bl = spectatorManager2.isSpectator(uUID);
            } else {
                bl = false;
            }
            if (!bl || game.getPlayers().containsKey(player.getUniqueId())) continue;
            if (!Intrinsics.areEqual(player.getScoreboard(), mainScoreboard)) {
                player.setScoreboard(mainScoreboard);
            }
            spectatorTeam.addEntry(player.getName());
        }
    }

    private final void cleanupTeams(Game game) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        String[] stringArray = new String[]{"hs_seekers", "hs_hiders", "hs_spectators"};
        List<String> teamNames = CollectionsKt.listOf(stringArray);
        Iterable $this$forEach$iv = teamNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Team team;
            String teamName = (String)element$iv;
            boolean bl = false;
            if (mainScoreboard.getTeam(teamName) == null) continue;
            boolean bl2 = false;
            Set set = team.getEntries();
            Intrinsics.checkNotNullExpressionValue(set, "getEntries(...)");
            Iterable $this$forEach$iv2 = CollectionsKt.toList(set);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String entry = (String)element$iv2;
                boolean bl3 = false;
                team.removeEntry(entry);
            }
            team.unregister();
        }
        $this$forEach$iv = game.getPlayers().keySet();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl4 = false;
            if (Intrinsics.areEqual(player.getScoreboard(), mainScoreboard)) continue;
            player.setScoreboard(mainScoreboard);
        }
    }

    private final void setupWorldTime(Game game) {
        World world = game.getArena().getWorld();
        world.setTime(1000L);
        int taskId = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> GameManager.setupWorldTime$lambda$0(world), 200L, 200L).getTaskId();
        game.setNightSkipTaskId(taskId);
    }

    private final void backupPlayers(Game game) {
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            PlayerGameData playerData = entry.getValue();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            playerData.setBackup(PlayerBackup.Companion.create(player));
            if (player.isDead()) {
                player.spigot().respawn();
            }
            player.getInventory().clear();
            player.setGameMode(GameMode.SURVIVAL);
            Collection collection = player.getActivePotionEffects();
            Intrinsics.checkNotNullExpressionValue(collection, "getActivePotionEffects(...)");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PotionEffect effect = (PotionEffect)element$iv2;
                boolean bl3 = false;
                player.removePotionEffect(effect.getType());
            }
            player.setHealth(player.getMaxHealth());
            player.setFoodLevel(20);
            player.setSaturation(20.0f);
        }
    }

    private final void teleportPlayers(Game game) {
        Set usedLocations = new LinkedHashSet();
        int minDistance = 5;
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            Location spawn = this.getRandomSpawnLocation(game.getArena(), usedLocations, minDistance);
            player.teleport(spawn);
            usedLocations.add(new Pair<Integer, Integer>(spawn.getBlockX(), spawn.getBlockZ()));
        }
    }

    @NotNull
    public final Location getRandomSpawnLocation(@NotNull Arena arena, @NotNull Set<Pair<Integer, Integer>> usedLocations, int minDistance) {
        Intrinsics.checkNotNullParameter(arena, "arena");
        Intrinsics.checkNotNullParameter(usedLocations, "usedLocations");
        Location center = arena.getBoundaries().getCenter();
        double diameter = arena.getBoundaries().getSize();
        double radius = diameter / 2.0;
        double maxOffset = radius * 0.5;
        World world = arena.getWorld();
        int attempts = 0;
        int maxAttempts = 50;
        while (attempts < maxAttempts) {
            Integer safeY;
            boolean isFarEnough;
            int spawnZ;
            int spawnX;
            block6: {
                double offsetX = Math.random() * maxOffset * (double)2 - maxOffset;
                double offsetZ = Math.random() * maxOffset * (double)2 - maxOffset;
                spawnX = (int)((double)center.getBlockX() + offsetX);
                spawnZ = (int)((double)center.getBlockZ() + offsetZ);
                Location testLocation = new Location(world, (double)spawnX + 0.5, center.getY(), (double)spawnZ + 0.5);
                double distanceFromCenter = testLocation.distance(center);
                if (distanceFromCenter > maxOffset) {
                    ++attempts;
                    continue;
                }
                Iterable $this$all$iv = usedLocations;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    v0 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl = false;
                        int usedX = ((Number)pair.component1()).intValue();
                        int usedZ = ((Number)pair.component2()).intValue();
                        double distance = Math.sqrt((spawnX - usedX) * (spawnX - usedX) + (spawnZ - usedZ) * (spawnZ - usedZ));
                        if (distance >= (double)minDistance) continue;
                        v0 = false;
                        break block6;
                    }
                    v0 = isFarEnough = true;
                }
            }
            if (isFarEnough && (safeY = this.findSafeGroundY(world, spawnX, spawnZ)) != null) {
                Location spawnLocation = new Location(world, (double)spawnX + 0.5, (double)safeY.intValue(), (double)spawnZ + 0.5, 0.0f, 0.0f);
                return spawnLocation;
            }
            ++attempts;
        }
        this.plugin.getLogger().warning("[Spawn] Could not find safe spawn location after " + maxAttempts + " attempts, using center");
        Integer n = this.findSafeGroundY(world, center.getBlockX(), center.getBlockZ());
        int safeY = n != null ? n : world.getHighestBlockYAt(center.getBlockX(), center.getBlockZ()) + 1;
        return new Location(world, (double)center.getBlockX() + 0.5, (double)safeY, (double)center.getBlockZ() + 0.5, 0.0f, 0.0f);
    }

    public static /* synthetic */ Location getRandomSpawnLocation$default(GameManager gameManager, Arena arena, Set set, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n2 & 4) != 0) {
            n = 5;
        }
        return gameManager.getRandomSpawnLocation(arena, set, n);
    }

    private final Integer findSafeGroundY(World world, int x, int z) {
        int highestY = world.getHighestBlockYAt(x, z);
        for (int yOffset = 0; yOffset < 6; ++yOffset) {
            Block headBlock;
            Block feetBlock;
            Block groundBlock;
            int y = highestY - yOffset;
            if (y < world.getMinHeight()) continue;
            Intrinsics.checkNotNullExpressionValue(world.getBlockAt(x, y, z), "getBlockAt(...)");
            Intrinsics.checkNotNullExpressionValue(world.getBlockAt(x, y + 1, z), "getBlockAt(...)");
            Intrinsics.checkNotNullExpressionValue(world.getBlockAt(x, y + 2, z), "getBlockAt(...)");
            if (!groundBlock.getType().isSolid()) continue;
            Material material = groundBlock.getType();
            Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
            if (this.isDangerousBlock(material)) continue;
            Material material2 = feetBlock.getType();
            Intrinsics.checkNotNullExpressionValue(material2, "getType(...)");
            if (!this.isSafeAir(material2)) continue;
            Material material3 = headBlock.getType();
            Intrinsics.checkNotNullExpressionValue(material3, "getType(...)");
            if (!this.isSafeAir(material3)) continue;
            Material material4 = groundBlock.getType();
            Intrinsics.checkNotNullExpressionValue(material4, "getType(...)");
            if (this.isUnstableBlock(material4)) continue;
            return y + 1;
        }
        this.plugin.getLogger().warning("[Safe Ground] No safe ground found at (" + x + ", " + z + ") near highest block Y=" + highestY);
        return null;
    }

    private final boolean isUnstableBlock(Material material) {
        return StringsKt.contains$default((CharSequence)material.name(), "LEAVES", false, 2, null) ? true : (StringsKt.contains$default((CharSequence)material.name(), "GLASS_PANE", false, 2, null) ? true : (StringsKt.contains$default((CharSequence)material.name(), "IRON_BARS", false, 2, null) ? true : (material == Material.SCAFFOLDING ? true : (material == Material.SNOW ? true : material == Material.POWDER_SNOW))));
    }

    private final boolean isDangerousBlock(Material material) {
        return switch (WhenMappings.$EnumSwitchMapping$1[material.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7 -> true;
            default -> false;
        };
    }

    private final boolean isSafeAir(Material material) {
        return switch (WhenMappings.$EnumSwitchMapping$1[material.ordinal()]) {
            case 8, 9, 10 -> true;
            default -> false;
        };
    }

    @Deprecated(message="Use isSafeAir for spawn checking")
    private final boolean isPassableBlock(Material material) {
        return material.isAir() || !material.isSolid();
    }

    private final void clearPlayerInventories(Game game) {
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            player.getInventory().clear();
            player.getInventory().setArmorContents(new ItemStack[4]);
            player.getInventory().setItemInOffHand(null);
        }
    }

    private final void giveShopItems(Game game) {
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this.giveShopItemToPlayer(player);
        }
    }

    public final void giveShopItemToPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        ShopManager shopManager = this.shopManager;
        if (shopManager == null) {
            return;
        }
        ShopManager shopMgr = shopManager;
        ConfigurationSection shopConfig = this.configManager.getShop().getConfigurationSection("shop");
        if (shopConfig == null) {
            return;
        }
        ShopConfig config = new ShopConfig(shopConfig);
        int slot = config.getShopItemSlot();
        ItemStack shopItem = shopMgr.createShopItem();
        player.getInventory().setItem(slot, shopItem);
    }

    public final void handleCapture(@NotNull Player capturer, @NotNull Player captured) {
        Intrinsics.checkNotNullParameter(capturer, "capturer");
        Intrinsics.checkNotNullParameter(captured, "captured");
        Game game = this.activeGame;
        if (game == null) {
            return;
        }
        Game game2 = game;
        PlayerGameData playerGameData = game2.getPlayers().get(captured.getUniqueId());
        if (playerGameData == null) {
            return;
        }
        PlayerGameData capturedData = playerGameData;
        switch (WhenMappings.$EnumSwitchMapping$2[this.configManager.getCaptureMode().ordinal()]) {
            case 1: {
                Team mainHiderTeam;
                capturedData.setRole(PlayerRole.SPECTATOR);
                captured.setGameMode(GameMode.SPECTATOR);
                Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
                Scoreboard mainScoreboard = scoreboard;
                Team mainSpectatorTeam = mainScoreboard.getTeam("hs_spectators");
                Team team = mainHiderTeam = mainScoreboard.getTeam("hs_hiders");
                if (team != null) {
                    team.removeEntry(captured.getName());
                }
                Team team2 = mainSpectatorTeam;
                if (team2 != null) {
                    team2.addEntry(captured.getName());
                }
                Iterable $this$forEach$iv = game2.getPlayers().keySet();
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Team hiderTeam;
                    Scoreboard playerScoreboard;
                    Player player;
                    UUID uuid = (UUID)element$iv;
                    boolean bl = false;
                    if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(player.getScoreboard(), "getScoreboard(...)");
                    if (Intrinsics.areEqual(playerScoreboard, mainScoreboard)) continue;
                    Team spectatorTeam = playerScoreboard.getTeam("hs_spectators");
                    Team team3 = hiderTeam = playerScoreboard.getTeam("hs_hiders");
                    if (team3 != null) {
                        team3.removeEntry(captured.getName());
                    }
                    Team team4 = spectatorTeam;
                    if (team4 == null) continue;
                    team4.addEntry(captured.getName());
                }
                MessageManager messageManager = this.messageManager;
                if (messageManager != null) {
                    Object[] $i$f$forEach2 = new Object[1];
                    Intrinsics.checkNotNullExpressionValue(capturer.getName(), "getName(...)");
                    messageManager.send(captured, "game.spectator.captured_spectator", $i$f$forEach2);
                }
                break;
            }
            case 2: {
                Team mainHiderTeam;
                capturedData.setRole(PlayerRole.SEEKER);
                capturedData.setCaptured(false);
                Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
                Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
                Scoreboard mainScoreboard = scoreboard;
                Team mainSeekerTeam = mainScoreboard.getTeam("hs_seekers");
                Team team = mainHiderTeam = mainScoreboard.getTeam("hs_hiders");
                if (team != null) {
                    team.removeEntry(captured.getName());
                }
                Team team5 = mainSeekerTeam;
                if (team5 != null) {
                    team5.addEntry(captured.getName());
                }
                Iterable $this$forEach$iv = game2.getPlayers().keySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Team hiderTeam;
                    Scoreboard playerScoreboard;
                    Player player;
                    UUID uuid = (UUID)element$iv;
                    boolean bl = false;
                    if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue(player.getScoreboard(), "getScoreboard(...)");
                    if (Intrinsics.areEqual(playerScoreboard, mainScoreboard)) continue;
                    Team seekerTeam = playerScoreboard.getTeam("hs_seekers");
                    Team team6 = hiderTeam = playerScoreboard.getTeam("hs_hiders");
                    if (team6 != null) {
                        team6.removeEntry(captured.getName());
                    }
                    Team team7 = seekerTeam;
                    if (team7 == null) continue;
                    team7.addEntry(captured.getName());
                }
                this.giveShopItemToPlayer(captured);
                MessageManager messageManager = this.messageManager;
                if (messageManager != null) {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue(capturer.getName(), "getName(...)");
                    messageManager.send(captured, "game.spectator.captured_infection", objectArray);
                }
                MessageManager messageManager2 = this.messageManager;
                if (messageManager2 != null) {
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue(captured.getName(), "getName(...)");
                    messageManager2.send(capturer, "game.capture.success_infection", objectArray);
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void revertSeekerToHider(@NotNull Player seeker, @NotNull PlayerGameData seekerData, @NotNull Game game) {
        EffectManagerImpl effectManager;
        int n;
        Intrinsics.checkNotNullParameter(seeker, "seeker");
        Intrinsics.checkNotNullParameter(seekerData, "seekerData");
        Intrinsics.checkNotNullParameter(game, "game");
        seekerData.setRole(PlayerRole.HIDER);
        seekerData.setCaptured(false);
        SeekerStrengthManager seekerStrengthManager = this.seekerStrengthManager;
        if (seekerStrengthManager != null) {
            UUID uUID = seeker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            n = seekerStrengthManager.getStrength(uUID);
        } else {
            n = 0;
        }
        int previousStrength = n;
        SeekerStrengthManager seekerStrengthManager2 = this.seekerStrengthManager;
        if (seekerStrengthManager2 != null) {
            UUID uUID = seeker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            seekerStrengthManager2.resetStrength(uUID);
        }
        int hiderPoints = seekerData.getHiderPoints();
        PointManager pointManager = this.pointManager;
        if (pointManager != null) {
            UUID uUID = seeker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            pointManager.setPoints(uUID, hiderPoints);
        }
        Plugin plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        EffectManagerImpl effectManagerImpl = effectManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getEffectManager() : null;
        if (effectManagerImpl != null) {
            UUID uUID = seeker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            effectManagerImpl.removeAllEffects(uUID);
        }
        this.updateTeamForReversion(seeker, game);
        Location spawnLocation = GameManager.getRandomSpawnLocation$default(this, game.getArena(), null, 0, 6, null);
        seeker.teleport(spawnLocation);
        seeker.getInventory().clear();
        this.giveShopItemToPlayer(seeker);
        MessageManager messageManager = this.messageManager;
        if (messageManager != null) {
            messageManager.send(seeker, "game.seeker.reverted", new Object[0]);
        }
        MessageManager messageManager2 = this.messageManager;
        if (messageManager2 != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            Object[] objectArray = (Object[])game.getPlayers().keySet();
            MessageManager messageManager3 = messageManager2;
            boolean $i$f$mapNotNull = false;
            void var11_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Player it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                UUID it = (UUID)element$iv$iv;
                boolean bl2 = false;
                if (Bukkit.getPlayer((UUID)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapNotNullTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Player it = (Player)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it.getUniqueId(), seeker.getUniqueId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue(seeker.getName(), "getName(...)");
            objectArray[1] = "";
            messageManager3.broadcast(collection, "game.seeker.pk.broadcast_reversion", objectArray);
        }
        seeker.playSound(seeker.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        seeker.getWorld().spawnParticle(Particle.ENCHANT, seeker.getLocation(), 50, 0.5, 1.0, 0.5);
    }

    private final void updateTeamForReversion(Player player, Game game) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        Team seekerTeam = mainScoreboard.getTeam("hs_seekers");
        Team hiderTeam = mainScoreboard.getTeam("hs_hiders");
        Team team = seekerTeam;
        if (team != null) {
            team.removeEntry(player.getName());
        }
        Team team2 = hiderTeam;
        if (team2 != null) {
            team2.addEntry(player.getName());
        }
        Iterable $this$forEach$iv = game.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scoreboard playerScoreboard;
            Player otherPlayer;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(otherPlayer.getScoreboard(), "getScoreboard(...)");
            if (Intrinsics.areEqual(playerScoreboard, mainScoreboard)) continue;
            Team otherSeekerTeam = playerScoreboard.getTeam("hs_seekers");
            Team otherHiderTeam = playerScoreboard.getTeam("hs_hiders");
            Team team3 = otherSeekerTeam;
            if (team3 != null) {
                team3.removeEntry(player.getName());
            }
            Team team4 = otherHiderTeam;
            if (team4 == null) continue;
            team4.addEntry(player.getName());
        }
    }

    private final void applyWorldBorder(Game game) {
        World world = game.getArena().getWorld();
        game.setWorldBorderBackup(WorldBorderBackup.Companion.capture(world));
        WorldBorder worldBorder = world.getWorldBorder();
        Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
        WorldBorder worldBorder2 = worldBorder;
        ArenaBoundaries boundaries = game.getArena().getBoundaries();
        Location center = boundaries.getCenter();
        double size = Math.max(boundaries.getWidth(), boundaries.getDepth());
        worldBorder2.setCenter(center);
        worldBorder2.setSize(size);
        worldBorder2.setWarningDistance(5);
        worldBorder2.setDamageAmount(0.2);
        worldBorder2.setDamageBuffer(0.0);
    }

    /*
     * WARNING - void declaration
     */
    private final void startPreparationPhase(Game game) {
        game.setPhase(GamePhase.PREPARATION);
        game.setPhaseStartTime(System.currentTimeMillis());
        LocalizedScoreboardManager localizedScoreboardManager = this.localizedScoreboard;
        if (localizedScoreboardManager != null) {
            localizedScoreboardManager.startUpdating(game);
        }
        MessageManager msgMgr = this.messageManager;
        if (msgMgr != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = game.getPlayers().keySet();
            boolean $i$f$mapNotNull = false;
            Iterator iterator2 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Player it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl = false;
                UUID it = (UUID)element$iv$iv;
                boolean bl2 = false;
                if (Bukkit.getPlayer((UUID)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List allPlayers = (List)destination$iv$iv;
            Iterable $this$forEach$iv = game.getSeekers();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player;
                UUID uuid = (UUID)element$iv;
                boolean bl = false;
                if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                boolean bl4 = false;
                player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 300, 1, false, false));
                player.setSendViewDistance(0);
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 300, 255, false, false));
                player.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 300, 255, false, false));
                msgMgr.send(player, "game.seeker.you_are_seeker", new Object[0]);
                msgMgr.send(player, "game.seeker.cannot_move", new Object[0]);
                Duration duration = Duration.ofMillis(500L);
                Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
                Duration duration2 = Duration.ofMillis(3000L);
                Intrinsics.checkNotNullExpressionValue(duration2, "ofMillis(...)");
                Duration duration3 = Duration.ofMillis(500L);
                Intrinsics.checkNotNullExpressionValue(duration3, "ofMillis(...)");
                msgMgr.sendTitle(player, "game.role.title.seeker", "game.role.subtitle.seeker", duration, duration2, duration3, new Object[0]);
            }
            $this$forEach$iv = game.getHiders();
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player;
                UUID uuid = (UUID)element$iv;
                boolean bl = false;
                if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                boolean bl5 = false;
                Duration duration = Duration.ofMillis(500L);
                Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
                Duration duration4 = Duration.ofMillis(3000L);
                Intrinsics.checkNotNullExpressionValue(duration4, "ofMillis(...)");
                Duration duration5 = Duration.ofMillis(500L);
                Intrinsics.checkNotNullExpressionValue(duration5, "ofMillis(...)");
                msgMgr.sendTitle(player, "game.role.title.hider", "game.role.subtitle.hider", duration, duration4, duration5, new Object[0]);
            }
            msgMgr.broadcast(allPlayers, "game.phase.preparation.broadcast", new Object[0]);
            Object[] objectArray = new Object[]{this.configManager.getPreparationTime()};
            msgMgr.broadcast(allPlayers, "game.phase.preparation.duration", objectArray);
        }
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> GameManager.startPreparationPhase$lambda$3(this, game), 300L);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> GameManager.startPreparationPhase$lambda$4(this, game), (long)(this.configManager.getPreparationTime() * 20));
    }

    private final void startSeekPhase(Game game) {
        Iterator $this$mapNotNullTo$iv$iv;
        game.setPhase(GamePhase.SEEKING);
        game.setPhaseStartTime(System.currentTimeMillis());
        MessageManager msgMgr = this.messageManager;
        Iterable $this$mapNotNull$iv = game.getPlayers().keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (Bukkit.getPlayer((UUID)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List allPlayers = (List)destination$iv$iv;
        MessageManager messageManager = msgMgr;
        if (messageManager != null) {
            messageManager.broadcast(allPlayers, "game.phase.seeking.broadcast", new Object[0]);
        }
        Iterable $this$forEach$iv = game.getSeekers();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl4 = false;
            player.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, Integer.MAX_VALUE, 0, false, false, false));
            MessageManager messageManager2 = msgMgr;
            if (messageManager2 == null) continue;
            messageManager2.send(player, "game.seeker.vision_restricted", new Object[0]);
        }
        double pointsPerSecond = this.configManager.getConfig().getDouble("points.points-per-second", 1.0);
        int accumulationInterval = this.configManager.getConfig().getInt("points.accumulation-interval", 15);
        PointManager pointManager = this.pointManager;
        if (pointManager != null) {
            pointManager.startPointAccumulation(game, pointsPerSecond, accumulationInterval * 20);
        }
        int seekTime = this.configManager.getSeekTime();
        Set warnedTimes = new LinkedHashSet();
        int checkTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> GameManager.startSeekPhase$lambda$2(this, game, seekTime, warnedTimes), 20L, 20L);
        game.setWinConditionCheckTaskId(checkTaskId);
    }

    public final void endGame(@NotNull GameResult result) {
        block42: {
            Object[] $this$mapNotNullTo$iv$iv;
            int taskId;
            Intrinsics.checkNotNullParameter((Object)result, "result");
            Game game = this.activeGame;
            if (game == null) {
                return;
            }
            Game game2 = game;
            if (game2.getPhase() == GamePhase.ENDED || game2.getPhase() == GamePhase.POST_GAME) {
                return;
            }
            game2.setPhase(GamePhase.ENDED);
            LocalizedScoreboardManager localizedScoreboardManager = this.localizedScoreboard;
            if (localizedScoreboardManager != null) {
                localizedScoreboardManager.stopUpdating();
            }
            PointManager pointManager = this.pointManager;
            if (pointManager != null) {
                pointManager.stopPointAccumulation();
            }
            Integer n = game2.getWinConditionCheckTaskId();
            if (n != null) {
                taskId = ((Number)n).intValue();
                boolean bl = false;
                Bukkit.getScheduler().cancelTask(taskId);
                game2.setWinConditionCheckTaskId(null);
            }
            Integer n2 = game2.getNightSkipTaskId();
            if (n2 != null) {
                taskId = ((Number)n2).intValue();
                boolean bl = false;
                Bukkit.getScheduler().cancelTask(taskId);
                game2.setNightSkipTaskId(null);
            }
            DisguiseManager disguiseManager = this.disguiseManager;
            if (disguiseManager != null) {
                disguiseManager.clearAllDisguises();
            }
            List<Object> winners = switch (WhenMappings.$EnumSwitchMapping$3[result.ordinal()]) {
                case 1 -> game2.getHiders();
                case 2 -> game2.getSeekers();
                case 3 -> CollectionsKt.emptyList();
                default -> throw new NoWhenBranchMatchedException();
            };
            MessageManager msgMgr = this.messageManager;
            Iterable $this$mapNotNull$iv = game2.getPlayers().keySet();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object[] objectArray = $this$forEach$iv$iv$iv.iterator();
            while (objectArray.hasNext()) {
                Player it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = objectArray.next();
                boolean bl = false;
                UUID it = (UUID)element$iv$iv;
                boolean bl2 = false;
                if (Bukkit.getPlayer((UUID)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List allPlayers = (List)destination$iv$iv;
            if (msgMgr != null) {
                $this$forEach$iv = game2.getPlayers().keySet();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UUID uuid = (UUID)element$iv;
                    boolean bl = false;
                    if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                    boolean bl4 = false;
                    switch (WhenMappings.$EnumSwitchMapping$3[result.ordinal()]) {
                        case 3: {
                            Player player;
                            Duration duration = Duration.ofMillis(500L);
                            Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
                            Duration duration2 = Duration.ofMillis(3000L);
                            Intrinsics.checkNotNullExpressionValue(duration2, "ofMillis(...)");
                            Duration duration3 = Duration.ofMillis(1000L);
                            Intrinsics.checkNotNullExpressionValue(duration3, "ofMillis(...)");
                            msgMgr.sendTitle(player, "game.result.title.cancelled", "game.result.subtitle.cancelled", duration, duration2, duration3, new Object[0]);
                            break;
                        }
                        case 2: {
                            Player player;
                            Duration duration = Duration.ofMillis(500L);
                            Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
                            Duration duration4 = Duration.ofMillis(3000L);
                            Intrinsics.checkNotNullExpressionValue(duration4, "ofMillis(...)");
                            Duration duration5 = Duration.ofMillis(1000L);
                            Intrinsics.checkNotNullExpressionValue(duration5, "ofMillis(...)");
                            msgMgr.sendTitle(player, "game.result.title.ended", "game.result.subtitle.all_captured", duration, duration4, duration5, new Object[0]);
                            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                            break;
                        }
                        case 1: {
                            Player player;
                            Duration duration = Duration.ofMillis(500L);
                            Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(...)");
                            Duration duration6 = Duration.ofMillis(3000L);
                            Intrinsics.checkNotNullExpressionValue(duration6, "ofMillis(...)");
                            Duration duration7 = Duration.ofMillis(1000L);
                            Intrinsics.checkNotNullExpressionValue(duration7, "ofMillis(...)");
                            msgMgr.sendTitle(player, "game.result.title.ended", "game.result.subtitle.time_up", duration, duration6, duration7, new Object[0]);
                            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                msgMgr.broadcast(allPlayers, "game.result.broadcast_header", new Object[0]);
                String resultKey = switch (WhenMappings.$EnumSwitchMapping$3[result.ordinal()]) {
                    case 1 -> "game.result.message.hiders_win";
                    case 2 -> "game.result.message.seekers_win";
                    case 3 -> "game.result.message.cancelled";
                    default -> throw new NoWhenBranchMatchedException();
                };
                String resultMessage = msgMgr.getRawMessage(null, resultKey, new Object[0]);
                $this$mapNotNullTo$iv$iv = new Object[]{resultMessage};
                msgMgr.broadcast(allPlayers, "game.result.broadcast_result", $this$mapNotNullTo$iv$iv);
            } else {
                $this$forEach$iv = game2.getPlayers().keySet();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    UUID uuid = (UUID)element$iv;
                    boolean bl = false;
                    if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                    boolean bl5 = false;
                    switch (WhenMappings.$EnumSwitchMapping$3[result.ordinal()]) {
                        case 3: {
                            Player player;
                            player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&7&l\u30b2\u30fc\u30e0\u4e2d\u6b62"), (Component)MessageUtil.INSTANCE.colorize("&7Game Cancelled"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(1000L))));
                            break;
                        }
                        case 2: {
                            Player player;
                            player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&e&l\u30b2\u30fc\u30e0\u7d42\u4e86"), (Component)MessageUtil.INSTANCE.colorize("&c\u5168\u54e1\u9b3c\u5316\uff01"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(1000L))));
                            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                            break;
                        }
                        case 1: {
                            Player player;
                            player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize("&e&l\u30b2\u30fc\u30e0\u7d42\u4e86"), (Component)MessageUtil.INSTANCE.colorize("&a\u6642\u9593\u5207\u308c\uff01"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(1000L))));
                            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                String resultMessageKey = switch (WhenMappings.$EnumSwitchMapping$3[result.ordinal()]) {
                    case 1 -> "game.result.message.hiders_win";
                    case 2 -> "game.result.message.seekers_win";
                    case 3 -> "game.result.message.cancelled";
                    default -> throw new NoWhenBranchMatchedException();
                };
                Iterable $this$forEach$iv = allPlayers;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Player player = (Player)element$iv;
                    boolean bl = false;
                    Object object = msgMgr;
                    if (object == null || (object = object.getMessage(player, resultMessageKey, new Object[0])) == null) {
                        object = this.getResultMessage(result);
                    }
                    Object resultMessage = object;
                    MessageManager messageManager = msgMgr;
                    if (messageManager == null) continue;
                    objectArray = new Object[]{resultMessage};
                    messageManager.send(player, "game.result.broadcast_result", objectArray);
                }
            }
            this.displayStats(game2);
            this.displayRankings(game2);
            this.restorePlayers(game2);
            WorldBorderBackup worldBorderBackup = game2.getWorldBorderBackup();
            if (worldBorderBackup != null) {
                worldBorderBackup.restore(game2.getArena().getWorld());
            }
            this.cleanupTeams(game2);
            if (this.configManager.isAutoRestartEnabled() && result != GameResult.CANCELLED) {
                game2.setPhase(GamePhase.POST_GAME);
                game2.setPhaseStartTime(System.currentTimeMillis());
                this.activeGame = game2;
                this.startAutoRestartTimer(game2);
            } else {
                this.activeGame = null;
            }
            MessageManager messageManager = msgMgr;
            if (messageManager == null) break block42;
            messageManager.broadcast(allPlayers, "game.result.thanks", new Object[0]);
        }
    }

    private final String getResultMessage(GameResult result) {
        return switch (WhenMappings.$EnumSwitchMapping$3[result.ordinal()]) {
            case 1 -> "\u4eba\u9593\u306e\u52dd\u5229\uff01";
            case 2 -> "\u9b3c\u306e\u52dd\u5229\uff01";
            case 3 -> "\u30b2\u30fc\u30e0\u4e2d\u6b62";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void displayStats(Game game) {
        block12: {
            Object v3;
            void $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object[] $this$mapNotNullTo$iv$iv;
            MessageManager msgMgr = this.messageManager;
            Iterable $this$mapNotNull$iv = game.getPlayers().keySet();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                Player it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv;
                boolean bl = false;
                UUID it = (UUID)element$iv$iv;
                boolean bl2 = false;
                if (Bukkit.getPlayer((UUID)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List allPlayers = (List)destination$iv$iv;
            MessageManager messageManager = msgMgr;
            if (messageManager != null) {
                messageManager.broadcast(allPlayers, "game.stats.title", new Object[0]);
            }
            long duration = (System.currentTimeMillis() - game.getStartTime()) / (long)1000;
            MessageManager messageManager2 = msgMgr;
            if (messageManager2 != null) {
                $this$mapNotNullTo$iv$iv = new Object[]{String.valueOf(duration)};
                messageManager2.broadcast(allPlayers, "game.stats.duration", $this$mapNotNullTo$iv$iv);
            }
            MessageManager messageManager3 = msgMgr;
            if (messageManager3 != null) {
                $this$mapNotNullTo$iv$iv = new Object[]{String.valueOf(game.getCaptured().size()), String.valueOf(game.getHiders().size())};
                messageManager3.broadcast(allPlayers, "game.stats.total_captures", $this$mapNotNullTo$iv$iv);
            }
            destination$iv$iv = game.getPlayers().values();
            boolean $i$f$filter = false;
            $this$forEach$iv$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PlayerGameData it = (PlayerGameData)element$iv$iv;
                boolean bl = false;
                if (!(it.getRole() == PlayerRole.SEEKER)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = maxElem$iv;
                } else {
                    PlayerGameData it = (PlayerGameData)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.getCaptureCount();
                    do {
                        Object e$iv = iterator$iv.next();
                        PlayerGameData it2 = (PlayerGameData)e$iv;
                        $i$a$-maxByOrNull-GameManager$displayStats$topSeeker$2 = false;
                        int v$iv = it2.getCaptureCount();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = maxElem$iv;
                }
            }
            PlayerGameData topSeeker = v3;
            if (topSeeker == null || topSeeker.getCaptureCount() <= 0) break block12;
            Player player = Bukkit.getPlayer((UUID)topSeeker.getUuid());
            if (player != null) {
                Player player2 = player;
                boolean bl = false;
                MessageManager messageManager4 = msgMgr;
                if (messageManager4 != null) {
                    Collection collection = allPlayers;
                    Object[] objectArray = new Object[2];
                    Intrinsics.checkNotNullExpressionValue(player2.getName(), "getName(...)");
                    objectArray[1] = String.valueOf(topSeeker.getCaptureCount());
                    messageManager4.broadcast(collection, "game.stats.top_seeker", objectArray);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void displayRankings(Game game) {
        void $this$mapNotNullTo$iv$iv;
        PointManager pointManager = this.pointManager;
        if (pointManager == null) {
            return;
        }
        PointManager pointMgr = pointManager;
        MessageManager msgMgr = this.messageManager;
        Iterable $this$mapNotNull$iv = game.getPlayers().keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (Bukkit.getPlayer((UUID)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List allPlayers = (List)destination$iv$iv;
        MessageManager messageManager = msgMgr;
        if (messageManager != null) {
            messageManager.broadcast(allPlayers, "game.rankings.title", new Object[0]);
        }
        MessageManager messageManager2 = msgMgr;
        if (messageManager2 != null) {
            messageManager2.broadcast(allPlayers, "game.rankings.subtitle", new Object[0]);
        }
        MessageManager messageManager3 = msgMgr;
        if (messageManager3 != null) {
            messageManager3.broadcast(allPlayers, "game.rankings.hider_title", new Object[0]);
        }
        List<Pair<UUID, Integer>> hiderRankings = pointMgr.getRankedPlayersByRolePoints(game, PlayerRole.HIDER);
        if (hiderRankings.isEmpty()) {
            Iterable $this$forEach$iv = allPlayers;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                $i$a$-forEach-GameManager$displayRankings$1 = 0;
                MessageManager messageManager4 = msgMgr;
                if (messageManager4 == null) continue;
                messageManager4.send(player, "game.rankings.no_hiders", new Object[0]);
            }
        } else {
            Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)hiderRankings, 5);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                Object[] bl3;
                String medal;
                if (($i$a$-forEach-GameManager$displayRankings$1 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object = (Pair)item$iv;
                int index = $i$a$-forEach-GameManager$displayRankings$1;
                boolean bl = false;
                UUID uuid = (UUID)((Pair)object).component1();
                int points = ((Number)((Pair)object).component2()).intValue();
                Player player = Bukkit.getPlayer((UUID)uuid);
                switch (index) {
                    case 0: {
                        Object object2 = "&6\ud83e\udd47";
                        break;
                    }
                    case 1: {
                        Object object2 = "&7\ud83e\udd48";
                        break;
                    }
                    case 2: {
                        Object object2 = "&c\ud83e\udd49";
                        break;
                    }
                    default: {
                        Object object2 = medal = "&7" + (index + 1) + ".";
                    }
                }
                if (player != null) {
                    MessageManager messageManager5 = msgMgr;
                    if (messageManager5 != null) {
                        Collection collection = allPlayers;
                        bl3 = new Object[3];
                        bl3[0] = medal;
                        Intrinsics.checkNotNullExpressionValue(player.getName(), "getName(...)");
                        bl3[2] = String.valueOf(points);
                        messageManager5.broadcast(collection, "game.rankings.entry_online", bl3);
                    }
                    continue;
                }
                MessageManager messageManager6 = msgMgr;
                if (messageManager6 == null) continue;
                bl3 = new Object[]{medal, String.valueOf(points)};
                messageManager6.broadcast(allPlayers, "game.rankings.entry_offline", bl3);
            }
        }
        MessageManager messageManager7 = msgMgr;
        if (messageManager7 != null) {
            messageManager7.broadcast(allPlayers, "game.rankings.seeker_title", new Object[0]);
        }
        List<Pair<UUID, Integer>> seekerRankings = pointMgr.getRankedPlayersByRolePoints(game, PlayerRole.SEEKER);
        if (seekerRankings.isEmpty()) {
            Iterable $this$forEach$iv = allPlayers;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player = (Player)element$iv;
                boolean bl = false;
                MessageManager messageManager8 = msgMgr;
                if (messageManager8 == null) continue;
                messageManager8.send(player, "game.rankings.no_seekers", new Object[0]);
            }
        } else {
            Iterable $this$forEachIndexed$iv = CollectionsKt.take((Iterable)seekerRankings, 5);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                Object[] objectArray;
                String medal;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl = false;
                UUID uuid = (UUID)pair.component1();
                int points = ((Number)pair.component2()).intValue();
                Player player = Bukkit.getPlayer((UUID)uuid);
                switch (index) {
                    case 0: {
                        Object object3 = "&6\ud83e\udd47";
                        break;
                    }
                    case 1: {
                        Object object3 = "&7\ud83e\udd48";
                        break;
                    }
                    case 2: {
                        Object object3 = "&c\ud83e\udd49";
                        break;
                    }
                    default: {
                        Object object3 = medal = "&7" + (index + 1) + ".";
                    }
                }
                if (player != null) {
                    MessageManager messageManager9 = msgMgr;
                    if (messageManager9 != null) {
                        Collection collection = allPlayers;
                        objectArray = new Object[3];
                        objectArray[0] = medal;
                        Intrinsics.checkNotNullExpressionValue(player.getName(), "getName(...)");
                        objectArray[2] = String.valueOf(points);
                        messageManager9.broadcast(collection, "game.rankings.entry_online", objectArray);
                    }
                    continue;
                }
                MessageManager messageManager10 = msgMgr;
                if (messageManager10 == null) continue;
                objectArray = new Object[]{medal, String.valueOf(points)};
                messageManager10.broadcast(allPlayers, "game.rankings.entry_offline", objectArray);
            }
        }
    }

    private final void restorePlayers(Game game) {
        Map<UUID, PlayerGameData> $this$forEach$iv = game.getPlayers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Player player;
            Map.Entry<UUID, PlayerGameData> element$iv;
            Map.Entry<UUID, PlayerGameData> entry = element$iv = iterator2.next();
            boolean bl = false;
            UUID uuid = entry.getKey();
            PlayerGameData playerData = entry.getValue();
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            PlayerBackup playerBackup = playerData.getBackup();
            if (playerBackup != null) {
                playerBackup.restore(player);
            }
            LocalizedScoreboardManager localizedScoreboardManager = this.localizedScoreboard;
            if (localizedScoreboardManager == null) continue;
            localizedScoreboardManager.removePlayer(player);
        }
        this.cleanupTeams(game);
    }

    private final void broadcastToWaiting(String message) {
        Iterable $this$forEach$iv = this.waitingPlayers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            MessageUtil.INSTANCE.send((CommandSender)it, message);
        }
    }

    private final void broadcastToGame(Game game, String message) {
        Iterable $this$forEach$iv = game.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            MessageUtil.INSTANCE.send((CommandSender)it, message);
        }
    }

    public final void broadcastToActiveGame(@NotNull String message) {
        block0: {
            Intrinsics.checkNotNullParameter(message, "message");
            Game game = this.activeGame;
            if (game == null) break block0;
            Game game2 = game;
            boolean bl = false;
            this.broadcastToGame(game2, message);
        }
    }

    @NotNull
    public final List<UUID> getWaitingPlayers() {
        return CollectionsKt.toList((Iterable)this.waitingPlayers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isInGame(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        if (this.waitingPlayers.contains(player.getUniqueId())) return true;
        Game game = this.activeGame;
        Object object = game;
        if (game == null) return false;
        Map<UUID, PlayerGameData> map = ((Game)object).getPlayers();
        object = map;
        if (map == null) return false;
        if (!object.containsKey(player.getUniqueId())) return false;
        return true;
    }

    private final void checkAutoStart() {
        if (this.activeGame != null) {
            return;
        }
        int minPlayers = this.configManager.getMinPlayers();
        if (this.waitingPlayers.size() >= minPlayers) {
            Arena arena;
            ArenaManager arenaManager = this.arenaManager;
            Arena arena2 = arena = arenaManager != null ? arenaManager.getRandomArena() : null;
            if (arena == null) {
                this.broadcastToWaiting("&cNo arenas available. Cannot start game.");
                return;
            }
            this.broadcastToWaiting("&aStarting game on arena: &e" + arena.getDisplayName());
            this.startGameCountdown(arena, 3);
        }
    }

    private final void broadcastToServer(String message) {
        Collection collection = Bukkit.getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(player);
            MessageUtil.INSTANCE.send((CommandSender)player, message);
        }
    }

    private final void tryStartGame() {
        Arena arena;
        ArenaManager arenaManager = this.arenaManager;
        Arena arena2 = arena = arenaManager != null ? arenaManager.getRandomArena() : null;
        if (arena != null) {
            this.startGameCountdown(arena, 3);
        } else {
            this.broadcastToWaiting("&cNo arenas available. Cannot start game.");
        }
    }

    private final void startGameCountdown(Arena arena, int seconds) {
        Ref.IntRef remaining = new Ref.IntRef();
        remaining.element = seconds;
        Runnable countdownTask2 = new Runnable(remaining, this, arena){
            final /* synthetic */ Ref.IntRef $remaining;
            final /* synthetic */ GameManager this$0;
            final /* synthetic */ Arena $arena;
            {
                this.$remaining = $remaining;
                this.this$0 = $receiver;
                this.$arena = $arena;
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                void $this$forEach$iv;
                if (this.$remaining.element <= 0) {
                    this.this$0.startGame(this.$arena);
                    return;
                }
                Iterable iterable = GameManager.access$getWaitingPlayers$p(this.this$0);
                Ref.IntRef intRef = this.$remaining;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Player player;
                    UUID uuid = (UUID)element$iv;
                    boolean bl = false;
                    if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                    boolean bl2 = false;
                    String color = switch (intRef.element) {
                        case 1 -> "&c";
                        case 2 -> "&e";
                        default -> "&a";
                    };
                    player.showTitle(Title.title((Component)MessageUtil.INSTANCE.colorize(color + "&l" + intRef.element), (Component)MessageUtil.INSTANCE.colorize("&7\u30b2\u30fc\u30e0\u958b\u59cb\u307e\u3067..."), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis(250L))));
                }
                int n = this.$remaining.element;
                this.$remaining.element = n + -1;
                Bukkit.getScheduler().runTaskLater(this.this$0.getPlugin(), (Runnable)this, 20L);
            }
        };
        Bukkit.getScheduler().runTask(this.plugin, countdownTask2);
    }

    public final void startAutoRestartTimer(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        if (!this.configManager.isAutoRestartEnabled()) {
            return;
        }
        int countdownSeconds = this.configManager.getPostGameCountdown();
        int broadcastInterval = this.configManager.getBroadcastInterval();
        game.setAutoRestartStartTime(System.currentTimeMillis());
        int countdownTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask(this.plugin, () -> GameManager.startAutoRestartTimer$lambda$0(game, countdownSeconds, this, broadcastInterval), 0L, 20L);
        game.setAutoRestartTaskId(countdownTaskId);
    }

    public final void cancelAutoRestartTimer(@NotNull Game game) {
        block0: {
            Intrinsics.checkNotNullParameter(game, "game");
            Integer n = game.getAutoRestartTaskId();
            if (n == null) break block0;
            int taskId = ((Number)n).intValue();
            boolean bl = false;
            Bukkit.getScheduler().cancelTask(taskId);
            game.setAutoRestartTaskId(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transitionToWaiting(Game game) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv2;
        List previousPlayers = CollectionsKt.toList((Iterable)game.getPlayers().keySet());
        MessageManager msgMgr = this.messageManager;
        Iterable $this$mapNotNull$iv = game.getPlayers().keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Player> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            Player it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl2 = false;
            if (Bukkit.getPlayer((UUID)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List allPlayers = (List)destination$iv$iv;
        MessageManager messageManager = msgMgr;
        if (messageManager != null) {
            messageManager.broadcast(allPlayers, "game.auto_restart.ended", new Object[0]);
        }
        Iterable $this$mapNotNull$iv2 = previousPlayers;
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        Iterator $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            Player it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            UUID it = (UUID)element$iv$iv;
            boolean bl4 = false;
            if (Bukkit.getPlayer((UUID)it) == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv2 = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Player it = (Player)element$iv$iv;
            boolean bl = false;
            if (!it.isOnline()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            SpectatorManager spectatorManager;
            Player player = (Player)element$iv$iv;
            boolean bl6 = false;
            Plugin plugin = this.plugin;
            HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
            SpectatorManager spectatorManager2 = spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
            if (spectatorManager2 != null) {
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                bl = spectatorManager2.isSpectator(uUID);
            } else {
                bl = false;
            }
            if (bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List activePlayers = (List)destination$iv$iv2;
        int minPlayers = this.configManager.getMinPlayers();
        this.activeGame = null;
        if (activePlayers.size() >= minPlayers) {
            MessageManager messageManager2 = msgMgr;
            if (messageManager2 != null) {
                Collection collection = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                messageManager2.broadcast(CollectionsKt.toList(collection), "game.auto_restart.starting", new Object[0]);
            }
            this.waitingPlayers.clear();
            Iterable $this$forEach$iv = activePlayers;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Player)element$iv;
                boolean bl = false;
                UUID uUID = it.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                this.waitingPlayers.add(uUID);
            }
            this.tryStartGame();
        } else {
            MessageManager messageManager3 = msgMgr;
            if (messageManager3 != null) {
                Collection collection = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                Object[] $this$forEach$iv = new Object[]{String.valueOf(activePlayers.size()), String.valueOf(minPlayers)};
                messageManager3.broadcast(CollectionsKt.toList(collection), "game.auto_restart.waiting_players", $this$forEach$iv);
            }
            MessageManager messageManager4 = msgMgr;
            if (messageManager4 != null) {
                Collection collection = Bukkit.getOnlinePlayers();
                Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
                messageManager4.broadcast(CollectionsKt.toList(collection), "game.auto_restart.waiting_message", new Object[0]);
            }
            this.waitingPlayers.clear();
            Iterable $this$forEach$iv = activePlayers;
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Player)element$iv;
                boolean bl = false;
                UUID uUID = it.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                this.waitingPlayers.add(uUID);
            }
        }
    }

    public final int getActivePlayerCount() {
        int n;
        Plugin plugin = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
        SpectatorManager spectatorManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSpectatorManager() : null;
        Iterable $this$count$iv = this.waitingPlayers;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                UUID uuid = (UUID)element$iv;
                boolean bl = false;
                SpectatorManager spectatorManager2 = spectatorManager;
                boolean isSpectator = spectatorManager2 != null ? spectatorManager2.isSpectator(uuid) : false;
                if (!(!isSpectator) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    private static final void setupWorldTime$lambda$0(World $world) {
        if ($world.getTime() >= 12542L || $world.getTime() <= 23459L) {
            boolean isNight;
            long l = $world.getTime();
            boolean bl = 12542L <= l ? l < 24000L : (isNight = false);
            if (isNight) {
                $world.setTime(1000L);
            }
        }
    }

    private static final void startPreparationPhase$lambda$3(GameManager this$0, Game $game) {
        if (Intrinsics.areEqual(this$0.activeGame, $game)) {
            MessageManager msgMgr = this$0.messageManager;
            Iterable $this$forEach$iv = $game.getSeekers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player;
                UUID uuid = (UUID)element$iv;
                boolean bl = false;
                if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                boolean bl2 = false;
                player.setSendViewDistance(10);
                MessageManager messageManager = msgMgr;
                if (messageManager == null) continue;
                messageManager.send(player, "game.seeker.can_move", new Object[0]);
            }
        }
    }

    private static final void startPreparationPhase$lambda$4(GameManager this$0, Game $game) {
        if (Intrinsics.areEqual(this$0.activeGame, $game)) {
            this$0.startSeekPhase($game);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void startSeekPhase$lambda$2(GameManager this$0, Game $game, int $seekTime, Set $warnedTimes) {
        block13: {
            block12: {
                void $this$mapNotNullTo$iv$iv;
                if (!Intrinsics.areEqual(this$0.activeGame, $game) || $game.getPhase() != GamePhase.SEEKING) break block12;
                long elapsed = (System.currentTimeMillis() - $game.getPhaseStartTime()) / (long)1000;
                int remaining = $seekTime - (int)elapsed;
                MessageManager msgMgr = this$0.messageManager;
                Iterable $this$mapNotNull$iv = $game.getPlayers().keySet();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Player it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    UUID it = (UUID)element$iv$iv;
                    boolean bl2 = false;
                    if (Bukkit.getPlayer((UUID)it) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List allPlayers = (List)destination$iv$iv;
                switch (remaining) {
                    case 60: {
                        UUID uuid;
                        if ($warnedTimes.contains(60)) break;
                        MessageManager messageManager = msgMgr;
                        if (messageManager != null) {
                            messageManager.broadcast(allPlayers, "game.time.warning_1min", new Object[0]);
                        }
                        Iterable $this$forEach$iv = $game.getPlayers().keySet();
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv : $this$forEach$iv) {
                            uuid = (UUID)element$iv;
                            boolean bl = false;
                            Player player = Bukkit.getPlayer((UUID)uuid);
                            if (player == null) continue;
                            Player player2 = Bukkit.getPlayer((UUID)uuid);
                            Intrinsics.checkNotNull(player2);
                            player.playSound(player2.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                        }
                        $warnedTimes.add(60);
                        break;
                    }
                    case 30: {
                        UUID uuid;
                        if ($warnedTimes.contains(30)) break;
                        MessageManager messageManager = msgMgr;
                        if (messageManager != null) {
                            messageManager.broadcast(allPlayers, "game.time.warning_30sec", new Object[0]);
                        }
                        Iterable $this$forEach$iv = $game.getPlayers().keySet();
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv : $this$forEach$iv) {
                            uuid = (UUID)element$iv;
                            boolean bl = false;
                            Player player = Bukkit.getPlayer((UUID)uuid);
                            if (player == null) continue;
                            Player player3 = Bukkit.getPlayer((UUID)uuid);
                            Intrinsics.checkNotNull(player3);
                            player.playSound(player3.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.2f);
                        }
                        $warnedTimes.add(30);
                        break;
                    }
                    case 10: {
                        UUID uuid;
                        if ($warnedTimes.contains(10)) break;
                        MessageManager messageManager = msgMgr;
                        if (messageManager != null) {
                            messageManager.broadcast(allPlayers, "game.time.warning_10sec", new Object[0]);
                        }
                        Iterable $this$forEach$iv = $game.getPlayers().keySet();
                        boolean $i$f$forEach4 = false;
                        for (Object element$iv : $this$forEach$iv) {
                            uuid = (UUID)element$iv;
                            boolean bl = false;
                            Player player = Bukkit.getPlayer((UUID)uuid);
                            if (player == null) continue;
                            Player player4 = Bukkit.getPlayer((UUID)uuid);
                            Intrinsics.checkNotNull(player4);
                            player.playSound(player4.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.5f);
                        }
                        $warnedTimes.add(10);
                    }
                }
                GameResult result = $game.checkWinCondition((long)$seekTime * (long)1000);
                if (result == null) break block13;
                this$0.endGame(result);
                break block13;
            }
            Integer n = $game.getWinConditionCheckTaskId();
            if (n == null) break block13;
            int taskId = ((Number)n).intValue();
            boolean bl = false;
            Bukkit.getScheduler().cancelTask(taskId);
            $game.setWinConditionCheckTaskId(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void startAutoRestartTimer$lambda$0(Game $game, int $countdownSeconds, GameManager this$0, int $broadcastInterval) {
        block4: {
            void $this$mapNotNullTo$iv$iv;
            int remaining;
            block3: {
                long elapsed = (System.currentTimeMillis() - $game.getAutoRestartStartTime()) / (long)1000;
                remaining = $countdownSeconds - (int)elapsed;
                if (remaining > 0) break block3;
                Integer n = $game.getAutoRestartTaskId();
                if (n == null) {
                    return;
                }
                Bukkit.getScheduler().cancelTask(n.intValue());
                $game.setAutoRestartTaskId(null);
                this$0.transitionToWaiting($game);
                break block4;
            }
            if (remaining % $broadcastInterval != 0 && remaining > 5) break block4;
            MessageManager msgMgr = this$0.messageManager;
            Iterable $this$mapNotNull$iv = $game.getPlayers().keySet();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Player it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                UUID it = (UUID)element$iv$iv;
                boolean bl2 = false;
                if (Bukkit.getPlayer((UUID)it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List allPlayers = (List)destination$iv$iv;
            MessageManager messageManager = msgMgr;
            if (messageManager != null) {
                Object[] objectArray = new Object[]{String.valueOf(remaining)};
                messageManager.broadcast(allPlayers, "game.auto_restart.countdown", objectArray);
            }
        }
    }

    public static final /* synthetic */ List access$getWaitingPlayers$p(GameManager $this) {
        return $this.waitingPlayers;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[PlayerRole.values().length];
            try {
                nArray[PlayerRole.SEEKER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.HIDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.SPECTATOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Material.values().length];
            try {
                nArray[Material.LAVA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.MAGMA_BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.FIRE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CAMPFIRE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.SOUL_CAMPFIRE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CACTUS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.SWEET_BERRY_BUSH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.AIR.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CAVE_AIR.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.VOID_AIR.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[CaptureMode.values().length];
            try {
                nArray[CaptureMode.SPECTATOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaptureMode.INFECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[GameResult.values().length];
            try {
                nArray[GameResult.HIDER_WIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameResult.SEEKER_WIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GameResult.CANCELLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

