/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.i18n;

import com.hideandseek.i18n.LanguagePreferenceManager;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.i18n.UTF8Control;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.functions.Function1;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J3\u0010\u0016\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0017J1\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001aJ1\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001aJS\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010#J7\u0010$\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\u0006\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010'J7\u0010(\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\u0006\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010'JY\u0010)\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\u0006\u0010\u001d\u001a\u00020\u000b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020 2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\u0019H\u0016J\u001a\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u000b2\b\u0010.\u001a\u0004\u0018\u00010\nH\u0016J1\u0010\u0018\u001a\u00020\u00192\u0006\u0010/\u001a\u0002002\u0006\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u0019H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000b04H\u0016J\u0018\u00105\u001a\u00020\f2\u0006\u0010.\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/hideandseek/i18n/MessageManagerImpl;", "Lcom/hideandseek/i18n/MessageManager;", "plugin", "Lorg/bukkit/plugin/Plugin;", "languagePreferenceManager", "Lcom/hideandseek/i18n/LanguagePreferenceManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/i18n/LanguagePreferenceManager;)V", "messageFormatCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/Locale;", "", "Ljava/text/MessageFormat;", "getMessage", "Lnet/kyori/adventure/text/Component;", "player", "Lorg/bukkit/entity/Player;", "key", "args", "", "", "(Lorg/bukkit/entity/Player;Ljava/lang/String;[Ljava/lang/Object;)Lnet/kyori/adventure/text/Component;", "getRawMessage", "(Lorg/bukkit/entity/Player;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "send", "", "(Lorg/bukkit/entity/Player;Ljava/lang/String;[Ljava/lang/Object;)V", "sendActionBar", "sendTitle", "titleKey", "subtitleKey", "fadeIn", "Ljava/time/Duration;", "stay", "fadeOut", "(Lorg/bukkit/entity/Player;Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;[Ljava/lang/Object;)V", "broadcast", "players", "", "(Ljava/util/Collection;Ljava/lang/String;[Ljava/lang/Object;)V", "broadcastActionBar", "broadcastTitle", "(Ljava/util/Collection;Ljava/lang/String;Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;[Ljava/lang/Object;)V", "clearCache", "hasKey", "", "locale", "sender", "Lorg/bukkit/command/CommandSender;", "(Lorg/bukkit/command/CommandSender;Ljava/lang/String;[Ljava/lang/Object;)V", "reload", "getAvailableLanguages", "", "getMessageFormat", "Companion", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nMessageManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageManagerImpl.kt\ncom/hideandseek/i18n/MessageManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,194:1\n1#2:195\n1869#3,2:196\n1869#3,2:198\n1869#3,2:200\n1563#3:202\n1634#3,3:203\n*S KotlinDebug\n*F\n+ 1 MessageManagerImpl.kt\ncom/hideandseek/i18n/MessageManagerImpl\n*L\n97#1:196,2\n103#1:198,2\n117#1:200,2\n162#1:202\n162#1:203,3\n*E\n"})
public final class MessageManagerImpl
implements MessageManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final LanguagePreferenceManager languagePreferenceManager;
    @NotNull
    private final ConcurrentHashMap<Locale, ConcurrentHashMap<String, MessageFormat>> messageFormatCache;
    @NotNull
    private static final String MESSAGES_BASE_NAME = "messages";
    @NotNull
    private static final LegacyComponentSerializer LEGACY_SERIALIZER;
    @NotNull
    private static final UTF8Control UTF8_CONTROL;

    public MessageManagerImpl(@NotNull Plugin plugin, @NotNull LanguagePreferenceManager languagePreferenceManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(languagePreferenceManager, "languagePreferenceManager");
        this.plugin = plugin;
        this.languagePreferenceManager = languagePreferenceManager;
        this.messageFormatCache = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public Component getMessage(@NotNull Player player, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        String rawMessage = this.getRawMessage(player, key, Arrays.copyOf(args, args.length));
        TextComponent textComponent = LEGACY_SERIALIZER.deserialize(rawMessage);
        Intrinsics.checkNotNullExpressionValue(textComponent, "deserialize(...)");
        return (Component)textComponent;
    }

    @Override
    @NotNull
    public String getRawMessage(@Nullable Player player, @NotNull String key, Object ... args) {
        Object object;
        Object object2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(key, "key");
                Intrinsics.checkNotNullParameter(args, "args");
                object2 = player;
                if (object2 == null) break block5;
                Player it = object2;
                boolean bl = false;
                Locale locale = this.languagePreferenceManager.getLocale(it);
                object2 = locale;
                if (locale != null) break block6;
            }
            object2 = this.languagePreferenceManager.getDefaultLanguage();
        }
        Player locale = object2;
        try {
            MessageFormat messageFormat = this.getMessageFormat((Locale)locale, key);
            object = args.length == 0 ? messageFormat.toPattern() : messageFormat.format(args);
            Intrinsics.checkNotNull(object);
        }
        catch (MissingResourceException e) {
            this.plugin.getLogger().warning("Missing translation key: " + key + " for locale: " + locale.toLanguageTag());
            Object[] objectArray = new Object[]{key};
            object = this.getRawMessage(null, "system.translation.missing", objectArray);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error formatting message '" + key + "' for locale " + locale.toLanguageTag() + ": " + e.getMessage());
            object = "[Error: " + key + "]";
        }
        return object;
    }

    @Override
    public void send(@NotNull Player player, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        player.sendMessage(this.getMessage(player, key, Arrays.copyOf(args, args.length)));
    }

    @Override
    public void sendActionBar(@NotNull Player player, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        player.sendActionBar(this.getMessage(player, key, Arrays.copyOf(args, args.length)));
    }

    @Override
    public void sendTitle(@NotNull Player player, @NotNull String titleKey, @Nullable String subtitleKey, @NotNull Duration fadeIn, @NotNull Duration stay, @NotNull Duration fadeOut, Object ... args) {
        String string;
        Component title;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(player, "player");
                Intrinsics.checkNotNullParameter(titleKey, "titleKey");
                Intrinsics.checkNotNullParameter(fadeIn, "fadeIn");
                Intrinsics.checkNotNullParameter(stay, "stay");
                Intrinsics.checkNotNullParameter(fadeOut, "fadeOut");
                Intrinsics.checkNotNullParameter(args, "args");
                title = this.getMessage(player, titleKey, Arrays.copyOf(args, args.length));
                string = subtitleKey;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                Component component = this.getMessage(player, it, Arrays.copyOf(args, args.length));
                string = component;
                if (component != null) break block3;
            }
            TextComponent textComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue(textComponent, "empty(...)");
            string = (Component)textComponent;
        }
        String subtitle = string;
        Title.Times times = Title.Times.times((Duration)fadeIn, (Duration)stay, (Duration)fadeOut);
        Intrinsics.checkNotNullExpressionValue(times, "times(...)");
        Title.Times times2 = times;
        player.showTitle(Title.title((Component)title, (Component)subtitle, (Title.Times)times2));
    }

    @Override
    public void broadcast(@NotNull Collection<? extends Player> players, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter(players, "players");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        Iterable $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            this.send(player, key, Arrays.copyOf(args, args.length));
        }
    }

    @Override
    public void broadcastActionBar(@NotNull Collection<? extends Player> players, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter(players, "players");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        Iterable $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            this.sendActionBar(player, key, Arrays.copyOf(args, args.length));
        }
    }

    @Override
    public void broadcastTitle(@NotNull Collection<? extends Player> players, @NotNull String titleKey, @Nullable String subtitleKey, @NotNull Duration fadeIn, @NotNull Duration stay, @NotNull Duration fadeOut, Object ... args) {
        Intrinsics.checkNotNullParameter(players, "players");
        Intrinsics.checkNotNullParameter(titleKey, "titleKey");
        Intrinsics.checkNotNullParameter(fadeIn, "fadeIn");
        Intrinsics.checkNotNullParameter(stay, "stay");
        Intrinsics.checkNotNullParameter(fadeOut, "fadeOut");
        Intrinsics.checkNotNullParameter(args, "args");
        Iterable $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            this.sendTitle(player, titleKey, subtitleKey, fadeIn, stay, fadeOut, Arrays.copyOf(args, args.length));
        }
    }

    @Override
    public void clearCache() {
        this.messageFormatCache.clear();
        ResourceBundle.clearCache();
        this.plugin.getLogger().info("Message cache cleared");
    }

    @Override
    public boolean hasKey(@NotNull String key, @Nullable Locale locale) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        Locale locale2 = locale;
        if (locale2 == null) {
            locale2 = this.languagePreferenceManager.getDefaultLanguage();
        }
        Locale targetLocale = locale2;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(MESSAGES_BASE_NAME, targetLocale, UTF8_CONTROL);
            bl = bundle.containsKey(key);
        }
        catch (MissingResourceException e) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void send(@NotNull CommandSender sender, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        if (sender instanceof Player) {
            this.send((Player)sender, key, Arrays.copyOf(args, args.length));
        } else {
            String rawMessage = this.getRawMessage(null, key, Arrays.copyOf(args, args.length));
            TextComponent textComponent = LEGACY_SERIALIZER.deserialize(rawMessage);
            Intrinsics.checkNotNullExpressionValue(textComponent, "deserialize(...)");
            TextComponent component = textComponent;
            sender.sendMessage((Component)component);
        }
    }

    @Override
    public void reload() {
        this.clearCache();
        ResourceBundle.clearCache();
        this.plugin.getLogger().info("MessageManager reloaded - all translation caches cleared");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getAvailableLanguages() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.languagePreferenceManager.getAvailableLanguages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Locale locale = (Locale)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toLanguageTag());
        }
        return (List)destination$iv$iv;
    }

    private final MessageFormat getMessageFormat(Locale locale, String key) {
        ConcurrentHashMap concurrentHashMap = this.messageFormatCache.computeIfAbsent(locale, arg_0 -> MessageManagerImpl.getMessageFormat$lambda$1(MessageManagerImpl::getMessageFormat$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentHashMap, "computeIfAbsent(...)");
        ConcurrentHashMap localeCache = concurrentHashMap;
        MessageFormat messageFormat = localeCache.computeIfAbsent(key, arg_0 -> MessageManagerImpl.getMessageFormat$lambda$3(arg_0 -> MessageManagerImpl.getMessageFormat$lambda$2(locale, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(messageFormat, "computeIfAbsent(...)");
        return messageFormat;
    }

    private static final ConcurrentHashMap getMessageFormat$lambda$0(Locale it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ConcurrentHashMap();
    }

    private static final ConcurrentHashMap getMessageFormat$lambda$1(Function1 $tmp0, Object p0) {
        return (ConcurrentHashMap)$tmp0.invoke(p0);
    }

    private static final MessageFormat getMessageFormat$lambda$2(Locale $locale, String messageKey) {
        Intrinsics.checkNotNullParameter(messageKey, "messageKey");
        ResourceBundle bundle = ResourceBundle.getBundle(MESSAGES_BASE_NAME, $locale, UTF8_CONTROL);
        String pattern = bundle.getString(messageKey);
        return new MessageFormat(pattern, $locale);
    }

    private static final MessageFormat getMessageFormat$lambda$3(Function1 $tmp0, Object p0) {
        return (MessageFormat)$tmp0.invoke(p0);
    }

    static {
        LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacyAmpersand();
        Intrinsics.checkNotNullExpressionValue(legacyComponentSerializer, "legacyAmpersand(...)");
        LEGACY_SERIALIZER = legacyComponentSerializer;
        UTF8_CONTROL = new UTF8Control();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/hideandseek/i18n/MessageManagerImpl$Companion;", "", "<init>", "()V", "MESSAGES_BASE_NAME", "", "LEGACY_SERIALIZER", "Lnet/kyori/adventure/text/serializer/legacy/LegacyComponentSerializer;", "Lorg/jetbrains/annotations/NotNull;", "UTF8_CONTROL", "Lcom/hideandseek/i18n/UTF8Control;", "EasyHideAndSeek"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

