/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.items;

import com.hideandseek.game.Game;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.items.ItemConfig;
import com.hideandseek.items.ItemEffectHandler;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Result;
import com.hideandseek.libs.kotlin.ResultKt;
import com.hideandseek.libs.kotlin.Unit;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J-\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/hideandseek/items/EagleEyeHandler;", "Lcom/hideandseek/items/ItemEffectHandler;", "<init>", "()V", "canApply", "", "player", "Lorg/bukkit/entity/Player;", "game", "Lcom/hideandseek/game/Game;", "apply", "Lcom/hideandseek/libs/kotlin/Result;", "", "config", "Lcom/hideandseek/items/ItemConfig;", "apply-0E7RQCE", "(Lorg/bukkit/entity/Player;Lcom/hideandseek/game/Game;Lcom/hideandseek/items/ItemConfig;)Ljava/lang/Object;", "onExpire", "getDisplayLore", "", "", "findDisguisedHiders", "Lorg/bukkit/Location;", "seeker", "radius", "", "Companion", "EasyHideAndSeek"})
public final class EagleEyeHandler
implements ItemEffectHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<UUID, Integer> activeEagleEyes = new ConcurrentHashMap();

    @Override
    public boolean canApply(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        PlayerGameData playerGameData = game.getPlayers().get(player.getUniqueId());
        if (playerGameData == null) {
            return false;
        }
        PlayerGameData playerData = playerGameData;
        return Intrinsics.areEqual(playerData.getRole().name(), "SEEKER");
    }

    @Override
    @NotNull
    public Object apply-0E7RQCE(@NotNull Player player, @NotNull Game game, @NotNull ItemConfig config) {
        Object object;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(config, "config");
        try {
            Plugin plugin = player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
            Intrinsics.checkNotNull(plugin);
            Plugin plugin2 = plugin;
            double detectionRadius = config.getIntensity();
            player.sendMessage("\u00a7a\u2726 \u9df9\u306e\u76ee\u304c\u767a\u52d5\u3057\u307e\u3057\u305f");
            player.sendMessage("\u00a77\u507d\u88c5\u30d6\u30ed\u30c3\u30af\u304c\u5149\u3063\u3066\u898b\u3048\u307e\u3059\uff08\u7bc4\u56f2" + (int)detectionRadius + "\u30d6\u30ed\u30c3\u30af\uff09");
            player.playSound(player.getLocation(), Sound.ENTITY_ENDER_EYE_DEATH, 1.0f, 1.5f);
            BukkitRunnable task2 = new BukkitRunnable(config, player, plugin2, this, game, detectionRadius){
                private int ticksLeft;
                final /* synthetic */ Player $player;
                final /* synthetic */ Plugin $plugin;
                final /* synthetic */ EagleEyeHandler this$0;
                final /* synthetic */ Game $game;
                final /* synthetic */ double $detectionRadius;
                {
                    this.$player = $player;
                    this.$plugin = $plugin;
                    this.this$0 = $receiver;
                    this.$game = $game;
                    this.$detectionRadius = $detectionRadius;
                    this.ticksLeft = $config.getDuration() * 20;
                }

                public final int getTicksLeft() {
                    return this.ticksLeft;
                }

                public final void setTicksLeft(int n) {
                    this.ticksLeft = n;
                }

                public void run() {
                    if (this.ticksLeft <= 0 || !this.$player.isOnline()) {
                        UUID uUID = this.$player.getUniqueId();
                        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                        EagleEyeHandler.Companion.stopEagleEye(uUID, this.$plugin);
                        this.cancel();
                        return;
                    }
                    List disguisedLocations = EagleEyeHandler.access$findDisguisedHiders(this.this$0, this.$player, this.$game, this.$detectionRadius);
                    for (Location location : disguisedLocations) {
                        this.$player.spawnParticle(Particle.END_ROD, location.clone().add(0.5, 0.5, 0.5), 3, 0.3, 0.3, 0.3, 0.02);
                        this.$player.spawnParticle(Particle.HAPPY_VILLAGER, location.clone().add(0.5, 1.0, 0.5), 1, 0.2, 0.2, 0.2, 0.0);
                    }
                    int secondsLeft = this.ticksLeft / 20;
                    if (disguisedLocations.isEmpty()) {
                        this.$player.sendActionBar("\u00a77\u9df9\u306e\u76ee - \u691c\u51fa\u306a\u3057 \u00a7e\u6b8b\u308a" + secondsLeft + "\u79d2");
                    } else {
                        this.$player.sendActionBar("\u00a7e\u9df9\u306e\u76ee - " + disguisedLocations.size() + "\u500b\u691c\u51fa \u00a77\u6b8b\u308a" + secondsLeft + "\u79d2");
                    }
                    this.ticksLeft -= 10;
                }
            };
            int taskId = task2.runTaskTimer(plugin2, 0L, 10L).getTaskId();
            Map map = activeEagleEyes;
            UUID uUID = player.getUniqueId();
            Integer n = taskId;
            map.put(uUID, n);
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Exception e) {
            object = Result.constructor-impl(ResultKt.createFailure(e));
        }
        return object;
    }

    @Override
    public void onExpire(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        Plugin plugin = player.getServer().getPluginManager().getPlugin("EasyHideAndSeek");
        Intrinsics.checkNotNull(plugin);
        Plugin plugin2 = plugin;
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        Companion.stopEagleEye(uUID, plugin2);
        player.sendMessage("\u00a77\u9df9\u306e\u76ee\u306e\u52b9\u679c\u304c\u5207\u308c\u307e\u3057\u305f");
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.3f, 0.8f);
    }

    @Override
    @NotNull
    public List<String> getDisplayLore(@NotNull ItemConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        String[] stringArray = new String[]{"\u00a77\u507d\u88c5\u30d6\u30ed\u30c3\u30af\u304c\u30d1\u30fc\u30c6\u30a3\u30af\u30eb\u3067\u5149\u308b", "\u00a77\u30cf\u30a4\u30c0\u30fc\u3092\u898b\u3064\u3051\u3084\u3059\u304f\u306a\u308b\u5f37\u529b\u306a\u52b9\u679c", "", "\u00a7b\u52b9\u679c: \u00a7f\u507d\u88c5\u30d6\u30ed\u30c3\u30af\u3092\u8996\u899a\u5316", "\u00a7b\u7bc4\u56f2: \u00a7f" + (int)config.getIntensity() + "\u30d6\u30ed\u30c3\u30af", "\u00a7b\u6301\u7d9a\u6642\u9593: \u00a7f" + config.getDuration() + "\u79d2", "", "\u00a77\u30d1\u30fc\u30c6\u30a3\u30af\u30eb\u306f\u4f7f\u7528\u8005\u306b\u306e\u307f\u898b\u3048\u307e\u3059"};
        return CollectionsKt.listOf(stringArray);
    }

    private final List<Location> findDisguisedHiders(Player seeker, Game game, double radius) {
        List locations = new ArrayList();
        for (Map.Entry<UUID, PlayerGameData> entry : game.getPlayers().entrySet()) {
            Location blockLocation;
            Player hider;
            double distance;
            UUID playerId = entry.getKey();
            PlayerGameData playerData = entry.getValue();
            if (!Intrinsics.areEqual(playerData.getRole().name(), "HIDER") || playerData.isCaptured() || Bukkit.getPlayer((UUID)playerId) == null || !((distance = seeker.getLocation().distance(hider.getLocation())) <= radius) || !hider.hasPotionEffect(PotionEffectType.INVISIBILITY)) continue;
            Intrinsics.checkNotNullExpressionValue(hider.getLocation().getBlock().getLocation(), "getLocation(...)");
            locations.add(blockLocation);
        }
        return locations;
    }

    public static final /* synthetic */ List access$findDisguisedHiders(EagleEyeHandler $this, Player seeker, Game game, double radius) {
        return $this.findDisguisedHiders(seeker, game, radius);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hideandseek/items/EagleEyeHandler$Companion;", "", "<init>", "()V", "activeEagleEyes", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "", "stopEagleEye", "", "playerId", "plugin", "Lorg/bukkit/plugin/Plugin;", "stopAllEagleEyes", "EasyHideAndSeek"})
    @SourceDebugExtension(value={"SMAP\nEagleEyeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EagleEyeHandler.kt\ncom/hideandseek/items/EagleEyeHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1869#2,2:172\n*S KotlinDebug\n*F\n+ 1 EagleEyeHandler.kt\ncom/hideandseek/items/EagleEyeHandler$Companion\n*L\n37#1:172,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void stopEagleEye(@NotNull UUID playerId, @NotNull Plugin plugin) {
            block0: {
                Intrinsics.checkNotNullParameter(playerId, "playerId");
                Intrinsics.checkNotNullParameter(plugin, "plugin");
                Integer n = (Integer)activeEagleEyes.remove(playerId);
                if (n == null) break block0;
                int taskId = ((Number)n).intValue();
                boolean bl = false;
                Bukkit.getScheduler().cancelTask(taskId);
            }
        }

        public final void stopAllEagleEyes(@NotNull Plugin plugin) {
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            Collection collection = activeEagleEyes.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Integer taskId = (Integer)element$iv;
                boolean bl = false;
                BukkitScheduler bukkitScheduler = Bukkit.getScheduler();
                Intrinsics.checkNotNull(taskId);
                bukkitScheduler.cancelTask(taskId.intValue());
            }
            activeEagleEyes.clear();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

