/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.items;

import com.hideandseek.game.Game;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.items.ItemConfig;
import com.hideandseek.items.ItemEffectHandler;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Result;
import com.hideandseek.libs.kotlin.ResultKt;
import com.hideandseek.libs.kotlin.Unit;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.functions.Function1;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J-\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/hideandseek/items/SecondChanceHandler;", "Lcom/hideandseek/items/ItemEffectHandler;", "<init>", "()V", "canApply", "", "player", "Lorg/bukkit/entity/Player;", "game", "Lcom/hideandseek/game/Game;", "apply", "Lcom/hideandseek/libs/kotlin/Result;", "", "config", "Lcom/hideandseek/items/ItemConfig;", "apply-0E7RQCE", "(Lorg/bukkit/entity/Player;Lcom/hideandseek/game/Game;Lcom/hideandseek/items/ItemConfig;)Ljava/lang/Object;", "onExpire", "getDisplayLore", "", "", "Companion", "EasyHideAndSeek"})
public final class SecondChanceHandler
implements ItemEffectHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ConcurrentHashMap<UUID, Long> activeSecondChances = new ConcurrentHashMap();

    @Override
    public boolean canApply(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        PlayerGameData playerGameData = game.getPlayers().get(player.getUniqueId());
        if (playerGameData == null) {
            return false;
        }
        PlayerGameData playerData = playerGameData;
        if (!Intrinsics.areEqual(playerData.getRole().name(), "HIDER")) {
            return false;
        }
        if (playerData.isCaptured()) {
            return false;
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        if (Companion.hasSecondChance(uUID)) {
            player.sendMessage("\u00a7c\u65e2\u306b\u30bb\u30ab\u30f3\u30c9\u30c1\u30e3\u30f3\u30b9\u3092\u6240\u6301\u3057\u3066\u3044\u307e\u3059");
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Object apply-0E7RQCE(@NotNull Player player, @NotNull Game game, @NotNull ItemConfig config) {
        Object object;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(config, "config");
        try {
            long expirationTime = System.currentTimeMillis() + (long)(config.getDuration() * 1000);
            Map map = activeSecondChances;
            UUID uUID = player.getUniqueId();
            Long l = expirationTime;
            map.put(uUID, l);
            player.sendMessage("\u00a7a\u2726 \u30bb\u30ab\u30f3\u30c9\u30c1\u30e3\u30f3\u30b9\u3092\u53d6\u5f97\u3057\u307e\u3057\u305f");
            player.sendMessage("\u00a77\u6b21\u306b\u6355\u7372\u3055\u308c\u305f\u6642\u30011\u56de\u3060\u3051\u5fa9\u6d3b\u3067\u304d\u307e\u3059");
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 0.5f, 1.2f);
            player.getWorld().spawnParticle(Particle.ENCHANT, player.getLocation().clone().add(0.0, 2.0, 0.0), 30, 0.3, 0.5, 0.3, 0.5);
            object = Result.constructor-impl(Unit.INSTANCE);
        }
        catch (Exception e) {
            object = Result.constructor-impl(ResultKt.createFailure(e));
        }
        return object;
    }

    @Override
    public void onExpire(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        if (activeSecondChances.remove(player.getUniqueId()) != null) {
            player.sendMessage("\u00a77\u30bb\u30ab\u30f3\u30c9\u30c1\u30e3\u30f3\u30b9\u306e\u52b9\u679c\u304c\u5207\u308c\u307e\u3057\u305f\uff08\u672a\u4f7f\u7528\uff09");
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.3f, 0.6f);
        }
    }

    @Override
    @NotNull
    public List<String> getDisplayLore(@NotNull ItemConfig config) {
        Intrinsics.checkNotNullParameter(config, "config");
        String[] stringArray = new String[]{"\u00a77\u6355\u7372\u3055\u308c\u305f\u6642\u306b1\u56de\u3060\u3051\u5fa9\u6d3b", "\u00a77\u4fdd\u967a\u3068\u3057\u3066\u975e\u5e38\u306b\u6709\u7528", "", "\u00a7b\u52b9\u679c: \u00a7f\u6355\u7372\u6642\u306b\u81ea\u52d5\u5fa9\u6d3b", "\u00a7b\u7121\u6575\u6642\u9593: \u00a7f" + config.getDuration() + "\u79d2", "\u00a7b\u6709\u52b9\u671f\u9650: \u00a7f\u8cfc\u5165\u304b\u308910\u5206\u9593", "", "\u00a7c\u6ce8\u610f: \u5fa9\u6d3b\u5f8c\u306f\u767a\u5149\u3057\u3066\u76ee\u7acb\u3061\u307e\u3059", "\u00a77\u7121\u6575\u6642\u9593\u4e2d\u306b\u5b89\u5168\u306a\u5834\u6240\u3078\u79fb\u52d5\u3057\u307e\u3057\u3087\u3046"};
        return CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/hideandseek/items/SecondChanceHandler$Companion;", "", "<init>", "()V", "activeSecondChances", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "", "hasSecondChance", "", "playerId", "consumeSecondChance", "player", "Lorg/bukkit/entity/Player;", "immunitySeconds", "", "cleanupExpired", "", "clearAll", "EasyHideAndSeek"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean hasSecondChance(@NotNull UUID playerId) {
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            return activeSecondChances.containsKey(playerId);
        }

        public final boolean consumeSecondChance(@NotNull Player player, int immunitySeconds) {
            Intrinsics.checkNotNullParameter(player, "player");
            if (!activeSecondChances.containsKey(player.getUniqueId())) {
                return false;
            }
            activeSecondChances.remove(player.getUniqueId());
            player.setGameMode(GameMode.SURVIVAL);
            player.setHealth(player.getMaxHealth());
            player.setFoodLevel(20);
            player.setSaturation(20.0f);
            PotionEffect immunityEffect = new PotionEffect(PotionEffectType.RESISTANCE, immunitySeconds * 20, 4, false, true, true);
            PotionEffect glowEffect = new PotionEffect(PotionEffectType.GLOWING, immunitySeconds * 20, 0, false, true, true);
            player.addPotionEffect(immunityEffect);
            player.addPotionEffect(glowEffect);
            player.sendMessage("\u00a76\u2726 \u30bb\u30ab\u30f3\u30c9\u30c1\u30e3\u30f3\u30b9\u767a\u52d5\uff01");
            player.sendMessage("\u00a7e" + immunitySeconds + "\u79d2\u9593\u7121\u6575\u72b6\u614b\u3067\u3059");
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
            player.getWorld().spawnParticle(Particle.TOTEM_OF_UNDYING, player.getLocation().clone().add(0.0, 1.0, 0.0), 50, 0.5, 1.0, 0.5, 0.1);
            return true;
        }

        public final void cleanupExpired() {
            long now = System.currentTimeMillis();
            activeSecondChances.entrySet().removeIf(arg_0 -> Companion.cleanupExpired$lambda$1(arg_0 -> Companion.cleanupExpired$lambda$0(now, arg_0), arg_0));
        }

        public final void clearAll() {
            activeSecondChances.clear();
        }

        private static final boolean cleanupExpired$lambda$0(long $now, Map.Entry entry) {
            Intrinsics.checkNotNullParameter(entry, "<destruct>");
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, "component2(...)");
            Long expirationTime = (Long)v;
            return $now > expirationTime;
        }

        private static final boolean cleanupExpired$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

