/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.blockrestoration.BlockRestorationManager;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hideandseek/listeners/BlockBreakListener;", "Lorg/bukkit/event/Listener;", "gameManager", "Lcom/hideandseek/game/GameManager;", "blockRestorationManager", "Lcom/hideandseek/blockrestoration/BlockRestorationManager;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lcom/hideandseek/game/GameManager;Lcom/hideandseek/blockrestoration/BlockRestorationManager;Lorg/bukkit/plugin/Plugin;)V", "onBlockBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "EasyHideAndSeek"})
public final class BlockBreakListener
implements Listener {
    @NotNull
    private final GameManager gameManager;
    @NotNull
    private final BlockRestorationManager blockRestorationManager;
    @NotNull
    private final Plugin plugin;

    public BlockBreakListener(@NotNull GameManager gameManager, @NotNull BlockRestorationManager blockRestorationManager, @NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        Intrinsics.checkNotNullParameter(blockRestorationManager, "blockRestorationManager");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.gameManager = gameManager;
        this.blockRestorationManager = blockRestorationManager;
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        this.plugin.getLogger().info("[BlockBreak] Player " + player2.getName() + " broke block at " + block2.getLocation());
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            this.plugin.getLogger().info("[BlockBreak] No active game - allowing normal break");
            return;
        }
        this.plugin.getLogger().info("[BlockBreak] Active game found: " + game.getId());
        if (!game.getPlayers().containsKey(player2.getUniqueId())) {
            this.plugin.getLogger().info("[BlockBreak] Player " + player2.getName() + " not in game - allowing normal break");
            return;
        }
        this.plugin.getLogger().info("[BlockBreak] Player " + player2.getName() + " is in game - processing restoration");
        boolean tracked = this.blockRestorationManager.trackBrokenBlock(block2, game.getId());
        this.plugin.getLogger().info("[BlockBreak] Block tracked: " + tracked);
        if (tracked) {
            event.setCancelled(true);
            block2.setType(Material.AIR);
            block2.getWorld().playEffect(block2.getLocation(), Effect.STEP_SOUND, (Object)block2.getType());
            this.plugin.getLogger().info("[BlockBreak] Block set to AIR, will restore in 5 seconds");
        } else {
            this.plugin.getLogger().info("[BlockBreak] Block was NOT tracked - allowing normal break");
        }
    }
}

