/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.GameResult;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.utils.MessageUtil;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/hideandseek/listeners/BlockDamageListener;", "Lorg/bukkit/event/Listener;", "disguiseManager", "Lcom/hideandseek/disguise/DisguiseManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lcom/hideandseek/disguise/DisguiseManager;Lcom/hideandseek/game/GameManager;)V", "onBlockDamage", "", "event", "Lorg/bukkit/event/block/BlockDamageEvent;", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nBlockDamageListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockDamageListener.kt\ncom/hideandseek/listeners/BlockDamageListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1869#2,2:75\n*S KotlinDebug\n*F\n+ 1 BlockDamageListener.kt\ncom/hideandseek/listeners/BlockDamageListener\n*L\n62#1:75,2\n*E\n"})
public final class BlockDamageListener
implements Listener {
    @NotNull
    private final DisguiseManager disguiseManager;
    @NotNull
    private final GameManager gameManager;

    public BlockDamageListener(@NotNull DisguiseManager disguiseManager, @NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(disguiseManager, "disguiseManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.disguiseManager = disguiseManager;
        this.gameManager = gameManager;
    }

    @EventHandler
    public final void onBlockDamage(@NotNull BlockDamageEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player attacker = player;
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location location2 = location;
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        PlayerGameData playerGameData = game2.getPlayers().get(attacker.getUniqueId());
        if (playerGameData == null) {
            return;
        }
        PlayerGameData attackerData = playerGameData;
        if (attackerData.getRole() != PlayerRole.SEEKER) {
            return;
        }
        UUID uUID = this.disguiseManager.getDisguisedPlayerAt(location2);
        if (uUID == null) {
            return;
        }
        UUID hiderId = uUID;
        event.setCancelled(true);
        Player hider = Bukkit.getPlayer((UUID)hiderId);
        if (hider == null) {
            this.disguiseManager.undisguiseByLocation(location2);
            return;
        }
        PlayerGameData hiderData = game2.getPlayers().get(hiderId);
        if (hiderData == null) {
            this.disguiseManager.undisguise(hider, "capture");
            return;
        }
        if (hiderData.isCaptured()) {
            return;
        }
        this.disguiseManager.undisguise(hider, "capture");
        hiderData.capture();
        attackerData.recordCapture();
        hider.setGameMode(GameMode.SPECTATOR);
        MessageUtil.INSTANCE.send((CommandSender)attacker, "&aYou captured " + hider.getName() + "!");
        MessageUtil.INSTANCE.send((CommandSender)hider, "&cYou were captured by " + attacker.getName() + "!");
        Iterable $this$forEach$iv = game2.getPlayers().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player2;
            PlayerGameData playerData = (PlayerGameData)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)playerData.getUuid()) == null) continue;
            boolean bl2 = false;
            MessageUtil.INSTANCE.send((CommandSender)player2, "&e" + hider.getName() + " was captured! (" + game2.getCaptured().size() + "/" + game2.getHiders().size() + ")");
        }
        GameResult winCondition = game2.checkWinCondition(0L);
        if (winCondition != null) {
            this.gameManager.endGame(winCondition);
        }
    }
}

