/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaBoundaries;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.GamePhase;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.utils.MessageUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/hideandseek/listeners/BoundaryListener;", "Lorg/bukkit/event/Listener;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lcom/hideandseek/game/GameManager;)V", "onPlayerMove", "", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "Companion", "EasyHideAndSeek"})
public final class BoundaryListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GameManager gameManager;
    @NotNull
    private static final Map<UUID, Long> lastBoundaryWarning = new LinkedHashMap();

    public BoundaryListener(@NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.gameManager = gameManager;
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        Arena arena;
        ArenaBoundaries boundaries;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Location location = event.getTo();
        if (location == null) {
            return;
        }
        Location to = location;
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        if (game2.getPhase() != GamePhase.SEEKING && game2.getPhase() != GamePhase.PREPARATION) {
            return;
        }
        if (!game2.getPlayers().containsKey(player2.getUniqueId())) {
            return;
        }
        if (game2.getPhase() == GamePhase.PREPARATION) {
            PlayerGameData playerData;
            PlayerGameData playerGameData = playerData = game2.getPlayers().get(player2.getUniqueId());
            if ((playerGameData != null ? playerGameData.getRole() : null) == PlayerRole.SEEKER) {
                return;
            }
        }
        if (!(boundaries = (arena = game2.getArena()).getBoundaries()).contains(to)) {
            long lastWarning;
            event.setCancelled(true);
            long now = System.currentTimeMillis();
            Long l = lastBoundaryWarning.get(player2.getUniqueId());
            long l2 = lastWarning = l != null ? l : 0L;
            if (now - lastWarning > 1000L) {
                lastBoundaryWarning.put(player2.getUniqueId(), now);
                MessageUtil.INSTANCE.send((CommandSender)player2, "&c\u30b2\u30fc\u30e0\u30a8\u30ea\u30a2\u5916\u306b\u306f\u51fa\u3089\u308c\u307e\u305b\u3093!");
                this.gameManager.getPlugin().getLogger().info("[Boundary] " + player2.getName() + " tried to leave arena:");
                this.gameManager.getPlugin().getLogger().info("  Attempted position: (" + to.getBlockX() + ", " + to.getBlockZ() + ")");
                this.gameManager.getPlugin().getLogger().info("  Arena bounds: X[" + Math.min(boundaries.getPos1().getBlockX(), boundaries.getPos2().getBlockX()) + " to " + Math.max(boundaries.getPos1().getBlockX(), boundaries.getPos2().getBlockX()) + "], Z[" + Math.min(boundaries.getPos1().getBlockZ(), boundaries.getPos2().getBlockZ()) + " to " + Math.max(boundaries.getPos1().getBlockZ(), boundaries.getPos2().getBlockZ()) + "]");
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/hideandseek/listeners/BoundaryListener$Companion;", "", "<init>", "()V", "lastBoundaryWarning", "", "Ljava/util/UUID;", "", "EasyHideAndSeek"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

