/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.disguise.DisguiseData;
import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/hideandseek/listeners/PlayerMoveListener;", "Lorg/bukkit/event/Listener;", "disguiseManager", "Lcom/hideandseek/disguise/DisguiseManager;", "<init>", "(Lcom/hideandseek/disguise/DisguiseManager;)V", "plugin", "Lorg/bukkit/plugin/Plugin;", "setPlugin", "", "onPlayerMove", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "EasyHideAndSeek"})
public final class PlayerMoveListener
implements Listener {
    @NotNull
    private final DisguiseManager disguiseManager;
    @Nullable
    private Plugin plugin;

    public PlayerMoveListener(@NotNull DisguiseManager disguiseManager) {
        Intrinsics.checkNotNullParameter(disguiseManager, "disguiseManager");
        this.disguiseManager = disguiseManager;
    }

    public final void setPlugin(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler
    public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
        int dz;
        int dy;
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        Location location = event.getTo();
        if (location == null) {
            return;
        }
        Location to = location;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        if (!this.disguiseManager.isDisguised(uUID)) {
            return;
        }
        DisguiseData disguiseData = this.disguiseManager.getActiveDisguises().get(player2.getUniqueId());
        if (disguiseData == null) {
            return;
        }
        DisguiseData disguiseData2 = disguiseData;
        Location disguiseLocation = disguiseData2.getBlockLocation();
        int dx = to.getBlockX() - disguiseLocation.getBlockX();
        double distance = Math.sqrt(dx * dx + (dy = to.getBlockY() - disguiseLocation.getBlockY()) * dy + (dz = to.getBlockZ() - disguiseLocation.getBlockZ()) * dz);
        if (distance > 1.0) {
            Object object = this.plugin;
            if (object != null && (object = object.getLogger()) != null) {
                String string = player2.getName();
                String string2 = "%.2f";
                Object[] objectArray = new Object[]{distance};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
                ((Logger)object).info("[Disguise] Player " + string + " moved " + string3 + " blocks from disguise location");
            }
            this.disguiseManager.undisguise(player2, "movement");
        }
    }
}

