/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.effects.EffectManager;
import com.hideandseek.effects.EffectType;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.text.StringsKt;
import com.hideandseek.points.PointManager;
import com.hideandseek.shop.CooldownException;
import com.hideandseek.shop.InsufficientFundsException;
import com.hideandseek.shop.InventoryFullException;
import com.hideandseek.shop.ItemPurchaseRecord;
import com.hideandseek.shop.PurchaseLimitException;
import com.hideandseek.shop.PurchaseStorage;
import com.hideandseek.shop.PurchaseValidator;
import com.hideandseek.shop.RoleRestrictionException;
import com.hideandseek.shop.ShopAction;
import com.hideandseek.shop.ShopItem;
import com.hideandseek.shop.ShopManager;
import com.hideandseek.shop.UsageRestrictionException;
import com.hideandseek.utils.MessageUtil;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J \u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$H\u0002J \u0010&\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J0\u0010+\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020,2\u0006\u0010)\u001a\u00020*2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020$H\u0002J \u0010/\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u0002002\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00101\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002J \u00102\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u0002032\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00064"}, d2={"Lcom/hideandseek/listeners/ShopListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "shopManager", "Lcom/hideandseek/shop/ShopManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "effectManager", "Lcom/hideandseek/effects/EffectManager;", "purchaseStorage", "Lcom/hideandseek/shop/PurchaseStorage;", "economy", "Lnet/milkbowl/vault/economy/Economy;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/shop/ShopManager;Lcom/hideandseek/game/GameManager;Lcom/hideandseek/effects/EffectManager;Lcom/hideandseek/shop/PurchaseStorage;Lnet/milkbowl/vault/economy/Economy;)V", "disguiseManager", "Lcom/hideandseek/disguise/DisguiseManager;", "getDisguiseManager", "()Lcom/hideandseek/disguise/DisguiseManager;", "setDisguiseManager", "(Lcom/hideandseek/disguise/DisguiseManager;)V", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "getMessageManager", "()Lcom/hideandseek/i18n/MessageManager;", "setMessageManager", "(Lcom/hideandseek/i18n/MessageManager;)V", "onInventoryClick", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "handleItemPurchase", "player", "Lorg/bukkit/entity/Player;", "categoryId", "", "itemId", "handleDisguisePurchase", "action", "Lcom/hideandseek/shop/ShopAction$Disguise;", "shopItem", "Lcom/hideandseek/shop/ShopItem;", "handleEffectItemPurchase", "Lcom/hideandseek/shop/ShopAction$UseEffectItem;", "playerRole", "gameId", "handleTauntItemPurchase", "Lcom/hideandseek/shop/ShopAction$UseTauntItem;", "spawnTauntFirework", "handleGiveItemPurchase", "Lcom/hideandseek/shop/ShopAction$GiveItem;", "EasyHideAndSeek"})
public final class ShopListener
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final ShopManager shopManager;
    @NotNull
    private final GameManager gameManager;
    @Nullable
    private final EffectManager effectManager;
    @NotNull
    private final PurchaseStorage purchaseStorage;
    @Nullable
    private final Economy economy;
    @Nullable
    private DisguiseManager disguiseManager;
    @Nullable
    private MessageManager messageManager;

    public ShopListener(@NotNull Plugin plugin, @NotNull ShopManager shopManager, @NotNull GameManager gameManager, @Nullable EffectManager effectManager, @NotNull PurchaseStorage purchaseStorage, @Nullable Economy economy) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(shopManager, "shopManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        Intrinsics.checkNotNullParameter(purchaseStorage, "purchaseStorage");
        this.plugin = plugin;
        this.shopManager = shopManager;
        this.gameManager = gameManager;
        this.effectManager = effectManager;
        this.purchaseStorage = purchaseStorage;
        this.economy = economy;
    }

    @Nullable
    public final DisguiseManager getDisguiseManager() {
        return this.disguiseManager;
    }

    public final void setDisguiseManager(@Nullable DisguiseManager disguiseManager) {
        this.disguiseManager = disguiseManager;
    }

    @Nullable
    public final MessageManager getMessageManager() {
        return this.messageManager;
    }

    public final void setMessageManager(@Nullable MessageManager messageManager) {
        this.messageManager = messageManager;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onInventoryClick(@NotNull InventoryClickEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter(event, "event");
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        player2.sendMessage("\u00a78[Debug] Inventory click detected");
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack clickedItem = itemStack;
        InventoryView inventoryView = event.getView();
        Intrinsics.checkNotNullExpressionValue(inventoryView, "getView(...)");
        InventoryView view = inventoryView;
        String string = view.getTitle();
        Intrinsics.checkNotNullExpressionValue(string, "getTitle(...)");
        String title = string;
        player2.sendMessage("\u00a77[Debug] Clicked item: " + clickedItem.getType());
        player2.sendMessage("\u00a77[Debug] Inventory title: " + title);
        String itemId = this.shopManager.getItemIdFromItem(clickedItem);
        String categoryId = this.shopManager.getCategoryFromItem(clickedItem);
        player2.sendMessage("\u00a77[Debug] ItemId: " + itemId + ", CategoryId: " + categoryId);
        if (itemId == null && categoryId == null && !this.shopManager.isShopItem(clickedItem)) {
            player2.sendMessage("\u00a7c[Debug] Not a shop item, ignoring");
            return;
        }
        event.setCancelled(true);
        player2.sendMessage("\u00a7a[Debug] Shop item detected!");
        Game game = this.gameManager.getActiveGame();
        String playerRole = game != null && game.getPlayers().containsKey(player2.getUniqueId()) ? ((object = game.getPlayers().get(player2.getUniqueId())) != null && (object = ((PlayerGameData)object).getRole()) != null ? ((Enum)object).name() : null) : null;
        String string2 = itemId;
        if (Intrinsics.areEqual(string2, "close")) {
            player2.closeInventory();
            return;
        }
        if (Intrinsics.areEqual(string2, "back")) {
            this.shopManager.openMainMenu(player2, playerRole);
            return;
        }
        if (categoryId != null && itemId == null) {
            this.shopManager.openCategory(player2, categoryId, playerRole);
            return;
        }
        if (categoryId != null && itemId != null) {
            this.handleItemPurchase(player2, categoryId, itemId);
            return;
        }
    }

    private final void handleItemPurchase(Player player, String categoryId, String itemId) {
        player.sendMessage("\u00a7e[Debug] handleItemPurchase called: category=" + categoryId + ", item=" + itemId);
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cYou must be in a game to purchase items");
            player.closeInventory();
            return;
        }
        if (!game.getPlayers().containsKey(player.getUniqueId())) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cYou are not in this game");
            player.closeInventory();
            return;
        }
        PlayerGameData playerData = game.getPlayers().get(player.getUniqueId());
        if (playerData == null) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&cPlayer data not found");
            player.closeInventory();
            return;
        }
        String playerRole = playerData.getRole().name();
        ShopItem shopItem = this.shopManager.getShopItem(categoryId, itemId);
        if (shopItem == null) {
            player.sendMessage("\u00a7c[Debug] Shop item not found!");
            MessageUtil.INSTANCE.send((CommandSender)player, "&cItem not found");
            return;
        }
        player.sendMessage("\u00a7a[Debug] Shop item found: " + shopItem.getDisplayName());
        ShopAction action = shopItem.getAction();
        if (action instanceof ShopAction.Disguise) {
            this.handleDisguisePurchase(player, (ShopAction.Disguise)action, shopItem);
        } else if (action instanceof ShopAction.UseEffectItem) {
            this.handleEffectItemPurchase(player, (ShopAction.UseEffectItem)action, shopItem, playerRole, game.getArena().getName());
        } else if (action instanceof ShopAction.UseTauntItem) {
            player.sendMessage("\u00a7c[Debug] ERROR: UseTauntItem action detected - this should not happen!");
            player.sendMessage("\u00a7c[Debug] Item: " + shopItem.getId() + ", tauntType: " + ((ShopAction.UseTauntItem)action).getTauntType());
            MessageUtil.INSTANCE.send((CommandSender)player, "&c\u3053\u306e\u30a2\u30a4\u30c6\u30e0\u306f\u53e4\u3044\u5f62\u5f0f\u3067\u3059\u3002\u7ba1\u7406\u8005\u306b\u9023\u7d61\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        } else if (action instanceof ShopAction.GiveItem) {
            this.handleGiveItemPurchase(player, (ShopAction.GiveItem)action, shopItem);
        } else if (action instanceof ShopAction.GoBack) {
            this.shopManager.openMainMenu(player, playerRole);
        } else if (action instanceof ShopAction.Close) {
            player.closeInventory();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void handleDisguisePurchase(Player player, ShopAction.Disguise action, ShopItem shopItem) {
        player.sendMessage("\u00a7b[Debug] Disguise action triggered for: " + action.getBlockType());
        DisguiseManager disguiseMgr = this.disguiseManager;
        if (disguiseMgr != null) {
            player.sendMessage("\u00a7b[Debug] DisguiseManager found, attempting disguise...");
            boolean success = disguiseMgr.disguise(player, action.getBlockType());
            player.sendMessage("\u00a7b[Debug] Disguise result: " + success);
            if (success) {
                player.closeInventory();
            }
        } else {
            player.sendMessage("\u00a7c[Debug] DisguiseManager is NULL!");
            MessageUtil.INSTANCE.send((CommandSender)player, "&cDisguise system not available");
            player.closeInventory();
        }
    }

    private final void handleEffectItemPurchase(Player player, ShopAction.UseEffectItem action, ShopItem shopItem, String playerRole, String gameId) {
        player.sendMessage("\u00a7b[Debug] Effect item purchase: " + action.getEffectType());
        try {
            EconomyResponse response;
            PurchaseValidator.INSTANCE.validatePurchase(player, shopItem, playerRole, gameId, this.economy, this.purchaseStorage);
            if (this.economy != null && shopItem.getPrice() > 0 && !(response = this.economy.withdrawPlayer((OfflinePlayer)player, (double)shopItem.getPrice())).transactionSuccess()) {
                throw new InsufficientFundsException(shopItem.getPrice(), this.economy.getBalance((OfflinePlayer)player));
            }
            if (this.effectManager != null) {
                boolean success;
                Map metadata = new LinkedHashMap();
                if (action.getEffectType() == EffectType.VISION) {
                    metadata.put("originalViewDistance", player.getClientViewDistance());
                }
                if (success = EffectManager.applyEffect$default(this.effectManager, player, action.getEffectType(), action.getDuration(), action.getIntensity(), null, metadata, 16, null)) {
                    UUID uUID = player.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                    String string = shopItem.getId();
                    Instant instant = Instant.now();
                    Intrinsics.checkNotNullExpressionValue(instant, "now(...)");
                    ItemPurchaseRecord record = new ItemPurchaseRecord(uUID, string, instant, gameId, shopItem.getPrice(), true, null, null, 192, null);
                    this.purchaseStorage.recordPurchase(record);
                    MessageManager msgMgr = this.messageManager;
                    if (msgMgr != null) {
                        Object[] objectArray = new Object[]{shopItem.getDisplayName()};
                        msgMgr.send(player, "shop.purchase.success", objectArray);
                    } else {
                        MessageUtil.INSTANCE.send((CommandSender)player, "&a\u30a2\u30a4\u30c6\u30e0\u3092\u8cfc\u5165\u3057\u307e\u3057\u305f: &e" + shopItem.getDisplayName());
                    }
                    MessageUtil.INSTANCE.send((CommandSender)player, "&b" + action.getEffectType().getDisplayName() + " &a\u304c\u9069\u7528\u3055\u308c\u307e\u3057\u305f\uff08&e" + action.getDuration() + "\u79d2\u9593&a\uff09");
                    player.closeInventory();
                } else {
                    if (this.economy != null && shopItem.getPrice() > 0) {
                        this.economy.depositPlayer((OfflinePlayer)player, (double)shopItem.getPrice());
                    }
                    MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30a8\u30d5\u30a7\u30af\u30c8\u306e\u9069\u7528\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
            } else {
                if (this.economy != null && shopItem.getPrice() > 0) {
                    this.economy.depositPlayer((OfflinePlayer)player, (double)shopItem.getPrice());
                }
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30a8\u30d5\u30a7\u30af\u30c8\u30b7\u30b9\u30c6\u30e0\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
            }
        }
        catch (InsufficientFundsException e) {
            MessageManager msgMgr = this.messageManager;
            if (msgMgr != null) {
                Object[] objectArray = new Object[]{e.getRequired(), (int)e.getActual()};
                msgMgr.send(player, "shop.purchase.failed.insufficient", objectArray);
            } else {
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u304a\u91d1\u304c\u8db3\u308a\u307e\u305b\u3093\u3002\u5fc5\u8981: &e" + e.getRequired() + " coins &c/ \u6240\u6301: &e" + (int)e.getActual() + " coins");
            }
        }
        catch (PurchaseLimitException e) {
            MessageManager msgMgr = this.messageManager;
            if (msgMgr != null) {
                msgMgr.send(player, "shop.purchase.failed.limit", new Object[0]);
            } else {
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u3053\u306e\u30a2\u30a4\u30c6\u30e0\u306f\u8cfc\u5165\u5236\u9650\u306b\u9054\u3057\u3066\u3044\u307e\u3059 (" + e.getCurrent() + "/" + e.getLimit() + ")");
            }
        }
        catch (CooldownException e) {
            MessageManager msgMgr = this.messageManager;
            if (msgMgr != null) {
                Object[] objectArray = new Object[]{e.getRemainingSeconds()};
                msgMgr.send(player, "shop.purchase.failed.cooldown", objectArray);
            } else {
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30af\u30fc\u30eb\u30c0\u30a6\u30f3\u4e2d\u3067\u3059\u3002\u6b8b\u308a\u6642\u9593: &e" + e.getRemainingSeconds() + "\u79d2");
            }
        }
        catch (InventoryFullException e) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30a4\u30f3\u30d9\u30f3\u30c8\u30ea\u304c\u3044\u3063\u3071\u3044\u3067\u3059");
        }
        catch (RoleRestrictionException e) {
            if (StringsKt.equals(e.getRequiredRole(), "SEEKER", true)) {
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u3053\u306e\u30a2\u30a4\u30c6\u30e0\u306f\u30b7\u30fc\u30ab\u30fc\u5c02\u7528\u3067\u3059");
            } else {
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u3053\u306e\u30a2\u30a4\u30c6\u30e0\u306f\u30cf\u30a4\u30c0\u30fc\u5c02\u7528\u3067\u3059");
            }
        }
        catch (UsageRestrictionException e) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&c" + e.getReason());
        }
        catch (Exception e) {
            player.sendMessage("\u00a7c[Debug] Unexpected error: " + e.getMessage());
            e.printStackTrace();
            MessageUtil.INSTANCE.send((CommandSender)player, "&c\u8cfc\u5165\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }

    private final void handleTauntItemPurchase(Player player, ShopAction.UseTauntItem action, ShopItem shopItem) {
        player.sendMessage("\u00a7b[Debug] Taunt item purchase: " + action.getTauntType());
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30b2\u30fc\u30e0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
            return;
        }
        String string = action.getTauntType().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        String string2 = string;
        if (Intrinsics.areEqual(string2, "SNOWBALL")) {
            PointManager pointMgr;
            Projectile projectile = player.launchProjectile(Snowball.class);
            Intrinsics.checkNotNullExpressionValue(projectile, "launchProjectile(...)");
            Snowball snowball = (Snowball)projectile;
            snowball.setVelocity(player.getLocation().getDirection().multiply(1.5));
            PointManager pointManager = pointMgr = this.gameManager.getPointManager();
            if (pointManager != null) {
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                pointManager.awardTauntBonus(uUID, action.getBonusPoints());
            }
            MessageUtil.INSTANCE.send((CommandSender)player, "&a\u96ea\u7389\u3092\u6295\u3052\u307e\u3057\u305f\uff01");
            MessageUtil.INSTANCE.send((CommandSender)player, "&e+" + action.getBonusPoints() + " \u30dd\u30a4\u30f3\u30c8 &7(\u96ea\u7389\u6311\u767a)");
            player.sendMessage("\u00a7c\u8b66\u544a: \u30b7\u30fc\u30ab\u30fc\u306b\u4f4d\u7f6e\u304c\u30d0\u30ec\u3084\u3059\u304f\u306a\u308a\u307e\u3057\u305f\uff01");
        } else if (Intrinsics.areEqual(string2, "FIREWORK")) {
            PointManager pointMgr;
            this.spawnTauntFirework(player);
            PointManager pointManager = pointMgr = this.gameManager.getPointManager();
            if (pointManager != null) {
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                pointManager.awardTauntBonus(uUID, action.getBonusPoints());
            }
            MessageUtil.INSTANCE.send((CommandSender)player, "&a\u82b1\u706b\u3092\u6253\u3061\u4e0a\u3052\u307e\u3057\u305f\uff01");
            MessageUtil.INSTANCE.send((CommandSender)player, "&e+" + action.getBonusPoints() + " \u30dd\u30a4\u30f3\u30c8 &7(\u82b1\u706b\u6311\u767a)");
            player.sendMessage("\u00a7c\u8b66\u544a: \u30b7\u30fc\u30ab\u30fc\u306b\u4f4d\u7f6e\u304c\u975e\u5e38\u306b\u30d0\u30ec\u3084\u3059\u304f\u306a\u308a\u307e\u3057\u305f\uff01");
        } else {
            MessageUtil.INSTANCE.send((CommandSender)player, "&c\u4e0d\u660e\u306a\u6311\u767a\u30bf\u30a4\u30d7\u3067\u3059");
            return;
        }
        player.closeInventory();
    }

    private final void spawnTauntFirework(Player player) {
        Location location = player.getLocation().clone().add(0.0, 1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location location2 = location;
        Entity entity = player.getWorld().spawnEntity(location2, EntityType.FIREWORK_ROCKET);
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.Firework");
        Firework firework = (Firework)entity;
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        Intrinsics.checkNotNullExpressionValue(fireworkMeta, "getFireworkMeta(...)");
        FireworkMeta meta = fireworkMeta;
        Color[] colorArray = new Color[]{Color.RED, Color.YELLOW, Color.LIME, Color.AQUA, Color.FUCHSIA};
        FireworkEffect fireworkEffect = FireworkEffect.builder().withColor(colorArray).with(FireworkEffect.Type.BALL_LARGE).withTrail().withFlicker().build();
        Intrinsics.checkNotNullExpressionValue(fireworkEffect, "build(...)");
        FireworkEffect effect = fireworkEffect;
        meta.addEffect(effect);
        meta.setPower(1);
        firework.setFireworkMeta(meta);
    }

    private final void handleGiveItemPurchase(Player player, ShopAction.GiveItem action, ShopItem shopItem) {
        player.sendMessage("\u00a7b[Debug] GiveItem action triggered: " + action.getMaterial() + " x" + action.getAmount());
        try {
            int price = shopItem.getEffectivePrice();
            PointManager pointMgr = this.gameManager.getPointManager();
            if (pointMgr == null) {
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30dd\u30a4\u30f3\u30c8\u30b7\u30b9\u30c6\u30e0\u304c\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
                return;
            }
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            int currentPoints = pointMgr.getPoints(uUID);
            if (currentPoints < price) {
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u8cfc\u5165\u306b\u5931\u6557\u3057\u307e\u3057\u305f - \u30b3\u30a4\u30f3\u304c\u8db3\u308a\u307e\u305b\u3093");
                MessageUtil.INSTANCE.send((CommandSender)player, "&7\u5fc5\u8981: &e" + price + " &7/ \u6240\u6301: &e" + currentPoints);
                return;
            }
            UUID uUID2 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            pointMgr.addPoints(uUID2, -price);
            ItemStack itemStack = new ItemStack(action.getMaterial(), action.getAmount());
            ItemStack[] itemStackArray = new ItemStack[]{itemStack};
            HashMap hashMap = player.getInventory().addItem(itemStackArray);
            Intrinsics.checkNotNullExpressionValue(hashMap, "addItem(...)");
            HashMap remaining = hashMap;
            if (remaining.isEmpty()) {
                MessageUtil.INSTANCE.send((CommandSender)player, "&a" + shopItem.getDisplayName() + " &7\u3092 &e" + action.getAmount() + "\u500b &7\u8cfc\u5165\u3057\u307e\u3057\u305f\uff01");
                MessageUtil.INSTANCE.send((CommandSender)player, "&7-" + price + " \u30b3\u30a4\u30f3 &7(\u6b8b\u308a: &e" + (currentPoints - price) + "&7)");
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            } else {
                UUID uUID3 = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
                pointMgr.addPoints(uUID3, price);
                MessageUtil.INSTANCE.send((CommandSender)player, "&c\u30a4\u30f3\u30d9\u30f3\u30c8\u30ea\u304c\u3044\u3063\u3071\u3044\u3067\u3059");
            }
            player.closeInventory();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error purchasing item: " + e.getMessage());
            e.printStackTrace();
            MessageUtil.INSTANCE.send((CommandSender)player, "&c\u8cfc\u5165\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }
}

