/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.scoreboard;

import com.hideandseek.HideAndSeekPlugin;
import com.hideandseek.game.Game;
import com.hideandseek.game.GamePhase;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.text.StringsKt;
import com.hideandseek.points.PointManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u000fJ\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/hideandseek/scoreboard/LocalizedScoreboardManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "messageManager", "Lcom/hideandseek/i18n/MessageManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/i18n/MessageManager;)V", "updateTask", "Lorg/bukkit/scheduler/BukkitTask;", "playerScoreboards", "", "Ljava/util/UUID;", "Lorg/bukkit/scoreboard/Scoreboard;", "startUpdating", "", "game", "Lcom/hideandseek/game/Game;", "stopUpdating", "clearAll", "createScoreboard", "player", "Lorg/bukkit/entity/Player;", "copyTeamsFromMain", "targetScoreboard", "buildLocalizedLines", "", "", "updateScoreboard", "clearScoreboard", "addPlayer", "removePlayer", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nLocalizedScoreboardManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizedScoreboardManager.kt\ncom/hideandseek/scoreboard/LocalizedScoreboardManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n1869#2,2:282\n1869#2,2:284\n1869#2:286\n1869#2,2:287\n1870#2:289\n1869#2,2:290\n1878#2,3:292\n1869#2,2:295\n*S KotlinDebug\n*F\n+ 1 LocalizedScoreboardManager.kt\ncom/hideandseek/scoreboard/LocalizedScoreboardManager\n*L\n37#1:282,2\n69#1:284,2\n126#1:286\n149#1:287,2\n126#1:289\n243#1:290,2\n251#1:292,3\n45#1:295,2\n*E\n"})
public final class LocalizedScoreboardManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final MessageManager messageManager;
    @Nullable
    private BukkitTask updateTask;
    @NotNull
    private final Map<UUID, Scoreboard> playerScoreboards;

    public LocalizedScoreboardManager(@NotNull Plugin plugin, @NotNull MessageManager messageManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(messageManager, "messageManager");
        this.plugin = plugin;
        this.messageManager = messageManager;
        this.playerScoreboards = new LinkedHashMap();
    }

    public final void startUpdating(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        this.stopUpdating();
        Iterable $this$forEach$iv = game.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this.createScoreboard(player, game);
        }
        this.updateTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> LocalizedScoreboardManager.startUpdating$lambda$1(game, this), 20L, 20L);
        this.plugin.getLogger().info("[LocalizedScoreboard] Started scoreboard updates");
    }

    public final void stopUpdating() {
        BukkitTask bukkitTask = this.updateTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.updateTask = null;
        this.plugin.getLogger().info("[LocalizedScoreboard] Stopped scoreboard updates");
    }

    public final void clearAll() {
        this.stopUpdating();
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.playerScoreboards.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this.clearScoreboard(player);
        }
        this.playerScoreboards.clear();
        this.plugin.getLogger().info("[LocalizedScoreboard] Cleared all scoreboards");
    }

    private final void createScoreboard(Player player, Game game) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getNewScoreboard(...)");
        Scoreboard scoreboard2 = scoreboard;
        this.copyTeamsFromMain(scoreboard2);
        String title = this.messageManager.getRawMessage(player, "ui.scoreboard.title", new Object[0]);
        Objective objective = scoreboard2.registerNewObjective("hideandseek", "dummy", StringsKt.replace$default(title, '&', '\u00a7', false, 4, null));
        Intrinsics.checkNotNullExpressionValue(objective, "registerNewObjective(...)");
        Objective objective2 = objective;
        objective2.setDisplaySlot(DisplaySlot.SIDEBAR);
        player.setScoreboard(scoreboard2);
        this.playerScoreboards.put(player.getUniqueId(), scoreboard2);
        this.plugin.getLogger().info("[LocalizedScoreboard] Created scoreboard for " + player.getName() + " with teams copied");
        this.updateScoreboard(player, game);
    }

    private final void copyTeamsFromMain(Scoreboard targetScoreboard) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        Pair[] pairArray = new Pair[]{TuplesKt.to("hs_seekers", ChatColor.RED), TuplesKt.to("hs_hiders", ChatColor.GREEN), TuplesKt.to("hs_spectators", ChatColor.GRAY)};
        Map teamColors = MapsKt.mapOf(pairArray);
        Object[] objectArray = new Pair[]{TuplesKt.to("hs_seekers", Team.OptionStatus.ALWAYS), TuplesKt.to("hs_hiders", Team.OptionStatus.NEVER), TuplesKt.to("hs_spectators", Team.OptionStatus.ALWAYS)};
        Map teamVisibility = MapsKt.mapOf(objectArray);
        objectArray = new String[]{"hs_seekers", "hs_hiders", "hs_spectators"};
        Iterable $this$forEach$iv = CollectionsKt.listOf(objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Team mainTeam;
            Team newTeam;
            Team.OptionStatus optionStatus;
            ChatColor color;
            String teamName = (String)element$iv;
            boolean bl = false;
            if (mainScoreboard.getTeam(teamName) == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(targetScoreboard.registerNewTeam(teamName), "registerNewTeam(...)");
            ChatColor chatColor = (ChatColor)teamColors.get(teamName);
            if (chatColor == null) {
                chatColor = color = ChatColor.WHITE;
            }
            if ((optionStatus = (Team.OptionStatus)teamVisibility.get(teamName)) == null) {
                optionStatus = Team.OptionStatus.ALWAYS;
            }
            Team.OptionStatus visibility = optionStatus;
            newTeam.setColor(color);
            newTeam.setPrefix(switch (WhenMappings.$EnumSwitchMapping$0[color.ordinal()]) {
                case 1 -> "\u00a7c";
                case 2 -> "\u00a7a";
                case 3 -> "\u00a77";
                default -> "";
            });
            newTeam.setSuffix("");
            newTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, visibility);
            Set set = mainTeam.getEntries();
            Intrinsics.checkNotNullExpressionValue(set, "getEntries(...)");
            Iterable $this$forEach$iv2 = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String entry = (String)element$iv2;
                boolean bl3 = false;
                newTeam.addEntry(entry);
            }
        }
    }

    private final List<String> buildLocalizedLines(Player player, Game game) {
        Object[] timeText;
        PlayerGameData playerData = game.getPlayers().get(player.getUniqueId());
        List lines = new ArrayList();
        lines.add("\u00a77");
        switch (WhenMappings.$EnumSwitchMapping$1[game.getPhase().ordinal()]) {
            case 1: {
                long elapsed = (System.currentTimeMillis() - game.getPhaseStartTime()) / (long)1000;
                int remaining = 30 - (int)elapsed;
                Object[] objectArray = new Object[]{remaining};
                String timeText2 = this.messageManager.getRawMessage(player, "ui.scoreboard.phase.preparation", objectArray);
                boolean bl = lines.add(StringsKt.replace$default(timeText2, '&', '\u00a7', false, 4, null));
                break;
            }
            case 2: {
                long elapsed = (System.currentTimeMillis() - game.getPhaseStartTime()) / (long)1000;
                int seekTime = 600;
                int remaining = (int)((long)seekTime - elapsed);
                int minutes = remaining / 60;
                int seconds = remaining % 60;
                String timeString = minutes + ":" + StringsKt.padStart(String.valueOf(seconds), 2, '0');
                Object[] objectArray = new Object[]{timeString};
                timeText = this.messageManager.getRawMessage(player, "ui.scoreboard.phase.seeking", objectArray);
                boolean bl = lines.add(StringsKt.replace$default((String)timeText, '&', '\u00a7', false, 4, null));
                break;
            }
            case 3: {
                String timeText3 = this.messageManager.getRawMessage(player, "ui.scoreboard.phase.post_game", new Object[0]);
                boolean bl = lines.add(StringsKt.replace$default(timeText3, '&', '\u00a7', false, 4, null));
                break;
            }
            default: {
                String timeText4 = this.messageManager.getRawMessage(player, "ui.scoreboard.phase.waiting", new Object[0]);
                boolean bl = lines.add(StringsKt.replace$default(timeText4, '&', '\u00a7', false, 4, null));
            }
        }
        lines.add("\u00a78");
        int seekers = game.getSeekers().size();
        int hiders = game.getHiders().size();
        int captured = game.getCaptured().size();
        Object[] seekTime = new Object[]{seekers};
        String seekersText = this.messageManager.getRawMessage(player, "ui.scoreboard.seekers", seekTime);
        lines.add(StringsKt.replace$default(seekersText, '&', '\u00a7', false, 4, null));
        Object[] remaining = new Object[]{hiders};
        String hidersText = this.messageManager.getRawMessage(player, "ui.scoreboard.hiders", remaining);
        lines.add(StringsKt.replace$default(hidersText, '&', '\u00a7', false, 4, null));
        Object[] minutes = new Object[]{captured};
        String capturedText = this.messageManager.getRawMessage(player, "ui.scoreboard.captured", minutes);
        lines.add(StringsKt.replace$default(capturedText, '&', '\u00a7', false, 4, null));
        lines.add("\u00a79");
        if (playerData != null) {
            int n;
            PointManager pointMgr;
            String roleKey = switch (WhenMappings.$EnumSwitchMapping$2[playerData.getRole().ordinal()]) {
                case 1 -> "ui.scoreboard.role.seeker";
                case 2 -> {
                    if (playerData.isCaptured()) {
                        yield "ui.scoreboard.role.captured";
                    }
                    yield "ui.scoreboard.role.hider";
                }
                case 3 -> "ui.scoreboard.role.spectator";
                default -> throw new NoWhenBranchMatchedException();
            };
            String roleText = this.messageManager.getRawMessage(player, roleKey, new Object[0]);
            timeText = new Object[]{roleText};
            String yourRoleText = this.messageManager.getRawMessage(player, "ui.scoreboard.your_role", timeText);
            lines.add(StringsKt.replace$default(yourRoleText, '&', '\u00a7', false, 4, null));
            Plugin plugin = this.plugin;
            HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
            PointManager pointManager = pointMgr = hideAndSeekPlugin != null ? hideAndSeekPlugin.getPointManager() : null;
            if (pointManager != null) {
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                n = pointManager.getPoints(uUID);
            } else {
                n = 0;
            }
            int points = n;
            Object[] objectArray = new Object[]{points};
            String pointsText = this.messageManager.getRawMessage(player, "ui.scoreboard.your_points", objectArray);
            lines.add(StringsKt.replace$default(pointsText, '&', '\u00a7', false, 4, null));
        }
        lines.add("\u00a70");
        return lines;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateScoreboard(Player player, Game game) {
        Scoreboard scoreboard = this.playerScoreboards.get(player.getUniqueId());
        if (scoreboard == null) {
            return;
        }
        Scoreboard scoreboard2 = scoreboard;
        Objective objective = scoreboard2.getObjective("hideandseek");
        if (objective == null) {
            return;
        }
        Objective objective2 = objective;
        Set set = scoreboard2.getEntries();
        Intrinsics.checkNotNullExpressionValue(set, "getEntries(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String entry = (String)element$iv;
            boolean bl = false;
            scoreboard2.resetScores(entry);
        }
        List<String> lines = this.buildLocalizedLines(player, game);
        Iterable $this$forEachIndexed$iv = CollectionsKt.reversed((Iterable)lines);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            objective2.getScore((String)line).setScore(index);
        }
    }

    private final void clearScoreboard(Player player) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        player.setScoreboard(mainScoreboard);
        this.playerScoreboards.remove(player.getUniqueId());
    }

    public final void addPlayer(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        this.createScoreboard(player, game);
        this.plugin.getLogger().info("[LocalizedScoreboard] Added " + player.getName() + " to scoreboard");
    }

    public final void removePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.clearScoreboard(player);
        this.plugin.getLogger().info("[LocalizedScoreboard] Removed " + player.getName() + " from scoreboard");
    }

    private static final void startUpdating$lambda$1(Game $game, LocalizedScoreboardManager this$0) {
        Iterable $this$forEach$iv = $game.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this$0.updateScoreboard(player, $game);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ChatColor.values().length];
            try {
                nArray[ChatColor.RED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatColor.GREEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatColor.GRAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GamePhase.values().length];
            try {
                nArray[GamePhase.PREPARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.SEEKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.POST_GAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PlayerRole.values().length];
            try {
                nArray[PlayerRole.SEEKER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.HIDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.SPECTATOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

