/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.shop;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.functions.Function1;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.shop.ItemPurchaseRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\nJ-\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00010\u001eR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/hideandseek/shop/PurchaseStorage;", "", "<init>", "()V", "purchases", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "", "Lcom/hideandseek/shop/ItemPurchaseRecord;", "recordPurchase", "", "record", "getPurchases", "", "playerId", "getPurchasesForItem", "itemId", "", "getLatestPurchase", "countPurchases", "", "gameId", "clearPlayer", "clearAll", "canPurchase", "", "purchaseLimit", "(Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)Z", "markAsUsed", "getStats", "", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nPurchaseStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PurchaseStorage.kt\ncom/hideandseek/shop/PurchaseStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n774#2:145\n865#2,2:146\n1999#2,14:148\n1788#2,4:162\n388#2,7:166\n1788#2,4:174\n1#3:173\n*S KotlinDebug\n*F\n+ 1 PurchaseStorage.kt\ncom/hideandseek/shop/PurchaseStorage\n*L\n42#1:145\n42#1:146,2\n52#1:148,14\n64#1:162,4\n116#1:166,7\n133#1:174,4\n*E\n"})
public final class PurchaseStorage {
    @NotNull
    private final ConcurrentHashMap<UUID, List<ItemPurchaseRecord>> purchases = new ConcurrentHashMap();

    public final void recordPurchase(@NotNull ItemPurchaseRecord record) {
        Intrinsics.checkNotNullParameter(record, "record");
        this.purchases.computeIfAbsent(record.getPlayerId(), arg_0 -> PurchaseStorage.recordPurchase$lambda$1(PurchaseStorage::recordPurchase$lambda$0, arg_0)).add(record);
    }

    @NotNull
    public final List<ItemPurchaseRecord> getPurchases(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        List<ItemPurchaseRecord> list = this.purchases.get(playerId);
        if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemPurchaseRecord> getPurchasesForItem(@NotNull UUID playerId, @NotNull String itemId) {
        List list;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(itemId, "itemId");
        List<ItemPurchaseRecord> list2 = this.purchases.get(playerId);
        if (list2 != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ItemPurchaseRecord it = (ItemPurchaseRecord)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getItemId(), itemId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final ItemPurchaseRecord getLatestPurchase(@NotNull UUID playerId, @NotNull String itemId) {
        Object v0;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(itemId, "itemId");
        Iterable $this$maxByOrNull$iv = this.getPurchasesForItem(playerId, itemId);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ItemPurchaseRecord it = (ItemPurchaseRecord)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = it.getPurchaseTime();
                do {
                    Object e$iv = iterator$iv.next();
                    ItemPurchaseRecord it2 = (ItemPurchaseRecord)e$iv;
                    $i$a$-maxByOrNull-PurchaseStorage$getLatestPurchase$1 = false;
                    Comparable v$iv = it2.getPurchaseTime();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public final int countPurchases(@NotNull UUID playerId, @NotNull String itemId, @NotNull String gameId) {
        int n;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(itemId, "itemId");
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        List<ItemPurchaseRecord> list = this.purchases.get(playerId);
        if (list != null) {
            void $this$count$iv;
            Iterable iterable = list;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ItemPurchaseRecord it = (ItemPurchaseRecord)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it.getItemId(), itemId) && Intrinsics.areEqual(it.getGameId(), gameId)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            n = 0;
        }
        return n;
    }

    public final void clearPlayer(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        this.purchases.remove(playerId);
    }

    public final void clearAll() {
        this.purchases.clear();
    }

    public final boolean canPurchase(@NotNull UUID playerId, @NotNull String itemId, @NotNull String gameId, @Nullable Integer purchaseLimit) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(itemId, "itemId");
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        if (purchaseLimit == null) {
            return true;
        }
        int count = this.countPurchases(playerId, itemId, gameId);
        return count < purchaseLimit;
    }

    public final boolean markAsUsed(@NotNull UUID playerId, @NotNull String itemId, @NotNull String gameId) {
        int index;
        List<ItemPurchaseRecord> playerPurchases;
        block3: {
            int n;
            Intrinsics.checkNotNullParameter(playerId, "playerId");
            Intrinsics.checkNotNullParameter(itemId, "itemId");
            Intrinsics.checkNotNullParameter(gameId, "gameId");
            List<ItemPurchaseRecord> list = this.purchases.get(playerId);
            if (list == null) {
                return false;
            }
            List<ItemPurchaseRecord> $this$indexOfLast$iv = playerPurchases = list;
            boolean $i$f$indexOfLast = false;
            ListIterator<ItemPurchaseRecord> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                ItemPurchaseRecord it = iterator$iv.previous();
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getItemId(), itemId) && Intrinsics.areEqual(it.getGameId(), gameId) && !it.getUsed())) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = index = -1;
        }
        if (index == -1) {
            return false;
        }
        playerPurchases.set(index, playerPurchases.get(index).markUsed());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> getStats() {
        int n;
        int n2;
        List list;
        Object object2;
        Collection<List<ItemPurchaseRecord>> collection = this.purchases.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable iterable = collection;
        int n3 = 0;
        for (Object object2 : iterable) {
            void it;
            list = (List)object2;
            n2 = n3;
            boolean bl = false;
            n = it.size();
            n3 = n2 + n;
        }
        int totalPurchases = n3;
        Collection<List<ItemPurchaseRecord>> collection2 = this.purchases.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Pair[] pairArray = (Pair[])collection2;
        int n4 = 0;
        object2 = pairArray.iterator();
        while (object2.hasNext()) {
            int n5;
            void list2;
            List bl = list = object2.next();
            n2 = n4;
            boolean bl2 = false;
            Intrinsics.checkNotNull(list2);
            Iterable $this$count$iv = (Iterable)list2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n5 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ItemPurchaseRecord it = (ItemPurchaseRecord)element$iv;
                    boolean bl3 = false;
                    if (!it.getUsed() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n5 = count$iv;
            }
            n = n5;
            n4 = n2 + n;
        }
        int usedPurchases = n4;
        pairArray = new Pair[]{TuplesKt.to("total_players", this.purchases.size()), TuplesKt.to("total_purchases", totalPurchases), TuplesKt.to("used_purchases", usedPurchases), TuplesKt.to("unused_purchases", totalPurchases - usedPurchases)};
        return MapsKt.mapOf(pairArray);
    }

    private static final List recordPurchase$lambda$0(UUID it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    private static final List recordPurchase$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

