/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.shop;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.text.StringsKt;
import com.hideandseek.shop.CooldownException;
import com.hideandseek.shop.InsufficientFundsException;
import com.hideandseek.shop.InventoryFullException;
import com.hideandseek.shop.ItemPurchaseRecord;
import com.hideandseek.shop.PurchaseLimitException;
import com.hideandseek.shop.PurchaseStorage;
import com.hideandseek.shop.RoleRestrictionException;
import com.hideandseek.shop.ShopItem;
import com.hideandseek.shop.UsageRestriction;
import com.hideandseek.shop.UsageRestrictionException;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0014"}, d2={"Lcom/hideandseek/shop/PurchaseValidator;", "", "<init>", "()V", "validatePurchase", "", "player", "Lorg/bukkit/entity/Player;", "item", "Lcom/hideandseek/shop/ShopItem;", "playerRole", "", "gameId", "economy", "Lnet/milkbowl/vault/economy/Economy;", "purchaseStorage", "Lcom/hideandseek/shop/PurchaseStorage;", "validateUsageRestriction", "canPurchase", "", "EasyHideAndSeek"})
public final class PurchaseValidator {
    @NotNull
    public static final PurchaseValidator INSTANCE = new PurchaseValidator();

    private PurchaseValidator() {
    }

    public final void validatePurchase(@NotNull Player player, @NotNull ShopItem item, @NotNull String playerRole, @NotNull String gameId, @Nullable Economy economy, @NotNull PurchaseStorage purchaseStorage) {
        double balance;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(playerRole, "playerRole");
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        Intrinsics.checkNotNullParameter(purchaseStorage, "purchaseStorage");
        if (item.getRoleFilter() != null && !StringsKt.equals(item.getRoleFilter(), playerRole, true)) {
            throw new RoleRestrictionException(item.getId(), item.getRoleFilter(), playerRole);
        }
        this.validateUsageRestriction(player, item, gameId);
        int effectivePrice = item.getEffectivePrice();
        if (economy != null && effectivePrice > 0 && (balance = economy.getBalance((OfflinePlayer)player)) < (double)effectivePrice) {
            throw new InsufficientFundsException(effectivePrice, balance);
        }
        if (item.getMaxPurchases() != null) {
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            int purchaseCount = purchaseStorage.countPurchases(uUID, item.getId(), gameId);
            if (purchaseCount >= item.getMaxPurchases()) {
                throw new PurchaseLimitException(item.getId(), item.getMaxPurchases(), purchaseCount);
            }
        }
        if (item.getCooldown() != null) {
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            ItemPurchaseRecord latestPurchase = purchaseStorage.getLatestPurchase(uUID, item.getId());
            if (latestPurchase != null && !latestPurchase.isCooldownExpired(item.getCooldown())) {
                long remaining = (long)item.getCooldown().intValue() - latestPurchase.getElapsedSeconds();
                throw new CooldownException(item.getId(), remaining);
            }
        }
        if (!item.isEffectItem() && player.getInventory().firstEmpty() == -1) {
            throw new InventoryFullException(item.getId());
        }
    }

    private final void validateUsageRestriction(Player player, ShopItem item, String gameId) {
        switch (WhenMappings.$EnumSwitchMapping$0[item.getUsageRestriction().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                if (!(((CharSequence)gameId).length() == 0) && !Intrinsics.areEqual(gameId, "lobby")) break;
                throw new UsageRestrictionException(item.getId(), UsageRestriction.IN_GAME_ONLY, "Can only be used during an active game");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final boolean canPurchase(@NotNull Player player, @NotNull ShopItem item, @NotNull String playerRole, @NotNull String gameId, @Nullable Economy economy, @NotNull PurchaseStorage purchaseStorage) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(playerRole, "playerRole");
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        Intrinsics.checkNotNullParameter(purchaseStorage, "purchaseStorage");
        try {
            this.validatePurchase(player, item, playerRole, gameId, economy, purchaseStorage);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UsageRestriction.values().length];
            try {
                nArray[UsageRestriction.ALWAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsageRestriction.SEEK_PHASE_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsageRestriction.NOT_WHILE_CAPTURED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsageRestriction.ONCE_PER_GAME.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UsageRestriction.IN_GAME_ONLY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

