/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.utils;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.ranges.RangesKt;
import com.hideandseek.utils.MessageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0007J\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0018\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0019J\u0014\u0010\b\u001a\u00020\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u001f\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0018\"\u00020\u0010\u00a2\u0006\u0002\u0010\u001bJ?\u0010\u0011\u001a\u00020\u0000\"\u0004\b\u0000\u0010\u001c\"\b\b\u0001\u0010\u001d*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u00142\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u0002H\u001d0\u00152\u0006\u0010 \u001a\u0002H\u001d\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0011\u001a\"\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0014\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00150\u0013\u0012\u0004\u0012\u00020\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/hideandseek/utils/ItemBuilder;", "", "material", "Lorg/bukkit/Material;", "<init>", "(Lorg/bukkit/Material;)V", "displayName", "", "lore", "", "amount", "", "glow", "", "flags", "", "Lorg/bukkit/inventory/ItemFlag;", "persistentData", "", "Lcom/hideandseek/libs/kotlin/Pair;", "Lorg/bukkit/NamespacedKey;", "Lorg/bukkit/persistence/PersistentDataType;", "name", "lines", "", "([Ljava/lang/String;)Lcom/hideandseek/utils/ItemBuilder;", "", "([Lorg/bukkit/inventory/ItemFlag;)Lcom/hideandseek/utils/ItemBuilder;", "T", "Z", "key", "type", "value", "(Lorg/bukkit/NamespacedKey;Lorg/bukkit/persistence/PersistentDataType;Ljava/lang/Object;)Lcom/hideandseek/utils/ItemBuilder;", "build", "Lorg/bukkit/inventory/ItemStack;", "Companion", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nItemBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemBuilder.kt\ncom/hideandseek/utils/ItemBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,168:1\n1563#2:169\n1634#2,3:170\n37#3,2:173\n216#4,2:175\n*S KotlinDebug\n*F\n+ 1 ItemBuilder.kt\ncom/hideandseek/utils/ItemBuilder\n*L\n129#1:169\n129#1:170,3\n140#1:173,2\n146#1:175,2\n*E\n"})
public final class ItemBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Material material;
    @Nullable
    private String displayName;
    @NotNull
    private final List<String> lore;
    private int amount;
    private boolean glow;
    @NotNull
    private final Set<ItemFlag> flags;
    @NotNull
    private final Map<Pair<NamespacedKey, PersistentDataType<?, ?>>, Object> persistentData;

    public ItemBuilder(@NotNull Material material) {
        Intrinsics.checkNotNullParameter(material, "material");
        this.material = material;
        this.lore = new ArrayList();
        this.amount = 1;
        this.flags = new LinkedHashSet();
        this.persistentData = new LinkedHashMap();
    }

    @NotNull
    public final ItemBuilder displayName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.displayName = name;
        return this;
    }

    @NotNull
    public final ItemBuilder lore(String ... lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        CollectionsKt.addAll((Collection)this.lore, lines);
        return this;
    }

    @NotNull
    public final ItemBuilder lore(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        this.lore.addAll((Collection<String>)lines);
        return this;
    }

    @NotNull
    public final ItemBuilder amount(int amount) {
        this.amount = RangesKt.coerceIn(amount, 1, 64);
        return this;
    }

    @NotNull
    public final ItemBuilder glow(boolean glow) {
        this.glow = glow;
        return this;
    }

    @NotNull
    public final ItemBuilder flags(ItemFlag ... flags) {
        Intrinsics.checkNotNullParameter(flags, "flags");
        CollectionsKt.addAll((Collection)this.flags, flags);
        return this;
    }

    @NotNull
    public final <T, Z> ItemBuilder persistentData(@NotNull NamespacedKey key, @NotNull PersistentDataType<T, Z> type, @NotNull Z value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(value, "value");
        this.persistentData.put(TuplesKt.to(key, type), value);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ItemStack build() {
        ItemFlag[] $this$map$iv;
        String it;
        ItemStack item = new ItemStack(this.material, this.amount);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return item;
        }
        ItemMeta meta = itemMeta;
        String string = this.displayName;
        if (string != null) {
            it = string;
            boolean bl = false;
            meta.displayName(MessageUtil.INSTANCE.colorize(it));
        }
        if (!((Collection)this.lore).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable iterable = this.lore;
            ItemMeta itemMeta2 = meta;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MessageUtil.INSTANCE.colorize((String)it2));
            }
            itemMeta2.lore((List)destination$iv$iv);
        }
        if (this.glow) {
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            $this$map$iv = new ItemFlag[]{ItemFlag.HIDE_ENCHANTS};
            meta.addItemFlags($this$map$iv);
        }
        if (!((Collection)this.flags).isEmpty()) {
            Collection $this$toTypedArray$iv = this.flags;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$map$iv = thisCollection$iv.toArray(new ItemFlag[0]);
            meta.addItemFlags(Arrays.copyOf($this$map$iv, $this$map$iv.length));
        }
        if (!this.persistentData.isEmpty()) {
            Map<Pair<NamespacedKey, PersistentDataType<?, ?>>, Object> $this$forEach$iv = this.persistentData;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Pair<NamespacedKey, PersistentDataType<?, ?>>, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Pair<NamespacedKey, PersistentDataType<?, ?>>, Object> element$iv;
                Map.Entry<Pair<NamespacedKey, PersistentDataType<?, ?>>, Object> entry = element$iv = iterator2.next();
                boolean bl = false;
                Pair<NamespacedKey, PersistentDataType<?, ?>> keyType = entry.getKey();
                Object value = entry.getValue();
                NamespacedKey key = keyType.component1();
                PersistentDataType<?, ?> type = keyType.component2();
                PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
                Intrinsics.checkNotNull(type, "null cannot be cast to non-null type org.bukkit.persistence.PersistentDataType<kotlin.Any, kotlin.Any>");
                persistentDataContainer.set(key, type, value);
            }
        }
        item.setItemMeta(meta);
        return item;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/hideandseek/utils/ItemBuilder$Companion;", "", "<init>", "()V", "of", "Lcom/hideandseek/utils/ItemBuilder;", "material", "Lorg/bukkit/Material;", "EasyHideAndSeek"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ItemBuilder of(@NotNull Material material) {
            Intrinsics.checkNotNullParameter(material, "material");
            return new ItemBuilder(material);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

