/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek;

import com.hideandseek.arena.ArenaManager;
import com.hideandseek.blockrestoration.BlockRestorationManager;
import com.hideandseek.commands.AdminCommand;
import com.hideandseek.commands.HideAndSeekCommand;
import com.hideandseek.commands.LangCommand;
import com.hideandseek.commands.ShopCommand;
import com.hideandseek.commands.SpectatorCommand;
import com.hideandseek.config.BlockRestorationConfig;
import com.hideandseek.config.ConfigManager;
import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.effects.EffectManager;
import com.hideandseek.effects.EffectManagerImpl;
import com.hideandseek.effects.EffectStorage;
import com.hideandseek.effects.EffectType;
import com.hideandseek.effects.ItemEffectHandlerAdapter;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.GameResult;
import com.hideandseek.i18n.LanguagePreferenceManager;
import com.hideandseek.i18n.LanguagePreferenceManagerImpl;
import com.hideandseek.i18n.MessageManager;
import com.hideandseek.i18n.MessageManagerImpl;
import com.hideandseek.items.AreaScanHandler;
import com.hideandseek.items.CaptureNetHandler;
import com.hideandseek.items.DecoyBlockHandler;
import com.hideandseek.items.EagleEyeHandler;
import com.hideandseek.items.GlowDetectorHandler;
import com.hideandseek.items.ReachExtenderHandler;
import com.hideandseek.items.SecondChanceHandler;
import com.hideandseek.items.ShadowSprintHandler;
import com.hideandseek.items.SpeedBoostHandler;
import com.hideandseek.items.TrackerCompassHandler;
import com.hideandseek.items.TrackerInsightHandler;
import com.hideandseek.items.VisionEffectHandler;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.listeners.BlockBreakListener;
import com.hideandseek.listeners.BlockDamageListener;
import com.hideandseek.listeners.EffectCleanupListener;
import com.hideandseek.listeners.EntityDamageByEntityListener;
import com.hideandseek.listeners.InventoryListener;
import com.hideandseek.listeners.PlayerDeathListener;
import com.hideandseek.listeners.PlayerInteractListener;
import com.hideandseek.listeners.PlayerJoinListener;
import com.hideandseek.listeners.PlayerMoveListener;
import com.hideandseek.listeners.ShopListener;
import com.hideandseek.listeners.SpectatorEventListener;
import com.hideandseek.listeners.TauntListener;
import com.hideandseek.points.PointManager;
import com.hideandseek.respawn.RespawnManager;
import com.hideandseek.scoreboard.GameScoreboard;
import com.hideandseek.scoreboard.LocalizedScoreboardManager;
import com.hideandseek.shop.PurchaseStorage;
import com.hideandseek.shop.ShopManager;
import com.hideandseek.spectator.SpectatorManager;
import com.hideandseek.strength.SeekerStrengthManager;
import com.hideandseek.utils.EffectScheduler;
import com.hideandseek.utils.TaskScheduler;
import java.io.File;
import java.util.Collection;
import java.util.UUID;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010M\u001a\u00020NH\u0016J\b\u0010O\u001a\u00020NH\u0016J\b\u0010P\u001a\u00020NH\u0002J\b\u0010Q\u001a\u00020NH\u0002J\b\u0010R\u001a\u00020NH\u0002R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\r@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0011@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0015@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0019@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u001d@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010\"\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020!@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\"\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\u0004\u001a\u0004\u0018\u00010%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001e\u0010*\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020)@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001e\u0010.\u001a\u00020-2\u0006\u0010\u0004\u001a\u00020-@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001e\u00102\u001a\u0002012\u0006\u0010\u0004\u001a\u000201@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001e\u00106\u001a\u0002052\u0006\u0010\u0004\u001a\u000205@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u001e\u0010:\u001a\u0002092\u0006\u0010\u0004\u001a\u000209@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u001e\u0010>\u001a\u00020=2\u0006\u0010\u0004\u001a\u00020=@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u001e\u0010B\u001a\u00020A2\u0006\u0010\u0004\u001a\u00020A@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u001e\u0010F\u001a\u00020E2\u0006\u0010\u0004\u001a\u00020E@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u001e\u0010J\u001a\u00020I2\u0006\u0010\u0004\u001a\u00020I@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010L\u00a8\u0006S"}, d2={"Lcom/hideandseek/HideAndSeekPlugin;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "value", "Lcom/hideandseek/config/ConfigManager;", "configManager", "getConfigManager", "()Lcom/hideandseek/config/ConfigManager;", "Lcom/hideandseek/arena/ArenaManager;", "arenaManager", "getArenaManager", "()Lcom/hideandseek/arena/ArenaManager;", "Lcom/hideandseek/game/GameManager;", "gameManager", "getGameManager", "()Lcom/hideandseek/game/GameManager;", "Lcom/hideandseek/shop/ShopManager;", "shopManager", "getShopManager", "()Lcom/hideandseek/shop/ShopManager;", "Lcom/hideandseek/disguise/DisguiseManager;", "disguiseManager", "getDisguiseManager", "()Lcom/hideandseek/disguise/DisguiseManager;", "Lcom/hideandseek/utils/TaskScheduler;", "taskScheduler", "getTaskScheduler", "()Lcom/hideandseek/utils/TaskScheduler;", "Lcom/hideandseek/effects/EffectManagerImpl;", "effectManager", "getEffectManager", "()Lcom/hideandseek/effects/EffectManagerImpl;", "Lcom/hideandseek/shop/PurchaseStorage;", "purchaseStorage", "getPurchaseStorage", "()Lcom/hideandseek/shop/PurchaseStorage;", "Lnet/milkbowl/vault/economy/Economy;", "economy", "getEconomy", "()Lnet/milkbowl/vault/economy/Economy;", "Lcom/hideandseek/points/PointManager;", "pointManager", "getPointManager", "()Lcom/hideandseek/points/PointManager;", "Lcom/hideandseek/blockrestoration/BlockRestorationManager;", "blockRestorationManager", "getBlockRestorationManager", "()Lcom/hideandseek/blockrestoration/BlockRestorationManager;", "Lcom/hideandseek/respawn/RespawnManager;", "respawnManager", "getRespawnManager", "()Lcom/hideandseek/respawn/RespawnManager;", "Lcom/hideandseek/spectator/SpectatorManager;", "spectatorManager", "getSpectatorManager", "()Lcom/hideandseek/spectator/SpectatorManager;", "Lcom/hideandseek/scoreboard/GameScoreboard;", "gameScoreboard", "getGameScoreboard", "()Lcom/hideandseek/scoreboard/GameScoreboard;", "Lcom/hideandseek/scoreboard/LocalizedScoreboardManager;", "localizedScoreboard", "getLocalizedScoreboard", "()Lcom/hideandseek/scoreboard/LocalizedScoreboardManager;", "Lcom/hideandseek/strength/SeekerStrengthManager;", "seekerStrengthManager", "getSeekerStrengthManager", "()Lcom/hideandseek/strength/SeekerStrengthManager;", "Lcom/hideandseek/i18n/LanguagePreferenceManager;", "languagePreferenceManager", "getLanguagePreferenceManager", "()Lcom/hideandseek/i18n/LanguagePreferenceManager;", "Lcom/hideandseek/i18n/MessageManager;", "messageManager", "getMessageManager", "()Lcom/hideandseek/i18n/MessageManager;", "onEnable", "", "onDisable", "registerCommands", "registerListeners", "setupEconomy", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nHideAndSeekPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HideAndSeekPlugin.kt\ncom/hideandseek/HideAndSeekPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,367:1\n1869#2:368\n1869#2,2:369\n1870#2:371\n*S KotlinDebug\n*F\n+ 1 HideAndSeekPlugin.kt\ncom/hideandseek/HideAndSeekPlugin\n*L\n261#1:368\n265#1:369,2\n261#1:371\n*E\n"})
public final class HideAndSeekPlugin
extends JavaPlugin {
    private ConfigManager configManager;
    private ArenaManager arenaManager;
    private GameManager gameManager;
    private ShopManager shopManager;
    private DisguiseManager disguiseManager;
    private TaskScheduler taskScheduler;
    private EffectManagerImpl effectManager;
    private PurchaseStorage purchaseStorage;
    @Nullable
    private Economy economy;
    private PointManager pointManager;
    private BlockRestorationManager blockRestorationManager;
    private RespawnManager respawnManager;
    private SpectatorManager spectatorManager;
    private GameScoreboard gameScoreboard;
    private LocalizedScoreboardManager localizedScoreboard;
    private SeekerStrengthManager seekerStrengthManager;
    private LanguagePreferenceManager languagePreferenceManager;
    private MessageManager messageManager;

    @NotNull
    public final ConfigManager getConfigManager() {
        ConfigManager configManager = this.configManager;
        if (configManager != null) {
            return configManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("configManager");
        return null;
    }

    @NotNull
    public final ArenaManager getArenaManager() {
        ArenaManager arenaManager = this.arenaManager;
        if (arenaManager != null) {
            return arenaManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("arenaManager");
        return null;
    }

    @NotNull
    public final GameManager getGameManager() {
        GameManager gameManager = this.gameManager;
        if (gameManager != null) {
            return gameManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gameManager");
        return null;
    }

    @NotNull
    public final ShopManager getShopManager() {
        ShopManager shopManager = this.shopManager;
        if (shopManager != null) {
            return shopManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("shopManager");
        return null;
    }

    @NotNull
    public final DisguiseManager getDisguiseManager() {
        DisguiseManager disguiseManager = this.disguiseManager;
        if (disguiseManager != null) {
            return disguiseManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("disguiseManager");
        return null;
    }

    @NotNull
    public final TaskScheduler getTaskScheduler() {
        TaskScheduler taskScheduler = this.taskScheduler;
        if (taskScheduler != null) {
            return taskScheduler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("taskScheduler");
        return null;
    }

    @NotNull
    public final EffectManagerImpl getEffectManager() {
        EffectManagerImpl effectManagerImpl = this.effectManager;
        if (effectManagerImpl != null) {
            return effectManagerImpl;
        }
        Intrinsics.throwUninitializedPropertyAccessException("effectManager");
        return null;
    }

    @NotNull
    public final PurchaseStorage getPurchaseStorage() {
        PurchaseStorage purchaseStorage = this.purchaseStorage;
        if (purchaseStorage != null) {
            return purchaseStorage;
        }
        Intrinsics.throwUninitializedPropertyAccessException("purchaseStorage");
        return null;
    }

    @Nullable
    public final Economy getEconomy() {
        return this.economy;
    }

    @NotNull
    public final PointManager getPointManager() {
        PointManager pointManager = this.pointManager;
        if (pointManager != null) {
            return pointManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("pointManager");
        return null;
    }

    @NotNull
    public final BlockRestorationManager getBlockRestorationManager() {
        BlockRestorationManager blockRestorationManager = this.blockRestorationManager;
        if (blockRestorationManager != null) {
            return blockRestorationManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("blockRestorationManager");
        return null;
    }

    @NotNull
    public final RespawnManager getRespawnManager() {
        RespawnManager respawnManager = this.respawnManager;
        if (respawnManager != null) {
            return respawnManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("respawnManager");
        return null;
    }

    @NotNull
    public final SpectatorManager getSpectatorManager() {
        SpectatorManager spectatorManager = this.spectatorManager;
        if (spectatorManager != null) {
            return spectatorManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("spectatorManager");
        return null;
    }

    @NotNull
    public final GameScoreboard getGameScoreboard() {
        GameScoreboard gameScoreboard = this.gameScoreboard;
        if (gameScoreboard != null) {
            return gameScoreboard;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gameScoreboard");
        return null;
    }

    @NotNull
    public final LocalizedScoreboardManager getLocalizedScoreboard() {
        LocalizedScoreboardManager localizedScoreboardManager = this.localizedScoreboard;
        if (localizedScoreboardManager != null) {
            return localizedScoreboardManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("localizedScoreboard");
        return null;
    }

    @NotNull
    public final SeekerStrengthManager getSeekerStrengthManager() {
        SeekerStrengthManager seekerStrengthManager = this.seekerStrengthManager;
        if (seekerStrengthManager != null) {
            return seekerStrengthManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("seekerStrengthManager");
        return null;
    }

    @NotNull
    public final LanguagePreferenceManager getLanguagePreferenceManager() {
        LanguagePreferenceManager languagePreferenceManager = this.languagePreferenceManager;
        if (languagePreferenceManager != null) {
            return languagePreferenceManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("languagePreferenceManager");
        return null;
    }

    @NotNull
    public final MessageManager getMessageManager() {
        MessageManager messageManager = this.messageManager;
        if (messageManager != null) {
            return messageManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("messageManager");
        return null;
    }

    public void onEnable() {
        this.getLogger().info("HideAndSeek plugin enabling...");
        this.languagePreferenceManager = new LanguagePreferenceManagerImpl((Plugin)this);
        this.messageManager = new MessageManagerImpl((Plugin)this, this.getLanguagePreferenceManager());
        this.getLogger().info("Internationalization system initialized (" + this.getLanguagePreferenceManager().getAvailableLanguages().size() + " languages)");
        this.configManager = new ConfigManager((Plugin)this);
        this.getConfigManager().load();
        this.taskScheduler = new TaskScheduler((Plugin)this);
        this.arenaManager = new ArenaManager((Plugin)this, this.getConfigManager());
        this.getArenaManager().loadArenas();
        this.gameManager = new GameManager((Plugin)this, this.getConfigManager());
        this.shopManager = new ShopManager((Plugin)this, this.getConfigManager());
        this.getShopManager().loadCategories();
        this.disguiseManager = new DisguiseManager((Plugin)this, this.getGameManager());
        EffectStorage effectStorage = new EffectStorage();
        EffectScheduler effectScheduler = new EffectScheduler((Plugin)this);
        Plugin plugin = (Plugin)this;
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        this.effectManager = new EffectManagerImpl(plugin, effectStorage, effectScheduler, logger);
        this.purchaseStorage = new PurchaseStorage();
        this.pointManager = new PointManager((Plugin)this);
        File blockRestorationConfigFile = new File(this.getDataFolder(), "block-restoration.yml");
        if (!blockRestorationConfigFile.exists()) {
            this.saveResource("block-restoration.yml", false);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)blockRestorationConfigFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration blockRestorationYaml = yamlConfiguration;
        BlockRestorationConfig blockRestorationConfig = new BlockRestorationConfig((ConfigurationSection)blockRestorationYaml);
        this.blockRestorationManager = new BlockRestorationManager((Plugin)this, blockRestorationConfig, this.getDisguiseManager());
        this.getBlockRestorationManager().start();
        this.getLogger().info("Block restoration system started");
        this.respawnManager = new RespawnManager((Plugin)this, blockRestorationConfig, this.getGameManager());
        this.getLogger().info("Respawn system initialized");
        this.spectatorManager = new SpectatorManager((Plugin)this);
        this.getSpectatorManager().initialize();
        this.getLogger().info("Spectator system initialized");
        this.gameScoreboard = new GameScoreboard((Plugin)this);
        this.localizedScoreboard = new LocalizedScoreboardManager((Plugin)this, this.getMessageManager());
        this.getLogger().info("Scoreboard system initialized (including localized scoreboard)");
        this.seekerStrengthManager = new SeekerStrengthManager((Plugin)this);
        this.getLogger().info("Seeker strength system initialized");
        this.getEffectManager().registerHandler(EffectType.VISION, new VisionEffectHandler());
        this.getEffectManager().registerHandler(EffectType.GLOW, new GlowDetectorHandler((Plugin)this, this.getDisguiseManager()));
        this.getEffectManager().registerHandler(EffectType.SPEED, new SpeedBoostHandler());
        this.getEffectManager().registerHandler(EffectType.REACH, new ReachExtenderHandler());
        this.getEffectManager().registerHandler(EffectType.SHADOW_SPRINT, new ItemEffectHandlerAdapter(new ShadowSprintHandler(), this.getGameManager()));
        this.getEffectManager().registerHandler(EffectType.SECOND_CHANCE, new ItemEffectHandlerAdapter(new SecondChanceHandler(), this.getGameManager()));
        this.getEffectManager().registerHandler(EffectType.DECOY_BLOCK, new ItemEffectHandlerAdapter(new DecoyBlockHandler(), this.getGameManager()));
        this.getEffectManager().registerHandler(EffectType.TRACKER_COMPASS, new ItemEffectHandlerAdapter(new TrackerCompassHandler(), this.getGameManager()));
        this.getEffectManager().registerHandler(EffectType.AREA_SCAN, new ItemEffectHandlerAdapter(new AreaScanHandler(), this.getGameManager()));
        this.getEffectManager().registerHandler(EffectType.EAGLE_EYE, new ItemEffectHandlerAdapter(new EagleEyeHandler(), this.getGameManager()));
        this.getEffectManager().registerHandler(EffectType.TRACKER_INSIGHT, new ItemEffectHandlerAdapter(new TrackerInsightHandler(), this.getGameManager()));
        this.getEffectManager().registerHandler(EffectType.CAPTURE_NET, new ItemEffectHandlerAdapter(new CaptureNetHandler(), this.getGameManager()));
        this.setupEconomy();
        this.getGameManager().setShopManager(this.getShopManager());
        this.getGameManager().setDisguiseManager(this.getDisguiseManager());
        this.getGameManager().setMessageManager(this.getMessageManager());
        this.getGameManager().setPointManager(this.getPointManager());
        this.getGameManager().setArenaManager(this.getArenaManager());
        this.getGameManager().setGameScoreboard(this.getGameScoreboard());
        this.getGameManager().setLocalizedScoreboard(this.getLocalizedScoreboard());
        this.getGameManager().setSeekerStrengthManager(this.getSeekerStrengthManager());
        this.getShopManager().setMessageManager(this.getMessageManager());
        this.registerCommands();
        this.registerListeners();
        this.getLogger().info("HideAndSeek plugin enabled!");
    }

    public void onDisable() {
        this.getLogger().info("HideAndSeek plugin disabling...");
        this.getLanguagePreferenceManager().saveAll();
        this.getLogger().info("Language preferences saved (" + this.getLanguagePreferenceManager().getPreferenceCount() + " players)");
        Game game = this.getGameManager().getActiveGame();
        if (game != null) {
            Game game2 = game;
            boolean bl = false;
            this.getLogger().info("Cleaning up active game...");
            this.getGameManager().endGame(GameResult.CANCELLED);
        }
        this.getDisguiseManager().clearAllDisguises();
        Collection collection = this.getServer().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player = (Player)element$iv;
            boolean bl = false;
            EffectManagerImpl effectManagerImpl = this.getEffectManager();
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            effectManagerImpl.removeAllEffects(uUID);
            Collection collection2 = player.getActivePotionEffects();
            Intrinsics.checkNotNullExpressionValue(collection2, "getActivePotionEffects(...)");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PotionEffect effect = (PotionEffect)element$iv2;
                boolean bl2 = false;
                player.removePotionEffect(effect.getType());
            }
            player.setSendViewDistance(10);
        }
        this.getBlockRestorationManager().stop();
        int clearedCount = this.getBlockRestorationManager().clearAll();
        this.getLogger().info("Block restoration system stopped (" + clearedCount + " pending blocks cleared)");
        this.getGameScoreboard().clearAll();
        this.getLocalizedScoreboard().clearAll();
        this.getLogger().info("Scoreboard system cleared");
        this.getSpectatorManager().shutdown();
        this.getSpectatorManager().getConfig().save();
        this.getTaskScheduler().cancelAll();
        this.getLogger().info("HideAndSeek plugin disabled!");
    }

    private final void registerCommands() {
        this.getLogger().info("Registering commands...");
        ShopCommand shopCommand = new ShopCommand(this.getShopManager(), this.getGameManager(), this.getMessageManager());
        AdminCommand adminCommand = new AdminCommand(this.getArenaManager(), this.getGameManager(), this.getMessageManager());
        SpectatorCommand spectatorCommand = new SpectatorCommand(this.getSpectatorManager(), this.getGameManager());
        LangCommand langCommand = new LangCommand(this.getLanguagePreferenceManager(), this.getMessageManager());
        HideAndSeekCommand mainCommand = new HideAndSeekCommand(adminCommand, shopCommand, spectatorCommand, langCommand, this.getMessageManager());
        PluginCommand command = this.getCommand("hideandseek");
        if (command == null) {
            this.getLogger().severe("Failed to register command 'hideandseek' - command not found in plugin.yml!");
            return;
        }
        command.setExecutor((CommandExecutor)mainCommand);
        command.setTabCompleter((TabCompleter)mainCommand);
        this.getLogger().info("Command 'hideandseek' (alias: 'hs') registered successfully");
        this.getLogger().info("Available subcommands: shop, lang, spectator, admin");
        this.getLogger().info("Auto-join enabled: Players automatically join game on login");
    }

    private final void registerListeners() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        Intrinsics.checkNotNullExpressionValue(pluginManager, "getPluginManager(...)");
        PluginManager pluginManager2 = pluginManager;
        ShopListener shopListener = new ShopListener((Plugin)this, this.getShopManager(), this.getGameManager(), this.getEffectManager(), this.getPurchaseStorage(), this.economy);
        shopListener.setDisguiseManager(this.getDisguiseManager());
        shopListener.setMessageManager(this.getMessageManager());
        PlayerMoveListener playerMoveListener = new PlayerMoveListener(this.getDisguiseManager());
        playerMoveListener.setPlugin((Plugin)this);
        EffectManager effectManager = this.getEffectManager();
        GameManager gameManager = this.getGameManager();
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        EffectCleanupListener effectCleanupListener = new EffectCleanupListener(effectManager, gameManager, logger);
        PlayerJoinListener playerJoinListener = new PlayerJoinListener((Plugin)this, this.getDisguiseManager(), this.getEffectManager(), this.getGameManager(), this.getSpectatorManager(), this.getMessageManager());
        SpectatorEventListener spectatorEventListener = new SpectatorEventListener(this.getSpectatorManager(), this.getGameManager());
        TauntListener tauntListener = new TauntListener((Plugin)this, this.getGameManager(), this.getPointManager());
        pluginManager2.registerEvents((Listener)shopListener, (Plugin)this);
        pluginManager2.registerEvents((Listener)new InventoryListener(this.getShopManager()), (Plugin)this);
        pluginManager2.registerEvents((Listener)new PlayerInteractListener(this.getShopManager(), this.getGameManager()), (Plugin)this);
        pluginManager2.registerEvents((Listener)playerMoveListener, (Plugin)this);
        pluginManager2.registerEvents((Listener)new BlockDamageListener(this.getDisguiseManager(), this.getGameManager()), (Plugin)this);
        pluginManager2.registerEvents((Listener)new EntityDamageByEntityListener(this.getDisguiseManager(), this.getGameManager(), this.getPointManager(), (Plugin)this), (Plugin)this);
        pluginManager2.registerEvents((Listener)effectCleanupListener, (Plugin)this);
        pluginManager2.registerEvents((Listener)playerJoinListener, (Plugin)this);
        pluginManager2.registerEvents((Listener)spectatorEventListener, (Plugin)this);
        pluginManager2.registerEvents((Listener)tauntListener, (Plugin)this);
        pluginManager2.registerEvents((Listener)new BlockBreakListener(this.getGameManager(), this.getBlockRestorationManager(), (Plugin)this), (Plugin)this);
        pluginManager2.registerEvents((Listener)new PlayerDeathListener((Plugin)this, this.getGameManager(), this.getRespawnManager()), (Plugin)this);
        this.getLogger().info("Listeners registered (including TauntListener, BlockBreakListener, PlayerDeathListener, and SpectatorEventListener)");
    }

    private final void setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault not found! Economy features will be disabled.");
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().warning("Economy provider not found! Economy features will be disabled.");
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        Logger logger = this.getLogger();
        Economy economy = this.economy;
        Intrinsics.checkNotNull(economy);
        logger.info("Vault economy integration enabled (" + economy.getName() + ")");
    }
}

